/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Locale;
import oracle.jdbc.OracleResultSet;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.ElementExtractor;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML2;
import oracle.spatial.util.RTree;
import oracle.spatial.util.RTreeJoinRes;

public class J3D_Geometry
extends JGeometry {
    private ArrayList solids1 = new ArrayList();
    private ArrayList solids2 = new ArrayList();
    private ArrayList solidHoles1 = new ArrayList();
    private ArrayList solidHoles2 = new ArrayList();
    private ArrayList surfs1 = new ArrayList();
    private ArrayList surfs2 = new ArrayList();
    private ArrayList surfHoles1 = new ArrayList();
    private ArrayList surfHoles2 = new ArrayList();
    private ArrayList belongingGeometry = new ArrayList();
    public static final int GTYPE_SURFACE = 3;
    public static final int GTYPE_SOLID = 8;
    public static final int GTYPE_MULTISOLID = 9;
    public static final int GTYPE_MULTISURFACE = 7;
    public static final int ETYPE_POLYGON = 3;
    public static final int ETYPE_SURFACE = 3;
    public static final int ETYPE_COMPOSITEPOLYGON = 6;
    public static final int ETYPE_COMPOSITESURFACE = 6;
    public static final int ETYPE_SOLID = 7;
    public static final int ETYPE_COMPOSITESOLID = 8;
    protected static final Locale ENGLISH = new Locale("en");

    public J3D_Geometry(int n, int n2, int[] nArray, double[] dArray) {
        super(n - 3000 >= 0 ? n : 3000 + n, n2, nArray, dArray);
    }

    public J3D_Geometry(int n, int n2, double d, double d2, double d3) {
        super(n - 3000 >= 0 ? n : 3000 + n, n2, new int[]{1, 1, 1}, new double[]{d, d2, d3});
    }

    public J3D_Geometry(int n, int n2, double d, double d2, double d3, int[] nArray, double[] dArray) {
        super(n - 3000 >= 0 ? n : 3000 + n, n2, d, d2, d3, nArray, dArray);
    }

    public void setBelongingGeometry(J3D_Geometry j3D_Geometry) {
        if (j3D_Geometry != null) {
            if (this.belongingGeometry.size() == 0) {
                this.belongingGeometry.add(j3D_Geometry);
            } else {
                this.belongingGeometry.set(0, j3D_Geometry);
            }
        }
    }

    public J3D_Geometry getBelongingGeometry() {
        if (this.belongingGeometry.size() > 0 && this.belongingGeometry.get(0) != null) {
            return (J3D_Geometry)this.belongingGeometry.get(0);
        }
        return null;
    }

    public void clearBelongingGeometry() {
        this.belongingGeometry.clear();
    }

    public boolean anyInteract(J3D_Geometry j3D_Geometry, double d) throws Exception {
        String string = "FALSE";
        return this.anyInteract(j3D_Geometry, d, string);
    }

    private ArrayList convertGeometriesToGnomonic(J3D_Geometry j3D_Geometry, double d) throws Exception {
        int n;
        int n2;
        double[] dArray;
        double[] dArray2;
        J3D_Geometry j3D_Geometry2 = null;
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        if (d < 0.05) {
            d = 0.05;
        }
        if ((dArray2 = this.getMBR()).length != (dArray = j3D_Geometry.getMBR()).length) {
            throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        double[] dArray3 = new double[dArray2.length];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray3[n2] = 0.0;
        }
        for (n2 = 0; n2 < dArray2.length / 2; ++n2) {
            for (n = 0; n < 2; ++n) {
                dArray3[dArray2.length / 2 * n + n2] = (dArray2[dArray2.length / 2 * n + n2] + dArray[dArray.length / 2 * n + n2]) / 2.0;
            }
        }
        double[] dArray4 = new double[dArray3.length / 2];
        for (n = 0; n < dArray3.length / 2; ++n) {
            dArray4[n] = (dArray3[n + dArray3.length / 2] + dArray3[n]) / 2.0;
        }
        double d2 = Math.PI / 180 * dArray4[0];
        double d3 = Math.PI / 180 * dArray4[1];
        if (this.getType() % 10 == 1 || j3D_Geometry.getType() % 10 == 1) {
            d2 /= 2.0;
            d3 /= 2.0;
        }
        j3D_Geometry2 = J3D_Geometry.projectToGnomonicFromLongLat(this, d2, d3);
        j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry, d2, d3);
        arrayList.add(j3D_Geometry2);
        arrayList.add(j3D_Geometry);
        return arrayList;
    }

    public boolean anyInteract(J3D_Geometry j3D_Geometry, double d, String string) throws Exception {
        J3D_Geometry j3D_Geometry2;
        Object object;
        Object object2;
        int[] nArray = new int[1];
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        boolean[] blArray3 = new boolean[2];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (this.getSRID() != j3D_Geometry.getSRID()) {
            throw new Exception("13365");
        }
        int[] nArray2 = new int[this.elemInfo.length];
        System.arraycopy(this.elemInfo, 0, nArray2, 0, this.elemInfo.length);
        double[] dArray = new double[this.ordinates.length];
        System.arraycopy(this.ordinates, 0, dArray, 0, this.ordinates.length);
        int n = this.getSRID();
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(this.getType(), n, nArray2, dArray);
        int[] nArray3 = new int[j3D_Geometry.elemInfo.length];
        System.arraycopy(j3D_Geometry.elemInfo, 0, nArray3, 0, j3D_Geometry.elemInfo.length);
        double[] dArray2 = new double[j3D_Geometry.ordinates.length];
        System.arraycopy(j3D_Geometry.ordinates, 0, dArray2, 0, j3D_Geometry.ordinates.length);
        int n2 = j3D_Geometry.getSRID();
        J3D_Geometry j3D_Geometry4 = new J3D_Geometry(j3D_Geometry.getType(), n2, nArray3, dArray2);
        if (string.equals("TRUE")) {
            if (d < 0.05) {
                d = 0.05;
            }
            object2 = new ArrayList();
            object2 = j3D_Geometry3.convertGeometriesToGnomonic(j3D_Geometry4, d);
            System.arraycopy(((J3D_Geometry)object2.get(0)).getOrdinatesArray(), 0, j3D_Geometry3.ordinates, 0, ((J3D_Geometry)object2.get(0)).getOrdinatesArray().length);
            System.arraycopy(((J3D_Geometry)object2.get(1)).getOrdinatesArray(), 0, j3D_Geometry4.ordinates, 0, ((J3D_Geometry)object2.get(1)).getOrdinatesArray().length);
        }
        object2 = new double[3][2];
        double[][] dArray3 = new double[3][2];
        object2 = J3D_Geometry.getMBH(j3D_Geometry3);
        if (!this.ImbhAB((double[][])object2, dArray3 = J3D_Geometry.getMBH(j3D_Geometry4), d)) {
            return false;
        }
        if (j3D_Geometry3.gtype == 9 || j3D_Geometry3.gtype == 7 || j3D_Geometry3.gtype == 6 || j3D_Geometry3.elemInfo[1] % 1000 == 2 && j3D_Geometry3.ordinates.length != 6 || j3D_Geometry3.gtype == 5 || j3D_Geometry3.elemInfo[1] % 1000 == 8 || j3D_Geometry3.elemInfo[1] % 1000 == 6 || j3D_Geometry3.gtype == 4) {
            object = new ElementExtractor(j3D_Geometry3, 0, 0, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry2 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                arrayList.add(j3D_Geometry2);
            }
        } else if (j3D_Geometry3.gtype == 3 && j3D_Geometry3.elemInfo.length == 3 && j3D_Geometry3.elemInfo[1] % 1000 == 3 && j3D_Geometry3.elemInfo[2] == 3 && j3D_Geometry3.ordinates.length == 6) {
            object = J3D_Geometry.expandGeom(j3D_Geometry3);
            arrayList.add(object);
        } else {
            arrayList.add(j3D_Geometry3);
        }
        if (j3D_Geometry4.gtype == 9 || j3D_Geometry4.gtype == 7 || j3D_Geometry4.gtype == 6 || j3D_Geometry4.elemInfo[1] % 1000 == 2 && j3D_Geometry4.ordinates.length != 6 || j3D_Geometry4.gtype == 5 || j3D_Geometry4.elemInfo[1] % 1000 == 8 || j3D_Geometry4.elemInfo[1] % 1000 == 6 || j3D_Geometry4.gtype == 4) {
            object = new ElementExtractor(j3D_Geometry4, 0, 0, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry2 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                arrayList2.add(j3D_Geometry2);
            }
        } else if (j3D_Geometry4.gtype == 3 && j3D_Geometry4.elemInfo.length == 3 && j3D_Geometry4.elemInfo[1] % 1000 == 3 && j3D_Geometry4.elemInfo[2] == 3 && j3D_Geometry4.ordinates.length == 6) {
            object = J3D_Geometry.expandGeom(j3D_Geometry4);
            arrayList2.add(object);
        } else {
            arrayList2.add(j3D_Geometry4);
        }
        if (this.gtype == 6 || this.gtype == 4) {
            J3D_Geometry.decomposeLnStrIntoLnSgts(arrayList);
        }
        if (j3D_Geometry.gtype == 6 || j3D_Geometry.gtype == 4) {
            J3D_Geometry.decomposeLnStrIntoLnSgts(arrayList2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList2.size(); ++j) {
                ((J3D_Geometry)arrayList.get(i)).getFlags((J3D_Geometry)arrayList2.get(j), blArray, blArray2, blArray3);
                if (((J3D_Geometry)arrayList.get(i)).anyInteract2((J3D_Geometry)arrayList2.get(j), blArray, blArray2, blArray3, d)) {
                    return true;
                }
                ((J3D_Geometry)arrayList2.get(j)).getFlags((J3D_Geometry)arrayList.get(i), blArray, blArray2, blArray3);
                if (!((J3D_Geometry)arrayList2.get(j)).anyInteract2((J3D_Geometry)arrayList.get(i), blArray, blArray2, blArray3, d)) continue;
                return true;
            }
        }
        return false;
    }

    public void getFlags(J3D_Geometry j3D_Geometry, boolean[] blArray, boolean[] blArray2, boolean[] blArray3) throws Exception {
        J3D_Geometry j3D_Geometry2;
        int[] nArray;
        ElementExtractor elementExtractor;
        J3D_Geometry j3D_Geometry3;
        ElementExtractor elementExtractor2;
        int[] nArray2 = new int[1];
        blArray[0] = false;
        blArray[1] = false;
        blArray2[0] = false;
        blArray2[1] = false;
        blArray3[0] = false;
        blArray3[1] = false;
        this.solids1.clear();
        this.solids2.clear();
        this.solidHoles1.clear();
        this.solidHoles2.clear();
        this.surfs1.clear();
        this.surfs2.clear();
        this.surfHoles1.clear();
        this.surfHoles2.clear();
        if (this.gtype == 8) {
            elementExtractor2 = new ElementExtractor(this, 0, 2, 3, false);
            nArray2[0] = 0;
            j3D_Geometry3 = elementExtractor2.nextElement(nArray2);
            elementExtractor = new ElementExtractor(j3D_Geometry3, 0, 1, 3, false);
            nArray = new int[]{0};
            while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    this.solidHoles1.add(j3D_Geometry2);
                    continue;
                }
                this.solids1.add(j3D_Geometry2);
            }
            blArray[0] = true;
            if (this.solidHoles1.size() > 0) {
                blArray3[0] = true;
            }
            if (this.solidHoles1.size() > 0 || this.solids1.size() > 0) {
                blArray2[0] = true;
            }
        }
        if (j3D_Geometry.gtype == 8) {
            elementExtractor2 = new ElementExtractor(j3D_Geometry, 0, 2, 3, false);
            nArray2[0] = 0;
            j3D_Geometry3 = elementExtractor2.nextElement(nArray2);
            elementExtractor = new ElementExtractor(j3D_Geometry3, 0, 1, 3, false);
            nArray = new int[]{0};
            while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    this.solidHoles2.add(j3D_Geometry2);
                    continue;
                }
                this.solids2.add(j3D_Geometry2);
            }
            blArray[1] = true;
            if (this.solidHoles2.size() > 0) {
                blArray3[1] = true;
            }
            if (this.solidHoles2.size() > 0 || this.solids2.size() > 0) {
                blArray2[1] = true;
            }
        }
        if (this.gtype == 3) {
            elementExtractor2 = new ElementExtractor(this, 0, 1, 3, false);
            nArray2[0] = 0;
            while ((j3D_Geometry3 = elementExtractor2.nextElement(nArray2)) != null) {
                if (nArray2[0] == 2) {
                    this.surfHoles1.add(j3D_Geometry3);
                    continue;
                }
                this.surfs1.add(j3D_Geometry3);
            }
            if (this.surfHoles1.size() > 0) {
                blArray3[0] = true;
            }
            if (this.surfs1.size() > 1) {
                blArray2[0] = true;
            }
        }
        if (j3D_Geometry.gtype == 3) {
            elementExtractor2 = new ElementExtractor(j3D_Geometry, 0, 1, 3, false);
            nArray2[0] = 0;
            while ((j3D_Geometry3 = elementExtractor2.nextElement(nArray2)) != null) {
                if (nArray2[0] == 2) {
                    this.surfHoles2.add(j3D_Geometry3);
                    continue;
                }
                this.surfs2.add(j3D_Geometry3);
            }
            if (this.surfHoles2.size() > 0) {
                blArray3[1] = true;
            }
            if (this.surfs2.size() > 1) {
                blArray2[1] = true;
            }
        }
    }

    protected static double[][] getMBH(J3D_Geometry j3D_Geometry) {
        int n;
        int n2 = 3;
        int n3 = j3D_Geometry.ordinates.length / 3;
        double[][] dArray = new double[3][2];
        double[][] dArray2 = new double[n3][3];
        for (n = 0; n < n3; ++n) {
            dArray2[n][0] = j3D_Geometry.ordinates[3 * n];
            dArray2[n][1] = j3D_Geometry.ordinates[3 * n + 1];
            dArray2[n][2] = j3D_Geometry.ordinates[3 * n + 2];
        }
        double d = dArray2[0][0];
        double d2 = dArray2[0][1];
        double d3 = dArray2[0][2];
        double d4 = dArray2[0][0];
        double d5 = dArray2[0][1];
        double d6 = dArray2[0][2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n = 1; n < n3; ++n) {
            if (dArray2[n][0] > d) {
                d = dArray2[n][0];
                n4 = n;
            } else if (dArray2[n][0] < d4) {
                d4 = dArray2[n][0];
                n7 = n;
            }
            if (dArray2[n][1] > d2) {
                d2 = dArray2[n][1];
                n5 = n;
            } else if (dArray2[n][1] < d5) {
                d5 = dArray2[n][1];
                n8 = n;
            }
            if (dArray2[n][2] > d3) {
                d3 = dArray2[n][2];
                n6 = n;
                continue;
            }
            if (!(dArray2[n][2] < d6)) continue;
            d6 = dArray2[n][2];
            n9 = n;
        }
        dArray[0][0] = d4;
        dArray[0][1] = d;
        dArray[1][0] = d5;
        dArray[1][1] = d2;
        dArray[2][0] = d6;
        dArray[2][1] = d3;
        return dArray;
    }

    private boolean ImbhAB(double[][] dArray, double[][] dArray2, double d) {
        for (int i = 0; i < 3; ++i) {
            if (!(dArray[i][0] > dArray2[i][1] + d) && !(dArray2[i][0] > dArray[i][1] + d)) continue;
            return false;
        }
        return true;
    }

    private boolean pointInOnSolid(J3D_Geometry j3D_Geometry, boolean bl, double d) throws Exception {
        Object object;
        double[] dArray = new double[3];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        J3D_Geometry j3D_Geometry2 = null;
        double[][] dArray2 = new double[3][2];
        double[][] dArray3 = new double[3][2];
        dArray2 = J3D_Geometry.getMBH(this);
        if (!this.ImbhAB(dArray2, dArray3 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
            return false;
        }
        dArray[0] = this.ordinates[0];
        dArray[1] = this.ordinates[1];
        dArray[2] = this.ordinates[2];
        ArrayList arrayList = new ArrayList();
        arrayList = j3D_Geometry.getFaces(bl);
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        int n5 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            object = new Object[]{(J3D_Geometry)arrayList.get(n), n5};
            arrayList2.add((Object[])object);
            ++n5;
        }
        object = new J3D_Geometry(2, 0, new int[]{1, 2, 1}, new double[]{dArray[0], dArray[1], dArray[2], 0.0, 0.0, 0.0});
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(2, 0, new int[]{1, 2, 1}, new double[]{dArray[0], dArray[1], dArray[2], dArray[0], dArray[1], Math.abs(dArray[2]) + dArray3[2][1]});
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        for (n = 0; n < arrayList2.size(); ++n) {
            Object[] objectArray = new Object[2];
            objectArray = (Object[])arrayList2.get(n);
            j3D_Geometry2 = (J3D_Geometry)objectArray[0];
            n5 = (Integer)objectArray[1];
            for (n2 = 0; n2 < j3D_Geometry2.ordinates.length / 3 - 1; ++n2) {
                arrayList3.add(new J3D_Geometry(2, 0, new int[]{1, 2, 1}, new double[]{dArray[0], dArray[1], dArray[2], j3D_Geometry2.ordinates[3 * n2], j3D_Geometry2.ordinates[3 * n2 + 1], j3D_Geometry2.ordinates[3 * n2 + 2]}));
            }
        }
        double d2 = 0.0;
        double[] dArray4 = new double[arrayList3.size()];
        double d3 = 0.0;
        for (n = 0; n < arrayList3.size(); ++n) {
            j3D_Geometry2 = (J3D_Geometry)arrayList3.get(n);
            d2 = Math.sqrt((j3D_Geometry2.ordinates[3] - j3D_Geometry2.ordinates[0]) * (j3D_Geometry2.ordinates[3] - j3D_Geometry2.ordinates[0]) + (j3D_Geometry2.ordinates[4] - j3D_Geometry2.ordinates[1]) * (j3D_Geometry2.ordinates[4] - j3D_Geometry2.ordinates[1]) + (j3D_Geometry2.ordinates[5] - j3D_Geometry2.ordinates[2]) * (j3D_Geometry2.ordinates[5] - j3D_Geometry2.ordinates[2]));
            d3 = Math.acos((j3D_Geometry2.ordinates[5] - j3D_Geometry2.ordinates[2]) / d2);
            dArray4[n] = Math.abs(d3);
        }
        double d4 = dArray4[0];
        int n6 = 0;
        for (n = 1; n < dArray4.length; ++n) {
            if (!(dArray4[n] < d4) || !(dArray4[n] > 0.0)) continue;
            d4 = dArray4[n];
            n6 = n;
        }
        j3D_Geometry2 = (J3D_Geometry)arrayList3.get(n6);
        object.ordinates[3] = (j3D_Geometry3.ordinates[3] + j3D_Geometry2.ordinates[3]) / 2.0;
        object.ordinates[4] = (j3D_Geometry3.ordinates[4] + j3D_Geometry2.ordinates[4]) / 2.0;
        object.ordinates[5] = (j3D_Geometry3.ordinates[5] + j3D_Geometry2.ordinates[5]) / 2.0;
        for (n = 0; n < arrayList2.size(); ++n) {
            Object[] objectArray;
            Object[] objectArray2;
            double[] dArray5 = new double[1];
            double[] dArray6 = new double[3];
            Object[] objectArray3 = new Object[2];
            objectArray3 = (Object[])arrayList2.get(n);
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)objectArray3[0];
            int n7 = (Integer)objectArray3[1];
            J3D_Geometry.planeEquation(dArray6, dArray5, j3D_Geometry4);
            if (j3D_Geometry4.pointBoundaryIntersect(this, d)) {
                return true;
            }
            if (this.pointInPolygon(j3D_Geometry4, d)) {
                return true;
            }
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, j3D_Geometry4.getSRID(), new int[]{1, 1, 1}, new double[]{0.0, 0.0, 0.0});
            if (!J3D_Geometry.rayPlaneIntersection((J3D_Geometry)object, dArray6, dArray5, j3D_Geometry5, d)) continue;
            if (j3D_Geometry5.pointInPolygon(j3D_Geometry4, d) && !j3D_Geometry4.pointBoundaryIntersect(j3D_Geometry5, d)) {
                ++n4;
                continue;
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            if (!j3D_Geometry4.pointBoundaryIntersect(j3D_Geometry5, nArray, d)) continue;
            J3D_Geometry j3D_Geometry6 = null;
            ArrayList<double[][]> arrayList4 = new ArrayList<double[][]>();
            ArrayList<Object[]> arrayList5 = new ArrayList<Object[]>();
            ArrayList<double[][]> arrayList6 = new ArrayList<double[][]>();
            ArrayList<Object[]> arrayList7 = new ArrayList<Object[]>();
            double[][] dArray7 = new double[3][2];
            dArray7 = J3D_Geometry.getMBH(j3D_Geometry4);
            arrayList4.add(dArray7);
            Object[] objectArray4 = new Object[]{j3D_Geometry4, n7};
            arrayList5.add(objectArray4);
            RTree rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree, arrayList4, arrayList5);
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                if (n3 == n) continue;
                objectArray2 = new Object[2];
                objectArray2 = (Object[])arrayList2.get(n3);
                j3D_Geometry2 = (J3D_Geometry)objectArray2[0];
                n5 = (Integer)objectArray2[1];
                arrayList7.add(objectArray2);
                arrayList6.add(J3D_Geometry.getMBH(j3D_Geometry2));
            }
            objectArray2 = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2((RTree)objectArray2, arrayList6, arrayList7);
            ArrayList arrayList8 = new ArrayList();
            rTree.anyInteract((RTree)objectArray2, arrayList8);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            J3D_Geometry j3D_Geometry7 = null;
            J3D_Geometry j3D_Geometry8 = null;
            for (n3 = 0; n3 < arrayList8.size(); ++n3) {
                RTreeJoinRes rTreeJoinRes = (RTreeJoinRes)arrayList8.get(n3);
                objectArray = new Object[2];
                Object[] objectArray5 = new Object[2];
                objectArray = (Object[])rTreeJoinRes.ptr1;
                objectArray5 = (Object[])rTreeJoinRes.ptr2;
                j3D_Geometry7 = (J3D_Geometry)objectArray[0];
                j3D_Geometry8 = (J3D_Geometry)objectArray5[0];
                n8 = (Integer)objectArray[1];
                n9 = (Integer)objectArray5[1];
                if (j3D_Geometry7.elemInfo[1] == 2003) {
                    j3D_Geometry7.elemInfo[1] = 1003;
                }
                if (j3D_Geometry8.elemInfo[1] == 2003) {
                    j3D_Geometry8.elemInfo[1] = 1003;
                }
                if (!j3D_Geometry7.anyInteract(j3D_Geometry8, d) || !j3D_Geometry7.anyInteract(j3D_Geometry5, d) || !j3D_Geometry8.anyInteract(j3D_Geometry5, d)) continue;
                if (n8 == n7) {
                    j3D_Geometry6 = new J3D_Geometry(3, j3D_Geometry8.getSRID(), j3D_Geometry8.getElemInfo(), j3D_Geometry8.getOrdinatesArray());
                    break;
                }
                j3D_Geometry6 = new J3D_Geometry(3, j3D_Geometry7.getSRID(), j3D_Geometry7.getElemInfo(), j3D_Geometry7.getOrdinatesArray());
                n10 = n9;
                n9 = n8;
                n8 = n10;
                break;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList2.get(i);
                int n11 = (Integer)objectArray[1];
                if (n9 != n11) continue;
                arrayList2.remove(i);
            }
            if (super.pointBoundaryIntersect(this, d) || this.pointInPolygon(j3D_Geometry6, d)) {
                return true;
            }
            if (!j3D_Geometry6.pointBoundaryIntersect(j3D_Geometry5, nArray2, d)) {
                throw new Exception("13034: Invalid data in the SDO_ORDINATE_ARRAY in SDO_GEOMETRY object");
            }
            n4 += J3D_Geometry.Points_on_2_faces(j3D_Geometry4, j3D_Geometry6, nArray, nArray2, (J3D_Geometry)object, j3D_Geometry5);
        }
        return n4 % 2 != 0;
    }

    private boolean pointInSolid(J3D_Geometry j3D_Geometry, boolean bl, double d) throws Exception {
        Object object;
        double[] dArray = new double[3];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        J3D_Geometry j3D_Geometry2 = null;
        double[][] dArray2 = new double[3][2];
        double[][] dArray3 = new double[3][2];
        dArray2 = J3D_Geometry.getMBH(this);
        if (!this.ImbhAB(dArray2, dArray3 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
            return false;
        }
        dArray[0] = this.ordinates[0];
        dArray[1] = this.ordinates[1];
        dArray[2] = this.ordinates[2];
        ArrayList arrayList = new ArrayList();
        arrayList = j3D_Geometry.getFaces(bl);
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        int n5 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            object = new Object[]{(J3D_Geometry)arrayList.get(n), n5};
            arrayList2.add((Object[])object);
            ++n5;
        }
        object = new J3D_Geometry(2, 0, new int[]{1, 2, 1}, new double[]{dArray[0], dArray[1], dArray[2], 0.0, 0.0, 0.0});
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(2, 0, new int[]{1, 2, 1}, new double[]{dArray[0], dArray[1], dArray[2], dArray[0], dArray[1], Math.abs(dArray[2]) + dArray3[2][1]});
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        for (n = 0; n < arrayList2.size(); ++n) {
            Object[] objectArray = new Object[2];
            objectArray = (Object[])arrayList2.get(n);
            j3D_Geometry2 = (J3D_Geometry)objectArray[0];
            n5 = (Integer)objectArray[1];
            for (n2 = 0; n2 < j3D_Geometry2.ordinates.length / 3 - 1; ++n2) {
                arrayList3.add(new J3D_Geometry(2, 0, new int[]{1, 2, 1}, new double[]{dArray[0], dArray[1], dArray[2], j3D_Geometry2.ordinates[3 * n2], j3D_Geometry2.ordinates[3 * n2 + 1], j3D_Geometry2.ordinates[3 * n2 + 2]}));
            }
        }
        double d2 = 0.0;
        double[] dArray4 = new double[arrayList3.size()];
        double d3 = 0.0;
        for (n = 0; n < arrayList3.size(); ++n) {
            j3D_Geometry2 = (J3D_Geometry)arrayList3.get(n);
            d2 = Math.sqrt((j3D_Geometry2.ordinates[3] - j3D_Geometry2.ordinates[0]) * (j3D_Geometry2.ordinates[3] - j3D_Geometry2.ordinates[0]) + (j3D_Geometry2.ordinates[4] - j3D_Geometry2.ordinates[1]) * (j3D_Geometry2.ordinates[4] - j3D_Geometry2.ordinates[1]) + (j3D_Geometry2.ordinates[5] - j3D_Geometry2.ordinates[2]) * (j3D_Geometry2.ordinates[5] - j3D_Geometry2.ordinates[2]));
            d3 = Math.acos((j3D_Geometry2.ordinates[5] - j3D_Geometry2.ordinates[2]) / d2);
            dArray4[n] = Math.abs(d3);
        }
        double d4 = dArray4[0];
        int n6 = 0;
        for (n = 1; n < dArray4.length; ++n) {
            if (!(dArray4[n] < d4) || !(dArray4[n] > 0.0)) continue;
            d4 = dArray4[n];
            n6 = n;
        }
        j3D_Geometry2 = (J3D_Geometry)arrayList3.get(n6);
        object.ordinates[3] = (j3D_Geometry3.ordinates[3] + j3D_Geometry2.ordinates[3]) / 2.0;
        object.ordinates[4] = (j3D_Geometry3.ordinates[4] + j3D_Geometry2.ordinates[4]) / 2.0;
        object.ordinates[5] = (j3D_Geometry3.ordinates[5] + j3D_Geometry2.ordinates[5]) / 2.0;
        for (n = 0; n < arrayList2.size(); ++n) {
            Object[] objectArray;
            Object[] objectArray2;
            double[] dArray5 = new double[1];
            double[] dArray6 = new double[3];
            Object[] objectArray3 = new Object[2];
            objectArray3 = (Object[])arrayList2.get(n);
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)objectArray3[0];
            int n7 = (Integer)objectArray3[1];
            J3D_Geometry.planeEquation(dArray6, dArray5, j3D_Geometry4);
            if (j3D_Geometry4.pointBoundaryIntersect(this, d)) {
                return false;
            }
            if (this.pointInPolygon(j3D_Geometry4, d)) {
                return false;
            }
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, j3D_Geometry4.getSRID(), new int[]{1, 1, 1}, new double[]{0.0, 0.0, 0.0});
            if (!J3D_Geometry.rayPlaneIntersection((J3D_Geometry)object, dArray6, dArray5, j3D_Geometry5, d)) continue;
            if (j3D_Geometry5.pointInPolygon(j3D_Geometry4, d) && !j3D_Geometry4.pointBoundaryIntersect(j3D_Geometry5, d)) {
                ++n4;
                continue;
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            if (!j3D_Geometry4.pointBoundaryIntersect(j3D_Geometry5, nArray, d)) continue;
            J3D_Geometry j3D_Geometry6 = null;
            ArrayList<double[][]> arrayList4 = new ArrayList<double[][]>();
            ArrayList<Object[]> arrayList5 = new ArrayList<Object[]>();
            ArrayList<double[][]> arrayList6 = new ArrayList<double[][]>();
            ArrayList<Object[]> arrayList7 = new ArrayList<Object[]>();
            double[][] dArray7 = new double[3][2];
            dArray7 = J3D_Geometry.getMBH(j3D_Geometry4);
            arrayList4.add(dArray7);
            Object[] objectArray4 = new Object[]{j3D_Geometry4, n7};
            arrayList5.add(objectArray4);
            RTree rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree, arrayList4, arrayList5);
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                if (n3 == n) continue;
                objectArray2 = new Object[2];
                objectArray2 = (Object[])arrayList2.get(n3);
                j3D_Geometry2 = (J3D_Geometry)objectArray2[0];
                n5 = (Integer)objectArray2[1];
                arrayList7.add(objectArray2);
                arrayList6.add(J3D_Geometry.getMBH(j3D_Geometry2));
            }
            objectArray2 = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2((RTree)objectArray2, arrayList6, arrayList7);
            ArrayList arrayList8 = new ArrayList();
            rTree.anyInteract((RTree)objectArray2, arrayList8);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            J3D_Geometry j3D_Geometry7 = null;
            J3D_Geometry j3D_Geometry8 = null;
            for (n3 = 0; n3 < arrayList8.size(); ++n3) {
                RTreeJoinRes rTreeJoinRes = (RTreeJoinRes)arrayList8.get(n3);
                objectArray = new Object[2];
                Object[] objectArray5 = new Object[2];
                objectArray = (Object[])rTreeJoinRes.ptr1;
                objectArray5 = (Object[])rTreeJoinRes.ptr2;
                j3D_Geometry7 = (J3D_Geometry)objectArray[0];
                j3D_Geometry8 = (J3D_Geometry)objectArray5[0];
                n8 = (Integer)objectArray[1];
                n9 = (Integer)objectArray5[1];
                if (j3D_Geometry7.elemInfo[1] == 2003) {
                    j3D_Geometry7.elemInfo[1] = 1003;
                }
                if (j3D_Geometry8.elemInfo[1] == 2003) {
                    j3D_Geometry8.elemInfo[1] = 1003;
                }
                if (!j3D_Geometry7.anyInteract(j3D_Geometry8, d) || !j3D_Geometry7.anyInteract(j3D_Geometry5, d) || !j3D_Geometry8.anyInteract(j3D_Geometry5, d)) continue;
                if (n8 == n7) {
                    j3D_Geometry6 = new J3D_Geometry(3, j3D_Geometry8.getSRID(), j3D_Geometry8.getElemInfo(), j3D_Geometry8.getOrdinatesArray());
                    break;
                }
                j3D_Geometry6 = new J3D_Geometry(3, j3D_Geometry7.getSRID(), j3D_Geometry7.getElemInfo(), j3D_Geometry7.getOrdinatesArray());
                n10 = n9;
                n9 = n8;
                n8 = n10;
                break;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList2.get(i);
                int n11 = (Integer)objectArray[1];
                if (n9 != n11) continue;
                arrayList2.remove(i);
            }
            if (super.pointBoundaryIntersect(this, d) || this.pointInPolygon(j3D_Geometry6, d)) {
                return false;
            }
            if (!j3D_Geometry6.pointBoundaryIntersect(j3D_Geometry5, nArray2, d)) {
                throw new Exception("13034: Invalid data in the SDO_ORDINATE_ARRAY in SDO_GEOMETRY object");
            }
            n4 += J3D_Geometry.Points_on_2_faces(j3D_Geometry4, j3D_Geometry6, nArray, nArray2, (J3D_Geometry)object, j3D_Geometry5);
        }
        return n4 % 2 != 0;
    }

    private static int Points_on_2_faces(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, int[] nArray, int[] nArray2, J3D_Geometry j3D_Geometry3, J3D_Geometry j3D_Geometry4) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n3 = nArray[0] == j3D_Geometry.ordinates.length / 3 - 1 ? 0 : nArray[0] + 2;
        n4 = nArray2[0] == j3D_Geometry2.ordinates.length / 3 - 1 ? 0 : nArray2[0] + 2;
        J3D_Geometry j3D_Geometry5 = new J3D_Geometry(2, j3D_Geometry.getSRID(), new int[]{1, 2, 1}, new double[]{j3D_Geometry.ordinates[3 * nArray[0]], j3D_Geometry.ordinates[3 * nArray[0] + 1], j3D_Geometry.ordinates[3 * nArray[0] + 2], j3D_Geometry.ordinates[3 * nArray[0] + 3], j3D_Geometry.ordinates[3 * nArray[0] + 4], j3D_Geometry.ordinates[3 * nArray[0] + 5]});
        J3D_Geometry j3D_Geometry6 = new J3D_Geometry(3, j3D_Geometry.getSRID(), new int[]{1, 1003, 1}, new double[12]);
        for (n2 = 0; n2 < 3; ++n2) {
            j3D_Geometry6.ordinates[n2] = j3D_Geometry5.ordinates[n2];
            j3D_Geometry6.ordinates[3 + n2] = j3D_Geometry5.ordinates[3 + n2];
            j3D_Geometry6.ordinates[6 + n2] = j3D_Geometry3.ordinates[n2];
            j3D_Geometry6.ordinates[9 + n2] = j3D_Geometry5.ordinates[n2];
        }
        J3D_Geometry j3D_Geometry7 = new J3D_Geometry(1, j3D_Geometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.ordinates[3 * n3], j3D_Geometry.ordinates[3 * n3 + 1], j3D_Geometry.ordinates[3 * n3 + 2]});
        J3D_Geometry j3D_Geometry8 = new J3D_Geometry(1, j3D_Geometry2.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry2.ordinates[3 * n4], j3D_Geometry2.ordinates[3 * n4 + 1], j3D_Geometry2.ordinates[3 * n4 + 2]});
        int n5 = J3D_Geometry.compassing(j3D_Geometry6, j3D_Geometry7);
        if (n5 == (n = J3D_Geometry.compassing(j3D_Geometry6, j3D_Geometry8))) {
            return 0;
        }
        return 1;
    }

    private static int compassing(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2) {
        double d = 0.0;
        double d2 = 1.0E-16;
        double[] dArray = new double[3];
        double[] dArray2 = new double[1];
        J3D_Geometry.planeEquation(dArray, dArray2, j3D_Geometry);
        d = dArray[0] * j3D_Geometry2.ordinates[0] + dArray[1] * j3D_Geometry2.ordinates[1] + dArray[2] * j3D_Geometry2.ordinates[2] + dArray2[0];
        int n = d > d2 ? 1 : (d < -d2 ? -1 : 0);
        return n;
    }

    private static int planeEquation(double[] dArray, double[] dArray2, J3D_Geometry j3D_Geometry) {
        int n = j3D_Geometry.ordinates.length / 3;
        double[][] dArray3 = new double[n][3];
        for (int i = 0; i < n; ++i) {
            dArray3[i][0] = j3D_Geometry.ordinates[3 * i];
            dArray3[i][1] = j3D_Geometry.ordinates[3 * i + 1];
            dArray3[i][2] = j3D_Geometry.ordinates[3 * i + 2];
        }
        return J3D_Geometry.planeEquation(dArray, dArray2, dArray3);
    }

    private static int planeEquation(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2;
        int n3 = dArray3.length - 1;
        int n4 = 3;
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = (n2 + 1) % n3;
            dArray[0] = dArray[0] + (dArray3[n2][1] - dArray3[n][1]) * (dArray3[n2][2] + dArray3[n][2]);
            dArray[1] = dArray[1] + (dArray3[n2][2] - dArray3[n][2]) * (dArray3[n2][0] + dArray3[n][0]);
            dArray[2] = dArray[2] + (dArray3[n2][0] - dArray3[n][0]) * (dArray3[n2][1] + dArray3[n][1]);
        }
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        n = 0;
        while (n < n4) {
            int n5 = n++;
            dArray[n5] = dArray[n5] / d;
        }
        double[] dArray4 = new double[n4];
        n = 0;
        while (n < n4) {
            dArray4[n] = 0.0;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n] = dArray4[n] + dArray3[n2][n];
            }
            int n6 = n++;
            dArray4[n6] = dArray4[n6] / (double)n3;
        }
        dArray2[0] = -1.0 * (dArray[0] * dArray4[0] + dArray[1] * dArray4[1] + dArray[2] * dArray4[2]);
        double d2 = Math.abs(dArray[0]);
        double d3 = Math.abs(dArray[1]);
        double d4 = Math.abs(dArray[2]);
        int n7 = 3;
        if (d2 > d3) {
            if (d2 > d4) {
                n7 = 1;
            }
        } else if (d3 > d4) {
            n7 = 2;
        }
        return n7;
    }

    private boolean pointBoundaryIntersect(J3D_Geometry j3D_Geometry, double d) {
        int[] nArray = new int[1];
        return this.pointBoundaryIntersect(j3D_Geometry, nArray, d);
    }

    private boolean pointBoundaryIntersect(J3D_Geometry j3D_Geometry, int[] nArray, double d) {
        double[] dArray = new double[]{j3D_Geometry.ordinates[0], j3D_Geometry.ordinates[1], j3D_Geometry.ordinates[2]};
        for (int i = 0; i < this.ordinates.length / 3 - 1; ++i) {
            nArray[0] = i;
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[3];
            for (int j = 0; j < 3; ++j) {
                dArray2[j] = this.ordinates[3 * i + j];
                dArray3[j] = this.ordinates[3 * (i + 1) + j];
            }
            if (!J3D_Geometry.pointEdge(dArray, dArray2, dArray3, d)) continue;
            return true;
        }
        return false;
    }

    private static boolean pointEdge(double[] dArray, double[] dArray2, double[] dArray3, double d) {
        double d2;
        int n;
        if (dArray2[0] < dArray3[0] ? dArray[0] + d < dArray2[0] || dArray[0] > dArray3[0] + d : dArray[0] + d < dArray3[0] || dArray[0] > dArray2[0] + d) {
            return false;
        }
        if (dArray2[1] < dArray3[1] ? dArray[1] + d < dArray2[1] || dArray[1] > dArray3[1] + d : dArray[1] + d < dArray3[1] || dArray[1] > dArray2[1] + d) {
            return false;
        }
        if (dArray2[2] < dArray3[2] ? dArray[2] + d < dArray2[2] || dArray[2] > dArray3[2] + d : dArray[2] + d < dArray3[2] || dArray[2] > dArray2[2] + d) {
            return false;
        }
        double[] dArray4 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray4[n] = dArray3[n] - dArray2[n];
        }
        double[] dArray5 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray5[n] = dArray2[n] - dArray[n];
        }
        double[] dArray6 = new double[3];
        dArray6 = J3D_Geometry.crossProduct(dArray4, dArray5);
        double d3 = J3D_Geometry.dotProduct(dArray6, dArray6);
        double d4 = d3 / (d2 = J3D_Geometry.dotProduct(dArray4, dArray4));
        double d5 = Math.sqrt(d4);
        return d5 <= d;
    }

    private static double[] crossProduct(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    private static double dotProduct(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    private static boolean rayPlaneIntersection(J3D_Geometry j3D_Geometry, double[] dArray, double[] dArray2, J3D_Geometry j3D_Geometry2, double d) throws Exception {
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        boolean bl = false;
        double d2 = 0.0;
        dArray3[0] = j3D_Geometry.ordinates[0];
        dArray3[1] = j3D_Geometry.ordinates[1];
        dArray3[2] = j3D_Geometry.ordinates[2];
        dArray4[0] = j3D_Geometry.ordinates[3];
        dArray4[1] = j3D_Geometry.ordinates[4];
        dArray4[2] = j3D_Geometry.ordinates[5];
        double d3 = (dArray4[0] - dArray3[0]) * dArray[0] + (dArray4[1] - dArray3[1]) * dArray[1] + (dArray4[2] - dArray3[2]) * dArray[2];
        if (Math.abs(d3) <= d) {
            if (Math.abs(J3D_Geometry.dotProduct(dArray3, dArray) + dArray2[0]) <= d) {
                bl = true;
            } else {
                return false;
            }
        }
        double d4 = 0.0;
        if (!bl) {
            d4 = -1.0 * (J3D_Geometry.dotProduct(dArray3, dArray) + dArray2[0]);
            d2 = d4 / d3;
        }
        if (d2 < 0.0) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            j3D_Geometry2.ordinates[i] = dArray3[i] + d2 * (dArray4[i] - dArray3[i]);
        }
        return true;
    }

    public boolean pointInPolygon(J3D_Geometry j3D_Geometry, double d) {
        int n;
        double[] dArray = new double[1];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        int n2 = J3D_Geometry.planeEquation(dArray2, dArray, j3D_Geometry);
        double[] dArray5 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray5[n] = this.ordinates[n];
        }
        double d2 = J3D_Geometry.dotProduct(dArray2, dArray5) + dArray[0];
        if (!(Math.abs(d2) <= d)) {
            return false;
        }
        int n3 = 0;
        for (n = 0; n < j3D_Geometry.ordinates.length / 3; ++n) {
            int n4;
            J3D_Geometry j3D_Geometry2;
            int n5 = 0;
            if (n != j3D_Geometry.ordinates.length / 3 - 1) {
                n5 = n + 1;
            }
            if (J3D_Geometry.mindistpts_pntseg(this, j3D_Geometry2 = new J3D_Geometry(2, j3D_Geometry.getSRID(), new int[]{1, 2, 1}, new double[]{j3D_Geometry.ordinates[n * 3], j3D_Geometry.ordinates[n * 3 + 1], j3D_Geometry.ordinates[n * 3 + 2], j3D_Geometry.ordinates[n5 * 3], j3D_Geometry.ordinates[n5 * 3 + 1], j3D_Geometry.ordinates[n5 * 3 + 2]}), d)) {
                return false;
            }
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            switch (n2) {
                case 1: {
                    d3 = j3D_Geometry.ordinates[n * 3 + 2];
                    d4 = j3D_Geometry.ordinates[n5 * 3 + 2];
                    d5 = dArray5[2];
                    break;
                }
                case 2: {
                    d3 = j3D_Geometry.ordinates[n * 3 + 2];
                    d4 = j3D_Geometry.ordinates[n5 * 3 + 2];
                    d5 = dArray5[2];
                    break;
                }
                case 3: {
                    d3 = j3D_Geometry.ordinates[n * 3 + 1];
                    d4 = j3D_Geometry.ordinates[n5 * 3 + 1];
                    d5 = dArray5[1];
                }
            }
            if (d3 <= d5) {
                if (!(d4 > d5)) continue;
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray3[n4] = j3D_Geometry.ordinates[n * 3 + n4];
                    dArray4[n4] = j3D_Geometry.ordinates[n5 * 3 + n4];
                }
                if (!(J3D_Geometry.isLeft(dArray3, dArray4, dArray5, n2) > 0.0)) continue;
                ++n3;
                continue;
            }
            if (!(d4 <= d5)) continue;
            for (n4 = 0; n4 < 3; ++n4) {
                dArray3[n4] = j3D_Geometry.ordinates[n * 3 + n4];
                dArray4[n4] = j3D_Geometry.ordinates[n5 * 3 + n4];
            }
            if (!(J3D_Geometry.isLeft(dArray3, dArray4, dArray5, n2) < 0.0)) continue;
            --n3;
        }
        return n3 != 0;
    }

    private static double isLeft(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        double d = 0.0;
        switch (n) {
            case 1: {
                d = (dArray2[1] - dArray[1]) * (dArray3[2] - dArray[2]) - (dArray3[1] - dArray[1]) * (dArray2[2] - dArray[2]);
                break;
            }
            case 2: {
                d = (dArray2[0] - dArray[0]) * (dArray3[2] - dArray[2]) - (dArray3[0] - dArray[0]) * (dArray2[2] - dArray[2]);
                break;
            }
            case 3: {
                d = (dArray2[0] - dArray[0]) * (dArray3[1] - dArray[1]) - (dArray3[0] - dArray[0]) * (dArray2[1] - dArray[1]);
            }
        }
        return d;
    }

    private static double[][] volRegInt(double[][] dArray, double[][] dArray2) {
        int n = 3;
        double[][] dArray3 = new double[n][2];
        for (int i = 0; i < n; ++i) {
            dArray3[i][0] = Math.max(dArray[i][0], dArray2[i][0]);
            dArray3[i][1] = Math.min(dArray[i][1], dArray2[i][1]);
        }
        return dArray3;
    }

    private static void getIntsctMBH(double[][] dArray, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, double d) {
        int n = 3;
        for (int i = 0; i < arrayList2.size(); ++i) {
            Object object;
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                object = new double[n][2];
                object = (double[][])arrayList2.get(i);
                if (dArray[j][0] > object[j][1] + d || object[j][0] > dArray[j][1] + d) continue;
                ++n2;
            }
            if (n2 != n) continue;
            arrayList3.add(arrayList2.get(i));
            object = (J3D_Geometry)arrayList.get(i);
            arrayList4.add(object);
        }
    }

    private static void createRTree(RTree rTree, ArrayList arrayList, ArrayList arrayList2) throws Exception {
        int n = 3;
        int n2 = arrayList.size();
        double[][][] dArray = new double[n2][n][2];
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = (double[][])arrayList.get(i);
            objectArray[i] = (J3D_Geometry)arrayList2.get(i);
        }
        rTree.packTree(dArray, objectArray);
    }

    protected static void createRTree2(RTree rTree, ArrayList arrayList, ArrayList arrayList2) throws Exception {
        int n = 3;
        int n2 = arrayList.size();
        double[][][] dArray = new double[n2][n][2];
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = (double[][])arrayList.get(i);
            objectArray[i] = (Object[])arrayList2.get(i);
        }
        rTree.packTree(dArray, objectArray);
    }

    private static boolean mindistpts_segseg(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) {
        double d2;
        double d3;
        double d4;
        int n;
        double d5 = 1.0E-16;
        int n2 = 3;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = j3D_Geometry.ordinates[n];
            dArray2[n] = j3D_Geometry.ordinates[n + n2];
            dArray3[n] = j3D_Geometry2.ordinates[n];
            dArray4[n] = j3D_Geometry2.ordinates[n + n2];
        }
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray5[n] = dArray2[n] - dArray[n];
            dArray6[n] = dArray4[n] - dArray3[n];
            dArray7[n] = dArray[n] - dArray3[n];
        }
        for (n = 0; n < n2; ++n) {
            d6 += dArray5[n] * dArray5[n];
            d7 += dArray5[n] * dArray6[n];
            d8 += dArray6[n] * dArray6[n];
            d9 += dArray5[n] * dArray7[n];
            d10 += dArray6[n] * dArray7[n];
        }
        double d13 = d4 = d6 * d8 - d7 * d7;
        double d14 = d4;
        if (d4 < d5) {
            d3 = 0.0;
            d13 = 1.0;
            d2 = d10;
            d14 = d8;
        } else {
            d3 = d7 * d10 - d8 * d9;
            d2 = d6 * d10 - d7 * d9;
            if (d3 < 0.0) {
                d3 = 0.0;
                d2 = d10;
                d14 = d8;
            } else if (d3 > d13) {
                d3 = d13;
                d2 = d10 + d7;
                d14 = d8;
            }
        }
        if (d2 < 0.0) {
            d2 = 0.0;
            if (-d9 < 0.0) {
                d3 = 0.0;
            } else if (-d9 > d6) {
                d3 = d13;
            } else {
                d3 = -d9;
                d13 = d6;
            }
        } else if (d2 > d14) {
            d2 = d14;
            if (-d9 + d7 < 0.0) {
                d3 = 0.0;
            } else if (-d9 + d7 > d6) {
                d3 = d13;
            } else {
                d3 = -d9 + d7;
                d13 = d6;
            }
        }
        double d15 = Math.abs(d3) < d5 ? 0.0 : d3 / d13;
        double d16 = Math.abs(d2) < d5 ? 0.0 : d2 / d14;
        for (n = 0; n < n2; ++n) {
            dArray8[n] = dArray7[n] + d15 * dArray5[n] - d16 * dArray6[n];
            d12 += dArray8[n] * dArray8[n];
        }
        return d12 < d * d;
    }

    private static boolean mindistpts_pntseg(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) {
        int n;
        int n2 = 3;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = j3D_Geometry.ordinates[n];
            dArray2[n] = j3D_Geometry2.ordinates[n];
            dArray3[n] = j3D_Geometry2.ordinates[n + n2];
        }
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[2 * n2 + 1];
        for (n = 0; n < n2; ++n) {
            dArray4[n] = dArray3[n] - dArray2[n];
            dArray5[n] = dArray[n] - dArray2[n];
            d2 += dArray5[n] * dArray4[n];
            d3 += dArray4[n] * dArray4[n];
        }
        if (d2 <= 0.0) {
            d4 = 0.0;
            for (n = 0; n < n2; ++n) {
                d4 += (dArray[n] - dArray2[n]) * (dArray[n] - dArray2[n]);
                dArray7[n] = dArray[n];
                dArray7[n + n2] = dArray2[n];
            }
            dArray7[2 * n2] = Math.sqrt(d4);
            return Math.sqrt(d4) < d;
        }
        if (d3 <= d2) {
            d4 = 0.0;
            for (n = 0; n < n2; ++n) {
                d4 += (dArray[n] - dArray3[n]) * (dArray[n] - dArray3[n]);
                dArray7[n] = dArray[n];
                dArray7[n + n2] = dArray3[n];
            }
            dArray7[2 * n2] = Math.sqrt(d4);
            return Math.sqrt(d4) < d;
        }
        double d5 = d2 / d3;
        d4 = 0.0;
        for (n = 0; n < n2; ++n) {
            dArray6[n] = dArray2[n] + d5 * dArray4[n];
            d4 += (dArray[n] - dArray6[n]) * (dArray[n] - dArray6[n]);
            dArray7[n] = dArray[n];
            dArray7[n + n2] = dArray6[n];
        }
        dArray7[2 * n2] = Math.sqrt(d4);
        return Math.sqrt(d4) < d;
    }

    private ArrayList getFaces(boolean bl) throws Exception {
        J3D_Geometry j3D_Geometry;
        J3D_Geometry j3D_Geometry2;
        ElementExtractor elementExtractor;
        ArrayList<J3D_Geometry> arrayList;
        int[] nArray = new int[1];
        if (this.elemInfo[1] != 1006 && this.elemInfo[1] != 2006) {
            arrayList = new ArrayList();
            elementExtractor = new ElementExtractor(this, 0, 2, 3, bl);
            nArray[0] = 0;
            while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
                if (nArray[0] == 2) continue;
                arrayList.add(j3D_Geometry2);
            }
            j3D_Geometry2 = (J3D_Geometry)arrayList.get(0);
            ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
            ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry2, 0, 1, 3, bl);
            nArray[0] = 0;
            while ((j3D_Geometry = elementExtractor2.nextElement(nArray)) != null) {
                if (nArray[0] == 2) continue;
                arrayList2.add(j3D_Geometry);
            }
            j3D_Geometry = (J3D_Geometry)arrayList2.get(0);
        } else {
            j3D_Geometry = this;
        }
        arrayList = new ArrayList<J3D_Geometry>();
        elementExtractor = new ElementExtractor(j3D_Geometry, 0, 0, 3, bl);
        nArray[0] = 0;
        while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
            if (nArray[0] == 2) {
                arrayList.add(j3D_Geometry2);
                continue;
            }
            arrayList.add(j3D_Geometry2);
        }
        return arrayList;
    }

    private ArrayList getFaces2(boolean bl) throws Exception {
        J3D_Geometry j3D_Geometry;
        J3D_Geometry j3D_Geometry2;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(this, 0, 2, 3, bl);
        nArray[0] = 0;
        while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
            if (nArray[0] == 2) continue;
            arrayList.add(j3D_Geometry2);
        }
        j3D_Geometry2 = (J3D_Geometry)arrayList.get(0);
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry2, 0, 1, 3, bl);
        nArray[0] = 0;
        while ((j3D_Geometry = elementExtractor2.nextElement(nArray)) != null) {
            if (nArray[0] == 2) {
                arrayList2.add(j3D_Geometry);
                continue;
            }
            arrayList2.add(j3D_Geometry);
        }
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            J3D_Geometry j3D_Geometry3;
            j3D_Geometry = (J3D_Geometry)arrayList2.get(i);
            ElementExtractor elementExtractor3 = new ElementExtractor(j3D_Geometry, 0, 0, 3, bl);
            nArray[0] = 0;
            while ((j3D_Geometry3 = elementExtractor3.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    j3D_Geometry3.elemInfo[1] = 1003;
                    arrayList3.add(j3D_Geometry3);
                    continue;
                }
                arrayList3.add(j3D_Geometry3);
            }
        }
        return arrayList3;
    }

    private ArrayList getFaces3(boolean bl) throws Exception {
        J3D_Geometry j3D_Geometry;
        J3D_Geometry j3D_Geometry2;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(this, 0, 2, 3, bl);
        nArray[0] = 0;
        while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
            if (nArray[0] == 2) continue;
            arrayList.add(j3D_Geometry2);
        }
        j3D_Geometry2 = (J3D_Geometry)arrayList.get(0);
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry2, 0, 1, 3, bl);
        nArray[0] = 0;
        while ((j3D_Geometry = elementExtractor2.nextElement(nArray)) != null) {
            if (nArray[0] == 2) {
                arrayList2.add(j3D_Geometry);
                continue;
            }
            arrayList2.add(j3D_Geometry);
        }
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            J3D_Geometry j3D_Geometry3;
            j3D_Geometry = (J3D_Geometry)arrayList2.get(i);
            ElementExtractor elementExtractor3 = new ElementExtractor(j3D_Geometry, 0, 0, 3, bl);
            nArray[0] = 0;
            while ((j3D_Geometry3 = elementExtractor3.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    arrayList3.add(j3D_Geometry3);
                    continue;
                }
                arrayList3.add(j3D_Geometry3);
            }
        }
        return arrayList3;
    }

    public boolean anyInteract2(J3D_Geometry j3D_Geometry, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, double d) throws Exception {
        int n = 3;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (blArray3[0] || blArray3[1]) {
            int n2;
            int n3;
            J3D_Geometry j3D_Geometry2;
            J3D_Geometry j3D_Geometry3;
            if (this.gtype == 8) {
                j3D_Geometry3 = (J3D_Geometry)this.solids1.get(this.solids1.size() - 1);
            } else if (this.gtype == 3) {
                j3D_Geometry3 = (J3D_Geometry)this.surfs1.get(this.surfs1.size() - 1);
            } else if (this.gtype == 2) {
                j3D_Geometry3 = this;
            } else if (this.gtype == 1) {
                j3D_Geometry3 = this;
            } else {
                Object var18_10 = null;
                throw new Exception("54538");
            }
            if (j3D_Geometry.gtype == 8) {
                j3D_Geometry2 = (J3D_Geometry)this.solids2.get(this.solids2.size() - 1);
            } else if (j3D_Geometry.gtype == 3) {
                j3D_Geometry2 = (J3D_Geometry)this.surfs2.get(this.surfs2.size() - 1);
            } else if (j3D_Geometry.gtype == 2) {
                j3D_Geometry2 = j3D_Geometry;
            } else if (j3D_Geometry.gtype == 1) {
                j3D_Geometry2 = j3D_Geometry;
            } else {
                Object var19_17 = null;
                throw new Exception("54538");
            }
            blArray3[0] = false;
            blArray3[1] = false;
            if (!(j3D_Geometry3.gtype != 1 && j3D_Geometry3.gtype != 2 || j3D_Geometry2.gtype != 1 && j3D_Geometry2.gtype != 2)) {
                throw new Exception("54540");
            }
            ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList4 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList5 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList6 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList7 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList8 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList9 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList10 = new ArrayList<J3D_Geometry>();
            for (n3 = 1; n3 <= this.solids1.size(); ++n3) {
                arrayList3.add((J3D_Geometry)this.solids1.get(n3 - 1));
            }
            for (n3 = 1; n3 <= this.solids2.size(); ++n3) {
                arrayList4.add((J3D_Geometry)this.solids2.get(n3 - 1));
            }
            for (n3 = 1; n3 <= this.solidHoles1.size(); ++n3) {
                arrayList5.add((J3D_Geometry)this.solidHoles1.get(n3 - 1));
            }
            for (n3 = 1; n3 <= this.solidHoles2.size(); ++n3) {
                arrayList6.add((J3D_Geometry)this.solidHoles2.get(n3 - 1));
            }
            for (n3 = 1; n3 <= this.surfs1.size(); ++n3) {
                arrayList7.add((J3D_Geometry)this.surfs1.get(n3 - 1));
            }
            for (n3 = 1; n3 <= this.surfs2.size(); ++n3) {
                arrayList8.add((J3D_Geometry)this.surfs2.get(n3 - 1));
            }
            for (n3 = 1; n3 <= this.surfHoles1.size(); ++n3) {
                arrayList9.add((J3D_Geometry)this.surfHoles1.get(n3 - 1));
            }
            for (n3 = 1; n3 <= this.surfHoles2.size(); ++n3) {
                arrayList10.add((J3D_Geometry)this.surfHoles2.get(n3 - 1));
            }
            if (!j3D_Geometry3.anyInteract2(j3D_Geometry2, blArray, blArray2, blArray3, d)) {
                return false;
            }
            for (n2 = 0; n2 < arrayList6.size(); ++n2) {
                if (!j3D_Geometry3.isInside((J3D_Geometry)arrayList6.get(n2), d)) continue;
                return false;
            }
            for (n2 = 0; n2 < arrayList10.size(); ++n2) {
                if (!j3D_Geometry3.isInside((J3D_Geometry)arrayList10.get(n2), d)) continue;
                return false;
            }
            for (n2 = 0; n2 < arrayList5.size(); ++n2) {
                if (!j3D_Geometry2.isInside((J3D_Geometry)arrayList5.get(n2), d)) continue;
                return false;
            }
            for (n2 = 0; n2 < arrayList9.size(); ++n2) {
                if (!j3D_Geometry2.isInside((J3D_Geometry)arrayList9.get(n2), d)) continue;
                return false;
            }
            return true;
        }
        if ((blArray[0] || blArray[1]) && (blArray2[0] || blArray2[1]) && !blArray3[0] && !blArray3[1]) {
            boolean bl = blArray[0];
            boolean bl2 = blArray[1];
            double[][] dArray = new double[3][2];
            double[][] dArray2 = new double[3][2];
            dArray = J3D_Geometry.getMBH(this);
            if (!this.ImbhAB(dArray, dArray2 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
                return false;
            }
            int n4 = 0;
            int n5 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < 3; ++i) {
                if (dArray[i][1] + d >= dArray2[i][1] && dArray[i][0] <= dArray2[i][0] + d) {
                    ++n4;
                }
                if (!(dArray2[i][1] + d >= dArray[i][1]) || !(dArray2[i][0] <= dArray[i][0] + d)) continue;
                ++n5;
            }
            if (n4 == 3) {
                bl3 = true;
            }
            if (n5 == 3) {
                bl4 = true;
            }
            blArray[0] = false;
            blArray[1] = false;
            blArray3[0] = false;
            blArray3[1] = false;
            if (this.anyInteract2(j3D_Geometry, blArray, blArray2, blArray3, d)) {
                return true;
            }
            if (bl && bl3) {
                int[] nArray = new int[3];
                double[] dArray3 = new double[]{j3D_Geometry.ordinates[0], j3D_Geometry.ordinates[1], j3D_Geometry.ordinates[2]};
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[2] = 1;
                J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, 0, nArray, dArray3);
                return j3D_Geometry4.pointInOnSolid(this, false, d);
            }
            if (bl2 && bl4) {
                int[] nArray = new int[3];
                double[] dArray4 = new double[]{this.ordinates[0], this.ordinates[1], this.ordinates[2]};
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[2] = 1;
                J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, 0, nArray, dArray4);
                return j3D_Geometry5.pointInOnSolid(j3D_Geometry, false, d);
            }
            return false;
        }
        if (!(blArray[0] || blArray[1] || !blArray2[0] && !blArray2[1] || blArray3[0] || blArray3[1])) {
            J3D_Geometry j3D_Geometry6;
            Object object;
            int n6;
            double[][] dArray = new double[3][2];
            double[][] dArray5 = new double[3][2];
            dArray = J3D_Geometry.getMBH(this);
            if (!this.ImbhAB(dArray, dArray5 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
                return false;
            }
            ArrayList arrayList11 = new ArrayList();
            ArrayList arrayList12 = new ArrayList();
            if (blArray2[0]) {
                arrayList11 = this.getFaces(false);
            } else {
                arrayList11.add(this);
            }
            if (blArray2[1]) {
                arrayList12 = j3D_Geometry.getFaces(false);
            } else {
                arrayList12.add(j3D_Geometry);
            }
            ArrayList<double[][]> arrayList13 = new ArrayList<double[][]>();
            ArrayList<double[][]> arrayList14 = new ArrayList<double[][]>();
            for (n6 = 0; n6 < arrayList11.size(); ++n6) {
                object = (J3D_Geometry)arrayList11.get(n6);
                arrayList13.add(J3D_Geometry.getMBH((J3D_Geometry)object));
            }
            for (n6 = 0; n6 < arrayList12.size(); ++n6) {
                object = (J3D_Geometry)arrayList12.get(n6);
                arrayList14.add(J3D_Geometry.getMBH((J3D_Geometry)object));
            }
            object = new double[3][2];
            object = J3D_Geometry.volRegInt(dArray, dArray5);
            ArrayList<double[][]> arrayList15 = new ArrayList<double[][]>();
            ArrayList<double[][]> arrayList16 = new ArrayList<double[][]>();
            ArrayList<J3D_Geometry> arrayList17 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList18 = new ArrayList<J3D_Geometry>();
            if (arrayList11.size() > 1) {
                J3D_Geometry.getIntsctMBH((double[][])object, arrayList11, arrayList13, arrayList15, arrayList17, d);
            } else {
                arrayList15.add(dArray);
                j3D_Geometry6 = (J3D_Geometry)arrayList11.get(0);
                arrayList17.add(j3D_Geometry6);
            }
            if (arrayList12.size() > 1) {
                J3D_Geometry.getIntsctMBH((double[][])object, arrayList12, arrayList14, arrayList16, arrayList18, d);
            } else {
                arrayList16.add(dArray5);
                j3D_Geometry6 = (J3D_Geometry)arrayList12.get(0);
                arrayList18.add(j3D_Geometry6);
            }
            if (arrayList15.size() == 0 || arrayList16.size() == 0) {
                return false;
            }
            j3D_Geometry6 = new RTree(3, 8, 2, d);
            RTree rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree((RTree)j3D_Geometry6, arrayList15, arrayList17);
            J3D_Geometry.createRTree(rTree, arrayList16, arrayList18);
            return j3D_Geometry6.anyInteract(rTree, true, false, arrayList);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 3 || j3D_Geometry.gtype != 3)) {
            J3D_Geometry j3D_Geometry7;
            double[][] dArray = new double[3][2];
            double[][] dArray6 = new double[3][2];
            dArray = J3D_Geometry.getMBH(this);
            if (!this.ImbhAB(dArray, dArray6 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
                return false;
            }
            int n7 = this.ordinates.length / 3 - 1;
            int n8 = j3D_Geometry.ordinates.length / 3 - 1;
            boolean bl = false;
            int[] nArray = new int[1];
            ArrayList<J3D_Geometry> arrayList19 = new ArrayList<J3D_Geometry>();
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 2, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry7 = elementExtractor.nextElement(nArray)) != null) {
                arrayList19.add(j3D_Geometry7);
            }
            ArrayList<J3D_Geometry> arrayList20 = new ArrayList<J3D_Geometry>();
            arrayList20.add(this);
            if (n8 > 10) {
                J3D_Geometry j3D_Geometry8;
                ArrayList<double[][]> arrayList21 = new ArrayList<double[][]>();
                ArrayList<double[][]> arrayList22 = new ArrayList<double[][]>();
                for (int i = 0; i < arrayList19.size(); ++i) {
                    j3D_Geometry8 = (J3D_Geometry)arrayList19.get(i);
                    arrayList21.add(J3D_Geometry.getMBH(j3D_Geometry8));
                }
                arrayList22.add(J3D_Geometry.getMBH(this));
                j3D_Geometry8 = new RTree(3, 8, 2, d);
                RTree rTree = new RTree(3, 8, 2, d);
                J3D_Geometry.createRTree((RTree)j3D_Geometry8, arrayList21, arrayList19);
                J3D_Geometry.createRTree(rTree, arrayList22, arrayList20);
                return j3D_Geometry8.anyInteract(rTree, true, false, arrayList2);
            }
            for (int i = 0; i < n8; ++i) {
                if (!this.anyInteract2((J3D_Geometry)arrayList19.get(i), blArray, blArray2, blArray3, d)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 3 || j3D_Geometry.gtype != 2)) {
            J3D_Geometry j3D_Geometry9;
            double[][] dArray = new double[3][2];
            double[][] dArray7 = new double[3][2];
            dArray = J3D_Geometry.getMBH(j3D_Geometry);
            if (!this.ImbhAB(dArray, dArray7 = J3D_Geometry.getMBH(this), d)) {
                return false;
            }
            double[] dArray8 = new double[3];
            double[] dArray9 = new double[3];
            dArray8[0] = j3D_Geometry.ordinates[0];
            dArray8[1] = j3D_Geometry.ordinates[1];
            dArray8[2] = j3D_Geometry.ordinates[2];
            dArray9[0] = j3D_Geometry.ordinates[3];
            dArray9[1] = j3D_Geometry.ordinates[4];
            dArray9[2] = j3D_Geometry.ordinates[5];
            int n9 = this.ordinates.length / 3;
            double[][] dArray10 = new double[n9][3];
            for (int i = 0; i < n9; ++i) {
                dArray10[i][0] = this.ordinates[3 * i];
                dArray10[i][1] = this.ordinates[3 * i + 1];
                dArray10[i][2] = this.ordinates[3 * i + 2];
            }
            double[] dArray11 = new double[3];
            if (J3D_Geometry.lsPlaneInt(3, n9, dArray8, dArray9, dArray10, dArray11, d)) {
                int[] nArray = new int[]{1, 1, 1};
                J3D_Geometry j3D_Geometry10 = new J3D_Geometry(1, 0, nArray, dArray11);
                return j3D_Geometry10.pntInOnPolygon(this, d);
            }
            int n10 = this.ordinates.length / 3 - 1;
            int[] nArray = new int[1];
            ArrayList<J3D_Geometry> arrayList23 = new ArrayList<J3D_Geometry>();
            ElementExtractor elementExtractor = new ElementExtractor(this, 0, 2, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry9 = elementExtractor.nextElement(nArray)) != null) {
                arrayList23.add(j3D_Geometry9);
            }
            for (int i = 0; i < n10; ++i) {
                if (!J3D_Geometry.mindistpts_segseg(j3D_Geometry, (J3D_Geometry)arrayList23.get(i), d)) continue;
                return true;
            }
            int[] nArray2 = new int[]{1, 1, 1};
            J3D_Geometry j3D_Geometry11 = new J3D_Geometry(1, 0, nArray2, dArray8);
            return j3D_Geometry11.pntInOnPolygon(this, d);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 2 || j3D_Geometry.gtype != 3)) {
            J3D_Geometry j3D_Geometry12;
            double[][] dArray = new double[3][2];
            double[][] dArray12 = new double[3][2];
            dArray = J3D_Geometry.getMBH(this);
            if (!this.ImbhAB(dArray, dArray12 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
                return false;
            }
            double[] dArray13 = new double[3];
            double[] dArray14 = new double[3];
            dArray13[0] = this.ordinates[0];
            dArray13[1] = this.ordinates[1];
            dArray13[2] = this.ordinates[2];
            dArray14[0] = this.ordinates[3];
            dArray14[1] = this.ordinates[4];
            dArray14[2] = this.ordinates[5];
            int n11 = j3D_Geometry.ordinates.length / 3;
            double[][] dArray15 = new double[n11][3];
            for (int i = 0; i < n11; ++i) {
                dArray15[i][0] = j3D_Geometry.ordinates[3 * i];
                dArray15[i][1] = j3D_Geometry.ordinates[3 * i + 1];
                dArray15[i][2] = j3D_Geometry.ordinates[3 * i + 2];
            }
            double[] dArray16 = new double[3];
            if (J3D_Geometry.lsPlaneInt(3, n11, dArray13, dArray14, dArray15, dArray16, d)) {
                int[] nArray = new int[]{1, 1, 1};
                J3D_Geometry j3D_Geometry13 = new J3D_Geometry(1, 0, nArray, dArray16);
                return j3D_Geometry13.pntInOnPolygon(j3D_Geometry, d);
            }
            int n12 = j3D_Geometry.ordinates.length / 3 - 1;
            int[] nArray = new int[1];
            ArrayList<J3D_Geometry> arrayList24 = new ArrayList<J3D_Geometry>();
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 2, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry12 = elementExtractor.nextElement(nArray)) != null) {
                arrayList24.add(j3D_Geometry12);
            }
            for (int i = 0; i < n12; ++i) {
                if (!J3D_Geometry.mindistpts_segseg(this, (J3D_Geometry)arrayList24.get(i), d)) continue;
                return true;
            }
            int[] nArray3 = new int[]{1, 1, 1};
            J3D_Geometry j3D_Geometry14 = new J3D_Geometry(1, 0, nArray3, dArray13);
            return j3D_Geometry14.pntInOnPolygon(j3D_Geometry, d);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 1 || j3D_Geometry.gtype != 3)) {
            return this.pntInOnPolygon(j3D_Geometry, d);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 3 || j3D_Geometry.gtype != 1)) {
            return j3D_Geometry.pntInOnPolygon(this, d);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 2 || j3D_Geometry.gtype != 2)) {
            return J3D_Geometry.mindistpts_segseg(this, j3D_Geometry, d);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 1 || j3D_Geometry.gtype != 2)) {
            return J3D_Geometry.mindistpts_pntseg(this, j3D_Geometry, d);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 2 || j3D_Geometry.gtype != 1)) {
            return J3D_Geometry.mindistpts_pntseg(j3D_Geometry, this, d);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || blArray3[0] || blArray3[1] || this.gtype != 1 || j3D_Geometry.gtype != 1)) {
            return !(Math.abs(this.ordinates[0] - j3D_Geometry.ordinates[0]) > d) && !(Math.abs(this.ordinates[1] - j3D_Geometry.ordinates[1]) > d) && !(Math.abs(this.ordinates[2] - j3D_Geometry.ordinates[2]) > d);
        }
        throw new Exception("54539");
    }

    private boolean PhdInPhd(J3D_Geometry j3D_Geometry, double d) throws Exception {
        J3D_Geometry j3D_Geometry2;
        double[][] dArray = new double[3][2];
        double[][] dArray2 = new double[3][2];
        dArray = J3D_Geometry.getMBH(this);
        if (!this.ImbhAB(dArray, dArray2 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        arrayList = this.getFaces(false);
        arrayList2 = j3D_Geometry.getFaces(false);
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        boolean[] blArray3 = new boolean[2];
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList2.size(); ++j) {
                j3D_Geometry2 = (J3D_Geometry)arrayList.get(i);
                J3D_Geometry j3D_Geometry3 = (J3D_Geometry)arrayList2.get(j);
                blArray[0] = false;
                blArray[1] = false;
                blArray2[0] = false;
                blArray2[1] = false;
                blArray3[0] = false;
                blArray3[1] = false;
                if (j3D_Geometry2.anyInteract2(j3D_Geometry3, blArray, blArray2, blArray3, d)) {
                    return false;
                }
                if (!j3D_Geometry3.anyInteract2(j3D_Geometry2, blArray, blArray2, blArray3, d)) continue;
                return false;
            }
        }
        double[] dArray3 = new double[3];
        int[] nArray = new int[3];
        dArray3[0] = this.ordinates[0];
        dArray3[1] = this.ordinates[1];
        dArray3[2] = this.ordinates[2];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        j3D_Geometry2 = new J3D_Geometry(1, 0, nArray, dArray3);
        return j3D_Geometry2.pointInSolid(j3D_Geometry, false, d);
    }

    private boolean PhdThruPg(J3D_Geometry j3D_Geometry, double d) throws Exception {
        J3D_Geometry j3D_Geometry2;
        double[][] dArray = new double[3][2];
        double[][] dArray2 = new double[3][2];
        dArray = J3D_Geometry.getMBH(this);
        if (!this.ImbhAB(dArray, dArray2 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
            return false;
        }
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ArrayList arrayList2 = new ArrayList();
        arrayList.add(j3D_Geometry);
        arrayList2 = this.getFaces(false);
        int n = j3D_Geometry.ordinates.length / 3 - 1;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 2, 3, false);
        nArray[0] = 0;
        while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
            arrayList3.add(j3D_Geometry2);
        }
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        boolean[] blArray3 = new boolean[2];
        for (int i = 0; i < n; ++i) {
            J3D_Geometry j3D_Geometry3 = (J3D_Geometry)arrayList3.get(i);
            for (int j = 0; j < arrayList2.size(); ++j) {
                J3D_Geometry j3D_Geometry4 = (J3D_Geometry)arrayList2.get(j);
                blArray[0] = false;
                blArray[1] = false;
                blArray2[0] = false;
                blArray2[1] = false;
                blArray3[0] = false;
                blArray3[1] = false;
                if (!j3D_Geometry3.anyInteract2(j3D_Geometry4, blArray, blArray2, blArray3, d) && !j3D_Geometry4.anyInteract2(j3D_Geometry3, blArray, blArray2, blArray3, d)) continue;
                return false;
            }
        }
        J3D_Geometry j3D_Geometry5 = (J3D_Geometry)arrayList.get(0);
        for (int i = 0; i < arrayList2.size(); ++i) {
            J3D_Geometry j3D_Geometry6 = (J3D_Geometry)arrayList2.get(i);
            blArray[0] = false;
            blArray[1] = false;
            blArray2[0] = false;
            blArray2[1] = false;
            blArray3[0] = false;
            blArray3[1] = false;
            if (j3D_Geometry5.anyInteract2(j3D_Geometry6, blArray, blArray2, blArray3, d)) {
                return true;
            }
            if (!j3D_Geometry6.anyInteract2(j3D_Geometry5, blArray, blArray2, blArray3, d)) continue;
            return true;
        }
        return false;
    }

    private boolean PgInPhd(J3D_Geometry j3D_Geometry, double d) throws Exception {
        Object object;
        double[][] dArray = new double[3][2];
        double[][] dArray2 = new double[3][2];
        dArray = J3D_Geometry.getMBH(this);
        if (!this.ImbhAB(dArray, dArray2 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
            return false;
        }
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ArrayList arrayList2 = new ArrayList();
        arrayList.add(this);
        arrayList2 = j3D_Geometry.getFaces(false);
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        boolean[] blArray3 = new boolean[2];
        J3D_Geometry j3D_Geometry2 = (J3D_Geometry)arrayList.get(0);
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (J3D_Geometry)arrayList2.get(i);
            blArray[0] = false;
            blArray[1] = false;
            blArray2[0] = false;
            blArray2[1] = false;
            blArray3[0] = false;
            blArray3[1] = false;
            if (j3D_Geometry2.anyInteract2((J3D_Geometry)object, blArray, blArray2, blArray3, d)) {
                return false;
            }
            if (!((J3D_Geometry)object).anyInteract2(j3D_Geometry2, blArray, blArray2, blArray3, d)) continue;
            return false;
        }
        double[] dArray3 = new double[3];
        object = new int[3];
        dArray3[0] = this.ordinates[0];
        dArray3[1] = this.ordinates[1];
        dArray3[2] = this.ordinates[2];
        object[0] = true;
        object[1] = true;
        object[2] = true;
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, 0, (int[])object, dArray3);
        return j3D_Geometry3.pointInSolid(j3D_Geometry, false, d);
    }

    private boolean PgInPg(J3D_Geometry j3D_Geometry, double d) throws Exception {
        J3D_Geometry j3D_Geometry2;
        double[][] dArray = new double[3][2];
        double[][] dArray2 = new double[3][2];
        dArray = J3D_Geometry.getMBH(this);
        if (!this.ImbhAB(dArray, dArray2 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
            return false;
        }
        int n = this.ordinates.length / 3 - 1;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(this, 0, 2, 3, false);
        nArray[0] = 0;
        while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
            arrayList.add(j3D_Geometry2);
        }
        for (int i = 0; i < n; ++i) {
            J3D_Geometry j3D_Geometry3;
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[3];
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)arrayList.get(i);
            dArray3[0] = j3D_Geometry4.ordinates[0];
            dArray3[1] = j3D_Geometry4.ordinates[1];
            dArray3[2] = j3D_Geometry4.ordinates[2];
            dArray4[0] = j3D_Geometry4.ordinates[3];
            dArray4[1] = j3D_Geometry4.ordinates[4];
            dArray4[2] = j3D_Geometry4.ordinates[5];
            int n2 = j3D_Geometry.ordinates.length / 3;
            double[][] dArray5 = new double[n2][3];
            for (int j = 0; j < n2; ++j) {
                dArray5[j][0] = j3D_Geometry.ordinates[3 * j];
                dArray5[j][1] = j3D_Geometry.ordinates[3 * j + 1];
                dArray5[j][2] = j3D_Geometry.ordinates[3 * j + 2];
            }
            double[] dArray6 = new double[3];
            if (J3D_Geometry.lsPlaneInt(3, n2, dArray3, dArray4, dArray5, dArray6, d)) {
                return false;
            }
            int n3 = j3D_Geometry.ordinates.length / 3 - 1;
            int[] nArray2 = new int[1];
            ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
            ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry, 0, 2, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry3 = elementExtractor2.nextElement(nArray2)) != null) {
                arrayList2.add(j3D_Geometry3);
            }
            for (int j = 0; j < n3; ++j) {
                if (!J3D_Geometry.mindistpts_segseg((J3D_Geometry)arrayList.get(i), (J3D_Geometry)arrayList2.get(j), d)) continue;
                return false;
            }
            int[] nArray3 = new int[]{1, 1, 1};
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, 0, nArray3, dArray3);
            if (j3D_Geometry5.pointInPolygon(j3D_Geometry, d)) continue;
            return false;
        }
        return true;
    }

    private boolean lsInPg(J3D_Geometry j3D_Geometry, double d) throws Exception {
        J3D_Geometry j3D_Geometry2;
        double[][] dArray = new double[3][2];
        double[][] dArray2 = new double[3][2];
        dArray = J3D_Geometry.getMBH(this);
        if (!this.ImbhAB(dArray, dArray2 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
            return false;
        }
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        dArray3[0] = this.ordinates[0];
        dArray3[1] = this.ordinates[1];
        dArray3[2] = this.ordinates[2];
        dArray4[0] = this.ordinates[3];
        dArray4[1] = this.ordinates[4];
        dArray4[2] = this.ordinates[5];
        int n = j3D_Geometry.ordinates.length / 3;
        double[][] dArray5 = new double[n][3];
        for (int i = 0; i < n; ++i) {
            dArray5[i][0] = j3D_Geometry.ordinates[3 * i];
            dArray5[i][1] = j3D_Geometry.ordinates[3 * i + 1];
            dArray5[i][2] = j3D_Geometry.ordinates[3 * i + 2];
        }
        double[] dArray6 = new double[3];
        if (J3D_Geometry.lsPlaneInt(3, n, dArray3, dArray4, dArray5, dArray6, d)) {
            int[] nArray = new int[]{1, 1, 1};
            J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, 0, nArray, dArray6);
            return !j3D_Geometry.pointBoundaryIntersect(j3D_Geometry3, d);
        }
        int n2 = j3D_Geometry.ordinates.length / 3 - 1;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 2, 3, false);
        nArray[0] = 0;
        while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
            arrayList.add(j3D_Geometry2);
        }
        for (int i = 0; i < n2; ++i) {
            if (!J3D_Geometry.mindistpts_segseg(this, (J3D_Geometry)arrayList.get(i), d)) continue;
            return false;
        }
        int[] nArray2 = new int[]{1, 1, 1};
        J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, 0, nArray2, dArray3);
        return j3D_Geometry4.pointInPolygon(j3D_Geometry, d);
    }

    private boolean isInside(J3D_Geometry j3D_Geometry, double d) throws Exception {
        if (this.elemInfo[1] % 1000 == 6 && j3D_Geometry.elemInfo[1] % 1000 == 6) {
            return this.PhdInPhd(j3D_Geometry, d);
        }
        if (this.elemInfo[1] % 1000 == 6 && j3D_Geometry.elemInfo[1] % 1000 == 3) {
            return this.PhdThruPg(j3D_Geometry, d);
        }
        if (this.elemInfo[1] % 1000 == 3 && j3D_Geometry.elemInfo[1] % 1000 == 6) {
            return this.PgInPhd(j3D_Geometry, d);
        }
        if (this.elemInfo[1] % 1000 == 6 && j3D_Geometry.gtype == 2) {
            throw new Exception("54530");
        }
        if (this.gtype == 2 && j3D_Geometry.elemInfo[1] % 1000 == 6) {
            return this.PgInPhd(j3D_Geometry, d);
        }
        if (this.elemInfo[1] % 1000 == 6 && j3D_Geometry.gtype == 1) {
            throw new Exception("54530");
        }
        if (this.gtype == 1 && j3D_Geometry.elemInfo[1] % 1000 == 6) {
            return this.pointInSolid(j3D_Geometry, false, d);
        }
        if (this.elemInfo[1] % 1000 == 3 && j3D_Geometry.elemInfo[1] % 1000 == 3) {
            return this.PgInPg(j3D_Geometry, d);
        }
        if (this.gtype == 2 && j3D_Geometry.elemInfo[1] % 1000 == 3) {
            return this.lsInPg(j3D_Geometry, d);
        }
        if (this.elemInfo[1] % 1000 == 3 && j3D_Geometry.gtype == 2) {
            throw new Exception("54504");
        }
        if (this.gtype == 1 && j3D_Geometry.elemInfo[1] % 1000 == 3) {
            if (j3D_Geometry.pointBoundaryIntersect(this, d)) {
                return false;
            }
            return this.pointInPolygon(j3D_Geometry, d);
        }
        if (this.elemInfo[1] % 1000 == 3 && j3D_Geometry.gtype == 1) {
            throw new Exception("54504");
        }
        throw new Exception("54545");
    }

    private boolean pntInOnPolygon(J3D_Geometry j3D_Geometry, double d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[3];
        J3D_Geometry.planeEquation(dArray2, dArray, j3D_Geometry);
        if (j3D_Geometry.pointBoundaryIntersect(this, d)) {
            return true;
        }
        return this.pointInPolygon(j3D_Geometry, d);
    }

    private static boolean lsPlaneInt(int n, int n2, double[] dArray, double[] dArray2, double[][] dArray3, double[] dArray4, double d) {
        double d2;
        int n3;
        int n4;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        int n5 = J3D_Geometry.planeEquation(dArray5, dArray6, dArray3);
        double d3 = 0.0;
        for (n4 = 0; n4 < n; ++n4) {
            dArray7[n4] = dArray[n4];
            d3 += (dArray2[n4] - dArray[n4]) * (dArray2[n4] - dArray[n4]);
        }
        for (n4 = 0; n4 < n; ++n4) {
            dArray8[n4] = (dArray2[n4] - dArray[n4]) / Math.sqrt(d3);
        }
        double d4 = 0.0;
        for (n4 = 0; n4 < n; ++n4) {
            d4 += dArray5[n4] * dArray8[n4];
        }
        if (Math.abs(d4) <= d) {
            return false;
        }
        double d5 = dArray5[0] * dArray[0] + dArray5[1] * dArray[1] + dArray5[2] * dArray[2] + dArray6[0];
        int n6 = d5 > d ? 1 : (d5 < -d ? -1 : 0);
        if (n6 == (n3 = (d2 = dArray5[0] * dArray2[0] + dArray5[1] * dArray2[1] + dArray5[2] * dArray2[2] + dArray6[0]) > d ? 1 : (d2 < -d ? -1 : 0))) {
            return false;
        }
        double d6 = d5 / (d5 - d2);
        for (n4 = 0; n4 < n; ++n4) {
            dArray4[n4] = dArray[n4] + d6 * (dArray2[n4] - dArray[n4]);
            if (!(Math.abs(dArray4[n4]) < d)) continue;
            dArray4[n4] = 0.0;
        }
        return true;
    }

    public double distance(J3D_Geometry j3D_Geometry, double d) throws Exception {
        String string = "FALSE";
        double d2 = 6378137.0;
        double d3 = 0.003352810664747;
        double d4 = 1.0;
        return this.distance(j3D_Geometry, d, string, d2, d3, d4);
    }

    public double distance(J3D_Geometry j3D_Geometry, double d, String string, double d2, double d3, double d4) throws Exception {
        if (this.getSRID() != j3D_Geometry.getSRID()) {
            throw new Exception("13365");
        }
        double[] dArray = new double[6];
        dArray = this.distCpa(j3D_Geometry, d, string, d2, d3, d4);
        double d5 = 0.0;
        if (dArray != null && !string.equals("TRUE")) {
            d5 = Math.sqrt((dArray[0] - dArray[3]) * (dArray[0] - dArray[3]) + (dArray[1] - dArray[4]) * (dArray[1] - dArray[4]) + (dArray[2] - dArray[5]) * (dArray[2] - dArray[5]));
        } else if (dArray != null && string.equals("TRUE")) {
            JGeometry jGeometry = new JGeometry(this.dim * 1000 + 2, this.getSRID(), new int[]{1, 2, 1}, new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]});
            d5 = JGeometry.geodetic3DLength(jGeometry, d2, d3, d4);
        }
        this.clearBelongingGeometry();
        j3D_Geometry.clearBelongingGeometry();
        return d5;
    }

    public double[] distCpa(J3D_Geometry j3D_Geometry, double d, String string, double d2, double d3, double d4) throws Exception {
        int n;
        J3D_Geometry j3D_Geometry2;
        Object object;
        double[] dArray = new double[6];
        boolean bl = false;
        if (this.getSRID() != j3D_Geometry.getSRID()) {
            throw new Exception("13365");
        }
        if (this.anyInteract(j3D_Geometry, d, string) || j3D_Geometry.anyInteract(this, d, string)) {
            dArray = null;
            this.belongingGeometry.clear();
            j3D_Geometry.belongingGeometry.clear();
            return dArray;
        }
        int[] nArray = new int[1];
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        boolean[] blArray3 = new boolean[2];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        if (this.gtype == 9 || this.gtype == 7 || this.gtype == 6 || this.elemInfo[1] % 1000 == 2 && this.ordinates.length != 6 || this.gtype == 5 || this.elemInfo[1] % 1000 == 8 || this.elemInfo[1] % 1000 == 6 || this.gtype == 4) {
            object = new ElementExtractor(this, 0, 0, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry2 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                arrayList.add(j3D_Geometry2);
            }
        } else {
            arrayList.add(this);
        }
        if (j3D_Geometry.gtype == 9 || j3D_Geometry.gtype == 7 || j3D_Geometry.gtype == 6 || j3D_Geometry.elemInfo[1] % 1000 == 2 && j3D_Geometry.ordinates.length != 6 || j3D_Geometry.gtype == 5 || j3D_Geometry.elemInfo[1] % 1000 == 8 || j3D_Geometry.elemInfo[1] % 1000 == 6 || j3D_Geometry.gtype == 4) {
            object = new ElementExtractor(j3D_Geometry, 0, 0, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry2 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                arrayList2.add(j3D_Geometry2);
            }
        } else {
            arrayList2.add(j3D_Geometry);
        }
        if (this.gtype == 6 || this.gtype == 4) {
            J3D_Geometry.decomposeLnStrIntoLnSgts(arrayList);
        }
        if (j3D_Geometry.gtype == 6 || j3D_Geometry.gtype == 4) {
            J3D_Geometry.decomposeLnStrIntoLnSgts(arrayList2);
        }
        bl = !(this.gtype != 5 && this.gtype != 6 && this.gtype != 1 && this.gtype != 2 || j3D_Geometry.gtype != 5 && j3D_Geometry.gtype != 6 && j3D_Geometry.gtype != 1 && j3D_Geometry.gtype != 2);
        object = new double[6];
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        for (n = 0; n < 6; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 6; ++n) {
            dArray[n] = 0.0;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList2.size(); ++j) {
                ((J3D_Geometry)arrayList.get(i)).getFlags((J3D_Geometry)arrayList2.get(j), blArray, blArray2, blArray3);
                object = ((J3D_Geometry)arrayList.get(i)).distCpa2((J3D_Geometry)arrayList2.get(j), blArray, blArray2, blArray3, d, string);
                if (!string.equals("TRUE")) {
                    d5 = Math.sqrt((double)((object[0] - object[3]) * (object[0] - object[3]) + (object[1] - object[4]) * (object[1] - object[4]) + (object[2] - object[5]) * (object[2] - object[5])));
                } else {
                    JGeometry jGeometry = new JGeometry(this.dim * 1000 + 2, this.getSRID(), new int[]{1, 2, 1}, new double[]{(double)object[0], (double)object[1], (double)object[2], (double)object[3], (double)object[4], (double)object[5]});
                    d5 = JGeometry.geodetic3DLength(jGeometry, d2, d3, d4);
                }
                if (!(d5 < d6)) continue;
                d6 = d5;
                for (n = 0; n < 6; ++n) {
                    dArray[n] = (double)object[n];
                }
                if (!bl) continue;
                this.setBelongingGeometry((J3D_Geometry)((J3D_Geometry)arrayList.get((int)i)).belongingGeometry.get(0));
                j3D_Geometry.setBelongingGeometry((J3D_Geometry)((J3D_Geometry)arrayList2.get((int)j)).belongingGeometry.get(0));
            }
        }
        return dArray;
    }

    protected double[] distCpaLRS(J3D_Geometry j3D_Geometry, double d, String string, double d2, double d3, double d4) throws Exception {
        int n;
        J3D_Geometry j3D_Geometry2;
        Object object;
        double[] dArray = new double[6];
        boolean bl = false;
        if (this.getSRID() != j3D_Geometry.getSRID()) {
            throw new Exception("13365");
        }
        int[] nArray = new int[1];
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        boolean[] blArray3 = new boolean[2];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        if (this.gtype == 9 || this.gtype == 7 || this.gtype == 6 || this.elemInfo[1] % 1000 == 2 && this.ordinates.length != 6 || this.gtype == 5 || this.elemInfo[1] % 1000 == 8 || this.elemInfo[1] % 1000 == 6 || this.gtype == 4) {
            object = new ElementExtractor(this, 0, 0, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry2 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                arrayList.add(j3D_Geometry2);
            }
        } else {
            arrayList.add(this);
        }
        if (j3D_Geometry.gtype == 9 || j3D_Geometry.gtype == 7 || j3D_Geometry.gtype == 6 || j3D_Geometry.elemInfo[1] % 1000 == 2 && j3D_Geometry.ordinates.length != 6 || j3D_Geometry.gtype == 5 || j3D_Geometry.elemInfo[1] % 1000 == 8 || j3D_Geometry.elemInfo[1] % 1000 == 6 || j3D_Geometry.gtype == 4) {
            object = new ElementExtractor(j3D_Geometry, 0, 0, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry2 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                arrayList2.add(j3D_Geometry2);
            }
        } else {
            arrayList2.add(j3D_Geometry);
        }
        if (this.gtype == 6 || this.gtype == 4) {
            J3D_Geometry.decomposeLnStrIntoLnSgts(arrayList);
        }
        if (j3D_Geometry.gtype == 6 || j3D_Geometry.gtype == 4) {
            J3D_Geometry.decomposeLnStrIntoLnSgts(arrayList2);
        }
        bl = !(this.gtype != 5 && this.gtype != 6 && this.gtype != 1 && this.gtype != 2 || j3D_Geometry.gtype != 5 && j3D_Geometry.gtype != 6 && j3D_Geometry.gtype != 1 && j3D_Geometry.gtype != 2);
        object = new double[6];
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        for (n = 0; n < 6; ++n) {
            object[n] = 0.0;
        }
        for (n = 0; n < 6; ++n) {
            dArray[n] = 0.0;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList2.size(); ++j) {
                ((J3D_Geometry)arrayList.get(i)).getFlags((J3D_Geometry)arrayList2.get(j), blArray, blArray2, blArray3);
                object = ((J3D_Geometry)arrayList.get(i)).distCpa2((J3D_Geometry)arrayList2.get(j), blArray, blArray2, blArray3, d, string);
                if (!string.equals("TRUE")) {
                    d5 = Math.sqrt((double)((object[0] - object[3]) * (object[0] - object[3]) + (object[1] - object[4]) * (object[1] - object[4]) + (object[2] - object[5]) * (object[2] - object[5])));
                } else {
                    JGeometry jGeometry = new JGeometry(this.dim * 1000 + 2, this.getSRID(), new int[]{1, 2, 1}, new double[]{(double)object[0], (double)object[1], (double)object[2], (double)object[3], (double)object[4], (double)object[5]});
                    d5 = JGeometry.geodetic3DLength(jGeometry, d2, d3, d4);
                }
                if (!(d5 < d6)) continue;
                d6 = d5;
                for (n = 0; n < 6; ++n) {
                    dArray[n] = (double)object[n];
                }
                if (!bl) continue;
                this.setBelongingGeometry((J3D_Geometry)((J3D_Geometry)arrayList.get((int)i)).belongingGeometry.get(0));
                j3D_Geometry.setBelongingGeometry((J3D_Geometry)((J3D_Geometry)arrayList2.get((int)j)).belongingGeometry.get(0));
            }
        }
        return dArray;
    }

    public double[] distCpa2(J3D_Geometry j3D_Geometry, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, double d, String string) throws Exception {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray[i] = 0.0;
        }
        if ((blArray[0] || blArray[1]) && (blArray2[0] || blArray2[1])) {
            blArray[0] = false;
            blArray[1] = false;
            blArray3[0] = false;
            blArray3[1] = false;
            return this.distCpa2(j3D_Geometry, blArray, blArray2, blArray3, d, string);
        }
        if (!blArray[0] && !blArray[1] && (blArray2[0] || blArray2[1])) {
            J3D_Geometry j3D_Geometry2;
            int n;
            double d2 = 0.0;
            double d3 = 0.0;
            int[] nArray = new int[this.elemInfo.length];
            System.arraycopy(this.elemInfo, 0, nArray, 0, this.elemInfo.length);
            double[] dArray2 = new double[this.ordinates.length];
            System.arraycopy(this.ordinates, 0, dArray2, 0, this.ordinates.length);
            int n2 = this.getSRID();
            J3D_Geometry j3D_Geometry3 = new J3D_Geometry(this.getType(), n2, nArray, dArray2);
            int[] nArray2 = new int[j3D_Geometry.elemInfo.length];
            System.arraycopy(j3D_Geometry.elemInfo, 0, nArray2, 0, j3D_Geometry.elemInfo.length);
            double[] dArray3 = new double[j3D_Geometry.ordinates.length];
            System.arraycopy(j3D_Geometry.ordinates, 0, dArray3, 0, j3D_Geometry.ordinates.length);
            int n3 = j3D_Geometry.getSRID();
            J3D_Geometry j3D_Geometry4 = new J3D_Geometry(j3D_Geometry.getType(), n3, nArray2, dArray3);
            if (string.equals("TRUE")) {
                if (d < 0.05) {
                    d = 0.05;
                }
                d2 = Math.PI / 180 * this.getOrdinatesArray()[0];
                d3 = Math.PI / 180 * this.getOrdinatesArray()[1];
                if (this.getType() % 10 == 1 || j3D_Geometry.getType() % 10 == 1) {
                    d2 /= 2.0;
                    d3 /= 2.0;
                }
                j3D_Geometry3 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry3, d2, d3);
                j3D_Geometry4 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry4, d2, d3);
            }
            ArrayList arrayList4 = new ArrayList();
            ArrayList arrayList5 = new ArrayList();
            if (blArray2[0]) {
                arrayList4 = j3D_Geometry3.getFaces2(false);
            } else {
                arrayList4.add(j3D_Geometry3);
            }
            if (blArray2[1]) {
                arrayList5 = j3D_Geometry4.getFaces2(false);
            } else {
                arrayList5.add(j3D_Geometry4);
            }
            ArrayList<double[][]> arrayList6 = new ArrayList<double[][]>();
            ArrayList<double[][]> arrayList7 = new ArrayList<double[][]>();
            for (n = 0; n < arrayList4.size(); ++n) {
                j3D_Geometry2 = (J3D_Geometry)arrayList4.get(n);
                arrayList6.add(J3D_Geometry.getMBH(j3D_Geometry2));
            }
            for (n = 0; n < arrayList5.size(); ++n) {
                j3D_Geometry2 = (J3D_Geometry)arrayList5.get(n);
                arrayList7.add(J3D_Geometry.getMBH(j3D_Geometry2));
            }
            j3D_Geometry2 = new RTree(3, 8, 2, d);
            RTree rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree((RTree)j3D_Geometry2, arrayList6, arrayList4);
            J3D_Geometry.createRTree(rTree, arrayList7, arrayList5);
            j3D_Geometry2.nnSearch(rTree, true, false, arrayList);
            RTreeJoinRes rTreeJoinRes = (RTreeJoinRes)arrayList.get(0);
            J3D_Geometry j3D_Geometry5 = (J3D_Geometry)rTreeJoinRes.ptr1;
            J3D_Geometry j3D_Geometry6 = (J3D_Geometry)rTreeJoinRes.ptr2;
            dArray[0] = j3D_Geometry5.ordinates[0];
            dArray[1] = j3D_Geometry5.ordinates[1];
            dArray[2] = j3D_Geometry5.ordinates[2];
            dArray[3] = j3D_Geometry6.ordinates[0];
            dArray[4] = j3D_Geometry6.ordinates[1];
            dArray[5] = j3D_Geometry6.ordinates[2];
            if (string.equals("TRUE")) {
                dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d2, d3);
            }
            return dArray;
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 3 || j3D_Geometry.gtype != 3)) {
            return J3D_Geometry.CpaPgPg3D(this, j3D_Geometry, d, string);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 3 || j3D_Geometry.gtype != 2)) {
            return J3D_Geometry.CpaPgL3D(this, j3D_Geometry, d, string);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 2 || j3D_Geometry.gtype != 3)) {
            return J3D_Geometry.CpaPgL3D(j3D_Geometry, this, d, string);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 1 || j3D_Geometry.gtype != 3)) {
            return J3D_Geometry.CpaPtPg3D(this, j3D_Geometry, d, string);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 3 || j3D_Geometry.gtype != 1)) {
            return J3D_Geometry.CpaPtPg3D(j3D_Geometry, this, d, string);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 2 || j3D_Geometry.gtype != 2)) {
            return J3D_Geometry.CpaLL3D(this, j3D_Geometry, d, string);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 1 || j3D_Geometry.gtype != 2)) {
            return J3D_Geometry.CpaPtL3D(this, j3D_Geometry, d, string);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 2 || j3D_Geometry.gtype != 1)) {
            return J3D_Geometry.CpaPtL3D(j3D_Geometry, this, d, string);
        }
        if (!(blArray[0] || blArray[1] || blArray2[0] || blArray2[1] || this.gtype != 1 || j3D_Geometry.gtype != 1)) {
            return J3D_Geometry.CpaPtPt3D(this, j3D_Geometry, d);
        }
        throw new Exception("54539");
    }

    private static void decomposeLnStrIntoLnSgts(ArrayList arrayList) throws Exception {
        int n = 0;
        while (n < arrayList.size()) {
            int[] nArray = new int[1];
            J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n);
            if (j3D_Geometry.elemInfo[1] % 1000 == 2 && j3D_Geometry.ordinates.length > 6) {
                arrayList.remove(n);
                ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 0, 3, false);
                J3D_Geometry j3D_Geometry2 = null;
                nArray[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
                    arrayList.add(n, j3D_Geometry2);
                    ++n;
                }
                continue;
            }
            ++n;
        }
    }

    private static void primaryFilter(ArrayList arrayList, ArrayList arrayList2, double d) throws Exception {
        Cloneable cloneable;
        ArrayList<double[][]> arrayList3 = new ArrayList<double[][]>();
        ArrayList<double[][]> arrayList4 = new ArrayList<double[][]>();
        for (int i = 0; i < arrayList.size(); ++i) {
            J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(i);
            arrayList3.add(J3D_Geometry.getMBH(j3D_Geometry));
        }
        RTree rTree = new RTree(3, 8, 2, d);
        J3D_Geometry.createRTree(rTree, arrayList3, arrayList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            cloneable = (J3D_Geometry)arrayList2.get(i);
            arrayList4.add(J3D_Geometry.getMBH((J3D_Geometry)cloneable));
        }
        RTree rTree2 = new RTree(3, 8, 2, d);
        J3D_Geometry.createRTree(rTree2, arrayList4, arrayList2);
        cloneable = new ArrayList();
        rTree.nnSearch(rTree2, false, true, (ArrayList)cloneable);
        arrayList.clear();
        arrayList2.clear();
        for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
            RTreeJoinRes rTreeJoinRes = (RTreeJoinRes)((ArrayList)cloneable).get(i);
            J3D_Geometry j3D_Geometry = (J3D_Geometry)rTreeJoinRes.ptr1;
            J3D_Geometry j3D_Geometry2 = (J3D_Geometry)rTreeJoinRes.ptr2;
            arrayList.add(j3D_Geometry);
            arrayList2.add(j3D_Geometry2);
        }
    }

    private static double[] CpaPtPt3D(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) throws Exception {
        double[] dArray = new double[]{j3D_Geometry.ordinates[0], j3D_Geometry.ordinates[1], j3D_Geometry.ordinates[2], j3D_Geometry2.ordinates[0], j3D_Geometry2.ordinates[1], j3D_Geometry2.ordinates[2]};
        j3D_Geometry.setBelongingGeometry(j3D_Geometry);
        j3D_Geometry2.setBelongingGeometry(j3D_Geometry2);
        return dArray;
    }

    public static J3D_Geometry projectToGnomonicFromLongLat(J3D_Geometry j3D_Geometry, double d, double d2) throws Exception {
        int[] nArray = new int[j3D_Geometry.elemInfo.length];
        System.arraycopy(j3D_Geometry.elemInfo, 0, nArray, 0, j3D_Geometry.elemInfo.length);
        double[] dArray = new double[j3D_Geometry.ordinates.length];
        System.arraycopy(j3D_Geometry.ordinates, 0, dArray, 0, j3D_Geometry.ordinates.length);
        int n = j3D_Geometry.getSRID();
        JGeometry jGeometry = new JGeometry(j3D_Geometry.dim * 1000 + j3D_Geometry.getType(), n, nArray, dArray);
        jGeometry = jGeometry.projectToGNM_longLat(d, d2);
        int[] nArray2 = new int[jGeometry.elemInfo.length];
        System.arraycopy(jGeometry.elemInfo, 0, nArray2, 0, jGeometry.elemInfo.length);
        double[] dArray2 = new double[jGeometry.ordinates.length];
        System.arraycopy(jGeometry.ordinates, 0, dArray2, 0, jGeometry.ordinates.length);
        int n2 = jGeometry.getSRID();
        J3D_Geometry j3D_Geometry2 = new J3D_Geometry(jGeometry.dim * 1000 + jGeometry.getType(), n2, nArray2, dArray2);
        return j3D_Geometry2;
    }

    private static double[] projectFromGnomonicToLongLat(double[] dArray, double d, double d2) throws Exception {
        JGeometry jGeometry = new JGeometry(3002, 0, new int[]{1, 2, 1}, new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]});
        jGeometry = jGeometry.projectFromGNM_longLat(d, d2);
        double[] dArray2 = new double[]{jGeometry.getOrdinatesArray()[0], jGeometry.getOrdinatesArray()[1], jGeometry.getOrdinatesArray()[2], jGeometry.getOrdinatesArray()[3], jGeometry.getOrdinatesArray()[4], jGeometry.getOrdinatesArray()[5]};
        return dArray2;
    }

    private static double[] CpaPgPg3D(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d, String string) throws Exception {
        int n;
        J3D_Geometry j3D_Geometry3;
        double d2;
        Object object;
        Object object2;
        Object object3;
        int n2;
        J3D_Geometry j3D_Geometry4;
        J3D_Geometry j3D_Geometry5;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < 6; ++i) {
            dArray[i] = 0.0;
        }
        double d5 = Double.MAX_VALUE;
        if (string.equals("TRUE")) {
            if (d < 0.05) {
                d = 0.05;
            }
            d3 = Math.PI / 180 * j3D_Geometry.getOrdinatesArray()[0];
            d4 = Math.PI / 180 * j3D_Geometry.getOrdinatesArray()[1];
            j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry, d3, d4);
            j3D_Geometry2 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry2, d3, d4);
        }
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 1, 3, false);
        int[] nArray = new int[]{0};
        while ((j3D_Geometry5 = elementExtractor.nextElement(nArray)) != null) {
            if (nArray[0] == 2) {
                arrayList.add(j3D_Geometry5);
                continue;
            }
            arrayList2.add(j3D_Geometry5);
        }
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        if (arrayList2.size() != 1) {
            throw new Exception("54504");
        }
        J3D_Geometry j3D_Geometry6 = (J3D_Geometry)arrayList2.get(0);
        ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry6, 0, 2, 3, false);
        int[] nArray2 = new int[]{0};
        while ((j3D_Geometry4 = elementExtractor2.nextElement(nArray2)) != null) {
            if (nArray2[0] == 2) {
                throw new Exception("54501");
            }
            arrayList3.add(j3D_Geometry4);
        }
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            J3D_Geometry j3D_Geometry7 = (J3D_Geometry)arrayList.get(n2);
            object3 = new ElementExtractor(j3D_Geometry7, 0, 2, 3, false);
            object2 = new int[]{0};
            while ((object = ((ElementExtractor)object3).nextElement((int[])object2)) != null) {
                if (object2[0] == 2) {
                    throw new Exception("54501");
                }
                arrayList4.add(object);
            }
        }
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            dArray2 = J3D_Geometry.CpaPgL3D(j3D_Geometry2, (J3D_Geometry)arrayList3.get(n2), d, "FALSE");
            d2 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
            if (!(d2 < d5)) continue;
            for (int i = 0; i < 6; ++i) {
                dArray[i] = dArray2[i];
            }
            d5 = d2;
        }
        for (n2 = 0; n2 < arrayList4.size(); ++n2) {
            dArray2 = J3D_Geometry.CpaPgL3D(j3D_Geometry2, (J3D_Geometry)arrayList4.get(n2), d, "FALSE");
            d2 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
            if (!(d2 < d5)) continue;
            for (int i = 0; i < 6; ++i) {
                dArray[i] = dArray2[i];
            }
            d5 = d2;
        }
        arrayList.clear();
        arrayList2.clear();
        elementExtractor = new ElementExtractor(j3D_Geometry2, 0, 1, 3, false);
        nArray[0] = 0;
        while ((j3D_Geometry3 = elementExtractor.nextElement(nArray)) != null) {
            if (nArray[0] == 2) {
                arrayList.add(j3D_Geometry3);
                continue;
            }
            arrayList2.add(j3D_Geometry3);
        }
        arrayList3.clear();
        if (arrayList2.size() != 1) {
            throw new Exception("54504");
        }
        j3D_Geometry6 = (J3D_Geometry)arrayList2.get(0);
        elementExtractor2 = new ElementExtractor(j3D_Geometry6, 0, 2, 3, false);
        nArray2[0] = 0;
        while ((j3D_Geometry4 = elementExtractor2.nextElement(nArray2)) != null) {
            if (nArray2[0] == 2) {
                throw new Exception("54501");
            }
            arrayList3.add(j3D_Geometry4);
        }
        arrayList4.clear();
        block11: for (n = 0; n < arrayList.size(); ++n) {
            object3 = (J3D_Geometry)arrayList.get(n);
            object = new ElementExtractor((J3D_Geometry)object3, 0, 2, 3, false);
            int[] nArray3 = new int[]{0};
            while (true) {
                J3D_Geometry j3D_Geometry8 = ((ElementExtractor)object).nextElement(nArray3);
                object2 = j3D_Geometry8;
                if (j3D_Geometry8 == null) continue block11;
                if (nArray3[0] == 2) {
                    throw new Exception("54501");
                }
                arrayList4.add(object2);
            }
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            dArray2 = J3D_Geometry.CpaPgL3D(j3D_Geometry, (J3D_Geometry)arrayList3.get(n), d, "FALSE");
            d2 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
            if (!(d2 < d5)) continue;
            for (int i = 0; i < 6; ++i) {
                dArray[i] = dArray2[i];
            }
            d5 = d2;
        }
        for (n = 0; n < arrayList4.size(); ++n) {
            dArray2 = J3D_Geometry.CpaPgL3D(j3D_Geometry, (J3D_Geometry)arrayList4.get(n), d, "FALSE");
            d2 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
            if (!(d2 < d5)) continue;
            for (int i = 0; i < 6; ++i) {
                dArray[i] = dArray2[i];
            }
            d5 = d2;
        }
        if (string.equals("TRUE")) {
            dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d3, d4);
        }
        return dArray;
    }

    private static J3D_Geometry projectPtOntoPlane(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[3];
        int n = J3D_Geometry.planeEquation(dArray2, dArray, j3D_Geometry2);
        double d = J3D_Geometry.dotProduct(j3D_Geometry.ordinates, dArray2);
        double d2 = J3D_Geometry.dotProduct(dArray2, dArray2);
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = j3D_Geometry.ordinates[i] - (d + dArray[0]) / d2 * dArray2[i];
        }
        int[] nArray = new int[]{1, 1, 1};
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, 0, nArray, dArray3);
        return j3D_Geometry3;
    }

    private static double[] CpaPgL3D(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d, String string) throws Exception {
        J3D_Geometry j3D_Geometry3;
        int[] nArray;
        Object object;
        Object object2;
        int n;
        J3D_Geometry j3D_Geometry4;
        J3D_Geometry j3D_Geometry5;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 6; ++i) {
            dArray[i] = 0.0;
            dArray2[i] = 0.0;
        }
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MAX_VALUE;
        if (string.equals("TRUE")) {
            if (d < 0.05) {
                d = 0.05;
            }
            d2 = Math.PI / 180 * j3D_Geometry.getOrdinatesArray()[0];
            d3 = Math.PI / 180 * j3D_Geometry.getOrdinatesArray()[1];
            j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry, d2, d3);
            j3D_Geometry2 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry2, d2, d3);
        }
        int[] nArray2 = new int[3];
        double[] dArray3 = new double[]{j3D_Geometry2.ordinates[0], j3D_Geometry2.ordinates[1], j3D_Geometry2.ordinates[2]};
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[2] = 1;
        J3D_Geometry j3D_Geometry6 = new J3D_Geometry(1, 0, nArray2, dArray3);
        J3D_Geometry j3D_Geometry7 = J3D_Geometry.projectPtOntoPlane(j3D_Geometry6, j3D_Geometry);
        int[] nArray3 = new int[3];
        double[] dArray4 = new double[]{j3D_Geometry2.ordinates[3], j3D_Geometry2.ordinates[4], j3D_Geometry2.ordinates[5]};
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[2] = 1;
        J3D_Geometry j3D_Geometry8 = new J3D_Geometry(1, 0, nArray3, dArray4);
        J3D_Geometry j3D_Geometry9 = J3D_Geometry.projectPtOntoPlane(j3D_Geometry8, j3D_Geometry);
        if (j3D_Geometry7.ordinates[0] == j3D_Geometry9.ordinates[0] && j3D_Geometry7.ordinates[1] == j3D_Geometry9.ordinates[1] && j3D_Geometry7.ordinates[2] == j3D_Geometry9.ordinates[2]) {
            double d6;
            double[] dArray5 = new double[6];
            double[] dArray6 = new double[6];
            dArray5 = J3D_Geometry.CpaPtPg3D(j3D_Geometry6, j3D_Geometry, d, "FALSE");
            dArray6 = J3D_Geometry.CpaPtPg3D(j3D_Geometry8, j3D_Geometry, d, "FALSE");
            double d7 = Math.sqrt((dArray5[0] - dArray5[3]) * (dArray5[0] - dArray5[3]) + (dArray5[1] - dArray5[4]) * (dArray5[1] - dArray5[4]) + (dArray5[2] - dArray5[5]) * (dArray5[2] - dArray5[5]));
            if (d7 < (d6 = Math.sqrt((dArray6[0] - dArray6[3]) * (dArray6[0] - dArray6[3]) + (dArray6[1] - dArray6[4]) * (dArray6[1] - dArray6[4]) + (dArray6[2] - dArray6[5]) * (dArray6[2] - dArray6[5])))) {
                for (int i = 0; i < 6; ++i) {
                    dArray[i] = dArray5[i];
                }
            } else {
                for (int i = 0; i < 6; ++i) {
                    dArray[i] = dArray6[i];
                }
            }
            if (string.equals("TRUE")) {
                dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d2, d3);
            }
            return dArray;
        }
        Object object3 = new int[3];
        Object object4 = new double[]{j3D_Geometry7.ordinates[0], j3D_Geometry7.ordinates[1], j3D_Geometry7.ordinates[2], j3D_Geometry9.ordinates[0], j3D_Geometry9.ordinates[1], j3D_Geometry9.ordinates[2]};
        object3[0] = 1;
        object3[1] = 2;
        object3[2] = 1;
        J3D_Geometry j3D_Geometry10 = new J3D_Geometry(2, 0, (int[])object3, (double[])object4);
        object3 = new ArrayList();
        object4 = new ArrayList();
        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 1, 3, false);
        int[] nArray4 = new int[]{0};
        while ((j3D_Geometry5 = elementExtractor.nextElement(nArray4)) != null) {
            if (nArray4[0] == 2) {
                ((ArrayList)object3).add(j3D_Geometry5);
                continue;
            }
            object4.add(j3D_Geometry5);
        }
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        if (object4.size() != 1) {
            throw new Exception("54504");
        }
        J3D_Geometry j3D_Geometry11 = (J3D_Geometry)object4.get(0);
        ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry11, 0, 2, 3, false);
        int[] nArray5 = new int[]{0};
        while ((j3D_Geometry4 = elementExtractor2.nextElement(nArray5)) != null) {
            if (nArray5[0] == 2) {
                throw new Exception("54501");
            }
            arrayList.add(j3D_Geometry4);
        }
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object2 = (J3D_Geometry)((ArrayList)object3).get(n);
            object = new ElementExtractor((J3D_Geometry)object2, 0, 2, 3, false);
            nArray = new int[]{0};
            while ((j3D_Geometry3 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    throw new Exception("54501");
                }
                arrayList2.add(j3D_Geometry3);
            }
        }
        if (j3D_Geometry10.anyInteract(j3D_Geometry, d, "FALSE")) {
            J3D_Geometry j3D_Geometry12;
            double[] dArray7;
            int[] nArray6;
            int n2;
            ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
            object2 = new int[3];
            object = new double[3];
            object[0] = j3D_Geometry10.ordinates[0];
            object[1] = j3D_Geometry10.ordinates[1];
            object[2] = j3D_Geometry10.ordinates[2];
            object2[0] = true;
            object2[1] = true;
            object2[2] = true;
            j3D_Geometry3 = new J3D_Geometry(1, 0, (int[])object2, (double[])object);
            arrayList3.add(j3D_Geometry3);
            nArray = new int[3];
            double[] dArray8 = new double[]{j3D_Geometry10.ordinates[3], j3D_Geometry10.ordinates[4], j3D_Geometry10.ordinates[5]};
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            J3D_Geometry j3D_Geometry13 = new J3D_Geometry(1, 0, nArray, dArray8);
            arrayList3.add(j3D_Geometry13);
            for (int i = 0; i < arrayList3.size(); ++i) {
                int n3;
                int n4;
                n2 = 0;
                for (n4 = 0; n4 < ((ArrayList)object3).size(); ++n4) {
                    if (!((J3D_Geometry)arrayList3.get(i)).pointInPolygon((J3D_Geometry)((ArrayList)object3).get(n4), d)) continue;
                    n2 = 1;
                    break;
                }
                n4 = 0;
                if (!((J3D_Geometry)arrayList3.get(i)).pntInOnPolygon((J3D_Geometry)object4.get(0), d)) {
                    n4 = 1;
                }
                if (n2 != 0 || n4 != 0) {
                    int n5;
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        dArray2 = J3D_Geometry.CpaLL3D(j3D_Geometry2, (J3D_Geometry)arrayList.get(n3), d, "FALSE");
                        d5 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
                        if (!(d5 < d4)) continue;
                        for (n5 = 0; n5 < 6; ++n5) {
                            dArray[n5] = dArray2[n5];
                        }
                        d4 = d5;
                    }
                    for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                        dArray2 = J3D_Geometry.CpaLL3D(j3D_Geometry2, (J3D_Geometry)arrayList2.get(n3), d, "FALSE");
                        d5 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
                        if (!(d5 < d4)) continue;
                        for (n5 = 0; n5 < 6; ++n5) {
                            dArray[n5] = dArray2[n5];
                        }
                        d4 = d5;
                    }
                    continue;
                }
                dArray2 = J3D_Geometry.CpaPtL3D((J3D_Geometry)arrayList3.get(i), j3D_Geometry2, d, "FALSE");
                d5 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
                if (!(d5 < d4)) continue;
                for (n3 = 0; n3 < 6; ++n3) {
                    dArray[n3] = dArray2[n3];
                }
                d4 = d5;
            }
            ArrayList<J3D_Geometry> arrayList4 = new ArrayList<J3D_Geometry>();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                J3D_Geometry j3D_Geometry14 = (J3D_Geometry)arrayList.get(n2);
                dArray2 = J3D_Geometry.CpaLL3D(j3D_Geometry10, j3D_Geometry14, d, "FALSE");
                double d8 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
                if (!(d8 < d)) continue;
                nArray6 = new int[3];
                dArray7 = new double[]{dArray2[0], dArray2[1], dArray2[2]};
                nArray6[0] = 1;
                nArray6[1] = 1;
                nArray6[2] = 1;
                j3D_Geometry12 = new J3D_Geometry(1, 0, nArray6, dArray7);
                arrayList4.add(j3D_Geometry12);
            }
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                J3D_Geometry j3D_Geometry15 = (J3D_Geometry)arrayList2.get(n2);
                dArray2 = J3D_Geometry.CpaLL3D(j3D_Geometry10, j3D_Geometry15, d, "FALSE");
                double d9 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
                if (!(d9 < d)) continue;
                nArray6 = new int[3];
                dArray7 = new double[]{dArray2[0], dArray2[1], dArray2[2]};
                nArray6[0] = 1;
                nArray6[1] = 1;
                nArray6[2] = 1;
                j3D_Geometry12 = new J3D_Geometry(1, 0, nArray6, dArray7);
                arrayList4.add(j3D_Geometry12);
            }
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                dArray2 = J3D_Geometry.CpaPtL3D((J3D_Geometry)arrayList4.get(n2), j3D_Geometry2, d, "FALSE");
                d5 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
                if (!(d5 < d4)) continue;
                for (int i = 0; i < 6; ++i) {
                    dArray[i] = dArray2[i];
                }
                d4 = d5;
            }
            if (string.equals("TRUE")) {
                dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d2, d3);
            }
            return dArray;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            dArray2 = J3D_Geometry.CpaLL3D(j3D_Geometry2, (J3D_Geometry)arrayList.get(n), d, "FALSE");
            d5 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
            if (!(d5 < d4)) continue;
            for (int i = 0; i < 6; ++i) {
                dArray[i] = dArray2[i];
            }
            d4 = d5;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            dArray2 = J3D_Geometry.CpaLL3D(j3D_Geometry2, (J3D_Geometry)arrayList2.get(n), d, "FALSE");
            d5 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
            if (!(d5 < d4)) continue;
            for (int i = 0; i < 6; ++i) {
                dArray[i] = dArray2[i];
            }
            d4 = d5;
        }
        if (string.equals("TRUE")) {
            dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d2, d3);
        }
        return dArray;
    }

    private static double[] CpaPtPg3D(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d, String string) throws Exception {
        J3D_Geometry j3D_Geometry3;
        J3D_Geometry j3D_Geometry4;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 6; ++i) {
            dArray[i] = 0.0;
        }
        double d4 = Double.MAX_VALUE;
        if (string.equals("TRUE")) {
            if (d < 0.05) {
                d = 0.05;
            }
            d2 = Math.PI / 180 * j3D_Geometry.getOrdinatesArray()[0];
            d3 = Math.PI / 180 * j3D_Geometry.getOrdinatesArray()[1];
            if (j3D_Geometry.getType() % 10 == 1 || j3D_Geometry2.getType() % 10 == 1) {
                d2 /= 2.0;
                d3 /= 2.0;
            }
            j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry, d2, d3);
            j3D_Geometry2 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry2, d2, d3);
        }
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[3];
        int n = J3D_Geometry.planeEquation(dArray4, dArray3, j3D_Geometry2);
        J3D_Geometry j3D_Geometry5 = J3D_Geometry.projectPtOntoPlane(j3D_Geometry, j3D_Geometry2);
        if (j3D_Geometry5.anyInteract(j3D_Geometry2, d, "FALSE") || j3D_Geometry2.anyInteract(j3D_Geometry5, d, "FALSE")) {
            dArray[0] = j3D_Geometry.ordinates[0];
            dArray[1] = j3D_Geometry.ordinates[1];
            dArray[2] = j3D_Geometry.ordinates[2];
            dArray[3] = j3D_Geometry5.ordinates[0];
            dArray[4] = j3D_Geometry5.ordinates[1];
            dArray[5] = j3D_Geometry5.ordinates[2];
            return dArray;
        }
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry2, 0, 1, 3, false);
        int[] nArray = new int[]{0};
        while ((j3D_Geometry4 = elementExtractor.nextElement(nArray)) != null) {
            if (nArray[0] == 2) {
                arrayList2.add(j3D_Geometry4);
                continue;
            }
            arrayList.add(j3D_Geometry4);
        }
        boolean bl = false;
        J3D_Geometry j3D_Geometry6 = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (!j3D_Geometry5.isInside((J3D_Geometry)arrayList2.get(i), d)) continue;
            bl = true;
            j3D_Geometry6 = (J3D_Geometry)arrayList2.get(i);
            break;
        }
        if (bl) {
            J3D_Geometry j3D_Geometry7;
            ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
            ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry6, 0, 2, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry7 = elementExtractor2.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    throw new Exception("54501");
                }
                arrayList3.add(j3D_Geometry7);
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                dArray2 = J3D_Geometry.CpaPtL3D(j3D_Geometry, (J3D_Geometry)arrayList3.get(i), d, "FALSE");
                double d5 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
                if (!(d5 < d4)) continue;
                for (int j = 0; j < 6; ++j) {
                    dArray[j] = dArray2[j];
                }
                d4 = d5;
            }
            if (string.equals("TRUE")) {
                dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d2, d3);
            }
            return dArray;
        }
        ArrayList<J3D_Geometry> arrayList4 = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor3 = new ElementExtractor((J3D_Geometry)arrayList.get(0), 0, 2, 3, false);
        nArray[0] = 0;
        while ((j3D_Geometry3 = elementExtractor3.nextElement(nArray)) != null) {
            if (nArray[0] == 2) {
                throw new Exception("54501");
            }
            arrayList4.add(j3D_Geometry3);
        }
        for (int i = 0; i < arrayList4.size(); ++i) {
            dArray2 = J3D_Geometry.CpaPtL3D(j3D_Geometry, (J3D_Geometry)arrayList4.get(i), d, "FALSE");
            double d6 = Math.sqrt((dArray2[0] - dArray2[3]) * (dArray2[0] - dArray2[3]) + (dArray2[1] - dArray2[4]) * (dArray2[1] - dArray2[4]) + (dArray2[2] - dArray2[5]) * (dArray2[2] - dArray2[5]));
            if (!(d6 < d4)) continue;
            for (int j = 0; j < 6; ++j) {
                dArray[j] = dArray2[j];
            }
            d4 = d6;
        }
        if (string.equals("TRUE")) {
            dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d2, d3);
        }
        return dArray;
    }

    private static double[] CpaLL3D(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d, String string) throws Exception {
        double d2;
        double d3;
        double d4;
        int n;
        double d5 = 1.0E-16;
        int n2 = 3;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        j3D_Geometry.setBelongingGeometry(j3D_Geometry);
        j3D_Geometry2.setBelongingGeometry(j3D_Geometry2);
        if (string.equals("TRUE")) {
            if (d < 0.05) {
                d = 0.05;
            }
            d13 = Math.PI / 180 * j3D_Geometry2.getOrdinatesArray()[0];
            d14 = Math.PI / 180 * j3D_Geometry2.getOrdinatesArray()[1];
            j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry, d13, d14);
            j3D_Geometry2 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry2, d13, d14);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = j3D_Geometry.ordinates[n];
            dArray2[n] = j3D_Geometry.ordinates[n + n2];
            dArray3[n] = j3D_Geometry2.ordinates[n];
            dArray4[n] = j3D_Geometry2.ordinates[n + n2];
        }
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray5[n] = dArray2[n] - dArray[n];
            dArray6[n] = dArray4[n] - dArray3[n];
            dArray7[n] = dArray[n] - dArray3[n];
        }
        for (n = 0; n < n2; ++n) {
            d6 += dArray5[n] * dArray5[n];
            d7 += dArray5[n] * dArray6[n];
            d8 += dArray6[n] * dArray6[n];
            d9 += dArray5[n] * dArray7[n];
            d10 += dArray6[n] * dArray7[n];
        }
        double d15 = d4 = d6 * d8 - d7 * d7;
        double d16 = d4;
        if (d4 < d5) {
            d3 = 0.0;
            d15 = 1.0;
            d2 = d10;
            d16 = d8;
        } else {
            d3 = d7 * d10 - d8 * d9;
            d2 = d6 * d10 - d7 * d9;
            if (d3 < 0.0) {
                d3 = 0.0;
                d2 = d10;
                d16 = d8;
            } else if (d3 > d15) {
                d3 = d15;
                d2 = d10 + d7;
                d16 = d8;
            }
        }
        if (d2 < 0.0) {
            d2 = 0.0;
            if (-d9 < 0.0) {
                d3 = 0.0;
            } else if (-d9 > d6) {
                d3 = d15;
            } else {
                d3 = -d9;
                d15 = d6;
            }
        } else if (d2 > d16) {
            d2 = d16;
            if (-d9 + d7 < 0.0) {
                d3 = 0.0;
            } else if (-d9 + d7 > d6) {
                d3 = d15;
            } else {
                d3 = -d9 + d7;
                d15 = d6;
            }
        }
        double d17 = Math.abs(d3) < d5 ? 0.0 : d3 / d15;
        double d18 = Math.abs(d2) < d5 ? 0.0 : d2 / d16;
        for (n = 0; n < n2; ++n) {
            dArray8[n] = dArray7[n] + d17 * dArray5[n] - d18 * dArray6[n];
            d12 += dArray8[n] * dArray8[n];
        }
        double[] dArray9 = new double[6];
        for (n = 0; n < n2; ++n) {
            dArray9[n] = dArray[n] + d17 * (dArray2[n] - dArray[n]);
            dArray9[n + n2] = dArray3[n] + d18 * (dArray4[n] - dArray3[n]);
        }
        if (string.equals("TRUE")) {
            dArray9 = J3D_Geometry.projectFromGnomonicToLongLat(dArray9, d13, d14);
        }
        return dArray9;
    }

    protected static double[] CpaPtL3D(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d, String string) throws Exception {
        int n;
        double[] dArray = new double[6];
        int n2 = 3;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        j3D_Geometry.setBelongingGeometry(j3D_Geometry);
        j3D_Geometry2.setBelongingGeometry(j3D_Geometry2);
        if (string.equals("TRUE")) {
            if (d < 0.05) {
                d = 0.05;
            }
            d5 = Math.PI / 180 * j3D_Geometry.getOrdinatesArray()[0];
            d6 = Math.PI / 180 * j3D_Geometry.getOrdinatesArray()[1];
            if (j3D_Geometry.getType() % 10 == 1 || j3D_Geometry2.getType() % 10 == 1) {
                d5 /= 2.0;
                d6 /= 2.0;
            }
            j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry, d5, d6);
            j3D_Geometry2 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry2, d5, d6);
        }
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = j3D_Geometry.ordinates[n];
            dArray3[n] = j3D_Geometry2.ordinates[n];
            dArray4[n] = j3D_Geometry2.ordinates[n + n2];
        }
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray5[n] = dArray4[n] - dArray3[n];
            dArray6[n] = dArray2[n] - dArray3[n];
            d2 += dArray6[n] * dArray5[n];
            d3 += dArray5[n] * dArray5[n];
        }
        if (d2 <= 0.0) {
            d4 = 0.0;
            for (n = 0; n < n2; ++n) {
                d4 += (dArray2[n] - dArray3[n]) * (dArray2[n] - dArray3[n]);
                dArray[n] = dArray2[n];
                dArray[n + n2] = dArray3[n];
            }
            if (string.equals("TRUE")) {
                dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d5, d6);
            }
            return dArray;
        }
        if (d3 <= d2) {
            d4 = 0.0;
            for (n = 0; n < n2; ++n) {
                d4 += (dArray2[n] - dArray4[n]) * (dArray2[n] - dArray4[n]);
                dArray[n] = dArray2[n];
                dArray[n + n2] = dArray4[n];
            }
            if (string.equals("TRUE")) {
                dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d5, d6);
            }
            return dArray;
        }
        double d7 = d2 / d3;
        d4 = 0.0;
        for (n = 0; n < n2; ++n) {
            dArray7[n] = dArray3[n] + d7 * dArray5[n];
            d4 += (dArray2[n] - dArray7[n]) * (dArray2[n] - dArray7[n]);
            dArray[n] = dArray2[n];
            dArray[n + n2] = dArray7[n];
        }
        if (string.equals("TRUE")) {
            dArray = J3D_Geometry.projectFromGnomonicToLongLat(dArray, d5, d6);
        }
        return dArray;
    }

    public String validate(boolean bl, double d) throws Exception {
        String string = "FALSE";
        return this.validate(bl, d, string);
    }

    public String validate(boolean bl, double d, String string) throws Exception {
        int n;
        double[] dArray;
        int[] nArray;
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        ArrayList arrayList = new ArrayList();
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        if (this.gtype != 0 && (this.elemInfo == null || this.ordinates == null)) {
            return J3D_Geometry.valdtnStr3("13032", ";", ",0,0,0,0,0,0,0", "");
        }
        if (this.gtype != 9 && this.gtype != 7 && this.gtype != 6 && this.gtype != 5 && this.gtype != 4 && this.gtype != 8 && this.gtype != 3 && this.gtype != 2 && this.gtype != 1) {
            return J3D_Geometry.valdtnStr3("13028", ";", ",0,0,0,0,0,0,0", "");
        }
        if (this.isOrientedMultiPoint() || this.isOrientedPoint()) {
            if (this.elemInfo.length != this.ordinates.length || this.elemInfo.length % 6 != 0 || this.ordinates.length % 6 != 0) {
                if (this.gtype == 5) {
                    return J3D_Geometry.valdtnStr3("13032", ";", ",0,0,0,0,0,0,1", "");
                }
                return J3D_Geometry.valdtnStr3("13032", ";", ",1", "");
            }
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            J3D_Geometry.removeOrientedPointComponents(this.elemInfo, this.ordinates, arrayList2, arrayList3);
            nArray = new int[arrayList2.size()];
            dArray = new double[arrayList3.size()];
            for (n = 0; n < arrayList2.size(); ++n) {
                nArray[n] = (Integer)arrayList2.get(n);
            }
            for (n = 0; n < arrayList3.size(); ++n) {
                dArray[n] = (Double)arrayList3.get(n);
            }
            this.elemInfo = nArray;
            this.ordinates = dArray;
        }
        nArray3[0] = this.getElemInfo()[1] % 1000;
        nArray2[0] = this.getType();
        int n3 = this.getElemInfo()[1];
        int n4 = this.getElemInfo()[2];
        if (this.gtype == 9 && n3 != 1007 && n3 != 1008) {
            return J3D_Geometry.valdtnStr3("54530", ";", ",0,0,0,0,0,0,1", "");
        }
        if (this.gtype == 7) {
            if (n3 != 1003 && n3 != 1006) {
                return J3D_Geometry.valdtnStr3("54530", ";", ",0,0,0,0,0,0,1", "");
            }
            for (int i = 0; i < this.elemInfo.length / 3; ++i) {
                if (this.getElemInfo()[3 * i + 1] != 1003 && this.getElemInfo()[3 * i + 1] != 2003 || this.getElemInfo()[3 * i + 2] == 1 || this.getElemInfo()[3 * i + 2] == 3) continue;
                return J3D_Geometry.valdtnStr3("54530", ";", ",0,0,0,0,0,0,", String.valueOf(i + 1));
            }
        }
        if (this.gtype == 6) {
            if (n3 != 2) {
                return J3D_Geometry.valdtnStr3("54530", ";", ",0,0,0,0,0,0,1", "");
            }
            for (int i = 0; i < this.elemInfo.length / 3; ++i) {
                if (this.getElemInfo()[3 * i + 1] == 2 && this.getElemInfo()[3 * i + 2] == 1) continue;
                return J3D_Geometry.valdtnStr3("54530", ";", ",0,0,0,0,0,0,", String.valueOf(i + 1));
            }
        }
        if (this.gtype == 5) {
            if (n3 != 1 || this.elemInfo.length / 3 == 1 && n4 != this.ordinates.length / 3) {
                return J3D_Geometry.valdtnStr3("54530", ";", ",1", "");
            }
            if (this.elemInfo.length / 3 == this.ordinates.length / 3) {
                for (int i = 0; i < this.elemInfo.length / 3; ++i) {
                    if (this.getElemInfo()[3 * i + 1] == 1 && this.getElemInfo()[3 * i + 2] == 1) continue;
                    return J3D_Geometry.valdtnStr3("54530", ";", ",", String.valueOf(i + 1));
                }
            } else if (this.elemInfo.length / 3 > 1) {
                int n5 = Math.min(this.elemInfo.length / 3, this.ordinates.length / 3);
                return J3D_Geometry.valdtnStr3("54530", ";", ",", String.valueOf(n5));
            }
        }
        if (this.gtype == 8 && n3 != 1007 && n3 != 1008) {
            return J3D_Geometry.valdtnStr3("54530", ";", ",0,0,0,0,1", "");
        }
        if (this.gtype == 3 && n3 != 1003 && n3 != 1006) {
            return J3D_Geometry.valdtnStr3("54530", ";", ",0,0,1", "");
        }
        if (this.gtype == 2 && (n3 != 2 || this.elemInfo.length / 3 != 1 || n4 != 1)) {
            return J3D_Geometry.valdtnStr3("54530", ";", ",0,1", "");
        }
        if (this.gtype == 1 && (n3 != 1 || n4 != 1 || this.elemInfo.length / 3 != 1 || this.ordinates.length / 3 != 1)) {
            return J3D_Geometry.valdtnStr3("54530", ";", ",1", "");
        }
        nArray = new int[this.elemInfo.length];
        System.arraycopy(this.elemInfo, 0, nArray, 0, this.elemInfo.length);
        dArray = new double[this.ordinates.length];
        System.arraycopy(this.ordinates, 0, dArray, 0, this.ordinates.length);
        n = this.getSRID();
        J3D_Geometry j3D_Geometry = new J3D_Geometry(this.getType(), n, nArray, dArray);
        if (string.equals("TRUE")) {
            if (d < 0.05) {
                d = 0.05;
            }
            d2 = Math.PI / 180 * this.getOrdinatesArray()[0];
            d3 = Math.PI / 180 * this.getOrdinatesArray()[1];
            if (this.getType() % 10 == 1) {
                d2 /= 2.0;
                d3 /= 2.0;
            }
            j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry, d2, d3);
        }
        return j3D_Geometry.validation(arrayList, n2, nArray2, nArray3, bl, d);
    }

    private static void removeOrientedPointComponents(int[] nArray, double[] dArray, ArrayList arrayList, ArrayList arrayList2) {
        int n;
        int[] nArray2 = new int[nArray.length];
        double[] dArray2 = new double[dArray.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < nArray.length / 3; ++n2) {
            if (nArray[3 * n2 + 1] == 1 && nArray[3 * n2 + 2] == 0) {
                n7 = nArray[3 * n2] - 1;
                n8 = 3 * (n2 + 1) <= nArray.length - 1 ? nArray[3 * (n2 + 1)] - 2 : dArray.length - 1;
                n6 += n8 - n7 + 1;
                continue;
            }
            n7 = nArray[3 * n2] - 1;
            n8 = 3 * (n2 + 1) <= nArray.length - 1 ? nArray[3 * (n2 + 1)] - 2 : dArray.length - 1;
            for (n3 = n7; n3 <= n8; ++n3) {
                dArray2[n5] = dArray[n3];
                ++n5;
            }
            nArray2[n4] = nArray[3 * n2] - n6;
            ++n4;
            for (n3 = 1; n3 < 3; ++n3) {
                nArray2[n4] = nArray[3 * n2 + n3];
                ++n4;
            }
        }
        for (n = 0; n < n4; ++n) {
            arrayList.add(nArray2[n]);
        }
        for (n = 0; n < n5; ++n) {
            arrayList2.add(dArray2[n]);
        }
    }

    private String validation(ArrayList arrayList, int n, int[] nArray, int[] nArray2, boolean bl, double d) throws Exception {
        double[] dArray;
        double[] dArray2;
        Object[] objectArray;
        Object[] objectArray2;
        RTreeJoinRes rTreeJoinRes;
        RTree rTree;
        Object object;
        Object object2;
        Object object3;
        ArrayList<ArrayList<Integer>> arrayList2;
        int n2;
        ArrayList arrayList3;
        Object[] objectArray3;
        int n3;
        String string;
        int n4;
        ArrayList<Integer> arrayList4;
        J3D_Geometry j3D_Geometry;
        Object[] objectArray4;
        int n5;
        Object[] objectArray5;
        J3D_Geometry j3D_Geometry2;
        ElementExtractor elementExtractor;
        ArrayList<Object[]> arrayList5;
        Locale.setDefault(ENGLISH);
        StringBuilder stringBuilder = new StringBuilder("");
        int n6 = this.getElemInfo()[1] % 1000;
        int n7 = this.getType();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl2 = false;
        int n13 = 0;
        int[] nArray3 = new int[1];
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.ordinates.length % 3 != 0) {
            String string2 = "13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified";
            return J3D_Geometry.valdtnStr3(string2, ";", ",0,0,0,0,0,0,1", "");
        }
        if (n7 == 4) {
            if (n != 0) {
                String string3 = "54500: invalid combination of elements";
                return J3D_Geometry.valdtnStr3(string3, ";", ",0,0,0,0,0,0,1", "");
            }
            n8 = 0;
            arrayList5 = new ArrayList<Object[]>();
            try {
                elementExtractor = new ElementExtractor(this);
                nArray3[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string4 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr3(string4, ";", ",0,0,0,0,0,0,", String.valueOf(n8 + 1));
                    }
                    arrayList = new ArrayList();
                    ++n8;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry2;
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(n8);
                    objectArray5[1] = arrayList;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,0,0,0,0,", String.valueOf(n8 + 1));
            }
            ++n;
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                objectArray4 = new Object[3];
                objectArray4 = (Object[])arrayList5.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray4[0];
                arrayList4 = new ArrayList<Integer>();
                arrayList4 = (ArrayList<Integer>)objectArray4[1];
                n4 = (Integer)objectArray4[2];
                nArray2[0] = j3D_Geometry.getElemInfo()[1] % 1000;
                nArray[0] = j3D_Geometry.getType();
                string = j3D_Geometry.validation(arrayList4, n, nArray, nArray2, bl, d);
                if (string.startsWith("TRUE")) continue;
                return string;
            }
        }
        if (n7 == 9) {
            if (n != 0) {
                String string5 = "54500: invalid combination of elements";
                return J3D_Geometry.valdtnStr3(string5, ";", ",0,0,0,0,0,0,1", "");
            }
            n8 = 0;
            arrayList5 = new ArrayList();
            try {
                elementExtractor = new ElementExtractor(this);
                nArray3[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string6 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr3(string6, ";", ",0,0,0,0,0,0,", String.valueOf(n8 + 1));
                    }
                    arrayList = new ArrayList();
                    ++n8;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry2;
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(n8);
                    objectArray5[1] = arrayList;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,0,0,0,0,", String.valueOf(n8 + 1));
            }
            ++n;
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                objectArray4 = new Object[3];
                objectArray4 = (Object[])arrayList5.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray4[0];
                arrayList4 = new ArrayList();
                arrayList4 = (ArrayList)objectArray4[1];
                n4 = (Integer)objectArray4[2];
                nArray2[0] = j3D_Geometry.getElemInfo()[1] % 1000;
                nArray[0] = j3D_Geometry.getType();
                string = j3D_Geometry.validation(arrayList4, n, nArray, nArray2, bl, d);
                if (string.startsWith("TRUE")) continue;
                return string;
            }
            nArray2[0] = this.getElemInfo()[1] % 1000;
            nArray[0] = this.getType();
            string = J3D_Geometry.crossElementValidation(n7, n6, nArray, nArray2, arrayList5, bl, d);
            if (!string.startsWith("TRUE")) {
                return string;
            }
        }
        if (n7 != 9 && n7 != 4 && n6 == 8) {
            arrayList5 = new ArrayList();
            if (n == 0) {
                n8 = 0;
                n9 = 0;
                try {
                    elementExtractor = new ElementExtractor(this);
                    nArray3[0] = 0;
                    while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            String string7 = "54501: no holes expected";
                            return J3D_Geometry.valdtnStr3(string7, ";", ",0,0,0,0,0,", String.valueOf(n9 + 1));
                        }
                        arrayList = new ArrayList();
                        ++n9;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry2;
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(n9);
                        objectArray5[1] = arrayList;
                        objectArray5[2] = 1;
                        arrayList5.add(objectArray5);
                    }
                }
                catch (Exception exception) {
                    if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                        return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                    }
                    return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,0,0,0,", String.valueOf(n9 + 1));
                }
            }
            n9 = 0;
            try {
                elementExtractor = new ElementExtractor(this);
                nArray3[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string8 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr(5, 6, arrayList, String.valueOf(n9 + 1), string8);
                    }
                    ++n9;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry2;
                    arrayList4 = new ArrayList();
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        arrayList4.add((Integer)arrayList.get(n3));
                    }
                    arrayList4.set(5, n9);
                    objectArray5[1] = arrayList4;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr(5, 6, arrayList, String.valueOf(n9 + 1), exception.toString().substring(exception.toString().indexOf(":") + 2));
            }
            ++n;
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                objectArray4 = new Object[3];
                objectArray4 = (Object[])arrayList5.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray4[0];
                arrayList4 = new ArrayList<Integer>();
                arrayList4 = (ArrayList<Integer>)objectArray4[1];
                n4 = (Integer)objectArray4[2];
                nArray2[0] = j3D_Geometry.getElemInfo()[1] % 1000;
                nArray[0] = j3D_Geometry.getType();
                string = j3D_Geometry.validation(arrayList4, n, nArray, nArray2, bl, d);
                if (string.startsWith("TRUE")) continue;
                return string;
            }
            nArray2[0] = this.getElemInfo()[1] % 1000;
            nArray[0] = this.getType();
            string = J3D_Geometry.crossElementValidation(n7, n6, nArray, nArray2, arrayList5, bl, d);
            if (!string.startsWith("TRUE")) {
                return string;
            }
        }
        if (n7 != 9 && n7 != 4 && n6 != 8 && n6 == 7) {
            int n14;
            ArrayList<Object[]> arrayList6;
            J3D_Geometry j3D_Geometry3;
            ElementExtractor elementExtractor2;
            J3D_Geometry j3D_Geometry4;
            ElementExtractor elementExtractor3;
            ArrayList<J3D_Geometry> arrayList7 = new ArrayList<J3D_Geometry>();
            arrayList5 = new ArrayList();
            if (n == 0) {
                n8 = 0;
                n9 = 0;
                n10 = 0;
                try {
                    elementExtractor3 = new ElementExtractor(this, 0, 2, 3);
                    nArray3[0] = 0;
                    arrayList7 = new ArrayList();
                    while ((j3D_Geometry4 = elementExtractor3.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) continue;
                        arrayList7.add(j3D_Geometry4);
                    }
                }
                catch (Exception exception) {
                    if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                        return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                    }
                    return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,0,0,", String.valueOf(n10 + 1));
                }
                j3D_Geometry4 = (J3D_Geometry)arrayList7.get(0);
                try {
                    elementExtractor2 = new ElementExtractor(j3D_Geometry4, 0, 1, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry3 = elementExtractor2.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            if (++n10 == 1) {
                                String string9 = "13366: invalid combination of interior exterior rings";
                                return J3D_Geometry.valdtnStr3(string9, ";", ",0,0,0,0,", String.valueOf(n10));
                            }
                            arrayList = new ArrayList();
                            objectArray5 = new Object[3];
                            objectArray5[0] = j3D_Geometry3;
                            arrayList.add(0);
                            arrayList.add(0);
                            arrayList.add(0);
                            arrayList.add(0);
                            arrayList.add(n10);
                            objectArray5[1] = arrayList;
                            objectArray5[2] = 2;
                            arrayList5.add(objectArray5);
                            continue;
                        }
                        if (++n10 > 1) {
                            String string10 = "54504: multiple outer geometries";
                            return J3D_Geometry.valdtnStr3(string10, ";", ",0,0,0,0,", String.valueOf(n10));
                        }
                        arrayList = new ArrayList();
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry3;
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(n10);
                        objectArray5[1] = arrayList;
                        objectArray5[2] = 1;
                        arrayList5.add(objectArray5);
                    }
                }
                catch (Exception exception) {
                    if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                        return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                    }
                    return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,0,0,", String.valueOf(n10 + 1));
                }
            }
            n10 = 0;
            try {
                elementExtractor3 = new ElementExtractor(this, 0, 2, 3);
                nArray3[0] = 0;
                arrayList7 = new ArrayList();
                while ((j3D_Geometry4 = elementExtractor3.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) continue;
                    arrayList7.add(j3D_Geometry4);
                }
            }
            catch (Exception exception) {
                return J3D_Geometry.valdtnStr(4, 5, arrayList, String.valueOf(n10 + 1), exception.toString().substring(exception.toString().indexOf(":") + 2));
            }
            j3D_Geometry4 = (J3D_Geometry)arrayList7.get(0);
            try {
                elementExtractor2 = new ElementExtractor(j3D_Geometry4, 0, 1, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry3 = elementExtractor2.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        if (++n10 == 1) {
                            String string11 = "13366: invalid combination of interior exterior rings";
                            return J3D_Geometry.valdtnStr(4, 5, arrayList, String.valueOf(n10), string11);
                        }
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry3;
                        arrayList4 = new ArrayList<Integer>();
                        for (n3 = 0; n3 < arrayList.size(); ++n3) {
                            arrayList4.add((Integer)arrayList.get(n3));
                        }
                        arrayList4.set(4, n10);
                        objectArray5[1] = arrayList4;
                        objectArray5[2] = 2;
                        arrayList5.add(objectArray5);
                        continue;
                    }
                    if (++n10 > 1) {
                        String string12 = "54504: multiple outer geometries";
                        return J3D_Geometry.valdtnStr(4, 5, arrayList, String.valueOf(n10), string12);
                    }
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry3;
                    arrayList4 = new ArrayList();
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        arrayList4.add((Integer)arrayList.get(n3));
                    }
                    arrayList4.set(4, n10);
                    objectArray5[1] = arrayList4;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr(4, 5, arrayList, String.valueOf(n10 + 1), exception.toString().substring(exception.toString().indexOf(":") + 2));
            }
            ++n;
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                objectArray4 = new Object[3];
                objectArray4 = (Object[])arrayList5.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray4[0];
                arrayList = new ArrayList();
                arrayList = (ArrayList)objectArray4[1];
                n4 = (Integer)objectArray4[2];
                n11 = 0;
                arrayList6 = new ArrayList<Object[]>();
                try {
                    elementExtractor = new ElementExtractor(j3D_Geometry, 0, 0, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            j3D_Geometry2.elemInfo[1] = 1003;
                            ++n11;
                            objectArray5 = new Object[3];
                            objectArray5[0] = j3D_Geometry2;
                            arrayList4 = new ArrayList();
                            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                                arrayList4.add((Integer)arrayList.get(n3));
                            }
                            arrayList4.set(3, n11);
                            objectArray5[1] = arrayList4;
                            objectArray5[2] = 2;
                            arrayList6.add(objectArray5);
                            continue;
                        }
                        ++n11;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry2;
                        arrayList4 = new ArrayList();
                        for (n3 = 0; n3 < arrayList.size(); ++n3) {
                            arrayList4.add((Integer)arrayList.get(n3));
                        }
                        arrayList4.set(3, n11);
                        objectArray5[1] = arrayList4;
                        objectArray5[2] = 1;
                        arrayList6.add(objectArray5);
                    }
                }
                catch (Exception exception) {
                    if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                        return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                    }
                    return J3D_Geometry.valdtnStr(3, 4, arrayList, String.valueOf(n11 + 1), exception.toString().substring(exception.toString().indexOf(":") + 2));
                }
                for (n3 = 0; n3 < arrayList6.size(); ++n3) {
                    objectArray3 = new Object[3];
                    objectArray3 = (Object[])arrayList6.get(n3);
                    J3D_Geometry j3D_Geometry5 = (J3D_Geometry)objectArray3[0];
                    arrayList3 = new ArrayList();
                    arrayList3 = (ArrayList)objectArray3[1];
                    n2 = (Integer)objectArray3[2];
                    nArray2[0] = j3D_Geometry5.getElemInfo()[1] % 1000;
                    nArray[0] = j3D_Geometry5.getType();
                    string = j3D_Geometry5.validation(arrayList3, n, nArray, nArray2, bl, d);
                    if (string.startsWith("TRUE")) continue;
                    return string;
                }
                arrayList2 = new ArrayList<ArrayList<Integer>>();
                if (!J3D_Geometry.solidClosedness(arrayList6, arrayList2, d)) {
                    String string13 = "54502: solid not closed";
                    return J3D_Geometry.valdtnStr2(arrayList2, string13);
                }
                object3 = new double[]{0.0, 0.0, 0.0};
                d3 = J3D_Geometry.volumeIntegrals(j3D_Geometry, (double[])object3);
                if (n4 == 1 && d3 <= 0.0) {
                    String string14 = "54503: incorrect solid orientation";
                    return J3D_Geometry.valdtnStr2(arrayList, string14);
                }
                if (n4 != 2 || !(d3 >= 0.0)) continue;
                String string15 = "54503: incorrect solid orientation";
                return J3D_Geometry.valdtnStr2(arrayList, string15);
            }
            arrayList2 = new ArrayList();
            object3 = new ArrayList();
            object2 = new ArrayList();
            object = new double[3][2];
            objectArray4 = (Object[])arrayList5.get(0);
            j3D_Geometry = (J3D_Geometry)objectArray4[0];
            arrayList = new ArrayList();
            arrayList = (ArrayList)objectArray4[1];
            n4 = (Integer)objectArray4[2];
            n11 = 0;
            arrayList6 = new ArrayList();
            elementExtractor = new ElementExtractor(j3D_Geometry, 0, 0, 3);
            nArray3[0] = 0;
            while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                if (nArray3[0] == 2) continue;
                ++n11;
                objectArray5 = new Object[3];
                objectArray5[0] = j3D_Geometry2;
                arrayList4 = new ArrayList();
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    arrayList4.add((Integer)arrayList.get(n3));
                }
                arrayList4.set(3, n11);
                objectArray5[1] = arrayList4;
                objectArray5[2] = 1;
                arrayList6.add(objectArray5);
                arrayList2.add(arrayList4);
                ((ArrayList)object3).add(objectArray5);
                object = J3D_Geometry.getMBH(j3D_Geometry2);
                ((ArrayList)object2).add(object);
            }
            rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree, (ArrayList)object2, object3);
            ArrayList arrayList8 = new ArrayList();
            rTree.anyInteract(rTree, arrayList8);
            rTreeJoinRes = (RTreeJoinRes)arrayList8.get(0);
            objectArray2 = new Object[3];
            objectArray = new Object[3];
            objectArray2 = (Object[])rTreeJoinRes.ptr1;
            ArrayList arrayList9 = new ArrayList();
            ArrayList arrayList10 = new ArrayList();
            arrayList9 = (ArrayList)objectArray2[1];
            ArrayList<Integer> arrayList11 = new ArrayList<Integer>();
            arrayList11.add((Integer)arrayList9.get(3));
            ArrayList<Integer> arrayList12 = new ArrayList<Integer>();
            arrayList12.add((Integer)arrayList9.get(3));
            ArrayList<Integer> arrayList13 = new ArrayList<Integer>();
            while (!arrayList11.isEmpty()) {
                arrayList13.clear();
                for (int i = 0; i < arrayList11.size(); ++i) {
                    int n15;
                    int n16 = (Integer)arrayList11.get(i);
                    ArrayList<Integer> arrayList14 = new ArrayList<Integer>();
                    for (n14 = 0; n14 < arrayList8.size(); ++n14) {
                        rTreeJoinRes = (RTreeJoinRes)arrayList8.get(n14);
                        objectArray2 = new Object[3];
                        objectArray = new Object[3];
                        objectArray2 = (Object[])rTreeJoinRes.ptr1;
                        objectArray = (Object[])rTreeJoinRes.ptr2;
                        J3D_Geometry j3D_Geometry6 = (J3D_Geometry)objectArray2[0];
                        J3D_Geometry j3D_Geometry7 = (J3D_Geometry)objectArray[0];
                        arrayList9 = new ArrayList();
                        arrayList10 = new ArrayList();
                        arrayList9 = (ArrayList)objectArray2[1];
                        arrayList10 = (ArrayList)objectArray[1];
                        n15 = (Integer)objectArray2[2];
                        int n17 = (Integer)objectArray[2];
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean bl5 = j3D_Geometry6.anyInteract(j3D_Geometry7, d);
                        if ((Integer)arrayList9.get(3) != n16 || !bl5) continue;
                        block56: for (int j = 0; j < j3D_Geometry6.ordinates.length / 3 - 1; ++j) {
                            double[] dArray3 = new double[]{j3D_Geometry6.ordinates[3 * j], j3D_Geometry6.ordinates[3 * j + 1], j3D_Geometry6.ordinates[3 * j + 2]};
                            double[] dArray4 = new double[]{j3D_Geometry6.ordinates[3 * j + 3], j3D_Geometry6.ordinates[3 * j + 4], j3D_Geometry6.ordinates[3 * j + 5]};
                            for (int k = 0; k < j3D_Geometry7.ordinates.length / 3 - 1; ++k) {
                                double[] dArray5 = new double[]{j3D_Geometry7.ordinates[3 * k], j3D_Geometry7.ordinates[3 * k + 1], j3D_Geometry7.ordinates[3 * k + 2]};
                                double[] dArray6 = new double[]{j3D_Geometry7.ordinates[3 * k + 3], j3D_Geometry7.ordinates[3 * k + 4], j3D_Geometry7.ordinates[3 * k + 5]};
                                double d4 = Math.sqrt((dArray3[0] - dArray5[0]) * (dArray3[0] - dArray5[0]) + (dArray3[1] - dArray5[1]) * (dArray3[1] - dArray5[1]) + (dArray3[2] - dArray5[2]) * (dArray3[2] - dArray5[2]));
                                double d5 = Math.sqrt((dArray4[0] - dArray6[0]) * (dArray4[0] - dArray6[0]) + (dArray4[1] - dArray6[1]) * (dArray4[1] - dArray6[1]) + (dArray4[2] - dArray6[2]) * (dArray4[2] - dArray6[2]));
                                double d6 = Math.sqrt((dArray3[0] - dArray6[0]) * (dArray3[0] - dArray6[0]) + (dArray3[1] - dArray6[1]) * (dArray3[1] - dArray6[1]) + (dArray3[2] - dArray6[2]) * (dArray3[2] - dArray6[2]));
                                double d7 = Math.sqrt((dArray4[0] - dArray5[0]) * (dArray4[0] - dArray5[0]) + (dArray4[1] - dArray5[1]) * (dArray4[1] - dArray5[1]) + (dArray4[2] - dArray5[2]) * (dArray4[2] - dArray5[2]));
                                if (!(d4 < d && d5 < d || d6 < d && d7 < d || d4 < d || d5 < d || d6 < d) && !(d7 < d)) continue;
                                bl3 = true;
                                break block56;
                            }
                        }
                        if (bl5 && !bl3) {
                            bl4 = true;
                        }
                        if (bl3) {
                            arrayList14.add((Integer)arrayList10.get(3));
                        }
                        if (!bl4) continue;
                        String string16 = "54502: solid not closed";
                        return J3D_Geometry.valdtnStr2(arrayList, string16);
                    }
                    for (n14 = 0; n14 < arrayList14.size(); ++n14) {
                        int n18 = (Integer)arrayList14.get(n14);
                        boolean bl6 = false;
                        for (n15 = 0; n15 < arrayList12.size(); ++n15) {
                            if (n18 != (Integer)arrayList12.get(n15)) continue;
                            bl6 = true;
                            break;
                        }
                        if (bl6) continue;
                        arrayList13.add(n18);
                        arrayList12.add(n18);
                    }
                }
                arrayList11.clear();
                for (n5 = 0; n5 < arrayList13.size(); ++n5) {
                    arrayList11.add((Integer)arrayList13.get(n5));
                }
            }
            for (n14 = 0; n14 < arrayList2.size(); ++n14) {
                ArrayList arrayList15 = new ArrayList();
                arrayList15 = (ArrayList)arrayList2.get(n14);
                int n19 = (Integer)arrayList15.get(3);
                boolean bl7 = true;
                for (int i = 0; i < arrayList12.size(); ++i) {
                    if (n19 != (Integer)arrayList12.get(i)) continue;
                    bl7 = false;
                    break;
                }
                if (!bl7) continue;
                String string17 = "54502: solid not closed";
                return J3D_Geometry.valdtnStr2(arrayList15, string17);
            }
            nArray2[0] = this.getElemInfo()[1] % 1000;
            nArray[0] = this.getType();
            string = J3D_Geometry.crossElementValidation(n7, n6, nArray, nArray2, arrayList5, bl, d);
            if (!string.startsWith("TRUE")) {
                return string;
            }
        }
        if (n7 == 7) {
            if (n != 0) {
                String string18 = "54500: invalid combination of elements";
                return J3D_Geometry.valdtnStr3(string18, ";", ",0,0,0,0,0,0,1", "");
            }
            n8 = 0;
            arrayList5 = new ArrayList();
            try {
                elementExtractor = new ElementExtractor(this);
                nArray3[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string19 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr3(string19, ";", ",0,0,0,0,0,0,", String.valueOf(n8 + 1));
                    }
                    arrayList = new ArrayList();
                    ++n8;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry2;
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    if (j3D_Geometry2.getElemInfo()[1] % 1000 == 3) {
                        arrayList.set(3, 1);
                    }
                    arrayList.add(0);
                    if (j3D_Geometry2.getElemInfo()[1] % 1000 == 6) {
                        arrayList.set(4, 1);
                    }
                    arrayList.add(0);
                    arrayList.add(n8);
                    objectArray5[1] = arrayList;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,0,0,0,0,", String.valueOf(n8 + 1));
            }
            ++n;
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                objectArray4 = new Object[3];
                objectArray4 = (Object[])arrayList5.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray4[0];
                arrayList4 = new ArrayList();
                arrayList4 = (ArrayList)objectArray4[1];
                n4 = (Integer)objectArray4[2];
                nArray2[0] = j3D_Geometry.getElemInfo()[1] % 1000;
                nArray[0] = j3D_Geometry.getType();
                string = j3D_Geometry.validation(arrayList4, n, nArray, nArray2, bl, d);
                if (string.startsWith("TRUE")) continue;
                return string;
            }
            nArray2[0] = this.getElemInfo()[1] % 1000;
            nArray[0] = this.getType();
            string = J3D_Geometry.crossElementValidation(n7, n6, nArray, nArray2, arrayList5, bl, d);
            if (!string.startsWith("TRUE")) {
                return string;
            }
        }
        if (n7 != 7 && n7 != 4 && n6 == 6) {
            arrayList5 = new ArrayList();
            if (n == 0) {
                n8 = 0;
                n9 = 0;
                n10 = 0;
                n11 = 0;
                try {
                    elementExtractor = new ElementExtractor(this);
                    nArray3[0] = 0;
                    while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                        ++n11;
                        arrayList = new ArrayList();
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry2;
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(n11);
                        objectArray5[1] = arrayList;
                        objectArray5[2] = 1;
                        arrayList5.add(objectArray5);
                    }
                }
                catch (Exception exception) {
                    if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                        return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                    }
                    return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,0,", String.valueOf(n11 + 1));
                }
            }
            n11 = 0;
            try {
                elementExtractor = new ElementExtractor(this, 0, 0, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        j3D_Geometry2.elemInfo[1] = 1003;
                        ++n11;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry2;
                        arrayList4 = new ArrayList<Integer>();
                        for (n3 = 0; n3 < arrayList.size(); ++n3) {
                            arrayList4.add((Integer)arrayList.get(n3));
                        }
                        arrayList4.set(3, n11);
                        objectArray5[1] = arrayList4;
                        objectArray5[2] = 2;
                        arrayList5.add(objectArray5);
                        continue;
                    }
                    ++n11;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry2;
                    arrayList4 = new ArrayList();
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        arrayList4.add((Integer)arrayList.get(n3));
                    }
                    arrayList4.set(3, n11);
                    objectArray5[1] = arrayList4;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr(3, 4, arrayList, String.valueOf(n11 + 1), exception.toString().substring(exception.toString().indexOf(":") + 2));
            }
            ++n;
            if (arrayList5.size() == 0) {
                return J3D_Geometry.valdtnStr3("54530", ";", ",0,0,0,1", "");
            }
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                objectArray4 = new Object[3];
                objectArray4 = (Object[])arrayList5.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray4[0];
                arrayList4 = new ArrayList<Integer>();
                arrayList4 = (ArrayList<Integer>)objectArray4[1];
                n4 = (Integer)objectArray4[2];
                nArray2[0] = j3D_Geometry.getElemInfo()[1] % 1000;
                nArray[0] = j3D_Geometry.getType();
                string = j3D_Geometry.validation(arrayList4, n, nArray, nArray2, bl, d);
                if (string.startsWith("TRUE")) continue;
                return string;
            }
            nArray2[0] = this.getElemInfo()[1] % 1000;
            nArray[0] = this.getType();
            string = J3D_Geometry.crossElementValidation(n7, n6, nArray, nArray2, arrayList5, bl, d);
            if (!string.startsWith("TRUE")) {
                return string;
            }
        }
        if (n7 != 7 && n7 != 4 && n6 != 6 && n6 == 3) {
            arrayList5 = new ArrayList();
            if (n == 0) {
                n8 = 0;
                n9 = 0;
                n10 = 0;
                n11 = 0;
                n12 = 0;
                try {
                    elementExtractor = new ElementExtractor(this, 0, 1, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            if (++n12 == 1) {
                                String string20 = "13366: invalid combination of interior exterior rings";
                                return J3D_Geometry.valdtnStr3(string20, ";", ",0,0,", String.valueOf(n12));
                            }
                            arrayList = new ArrayList();
                            objectArray5 = new Object[3];
                            objectArray5[0] = j3D_Geometry2;
                            arrayList.add(0);
                            arrayList.add(0);
                            arrayList.add(n12);
                            objectArray5[1] = arrayList;
                            objectArray5[2] = 2;
                            arrayList5.add(objectArray5);
                            continue;
                        }
                        if (++n12 > 1) {
                            String string21 = "54504: multiple outer geometries";
                            return J3D_Geometry.valdtnStr3(string21, ";", ",0,0,", String.valueOf(n12));
                        }
                        arrayList = new ArrayList();
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry2;
                        arrayList.add(0);
                        arrayList.add(0);
                        arrayList.add(n12);
                        objectArray5[1] = arrayList;
                        objectArray5[2] = 1;
                        arrayList5.add(objectArray5);
                    }
                }
                catch (Exception exception) {
                    if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                        return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                    }
                    return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,", String.valueOf(n12 + 1));
                }
            }
            n12 = 0;
            try {
                elementExtractor = new ElementExtractor(this, 0, 1, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        if (++n12 == 1) {
                            String string22 = "13366: invalid combination of interior exterior rings";
                            return J3D_Geometry.valdtnStr(2, 3, arrayList, String.valueOf(n12), string22);
                        }
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry2;
                        arrayList4 = new ArrayList();
                        for (n3 = 0; n3 < arrayList.size(); ++n3) {
                            arrayList4.add((Integer)arrayList.get(n3));
                        }
                        arrayList4.set(2, n12);
                        objectArray5[1] = arrayList4;
                        objectArray5[2] = 2;
                        arrayList5.add(objectArray5);
                        continue;
                    }
                    if (++n12 > 1) {
                        String string23 = "54504: multiple outer geometries";
                        return J3D_Geometry.valdtnStr(2, 3, arrayList, String.valueOf(n12), string23);
                    }
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry2;
                    arrayList4 = new ArrayList();
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        arrayList4.add((Integer)arrayList.get(n3));
                    }
                    arrayList4.set(2, n12);
                    objectArray5[1] = arrayList4;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr(2, 3, arrayList, String.valueOf(n12 + 1), exception.toString().substring(exception.toString().indexOf(":") + 2));
            }
            ++n;
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                objectArray4 = new Object[3];
                objectArray4 = (Object[])arrayList5.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray4[0];
                arrayList4 = new ArrayList();
                arrayList4 = (ArrayList)objectArray4[1];
                n4 = (Integer)objectArray4[2];
                arrayList2 = (ArrayList<ArrayList<Integer>>)new int[1];
                arrayList2[0] = false;
                if (j3D_Geometry.ordinates.length < 12) {
                    String string24 = "13343: a polygon geometry has fewer than four coordinates";
                    return J3D_Geometry.valdtnStr(1, 2, arrayList4, String.valueOf(1), string24);
                }
                if (j3D_Geometry.polygonDuplicateNode((int[])arrayList2, d)) {
                    String string25 = "13356: adjacent points in a geometry are redundant";
                    return J3D_Geometry.valdtnStr(1, 2, arrayList4, String.valueOf((int)arrayList2[0]), string25);
                }
                if (!j3D_Geometry.polygonFlatness((int[])arrayList2, d)) {
                    String string26 = "54505: ring does not lie on a plane";
                    return J3D_Geometry.valdtnStr(1, 2, arrayList4, String.valueOf((int)arrayList2[0]), string26);
                }
                if (!j3D_Geometry.polygonClosedness(d)) {
                    String string27 = "13348: polygon boundary is not closed";
                    return J3D_Geometry.valdtnStr(1, 2, arrayList4, String.valueOf(1), string27);
                }
                if (!j3D_Geometry.polygonSelfIntersection((int[])arrayList2, d)) continue;
                String string28 = "13349: polygon boundary crosses itself";
                return J3D_Geometry.valdtnStr(1, 2, arrayList4, String.valueOf((int)arrayList2[0]), string28);
            }
            string = J3D_Geometry.crossElementValidation(n7, n6, nArray, nArray2, arrayList5, bl, d);
            if (!string.startsWith("TRUE")) {
                return string;
            }
        }
        if (n7 == 6) {
            if (n != 0) {
                String string29 = "54500: invalid combination of elements";
                return J3D_Geometry.valdtnStr3(string29, ";", ",0,0,0,0,0,0,1", "");
            }
            n8 = 0;
            arrayList5 = new ArrayList();
            try {
                elementExtractor = new ElementExtractor(this);
                nArray3[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string30 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr3(string30, ";", ",0,0,0,0,0,0,", String.valueOf(n8 + 1));
                    }
                    arrayList = new ArrayList();
                    ++n8;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry2;
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(0);
                    arrayList.add(n8);
                    objectArray5[1] = arrayList;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",0,0,0,0,0,0,", String.valueOf(n8 + 1));
            }
            ++n;
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                objectArray4 = new Object[3];
                objectArray4 = (Object[])arrayList5.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray4[0];
                arrayList4 = new ArrayList();
                arrayList4 = (ArrayList<Integer>)objectArray4[1];
                n4 = (Integer)objectArray4[2];
                nArray2[0] = j3D_Geometry.getElemInfo()[1] % 1000;
                nArray[0] = j3D_Geometry.getType();
                string = j3D_Geometry.validation(arrayList4, n, nArray, nArray2, bl, d);
                if (string.startsWith("TRUE")) continue;
                return string;
            }
        }
        if (n7 != 6 && n7 != 4 && (n6 == 2 && this.getOrdinatesArray().length != 6 || n7 == 2)) {
            if (n == 0) {
                arrayList = new ArrayList();
                arrayList.add(0);
                arrayList.add(this.getOrdinatesArray().length / 3 - 1);
            } else {
                arrayList.set(1, this.getOrdinatesArray().length / 3 - 1);
            }
            dArray2 = new double[3];
            dArray = new double[3];
            int n20 = this.ordinates.length / 3;
            for (n3 = 0; n3 < n20 - 2; ++n3) {
                dArray2[0] = this.ordinates[3 * n3];
                dArray2[1] = this.ordinates[3 * n3 + 1];
                dArray2[2] = this.ordinates[3 * n3 + 2];
                dArray[0] = this.ordinates[3 * n3 + 3];
                dArray[1] = this.ordinates[3 * n3 + 4];
                dArray[2] = this.ordinates[3 * n3 + 5];
                d2 = Math.sqrt((dArray2[0] - dArray[0]) * (dArray2[0] - dArray[0]) + (dArray2[1] - dArray[1]) * (dArray2[1] - dArray[1]) + (dArray2[2] - dArray[2]) * (dArray2[2] - dArray[2]));
                if (!(d2 < d)) continue;
                String string31 = "13356: adjacent points in a geometry are redundant";
                return J3D_Geometry.valdtnStr(1, 2, arrayList, String.valueOf(n3), string31);
            }
        }
        if (n6 == 4) {
            String string32 = "54506: compound curve not supported for 3D geometries";
            return J3D_Geometry.valdtnStr2(arrayList, string32);
        }
        if (n7 == 5) {
            int n21;
            ArrayList arrayList16;
            J3D_Geometry j3D_Geometry8;
            Object[] objectArray6;
            if (n != 0) {
                String string33 = "54500: invalid combination of elements";
                return J3D_Geometry.valdtnStr3(string33, ";", ",1", "");
            }
            n13 = 0;
            arrayList5 = new ArrayList();
            try {
                elementExtractor = new ElementExtractor(this);
                nArray3[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string34 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr3(string34, ";", ",", String.valueOf(n13 + 1));
                    }
                    arrayList = new ArrayList();
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry2;
                    arrayList.add(++n13);
                    objectArray5[1] = arrayList;
                    objectArray5[2] = 1;
                    arrayList5.add(objectArray5);
                }
            }
            catch (Exception exception) {
                if (exception.toString().substring(0, 4).equals("java") && !exception.toString().substring(0, 19).equals("java.lang.Exception")) {
                    return J3D_Geometry.valdtnStr3(exception.toString(), "", "", "");
                }
                return J3D_Geometry.valdtnStr3(exception.toString().substring(exception.toString().indexOf(":") + 2), ";", ",", String.valueOf(n13 + 1));
            }
            ++n;
            if (arrayList5.size() >= 100) {
                ArrayList<Object[]> arrayList17 = new ArrayList<Object[]>();
                object3 = new ArrayList<Object>();
                object2 = new double[3][2];
                for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                    objectArray6 = new Object[3];
                    objectArray6 = (Object[])arrayList5.get(n5);
                    j3D_Geometry8 = (J3D_Geometry)objectArray6[0];
                    arrayList16 = new ArrayList();
                    arrayList16 = (ArrayList)objectArray6[1];
                    n21 = (Integer)objectArray6[2];
                    object2 = J3D_Geometry.getMBH(j3D_Geometry8);
                    ((ArrayList)object3).add(object2);
                    arrayList17.add(objectArray6);
                }
                object = new RTree(3, 8, 2, d);
                J3D_Geometry.createRTree2(object, object3, arrayList17);
                rTree = new ArrayList();
                object.anyInteract(true, false, rTree, false);
                arrayList5.clear();
                for (int i = 0; i < rTree.size(); ++i) {
                    rTreeJoinRes = (RTreeJoinRes)rTree.get(i);
                    objectArray2 = new Object[3];
                    objectArray = new Object[3];
                    objectArray2 = (Object[])rTreeJoinRes.ptr1;
                    objectArray = (Object[])rTreeJoinRes.ptr2;
                    arrayList5.add(objectArray2);
                    arrayList5.add(objectArray);
                }
            }
            for (n5 = 0; n5 < arrayList5.size(); ++n5) {
                for (n3 = 0; n3 < arrayList5.size(); ++n3) {
                    if (n5 == n3) continue;
                    objectArray6 = new Object[3];
                    objectArray6 = (Object[])arrayList5.get(n5);
                    j3D_Geometry8 = (J3D_Geometry)objectArray6[0];
                    arrayList16 = new ArrayList();
                    arrayList16 = (ArrayList)objectArray6[1];
                    n21 = (Integer)objectArray6[2];
                    objectArray3 = new Object[3];
                    objectArray3 = (Object[])arrayList5.get(n3);
                    J3D_Geometry j3D_Geometry9 = (J3D_Geometry)objectArray3[0];
                    arrayList3 = new ArrayList();
                    arrayList3 = (ArrayList)objectArray3[1];
                    n2 = (Integer)objectArray3[2];
                    dArray2 = new double[3];
                    dArray = new double[3];
                    dArray2[0] = j3D_Geometry8.ordinates[0];
                    dArray2[1] = j3D_Geometry8.ordinates[1];
                    dArray2[2] = j3D_Geometry8.ordinates[2];
                    dArray[0] = j3D_Geometry9.ordinates[0];
                    dArray[1] = j3D_Geometry9.ordinates[1];
                    dArray[2] = j3D_Geometry9.ordinates[2];
                    d2 = Math.sqrt((dArray2[0] - dArray[0]) * (dArray2[0] - dArray[0]) + (dArray2[1] - dArray[1]) * (dArray2[1] - dArray[1]) + (dArray2[2] - dArray[2]) * (dArray2[2] - dArray[2]));
                    if (!(d2 < d)) continue;
                    String string35 = "54507: duplicate points in multipoint geometry";
                    return J3D_Geometry.valdtnStr2(arrayList16, string35);
                }
            }
        }
        if (n7 == 1) {
            if (n == 0) {
                arrayList = new ArrayList();
                arrayList.add(1);
            } else {
                arrayList.set(0, 1);
            }
        }
        String string36 = "TRUE";
        stringBuilder = new StringBuilder("");
        stringBuilder.append(string36);
        return stringBuilder.toString();
    }

    private static String crossElementValidation(int n, int n2, int[] nArray, int[] nArray2, ArrayList arrayList, boolean bl, double d) throws Exception {
        J3D_Geometry j3D_Geometry;
        ElementExtractor elementExtractor;
        J3D_Geometry j3D_Geometry2;
        J3D_Geometry j3D_Geometry3;
        int n3;
        ArrayList<Object> arrayList2;
        int n4;
        ArrayList<Object> arrayList3;
        int n5;
        Object[] objectArray;
        Object[] objectArray2;
        boolean[] blArray;
        Object object;
        Object object2;
        J3D_Geometry j3D_Geometry4;
        J3D_Geometry j3D_Geometry5;
        int n6;
        int n7;
        ArrayList arrayList4;
        ArrayList arrayList5;
        J3D_Geometry j3D_Geometry6;
        J3D_Geometry j3D_Geometry7;
        Object[] objectArray3;
        Object[] objectArray4;
        J3D_Geometry j3D_Geometry8;
        ArrayList arrayList6;
        RTree rTree;
        J3D_Geometry j3D_Geometry9;
        ElementExtractor elementExtractor2;
        J3D_Geometry j3D_Geometry10;
        ElementExtractor elementExtractor3;
        int n8;
        ArrayList<Integer> arrayList7;
        Object[] objectArray5;
        J3D_Geometry j3D_Geometry11;
        String string;
        ElementExtractor elementExtractor4;
        int n9;
        ArrayList arrayList8;
        J3D_Geometry j3D_Geometry12;
        Object[] objectArray6;
        int n10;
        ArrayList<double[][]> arrayList9;
        ArrayList<Object[]> arrayList10;
        ArrayList<Object[]> arrayList11;
        ArrayList<J3D_Geometry> arrayList12;
        ArrayList<Object[]> arrayList13;
        StringBuilder stringBuilder = new StringBuilder("");
        double[][] dArray = new double[3][2];
        boolean bl2 = false;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        boolean bl5 = false;
        int n19 = 0;
        boolean bl6 = false;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        boolean bl7 = false;
        int n24 = 0;
        boolean bl8 = false;
        int[] nArray3 = new int[]{0};
        if (nArray[0] == 9) {
            arrayList13 = new ArrayList<Object[]>();
            arrayList12 = new ArrayList<J3D_Geometry>();
            arrayList11 = new ArrayList<Object[]>();
            arrayList10 = new ArrayList<Object[]>();
            arrayList9 = new ArrayList<double[][]>();
            ArrayList<Object[]> arrayList14 = new ArrayList<Object[]>();
            ArrayList<double[][]> arrayList15 = new ArrayList<double[][]>();
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                if (j3D_Geometry12.getElemInfo()[1] % 1000 == 8) {
                    n11 = 0;
                    elementExtractor4 = new ElementExtractor(j3D_Geometry12);
                    nArray3[0] = 0;
                    string = "";
                    while ((j3D_Geometry11 = elementExtractor4.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            String string2 = "54501: no holes expected";
                            return J3D_Geometry.valdtnStr(5, 6, arrayList8, String.valueOf(n11 + 1), string2);
                        }
                        ++n11;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry11;
                        arrayList7 = new ArrayList();
                        for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                            arrayList7.add((Integer)arrayList8.get(n8));
                        }
                        arrayList7.set(5, n11);
                        objectArray5[1] = arrayList7;
                        objectArray5[2] = 1;
                        arrayList13.add(objectArray5);
                    }
                    continue;
                }
                n11 = 1;
                objectArray5 = new Object[3];
                objectArray5[0] = j3D_Geometry12;
                arrayList7 = new ArrayList<Integer>();
                for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                    arrayList7.add((Integer)arrayList8.get(n8));
                }
                arrayList7.set(5, n11);
                objectArray5[1] = arrayList7;
                objectArray5[2] = 1;
                arrayList13.add(objectArray5);
            }
            for (n10 = 0; n10 < arrayList13.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList13.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                n12 = 0;
                elementExtractor3 = new ElementExtractor(j3D_Geometry12, 0, 2, 3);
                nArray3[0] = 0;
                arrayList12 = new ArrayList();
                while ((j3D_Geometry10 = elementExtractor3.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) continue;
                    arrayList12.add(j3D_Geometry10);
                }
                j3D_Geometry10 = (J3D_Geometry)arrayList12.get(0);
                elementExtractor2 = new ElementExtractor(j3D_Geometry10, 0, 1, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry9 = elementExtractor2.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        if (++n12 == 1) {
                            String string3 = "13366: invalid combination of interior exterior rings";
                            return J3D_Geometry.valdtnStr(4, 5, arrayList8, String.valueOf(n12), string3);
                        }
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry9;
                        arrayList7 = new ArrayList();
                        for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                            arrayList7.add((Integer)arrayList8.get(n8));
                        }
                        arrayList7.set(4, n12);
                        objectArray5[1] = arrayList7;
                        objectArray5[2] = 2;
                        arrayList11.add(objectArray5);
                        continue;
                    }
                    if (++n12 > 1) {
                        String string4 = "54504: multiple outer geometries";
                        return J3D_Geometry.valdtnStr(4, 5, arrayList8, String.valueOf(n12), string4);
                    }
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry9;
                    arrayList7 = new ArrayList();
                    for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                        arrayList7.add((Integer)arrayList8.get(n8));
                    }
                    arrayList7.set(4, n12);
                    objectArray5[1] = arrayList7;
                    objectArray5[2] = 1;
                    arrayList11.add(objectArray5);
                }
            }
            for (n10 = 0; n10 < arrayList11.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList11.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                n13 = 0;
                elementExtractor4 = new ElementExtractor(j3D_Geometry12, 0, 0, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry11 = elementExtractor4.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        j3D_Geometry11.elemInfo[1] = 1003;
                        ++n13;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry11;
                        arrayList7 = new ArrayList();
                        for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                            arrayList7.add((Integer)arrayList8.get(n8));
                        }
                        arrayList7.set(3, n13);
                        objectArray5[1] = arrayList7;
                        objectArray5[2] = 2;
                        arrayList10.add(objectArray5);
                        dArray = J3D_Geometry.getMBH(j3D_Geometry11);
                        arrayList9.add(dArray);
                        continue;
                    }
                    ++n13;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry11;
                    arrayList7 = new ArrayList();
                    for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                        arrayList7.add((Integer)arrayList8.get(n8));
                    }
                    arrayList7.set(3, n13);
                    objectArray5[1] = arrayList7;
                    objectArray5[2] = 1;
                    arrayList10.add(objectArray5);
                    dArray = J3D_Geometry.getMBH(j3D_Geometry11);
                    arrayList9.add(dArray);
                }
            }
            rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree, arrayList9, arrayList10);
            arrayList6 = new ArrayList();
            rTree.anyInteract(rTree, arrayList6);
            for (n10 = 0; n10 < arrayList6.size(); ++n10) {
                j3D_Geometry8 = (RTreeJoinRes)arrayList6.get(n10);
                objectArray4 = new Object[3];
                objectArray3 = new Object[3];
                objectArray4 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr1;
                objectArray3 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr2;
                j3D_Geometry7 = (J3D_Geometry)objectArray4[0];
                j3D_Geometry6 = (J3D_Geometry)objectArray3[0];
                arrayList5 = new ArrayList();
                arrayList4 = new ArrayList();
                arrayList5 = (ArrayList)objectArray4[1];
                arrayList4 = (ArrayList)objectArray3[1];
                n7 = (Integer)objectArray4[2];
                n6 = (Integer)objectArray3[2];
                n15 = (Integer)arrayList5.get(6);
                if (n15 == (n20 = ((Integer)arrayList4.get(6)).intValue()) || !j3D_Geometry7.onSamePlane(j3D_Geometry6, d) || !j3D_Geometry7.anyInteract(j3D_Geometry6, d) || !j3D_Geometry7.overlapArea(j3D_Geometry6, d)) continue;
                String string5 = "54508: overlapping surfaces in a multisolid geometry";
                return J3D_Geometry.valdtnStr2(arrayList5, string5);
            }
            for (n10 = 0; n10 < arrayList11.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList11.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                if (n9 != 1) continue;
                objectArray5 = new Object[]{j3D_Geometry12, arrayList8, 1};
                arrayList14.add(objectArray5);
                dArray = J3D_Geometry.getMBH(j3D_Geometry12);
                arrayList15.add(dArray);
            }
            RTree rTree2 = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree2, arrayList15, arrayList14);
            ArrayList arrayList16 = new ArrayList();
            rTree2.anyInteract(rTree2, arrayList16);
            for (n10 = 0; n10 < arrayList16.size(); ++n10) {
                J3D_Geometry j3D_Geometry13;
                int n25;
                j3D_Geometry8 = (RTreeJoinRes)arrayList16.get(n10);
                objectArray4 = new Object[3];
                objectArray3 = new Object[3];
                objectArray4 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr1;
                objectArray3 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr2;
                j3D_Geometry5 = (J3D_Geometry)objectArray4[0];
                j3D_Geometry4 = (J3D_Geometry)objectArray3[0];
                arrayList5 = new ArrayList();
                arrayList4 = new ArrayList();
                arrayList5 = (ArrayList)objectArray4[1];
                arrayList4 = (ArrayList)objectArray3[1];
                n7 = (Integer)objectArray4[2];
                n6 = (Integer)objectArray3[2];
                n15 = (Integer)arrayList5.get(6);
                if (n15 == (n20 = ((Integer)arrayList4.get(6)).intValue())) continue;
                for (n25 = 0; n25 < j3D_Geometry5.ordinates.length / 3; ++n25) {
                    object2 = new double[3];
                    object2[0] = (double[])j3D_Geometry5.ordinates[3 * n25];
                    object2[1] = (double[])j3D_Geometry5.ordinates[3 * n25 + 1];
                    object2[2] = (double[])j3D_Geometry5.ordinates[3 * n25 + 2];
                    object = new int[3];
                    object[0] = (double[])true;
                    object[1] = (double[])true;
                    object[2] = (double[])true;
                    j3D_Geometry13 = new J3D_Geometry(1, 0, (int[])object, (double[])object2);
                    if (!j3D_Geometry13.pointInSolid(j3D_Geometry4, false, d)) continue;
                    String string6 = "13034: Invalid data in the SDO_ORDINATE_ARRAY in SDO_GEOMETRY object";
                    return J3D_Geometry.valdtnStr2(arrayList5, string6);
                }
                for (n25 = 0; n25 < j3D_Geometry4.ordinates.length / 3; ++n25) {
                    object2 = new double[3];
                    object2[0] = (double[])j3D_Geometry4.ordinates[3 * n25];
                    object2[1] = (double[])j3D_Geometry4.ordinates[3 * n25 + 1];
                    object2[2] = (double[])j3D_Geometry4.ordinates[3 * n25 + 2];
                    object = new int[3];
                    object[0] = (double[])true;
                    object[1] = (double[])true;
                    object[2] = (double[])true;
                    j3D_Geometry13 = new J3D_Geometry(1, 0, (int[])object, (double[])object2);
                    if (!j3D_Geometry13.pointInSolid(j3D_Geometry5, false, d)) continue;
                    String string7 = "13034: Invalid data in the SDO_ORDINATE_ARRAY in SDO_GEOMETRY object";
                    return J3D_Geometry.valdtnStr2(arrayList4, string7);
                }
            }
        }
        if (nArray[0] != 9 && nArray2[0] == 8) {
            arrayList12 = new ArrayList();
            arrayList11 = new ArrayList();
            arrayList10 = new ArrayList();
            arrayList9 = new ArrayList();
            ArrayList<Object[]> arrayList17 = new ArrayList<Object[]>();
            ArrayList<double[][]> arrayList18 = new ArrayList<double[][]>();
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                n12 = 0;
                elementExtractor3 = new ElementExtractor(j3D_Geometry12, 0, 2, 3);
                nArray3[0] = 0;
                arrayList12 = new ArrayList();
                while ((j3D_Geometry10 = elementExtractor3.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) continue;
                    arrayList12.add(j3D_Geometry10);
                }
                j3D_Geometry10 = (J3D_Geometry)arrayList12.get(0);
                elementExtractor2 = new ElementExtractor(j3D_Geometry10, 0, 1, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry9 = elementExtractor2.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        if (++n12 == 1) {
                            String string8 = "13366: invalid combination of interior exterior rings";
                            return J3D_Geometry.valdtnStr(4, 5, arrayList8, String.valueOf(n12), string8);
                        }
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry9;
                        arrayList7 = new ArrayList();
                        for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                            arrayList7.add((Integer)arrayList8.get(n8));
                        }
                        arrayList7.set(4, n12);
                        objectArray5[1] = arrayList7;
                        objectArray5[2] = 2;
                        arrayList11.add(objectArray5);
                        continue;
                    }
                    if (++n12 > 1) {
                        String string9 = "54504: multiple outer geometries";
                        return J3D_Geometry.valdtnStr(4, 5, arrayList8, String.valueOf(n12), string9);
                    }
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry9;
                    arrayList7 = new ArrayList();
                    for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                        arrayList7.add((Integer)arrayList8.get(n8));
                    }
                    arrayList7.set(4, n12);
                    objectArray5[1] = arrayList7;
                    objectArray5[2] = 1;
                    arrayList11.add(objectArray5);
                }
            }
            for (n10 = 0; n10 < arrayList11.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList11.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                n13 = 0;
                elementExtractor4 = new ElementExtractor(j3D_Geometry12, 0, 0, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry11 = elementExtractor4.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        j3D_Geometry11.elemInfo[1] = 1003;
                        ++n13;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry11;
                        arrayList7 = new ArrayList();
                        for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                            arrayList7.add((Integer)arrayList8.get(n8));
                        }
                        arrayList7.set(3, n13);
                        objectArray5[1] = arrayList7;
                        objectArray5[2] = 2;
                        arrayList10.add(objectArray5);
                        dArray = J3D_Geometry.getMBH(j3D_Geometry11);
                        arrayList9.add(dArray);
                        continue;
                    }
                    ++n13;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry11;
                    arrayList7 = new ArrayList();
                    for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                        arrayList7.add((Integer)arrayList8.get(n8));
                    }
                    arrayList7.set(3, n13);
                    objectArray5[1] = arrayList7;
                    objectArray5[2] = 1;
                    arrayList10.add(objectArray5);
                    dArray = J3D_Geometry.getMBH(j3D_Geometry11);
                    arrayList9.add(dArray);
                }
            }
            rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree, arrayList9, arrayList10);
            arrayList6 = new ArrayList();
            rTree.anyInteract(rTree, arrayList6);
            blArray = new boolean[arrayList.size()];
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                blArray[n10] = false;
            }
            for (n10 = 0; n10 < arrayList6.size(); ++n10) {
                j3D_Geometry8 = (RTreeJoinRes)arrayList6.get(n10);
                objectArray4 = new Object[3];
                objectArray3 = new Object[3];
                objectArray4 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr1;
                objectArray3 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr2;
                j3D_Geometry7 = (J3D_Geometry)objectArray4[0];
                j3D_Geometry6 = (J3D_Geometry)objectArray3[0];
                arrayList5 = new ArrayList();
                arrayList4 = new ArrayList();
                arrayList5 = (ArrayList)objectArray4[1];
                arrayList4 = (ArrayList)objectArray3[1];
                n7 = (Integer)objectArray4[2];
                n6 = (Integer)objectArray3[2];
                n16 = (Integer)arrayList5.get(5);
                if (n16 == (n21 = ((Integer)arrayList4.get(5)).intValue()) || n7 != 1 || n6 != 1 || blArray[n16 - 1] && blArray[n21 - 1] || !j3D_Geometry7.onSamePlane(j3D_Geometry6, d) || !j3D_Geometry7.anyInteract(j3D_Geometry6, d) || !j3D_Geometry7.overlapArea(j3D_Geometry6, d)) continue;
                blArray[n16 - 1] = true;
                blArray[n21 - 1] = true;
            }
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                if (blArray[n10]) continue;
                String string10 = "54509: solid not attached to composite solid";
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                return J3D_Geometry.valdtnStr2(arrayList8, string10);
            }
            for (n10 = 0; n10 < arrayList11.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList11.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                if (n9 != 1) continue;
                objectArray5 = new Object[]{j3D_Geometry12, arrayList8, 1};
                arrayList17.add(objectArray5);
                dArray = J3D_Geometry.getMBH(j3D_Geometry12);
                arrayList18.add(dArray);
            }
            RTree rTree3 = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree3, arrayList18, arrayList17);
            ArrayList arrayList19 = new ArrayList();
            rTree3.anyInteract(rTree3, arrayList19);
            for (n10 = 0; n10 < arrayList19.size(); ++n10) {
                J3D_Geometry j3D_Geometry14;
                int n26;
                j3D_Geometry8 = (RTreeJoinRes)arrayList19.get(n10);
                objectArray4 = new Object[3];
                objectArray3 = new Object[3];
                objectArray4 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr1;
                objectArray3 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr2;
                j3D_Geometry5 = (J3D_Geometry)objectArray4[0];
                j3D_Geometry4 = (J3D_Geometry)objectArray3[0];
                arrayList5 = new ArrayList();
                arrayList4 = new ArrayList();
                arrayList5 = (ArrayList)objectArray4[1];
                arrayList4 = (ArrayList)objectArray3[1];
                n7 = (Integer)objectArray4[2];
                n6 = (Integer)objectArray3[2];
                n16 = (Integer)arrayList5.get(5);
                if (n16 == (n21 = ((Integer)arrayList4.get(5)).intValue()) || !j3D_Geometry5.anyInteract(j3D_Geometry4, d)) continue;
                double[][] dArray2 = new double[3][2];
                object2 = new double[3][2];
                dArray2 = J3D_Geometry.getMBH(j3D_Geometry5);
                object2 = J3D_Geometry.getMBH(j3D_Geometry4);
                object = new double[3][2];
                object = J3D_Geometry.volRegInt(dArray2, object2);
                for (n26 = 0; n26 < j3D_Geometry5.ordinates.length / 3; ++n26) {
                    objectArray2 = new double[3];
                    objectArray2[0] = (int)j3D_Geometry5.ordinates[3 * n26];
                    objectArray2[1] = (int)j3D_Geometry5.ordinates[3 * n26 + 1];
                    objectArray2[2] = (int)j3D_Geometry5.ordinates[3 * n26 + 2];
                    objectArray = new int[3];
                    objectArray[0] = 1.0;
                    objectArray[1] = 1.0;
                    objectArray[2] = 1.0;
                    j3D_Geometry14 = new J3D_Geometry(1, 0, (int[])objectArray, (double[])objectArray2);
                    n5 = 0;
                    for (n8 = 0; n8 < 3; ++n8) {
                        dArray = J3D_Geometry.getMBH(j3D_Geometry14);
                        if (object[n8][0] > dArray[n8][1] + d || dArray[n8][0] > object[n8][1] + d) continue;
                        ++n5;
                    }
                    if (n5 != 3 || !j3D_Geometry14.pointInSolid(j3D_Geometry4, false, d)) continue;
                    String string11 = "13034: Invalid data in the SDO_ORDINATE_ARRAY in SDO_GEOMETRY object";
                    return J3D_Geometry.valdtnStr2(arrayList5, string11);
                }
                for (n26 = 0; n26 < j3D_Geometry4.ordinates.length / 3; ++n26) {
                    objectArray2 = new double[3];
                    objectArray2[0] = (int)j3D_Geometry4.ordinates[3 * n26];
                    objectArray2[1] = (int)j3D_Geometry4.ordinates[3 * n26 + 1];
                    objectArray2[2] = (int)j3D_Geometry4.ordinates[3 * n26 + 2];
                    objectArray = new int[3];
                    objectArray[0] = 1.0;
                    objectArray[1] = 1.0;
                    objectArray[2] = 1.0;
                    j3D_Geometry14 = new J3D_Geometry(1, 0, (int[])objectArray, (double[])objectArray2);
                    n5 = 0;
                    for (n8 = 0; n8 < 3; ++n8) {
                        dArray = J3D_Geometry.getMBH(j3D_Geometry14);
                        if (object[n8][0] > dArray[n8][1] + d || dArray[n8][0] > object[n8][1] + d) continue;
                        ++n5;
                    }
                    if (n5 != 3 || !j3D_Geometry14.pointInSolid(j3D_Geometry5, false, d)) continue;
                    String string12 = "13034: Invalid data in the SDO_ORDINATE_ARRAY in SDO_GEOMETRY object";
                    return J3D_Geometry.valdtnStr2(arrayList4, string12);
                }
            }
        }
        if (nArray[0] != 9 && nArray2[0] != 8 && nArray2[0] == 7) {
            ArrayList<Integer> arrayList20;
            objectArray4 = new Object[3];
            objectArray4 = (Object[])arrayList.get(0);
            J3D_Geometry j3D_Geometry15 = (J3D_Geometry)objectArray4[0];
            arrayList5 = new ArrayList();
            arrayList5 = (ArrayList)objectArray4[1];
            n7 = (Integer)objectArray4[2];
            arrayList10 = new ArrayList();
            n13 = 0;
            elementExtractor4 = new ElementExtractor(j3D_Geometry15, 0, 0, 3);
            nArray3[0] = 0;
            while ((j3D_Geometry11 = elementExtractor4.nextElement(nArray3)) != null) {
                if (nArray3[0] == 2) {
                    String string13 = "54501: no holes expected";
                    return J3D_Geometry.valdtnStr2(arrayList5, string13);
                }
                ++n13;
                objectArray5 = new Object[3];
                objectArray5[0] = j3D_Geometry11;
                ArrayList<Integer> arrayList21 = new ArrayList<Integer>();
                for (n8 = 0; n8 < arrayList5.size(); ++n8) {
                    arrayList21.add((Integer)arrayList5.get(n8));
                }
                arrayList21.set(3, n13);
                arrayList21.set(2, 1);
                objectArray5[1] = arrayList21;
                objectArray5[2] = 1;
                arrayList10.add(objectArray5);
            }
            arrayList3 = new ArrayList<Object>();
            for (n4 = 0; n4 < arrayList10.size(); ++n4) {
                objectArray3 = new Object[3];
                objectArray3 = (Object[])arrayList10.get(n4);
                j3D_Geometry7 = (J3D_Geometry)objectArray3[0];
                arrayList4 = new ArrayList();
                arrayList4 = (ArrayList)objectArray3[1];
                n6 = (Integer)objectArray3[2];
                n19 = 0;
                elementExtractor4 = new ElementExtractor(j3D_Geometry7, 0, 2, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry11 = elementExtractor4.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string14 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr(1, 2, arrayList4, String.valueOf(n19 + 1), string14);
                    }
                    ++n19;
                    objectArray5 = new Object[3];
                    objectArray5[0] = j3D_Geometry11;
                    arrayList20 = new ArrayList<Integer>();
                    for (n8 = 0; n8 < arrayList4.size(); ++n8) {
                        arrayList20.add((Integer)arrayList4.get(n8));
                    }
                    arrayList20.set(1, n19);
                    objectArray5[1] = arrayList20;
                    objectArray5[2] = 1;
                    arrayList3.add(objectArray5);
                }
            }
            for (n10 = 1; n10 < arrayList.size(); ++n10) {
                objectArray3 = new Object[3];
                objectArray3 = (Object[])arrayList.get(n10);
                J3D_Geometry j3D_Geometry16 = (J3D_Geometry)objectArray3[0];
                arrayList4 = new ArrayList();
                arrayList4 = (ArrayList)objectArray3[1];
                n6 = (Integer)objectArray3[2];
                ArrayList<Object[]> arrayList22 = new ArrayList<Object[]>();
                n13 = 0;
                elementExtractor4 = new ElementExtractor(j3D_Geometry16, 0, 0, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry11 = elementExtractor4.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        j3D_Geometry11.elemInfo[1] = 1003;
                        ++n13;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry11;
                        arrayList20 = new ArrayList();
                        for (n8 = 0; n8 < arrayList4.size(); ++n8) {
                            arrayList20.add((Integer)arrayList4.get(n8));
                        }
                        arrayList20.set(3, n13);
                        arrayList20.set(2, 1);
                        objectArray5[1] = arrayList20;
                        objectArray5[2] = 2;
                        arrayList22.add(objectArray5);
                        continue;
                    }
                    String string15 = "54510: no outer geometry expected";
                    return J3D_Geometry.valdtnStr2(arrayList4, string15);
                }
                arrayList2 = new ArrayList<Object>();
                for (n3 = 0; n3 < arrayList22.size(); ++n3) {
                    Object[] objectArray7 = new Object[3];
                    objectArray7 = (Object[])arrayList22.get(n3);
                    j3D_Geometry6 = (J3D_Geometry)objectArray7[0];
                    ArrayList arrayList23 = new ArrayList();
                    arrayList23 = (ArrayList)objectArray7[1];
                    int n27 = (Integer)objectArray7[2];
                    n24 = 0;
                    elementExtractor4 = new ElementExtractor(j3D_Geometry6, 0, 2, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry11 = elementExtractor4.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            String string16 = "54501: no holes expected";
                            return J3D_Geometry.valdtnStr(1, 2, arrayList23, String.valueOf(n24 + 1), string16);
                        }
                        ++n24;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry11;
                        ArrayList<Integer> arrayList24 = new ArrayList<Integer>();
                        for (n8 = 0; n8 < arrayList23.size(); ++n8) {
                            arrayList24.add((Integer)arrayList23.get(n8));
                        }
                        arrayList24.set(1, n24);
                        objectArray5[1] = arrayList24;
                        objectArray5[2] = 1;
                        arrayList2.add(objectArray5);
                    }
                }
                for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                    for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                        Object[] objectArray8 = new Object[3];
                        objectArray8 = (Object[])arrayList3.get(n4);
                        j3D_Geometry3 = (J3D_Geometry)objectArray8[0];
                        ArrayList arrayList25 = new ArrayList();
                        arrayList25 = (ArrayList)objectArray8[1];
                        int n28 = (Integer)objectArray8[2];
                        Object[] objectArray9 = new Object[3];
                        objectArray9 = (Object[])arrayList2.get(n3);
                        j3D_Geometry2 = (J3D_Geometry)objectArray9[0];
                        ArrayList arrayList26 = new ArrayList();
                        arrayList26 = (ArrayList)objectArray9[1];
                        int n29 = (Integer)objectArray9[2];
                        if (!j3D_Geometry3.anyInteract(j3D_Geometry2, d) || !J3D_Geometry.T2reln(j3D_Geometry3, j3D_Geometry2, d) && !J3D_Geometry.T4reln(j3D_Geometry3, j3D_Geometry2, d)) continue;
                        String string17 = "54511: edges of inner and outer solids intersect";
                        return J3D_Geometry.valdtnStr2(arrayList25, string17);
                    }
                }
                for (n5 = 0; n5 < j3D_Geometry16.ordinates.length / 3; ++n5) {
                    int[] nArray4 = new int[3];
                    double[] dArray3 = new double[3];
                    nArray4[0] = 1;
                    nArray4[1] = 1;
                    nArray4[2] = 1;
                    dArray3[0] = j3D_Geometry16.ordinates[3 * n5];
                    dArray3[1] = j3D_Geometry16.ordinates[3 * n5 + 1];
                    dArray3[2] = j3D_Geometry16.ordinates[3 * n5 + 2];
                    J3D_Geometry j3D_Geometry17 = new J3D_Geometry(1, 0, nArray4, dArray3);
                    if (j3D_Geometry17.pointInOnSolid(j3D_Geometry15, true, d)) continue;
                    String string18 = "54512: a vertex of an inner solid is outside corresponding outer solid";
                    return J3D_Geometry.valdtnStr2(arrayList4, string18);
                }
                for (n4 = 0; n4 < arrayList10.size(); ++n4) {
                    for (n3 = 0; n3 < arrayList22.size(); ++n3) {
                        objectArray4 = new Object[3];
                        objectArray4 = (Object[])arrayList10.get(n4);
                        j3D_Geometry7 = (J3D_Geometry)objectArray4[0];
                        arrayList5 = new ArrayList();
                        arrayList5 = (ArrayList)objectArray4[1];
                        n7 = (Integer)objectArray4[2];
                        objectArray3 = new Object[3];
                        objectArray3 = (Object[])arrayList22.get(n3);
                        j3D_Geometry6 = (J3D_Geometry)objectArray3[0];
                        arrayList4 = new ArrayList();
                        arrayList4 = (ArrayList)objectArray3[1];
                        n6 = (Integer)objectArray3[2];
                        if (!j3D_Geometry7.overlapArea(j3D_Geometry6, d)) continue;
                        String string19 = "54513: inner solid surface overlaps outer solid surface";
                        return J3D_Geometry.valdtnStr2(arrayList5, string19);
                    }
                }
            }
        }
        if (nArray[0] == 7) {
            arrayList13 = new ArrayList();
            arrayList11 = new ArrayList();
            ArrayList<Object[]> arrayList27 = new ArrayList<Object[]>();
            ArrayList<double[][]> arrayList28 = new ArrayList<double[][]>();
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                if (j3D_Geometry12.getElemInfo()[1] % 1000 == 6) {
                    n13 = 0;
                    elementExtractor4 = new ElementExtractor(j3D_Geometry12);
                    nArray3[0] = 0;
                    string = "";
                    while ((j3D_Geometry11 = elementExtractor4.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            String string20 = "54501: no holes expected";
                            return J3D_Geometry.valdtnStr(3, 4, arrayList8, String.valueOf(n13 + 1), string20);
                        }
                        ++n13;
                        objectArray5 = new Object[3];
                        objectArray5[0] = j3D_Geometry11;
                        arrayList7 = new ArrayList();
                        for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                            arrayList7.add((Integer)arrayList8.get(n8));
                        }
                        arrayList7.set(3, n13);
                        objectArray5[1] = arrayList7;
                        objectArray5[2] = 1;
                        arrayList13.add(objectArray5);
                    }
                    continue;
                }
                n13 = 1;
                objectArray5 = new Object[3];
                objectArray5[0] = j3D_Geometry12;
                arrayList7 = new ArrayList();
                for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                    arrayList7.add((Integer)arrayList8.get(n8));
                }
                arrayList7.set(3, n13);
                objectArray5[1] = arrayList7;
                objectArray5[2] = 1;
                arrayList13.add(objectArray5);
            }
            for (n10 = 0; n10 < arrayList13.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList13.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                n14 = 0;
                elementExtractor = new ElementExtractor(j3D_Geometry12, 0, 1, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        if (++n14 == 1) {
                            String string21 = "13366: invalid combination of interior exterior rings";
                            return J3D_Geometry.valdtnStr(2, 3, arrayList8, String.valueOf(n14 + 1), string21);
                        }
                        Object[] objectArray10 = new Object[3];
                        objectArray10[0] = j3D_Geometry;
                        arrayList7 = new ArrayList();
                        for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                            arrayList7.add((Integer)arrayList8.get(n8));
                        }
                        arrayList7.set(2, n14);
                        objectArray10[1] = arrayList7;
                        objectArray10[2] = new Integer(2);
                        arrayList11.add(objectArray10);
                        continue;
                    }
                    if (++n14 > 1) {
                        String string22 = "54504: multiple outer geometries";
                        return J3D_Geometry.valdtnStr(2, 3, arrayList8, String.valueOf(n14 + 1), string22);
                    }
                    Object[] objectArray11 = new Object[3];
                    objectArray11[0] = j3D_Geometry;
                    arrayList7 = new ArrayList();
                    for (n8 = 0; n8 < arrayList8.size(); ++n8) {
                        arrayList7.add((Integer)arrayList8.get(n8));
                    }
                    arrayList7.set(2, n14);
                    objectArray11[1] = arrayList7;
                    objectArray11[2] = new Integer(1);
                    arrayList11.add(objectArray11);
                }
            }
            for (n10 = 0; n10 < arrayList11.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList11.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                if (n9 != 1) continue;
                arrayList27.add(objectArray6);
                dArray = J3D_Geometry.getMBH(j3D_Geometry12);
                arrayList28.add(dArray);
            }
            RTree rTree4 = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree4, arrayList28, arrayList27);
            arrayList6 = new ArrayList();
            rTree4.anyInteract(rTree4, arrayList6);
            for (n10 = 0; n10 < arrayList6.size(); ++n10) {
                j3D_Geometry8 = (RTreeJoinRes)arrayList6.get(n10);
                objectArray4 = new Object[3];
                objectArray3 = new Object[3];
                objectArray4 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr1;
                objectArray3 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr2;
                j3D_Geometry7 = (J3D_Geometry)objectArray4[0];
                j3D_Geometry6 = (J3D_Geometry)objectArray3[0];
                arrayList5 = new ArrayList();
                arrayList4 = new ArrayList();
                arrayList5 = (ArrayList)objectArray4[1];
                arrayList4 = (ArrayList)objectArray3[1];
                n7 = (Integer)objectArray4[2];
                n6 = (Integer)objectArray3[2];
                n15 = (Integer)arrayList5.get(6);
                n20 = (Integer)arrayList4.get(6);
                n16 = (Integer)arrayList5.get(5);
                n21 = (Integer)arrayList4.get(5);
                n17 = (Integer)arrayList5.get(4);
                n22 = (Integer)arrayList4.get(4);
                n18 = (Integer)arrayList5.get(3);
                n23 = (Integer)arrayList4.get(3);
                if (!(n15 == n20 && n17 == n22 && n18 != n23 || n15 == n20 && n17 != n22) && n15 == n20 || !j3D_Geometry7.onSamePlane(j3D_Geometry6, d) || !j3D_Geometry7.anyInteract(j3D_Geometry6, d) || !j3D_Geometry7.overlapArea(j3D_Geometry6, d)) continue;
                String string23 = "54514: overlapping areas in multipolygon";
                return J3D_Geometry.valdtnStr2(arrayList5, string23);
            }
            stringBuilder = new StringBuilder("");
            stringBuilder.append(J3D_Geometry.shareEdge(arrayList11, d));
            if (!stringBuilder.toString().equalsIgnoreCase("")) {
                return stringBuilder.toString();
            }
        }
        if (nArray[0] != 7 && nArray2[0] == 6) {
            J3D_Geometry j3D_Geometry18;
            J3D_Geometry j3D_Geometry19;
            ArrayList<J3D_Geometry> arrayList29;
            ArrayList<J3D_Geometry> arrayList30;
            ArrayList<J3D_Geometry> arrayList31;
            ArrayList<J3D_Geometry> arrayList32;
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                for (n5 = 0; n5 < arrayList.size(); ++n5) {
                    if (n10 == n5) continue;
                    objectArray4 = new Object[3];
                    objectArray3 = new Object[3];
                    objectArray4 = (Object[])arrayList.get(n10);
                    objectArray3 = (Object[])arrayList.get(n5);
                    j3D_Geometry7 = (J3D_Geometry)objectArray4[0];
                    j3D_Geometry6 = (J3D_Geometry)objectArray3[0];
                    arrayList5 = new ArrayList();
                    arrayList4 = new ArrayList();
                    arrayList5 = (ArrayList)objectArray4[1];
                    arrayList4 = (ArrayList)objectArray3[1];
                    n7 = (Integer)objectArray4[2];
                    n6 = (Integer)objectArray3[2];
                    if (!j3D_Geometry7.anyInteract(j3D_Geometry6, d)) continue;
                    arrayList32 = new ArrayList<J3D_Geometry>();
                    arrayList31 = new ArrayList<J3D_Geometry>();
                    arrayList30 = new ArrayList<J3D_Geometry>();
                    arrayList29 = new ArrayList<J3D_Geometry>();
                    elementExtractor = new ElementExtractor(j3D_Geometry7, 0, 1, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry = elementExtractor.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            arrayList32.add(j3D_Geometry);
                            continue;
                        }
                        arrayList31.add(j3D_Geometry);
                    }
                    elementExtractor = new ElementExtractor(j3D_Geometry6, 0, 1, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry = elementExtractor.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            arrayList30.add(j3D_Geometry);
                            continue;
                        }
                        arrayList29.add(j3D_Geometry);
                    }
                    j3D_Geometry19 = (J3D_Geometry)arrayList31.get(0);
                    j3D_Geometry18 = (J3D_Geometry)arrayList29.get(0);
                    arrayList3 = new ArrayList();
                    elementExtractor4 = new ElementExtractor(j3D_Geometry19, 0, 2, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry12 = elementExtractor4.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            String string24 = "54501: no holes expected";
                            return J3D_Geometry.valdtnStr(2, 3, arrayList5, String.valueOf(1), string24);
                        }
                        arrayList3.add(j3D_Geometry12);
                    }
                    arrayList2 = new ArrayList();
                    elementExtractor4 = new ElementExtractor(j3D_Geometry18, 0, 2, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry12 = elementExtractor4.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            String string25 = "54501: no holes expected";
                            return J3D_Geometry.valdtnStr(2, 3, arrayList5, String.valueOf(1), string25);
                        }
                        arrayList2.add(j3D_Geometry12);
                    }
                    if (j3D_Geometry19.anyInteract(j3D_Geometry18, d)) {
                        for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                                if (!J3D_Geometry.T2reln((J3D_Geometry)arrayList3.get(n4), (J3D_Geometry)arrayList2.get(n3), d)) continue;
                                String string26 = "54515: outer rings in a composite surface intersect";
                                return J3D_Geometry.valdtnStr(1, 3, arrayList5, String.valueOf(n4 + 1) + "," + String.valueOf(1), string26);
                            }
                        }
                    }
                    if (bl && j3D_Geometry19.onSamePlane(j3D_Geometry18, d)) {
                        for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                                if (!J3D_Geometry.T3reln((J3D_Geometry)arrayList3.get(n4), (J3D_Geometry)arrayList2.get(n3), d)) continue;
                                String string27 = "54516: adjacent outer rings of composite surface cannot be on same plane";
                                return J3D_Geometry.valdtnStr(1, 3, arrayList5, String.valueOf(n4 + 1) + "," + String.valueOf(1), string27);
                            }
                        }
                    }
                    if (!j3D_Geometry19.onSamePlane(j3D_Geometry18, d) || !j3D_Geometry19.overlapArea(j3D_Geometry18, d)) continue;
                    String string28 = "54517: outer ring is on the same plane and overlaps another outer ring";
                    return J3D_Geometry.valdtnStr(2, 3, arrayList5, String.valueOf(1), string28);
                }
            }
            arrayList10 = new ArrayList();
            arrayList9 = new ArrayList();
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList.get(n10);
                J3D_Geometry j3D_Geometry20 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                arrayList10.add(objectArray6);
                dArray = J3D_Geometry.getMBH(j3D_Geometry20);
                arrayList9.add(dArray);
            }
            rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(rTree, arrayList9, arrayList10);
            blArray = new boolean[arrayList.size()];
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                blArray[n10] = false;
            }
            arrayList6 = new ArrayList();
            rTree.anyInteract(rTree, arrayList6);
            for (n10 = 0; n10 < arrayList6.size(); ++n10) {
                j3D_Geometry8 = (RTreeJoinRes)arrayList6.get(n10);
                objectArray4 = new Object[3];
                objectArray3 = new Object[3];
                objectArray4 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr1;
                objectArray3 = (Object[])((RTreeJoinRes)j3D_Geometry8).ptr2;
                j3D_Geometry7 = (J3D_Geometry)objectArray4[0];
                j3D_Geometry6 = (J3D_Geometry)objectArray3[0];
                arrayList5 = new ArrayList();
                arrayList4 = new ArrayList();
                arrayList5 = (ArrayList)objectArray4[1];
                arrayList4 = (ArrayList)objectArray3[1];
                n7 = (Integer)objectArray4[2];
                n6 = (Integer)objectArray3[2];
                if (!j3D_Geometry7.anyInteract(j3D_Geometry6, d)) continue;
                arrayList32 = new ArrayList();
                arrayList31 = new ArrayList();
                arrayList30 = new ArrayList();
                arrayList29 = new ArrayList();
                elementExtractor = new ElementExtractor(j3D_Geometry7, 0, 1, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        arrayList32.add(j3D_Geometry);
                        continue;
                    }
                    arrayList31.add(j3D_Geometry);
                }
                elementExtractor = new ElementExtractor(j3D_Geometry6, 0, 1, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry = elementExtractor.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        arrayList30.add(j3D_Geometry);
                        continue;
                    }
                    arrayList29.add(j3D_Geometry);
                }
                j3D_Geometry19 = (J3D_Geometry)arrayList31.get(0);
                j3D_Geometry18 = (J3D_Geometry)arrayList29.get(0);
                arrayList3 = new ArrayList();
                elementExtractor4 = new ElementExtractor(j3D_Geometry19, 0, 2, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry12 = elementExtractor4.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string29 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr(2, 3, arrayList5, String.valueOf(1), string29);
                    }
                    arrayList3.add(j3D_Geometry12);
                }
                arrayList2 = new ArrayList();
                elementExtractor4 = new ElementExtractor(j3D_Geometry18, 0, 2, 3);
                nArray3[0] = 0;
                while ((j3D_Geometry12 = elementExtractor4.nextElement(nArray3)) != null) {
                    if (nArray3[0] == 2) {
                        String string30 = "54501: no holes expected";
                        return J3D_Geometry.valdtnStr(2, 3, arrayList5, String.valueOf(1), string30);
                    }
                    arrayList2.add(j3D_Geometry12);
                }
                n18 = (Integer)arrayList5.get(3);
                if (n18 == (n23 = ((Integer)arrayList4.get(3)).intValue())) continue;
                for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                    for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                        j3D_Geometry3 = (J3D_Geometry)arrayList3.get(n4);
                        if (!j3D_Geometry3.anyInteract(j3D_Geometry2 = (J3D_Geometry)arrayList2.get(n3), d)) continue;
                        if (J3D_Geometry.T3reln(j3D_Geometry3, j3D_Geometry2, d)) {
                            blArray[n18 - 1] = true;
                            blArray[n23 - 1] = true;
                            double[] dArray4 = new double[3];
                            double[] dArray5 = new double[3];
                            for (int i = 0; i < 3; ++i) {
                                dArray4[i] = j3D_Geometry3.ordinates[i + 3] - j3D_Geometry3.ordinates[i];
                                dArray5[i] = j3D_Geometry2.ordinates[i + 3] - j3D_Geometry2.ordinates[i];
                            }
                            double d2 = J3D_Geometry.dotProduct(dArray4, dArray5);
                            if (!(d2 > 0.0)) continue;
                            String string31 = "54518: shared edge of composite surface not oriented oppositely";
                            return J3D_Geometry.valdtnStr(1, 3, arrayList5, String.valueOf(n4) + "," + String.valueOf(1), string31);
                        }
                        if (!J3D_Geometry.T1reln(j3D_Geometry3, j3D_Geometry2, d)) continue;
                        blArray[n18 - 1] = true;
                        blArray[n23 - 1] = true;
                    }
                }
            }
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                if (blArray[n10]) continue;
                String string32 = "54519: polygon (surface) not attached to composite surface";
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList.get(n10);
                j3D_Geometry12 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                return J3D_Geometry.valdtnStr2(arrayList8, string32);
            }
        }
        if (nArray[0] != 7 && nArray2[0] != 6 && nArray2[0] == 3) {
            int n30;
            int n31;
            objectArray6 = new Object[3];
            objectArray6 = (Object[])arrayList.get(0);
            j3D_Geometry8 = (J3D_Geometry)objectArray6[0];
            arrayList8 = new ArrayList();
            arrayList8 = (ArrayList)objectArray6[1];
            n9 = (Integer)objectArray6[2];
            double[][] dArray6 = new double[4][3];
            int[] nArray5 = new int[3];
            int[] nArray6 = new int[3];
            double[] dArray7 = new double[6];
            double[] dArray8 = new double[6];
            double[] dArray9 = new double[1];
            double[] dArray10 = new double[3];
            double[] dArray11 = new double[3];
            double[] dArray12 = new double[1];
            double[] dArray13 = new double[3];
            double[] dArray14 = new double[]{0.0, 0.0, 0.0};
            object2 = new double[3][2];
            object2 = J3D_Geometry.getMBH(j3D_Geometry8);
            for (n31 = 0; n31 < 3; ++n31) {
                dArray14[n31] = (object2[n31][0] + object2[n31][1]) / 2.0;
            }
            n31 = j3D_Geometry8.getType();
            int n32 = j3D_Geometry8.getSRID();
            objectArray2 = new int[j3D_Geometry8.elemInfo.length];
            objectArray = new double[j3D_Geometry8.ordinates.length];
            for (n30 = 0; n30 < j3D_Geometry8.elemInfo.length; ++n30) {
                objectArray2[n30] = j3D_Geometry8.elemInfo[n30];
            }
            for (n30 = 0; n30 < j3D_Geometry8.ordinates.length / 3; ++n30) {
                objectArray[3 * n30] = j3D_Geometry8.ordinates[3 * n30] - dArray14[0];
                objectArray[3 * n30 + 1] = j3D_Geometry8.ordinates[3 * n30 + 1] - dArray14[1];
                objectArray[3 * n30 + 2] = j3D_Geometry8.ordinates[3 * n30 + 2] - dArray14[2];
            }
            J3D_Geometry j3D_Geometry21 = new J3D_Geometry(n31, n32, (int[])objectArray2, (double[])objectArray);
            J3D_Geometry.planeEquation(dArray10, dArray9, j3D_Geometry21);
            for (n10 = 1; n10 < arrayList.size(); ++n10) {
                int n33;
                objectArray6 = new Object[3];
                objectArray6 = (Object[])arrayList.get(n10);
                J3D_Geometry j3D_Geometry22 = (J3D_Geometry)objectArray6[0];
                arrayList8 = new ArrayList();
                arrayList8 = (ArrayList)objectArray6[1];
                n9 = (Integer)objectArray6[2];
                n31 = j3D_Geometry22.getType();
                n32 = j3D_Geometry22.getSRID();
                objectArray2 = new int[j3D_Geometry22.elemInfo.length];
                objectArray = new double[j3D_Geometry22.ordinates.length];
                for (n33 = 0; n33 < j3D_Geometry22.elemInfo.length; ++n33) {
                    objectArray2[n33] = j3D_Geometry22.elemInfo[n33];
                }
                for (n33 = 0; n33 < j3D_Geometry22.ordinates.length / 3; ++n33) {
                    objectArray[3 * n33] = j3D_Geometry22.ordinates[3 * n33] - dArray14[0];
                    objectArray[3 * n33 + 1] = j3D_Geometry22.ordinates[3 * n33 + 1] - dArray14[1];
                    objectArray[3 * n33 + 2] = j3D_Geometry22.ordinates[3 * n33 + 2] - dArray14[2];
                }
                J3D_Geometry j3D_Geometry23 = new J3D_Geometry(n31, n32, (int[])objectArray2, (double[])objectArray);
                for (n5 = 0; n5 < j3D_Geometry23.ordinates.length / 3; ++n5) {
                    dArray11[0] = j3D_Geometry23.ordinates[3 * n5];
                    dArray11[1] = j3D_Geometry23.ordinates[3 * n5 + 1];
                    dArray11[2] = j3D_Geometry23.ordinates[3 * n5 + 2];
                    double d3 = J3D_Geometry.dotProduct(dArray10, dArray11) + dArray9[0];
                    if (!(d3 > d)) continue;
                    String string33 = "54520: inner ring not on the same plane as its outer ring";
                    return J3D_Geometry.valdtnStr2(arrayList8, string33);
                }
                if (!j3D_Geometry23.PgInTouchoncePg(j3D_Geometry21, d)) {
                    String string34 = "54521: inner ring is not inside or is touching outer ring more than once";
                    return J3D_Geometry.valdtnStr2(arrayList8, string34);
                }
                J3D_Geometry.planeEquation(dArray13, dArray12, j3D_Geometry23);
                if (Math.abs(dArray13[0] + dArray10[0]) > d || Math.abs(dArray13[1] + dArray10[1]) > d || Math.abs(dArray13[2] + dArray10[2]) > d) {
                    String string35 = "13367: wrong orientation for interior/exterior rings";
                    return J3D_Geometry.valdtnStr2(arrayList8, string35);
                }
                for (n5 = 1; n5 < arrayList.size(); ++n5) {
                    int n34;
                    if (n10 == n5) continue;
                    objectArray6 = new Object[3];
                    objectArray6 = (Object[])arrayList.get(n5);
                    J3D_Geometry j3D_Geometry24 = (J3D_Geometry)objectArray6[0];
                    arrayList5 = new ArrayList();
                    arrayList5 = (ArrayList)objectArray6[1];
                    n9 = (Integer)objectArray6[2];
                    n31 = j3D_Geometry24.getType();
                    n32 = j3D_Geometry24.getSRID();
                    objectArray2 = new int[j3D_Geometry24.elemInfo.length];
                    objectArray = new double[j3D_Geometry24.ordinates.length];
                    for (n34 = 0; n34 < j3D_Geometry24.elemInfo.length; ++n34) {
                        objectArray2[n34] = j3D_Geometry24.elemInfo[n34];
                    }
                    for (n34 = 0; n34 < j3D_Geometry24.ordinates.length / 3; ++n34) {
                        objectArray[3 * n34] = j3D_Geometry24.ordinates[3 * n34] - dArray14[0];
                        objectArray[3 * n34 + 1] = j3D_Geometry24.ordinates[3 * n34 + 1] - dArray14[1];
                        objectArray[3 * n34 + 2] = j3D_Geometry24.ordinates[3 * n34 + 2] - dArray14[2];
                    }
                    J3D_Geometry j3D_Geometry25 = new J3D_Geometry(n31, n32, (int[])objectArray2, (double[])objectArray);
                    j3D_Geometry25.elemInfo[1] = 1003;
                    j3D_Geometry23.elemInfo[1] = 1003;
                    if (!j3D_Geometry23.anyInteract(j3D_Geometry25, d)) continue;
                    arrayList3 = new ArrayList();
                    elementExtractor4 = new ElementExtractor(j3D_Geometry25, 0, 2, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry12 = elementExtractor4.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            String string36 = "54501: no holes expected";
                            return J3D_Geometry.valdtnStr(2, 3, arrayList5, String.valueOf(n5 + 1), string36);
                        }
                        arrayList3.add(j3D_Geometry12);
                    }
                    arrayList2 = new ArrayList();
                    elementExtractor4 = new ElementExtractor(j3D_Geometry23, 0, 2, 3);
                    nArray3[0] = 0;
                    while ((j3D_Geometry12 = elementExtractor4.nextElement(nArray3)) != null) {
                        if (nArray3[0] == 2) {
                            String string37 = "54501: no holes expected";
                            return J3D_Geometry.valdtnStr(2, 3, arrayList8, String.valueOf(n10 + 1), string37);
                        }
                        arrayList2.add(j3D_Geometry12);
                    }
                    int n35 = 0;
                    for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                            j3D_Geometry3 = (J3D_Geometry)arrayList3.get(n4);
                            if (!j3D_Geometry3.anyInteract(j3D_Geometry2 = (J3D_Geometry)arrayList2.get(n3), d)) continue;
                            if (J3D_Geometry.T2reln(j3D_Geometry3, j3D_Geometry2, d) || J3D_Geometry.T3reln(j3D_Geometry3, j3D_Geometry2, d) || J3D_Geometry.T4reln(j3D_Geometry3, j3D_Geometry2, d)) {
                                String string38 = "54522: inner rings of same outer ring cannot intersect or share boundary";
                                return J3D_Geometry.valdtnStr(1, 3, arrayList8, String.valueOf(n4) + "," + String.valueOf(n10 + 1), string38);
                            }
                            if (!J3D_Geometry.T1reln(j3D_Geometry3, j3D_Geometry2, d)) continue;
                            ++n35;
                        }
                    }
                    if (n35 > 1) {
                        String string39 = "54523: inner rings of same outer ring cannot touch more than once";
                        return J3D_Geometry.valdtnStr(2, 3, arrayList8, String.valueOf(n10 + 1), string39);
                    }
                    if (n35 != 0) continue;
                    String string40 = "54524: inner ring cannot be inside another inner ring of same outer ring";
                    return J3D_Geometry.valdtnStr(2, 3, arrayList8, String.valueOf(n10 + 1), string40);
                }
            }
        }
        String string41 = "TRUE";
        stringBuilder.append(string41);
        return stringBuilder.toString();
    }

    private boolean overlapArea(J3D_Geometry j3D_Geometry, double d) throws Exception {
        J3D_Geometry j3D_Geometry2;
        Object object;
        int n;
        int n2;
        J3D_Geometry j3D_Geometry3;
        J3D_Geometry j3D_Geometry4;
        int[] nArray = new int[1];
        ArrayList<double[][]> arrayList = new ArrayList<double[][]>();
        ArrayList<double[][]> arrayList2 = new ArrayList<double[][]>();
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList4 = new ArrayList<J3D_Geometry>();
        ArrayList arrayList5 = new ArrayList();
        ElementExtractor elementExtractor = new ElementExtractor(this, 0, 2, 3);
        nArray[0] = 0;
        ArrayList<J3D_Geometry> arrayList6 = new ArrayList<J3D_Geometry>();
        while ((j3D_Geometry4 = elementExtractor.nextElement(nArray)) != null) {
            arrayList6.add(j3D_Geometry4);
        }
        ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry, 0, 2, 3);
        nArray[0] = 0;
        ArrayList<J3D_Geometry> arrayList7 = new ArrayList<J3D_Geometry>();
        while ((j3D_Geometry3 = elementExtractor2.nextElement(nArray)) != null) {
            arrayList7.add(j3D_Geometry3);
        }
        for (n2 = 0; n2 < arrayList6.size(); ++n2) {
            for (n = 0; n < arrayList7.size(); ++n) {
                J3D_Geometry j3D_Geometry5;
                J3D_Geometry j3D_Geometry6 = (J3D_Geometry)arrayList6.get(n2);
                if (!J3D_Geometry.T2reln(j3D_Geometry6, j3D_Geometry5 = (J3D_Geometry)arrayList7.get(n), d)) continue;
                return true;
            }
        }
        for (n2 = 0; n2 < j3D_Geometry.ordinates.length / 3 - 1; ++n2) {
            double[] dArray = new double[]{j3D_Geometry.ordinates[3 * n2], j3D_Geometry.ordinates[3 * n2 + 1], j3D_Geometry.ordinates[3 * n2 + 2]};
            int[] nArray2 = new int[]{1, 1, 1};
            J3D_Geometry j3D_Geometry7 = new J3D_Geometry(1, 0, nArray2, dArray);
            arrayList2.add(J3D_Geometry.getMBH(j3D_Geometry7));
            arrayList4.add(j3D_Geometry7);
            if (!j3D_Geometry7.pointInPolygon(this, d) || this.pointBoundaryIntersect(j3D_Geometry7, d)) continue;
            return true;
        }
        for (n = 0; n < this.ordinates.length / 3 - 1; ++n) {
            double[] dArray = new double[]{this.ordinates[3 * n], this.ordinates[3 * n + 1], this.ordinates[3 * n + 2]};
            int[] nArray3 = new int[]{1, 1, 1};
            J3D_Geometry j3D_Geometry8 = new J3D_Geometry(1, 0, nArray3, dArray);
            arrayList.add(J3D_Geometry.getMBH(j3D_Geometry8));
            arrayList3.add(j3D_Geometry8);
            if (!j3D_Geometry8.pointInPolygon(j3D_Geometry, d) || j3D_Geometry.pointBoundaryIntersect(j3D_Geometry8, d)) continue;
            return true;
        }
        ArrayList<RTree> arrayList8 = new ArrayList<RTree>();
        for (n2 = 0; n2 < arrayList6.size(); ++n2) {
            J3D_Geometry j3D_Geometry9 = (J3D_Geometry)arrayList6.get(n2);
            double[] dArray = new double[]{(j3D_Geometry9.ordinates[0] + j3D_Geometry9.ordinates[3]) / 2.0, (j3D_Geometry9.ordinates[1] + j3D_Geometry9.ordinates[4]) / 2.0, (j3D_Geometry9.ordinates[2] + j3D_Geometry9.ordinates[5]) / 2.0};
            int[] nArray4 = new int[]{1, 1, 1};
            object = new J3D_Geometry(1, 0, nArray4, dArray);
            arrayList8.add((RTree)object);
        }
        ArrayList<RTree> arrayList9 = new ArrayList<RTree>();
        for (n = 0; n < arrayList7.size(); ++n) {
            J3D_Geometry j3D_Geometry10 = (J3D_Geometry)arrayList7.get(n);
            double[] dArray = new double[]{(j3D_Geometry10.ordinates[0] + j3D_Geometry10.ordinates[3]) / 2.0, (j3D_Geometry10.ordinates[1] + j3D_Geometry10.ordinates[4]) / 2.0, (j3D_Geometry10.ordinates[2] + j3D_Geometry10.ordinates[5]) / 2.0};
            int[] nArray5 = new int[]{1, 1, 1};
            object = new J3D_Geometry(1, 0, nArray5, dArray);
            arrayList9.add((RTree)object);
        }
        for (n2 = 0; n2 < arrayList9.size(); ++n2) {
            j3D_Geometry2 = (J3D_Geometry)arrayList9.get(n2);
            if (!j3D_Geometry2.pointInPolygon(this, d) || this.pointBoundaryIntersect(j3D_Geometry2, d)) continue;
            return true;
        }
        for (n = 0; n < arrayList8.size(); ++n) {
            j3D_Geometry2 = (J3D_Geometry)arrayList8.get(n);
            if (!j3D_Geometry2.pointInPolygon(j3D_Geometry, d) || j3D_Geometry.pointBoundaryIntersect(j3D_Geometry2, d)) continue;
            return true;
        }
        if (this.ordinates.length == j3D_Geometry.ordinates.length) {
            object = new RTree(3, 8, 2, d);
            RTree rTree = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree(object, arrayList, arrayList3);
            J3D_Geometry.createRTree(rTree, arrayList2, arrayList4);
            object.anyInteract(rTree, arrayList5);
            double d2 = 1.0E-15;
            if (arrayList5.size() == this.ordinates.length / 3 - 1) {
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                double[] dArray3 = new double[3];
                double[] dArray4 = new double[3];
                J3D_Geometry.planeEquation(dArray3, dArray, this);
                J3D_Geometry.planeEquation(dArray4, dArray2, j3D_Geometry);
                if (Math.abs(dArray3[0] + dArray4[0]) <= d2 && Math.abs(dArray3[1] + dArray4[1]) <= d2 && Math.abs(dArray3[2] + dArray4[2]) <= d2) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean onSamePlane(J3D_Geometry j3D_Geometry, double d) throws Exception {
        boolean bl = true;
        double[] dArray = new double[1];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double d2 = 0.0;
        J3D_Geometry.planeEquation(dArray2, dArray, j3D_Geometry);
        for (int i = 0; i < this.ordinates.length / 3; ++i) {
            dArray3[0] = this.ordinates[3 * i];
            dArray3[1] = this.ordinates[3 * i + 1];
            dArray3[2] = this.ordinates[3 * i + 2];
            d2 = J3D_Geometry.dotProduct(dArray2, dArray3) + dArray[0];
            if (!(Math.abs(d2) > d)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean solidClosedness(ArrayList arrayList, ArrayList arrayList2, double d) throws Exception {
        int n;
        int n2;
        ArrayList<Integer> arrayList3;
        Object[] objectArray;
        int n3;
        ArrayList arrayList4;
        J3D_Geometry j3D_Geometry;
        Object[] objectArray2;
        int n4;
        int[] nArray = new int[3];
        double[][] dArray = new double[3][2];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Object[]> arrayList5 = new ArrayList<Object[]>();
        ArrayList<double[][]> arrayList6 = new ArrayList<double[][]>();
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            J3D_Geometry j3D_Geometry2;
            objectArray2 = new Object[3];
            objectArray2 = (Object[])arrayList.get(n4);
            j3D_Geometry = (J3D_Geometry)objectArray2[0];
            arrayList4 = new ArrayList();
            arrayList4 = (ArrayList)objectArray2[1];
            n3 = (Integer)objectArray2[2];
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 2, 3);
            nArray[0] = 0;
            n5 = 0;
            while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    return false;
                }
                if (n3 == 2) {
                    ++n5;
                    objectArray = new Object[4];
                    objectArray[0] = j3D_Geometry2;
                    arrayList3 = new ArrayList<Integer>();
                    for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                        arrayList3.add((Integer)arrayList4.get(n2));
                    }
                    arrayList3.set(2, 1);
                    arrayList3.set(1, n5);
                    objectArray[1] = arrayList3;
                    objectArray[2] = 0;
                    objectArray[3] = 2;
                    arrayList5.add(objectArray);
                    dArray = J3D_Geometry.getMBH(j3D_Geometry2);
                    arrayList6.add(dArray);
                    continue;
                }
                ++n5;
                objectArray = new Object[4];
                objectArray[0] = j3D_Geometry2;
                arrayList3 = new ArrayList();
                for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                    arrayList3.add((Integer)arrayList4.get(n2));
                }
                arrayList3.set(2, 1);
                arrayList3.set(1, n5);
                objectArray[1] = arrayList3;
                objectArray[2] = 0;
                objectArray[3] = 1;
                arrayList5.add(objectArray);
                dArray = J3D_Geometry.getMBH(j3D_Geometry2);
                arrayList6.add(dArray);
            }
        }
        RTree rTree = new RTree(3, 8, 2, d);
        J3D_Geometry.createRTree2(rTree, arrayList6, arrayList5);
        ArrayList arrayList7 = new ArrayList();
        rTree.anyInteract(rTree, arrayList7);
        for (int i = 0; i < arrayList7.size(); ++i) {
            int n6;
            RTreeJoinRes rTreeJoinRes = (RTreeJoinRes)arrayList7.get(i);
            Object[] objectArray3 = new Object[4];
            Object[] objectArray4 = new Object[4];
            objectArray3 = (Object[])rTreeJoinRes.ptr1;
            objectArray4 = (Object[])rTreeJoinRes.ptr2;
            J3D_Geometry j3D_Geometry3 = (J3D_Geometry)objectArray3[0];
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)objectArray4[0];
            ArrayList arrayList8 = new ArrayList();
            ArrayList arrayList9 = new ArrayList();
            arrayList8 = (ArrayList)objectArray3[1];
            arrayList9 = (ArrayList)objectArray4[1];
            int n7 = (Integer)objectArray3[2];
            int n8 = (Integer)objectArray4[2];
            int n9 = (Integer)objectArray3[3];
            int n10 = (Integer)objectArray4[3];
            int n11 = (Integer)arrayList8.get(3);
            if (n11 == (n6 = ((Integer)arrayList9.get(3)).intValue()) || !(j3D_Geometry3.distance(j3D_Geometry4, d) < d) || !J3D_Geometry.T3reln(j3D_Geometry3, j3D_Geometry4, d)) continue;
            for (n4 = 0; n4 < 3; ++n4) {
                dArray2[n4] = j3D_Geometry3.ordinates[n4 + 3] - j3D_Geometry3.ordinates[n4];
                dArray3[n4] = j3D_Geometry4.ordinates[n4 + 3] - j3D_Geometry4.ordinates[n4];
            }
            if (J3D_Geometry.dotProduct(dArray2, dArray3) > 0.0) {
                for (n2 = 0; n2 < arrayList8.size(); ++n2) {
                    arrayList2.add(Integer.valueOf((Integer)arrayList8.get(n2)));
                }
                return false;
            }
            ++n7;
            ++n8;
            for (n4 = 0; n4 < arrayList5.size(); ++n4) {
                objectArray2 = new Object[4];
                objectArray2 = (Object[])arrayList5.get(n4);
                j3D_Geometry = (J3D_Geometry)objectArray2[0];
                arrayList4 = new ArrayList();
                arrayList4 = (ArrayList)objectArray2[1];
                arrayList3 = new ArrayList();
                for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                    arrayList3.add((Integer)arrayList4.get(n2));
                }
                n = (Integer)objectArray2[2];
                n3 = (Integer)objectArray2[3];
                bl = true;
                if (arrayList8.size() != arrayList4.size()) {
                    return false;
                }
                for (n2 = 0; n2 < arrayList8.size(); ++n2) {
                    if (((Integer)arrayList8.get(n2)).intValue() == ((Integer)arrayList4.get(n2)).intValue()) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    objectArray = new Object[]{j3D_Geometry3, arrayList8, n7, n9};
                    arrayList5.set(n4, objectArray);
                }
                bl2 = true;
                if (arrayList9.size() != arrayList4.size()) {
                    return false;
                }
                for (n2 = 0; n2 < arrayList9.size(); ++n2) {
                    if (((Integer)arrayList9.get(n2)).intValue() == ((Integer)arrayList4.get(n2)).intValue()) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                objectArray = new Object[]{j3D_Geometry4, arrayList9, n8, n10};
                arrayList5.set(n4, objectArray);
            }
        }
        for (n4 = 0; n4 < arrayList5.size(); ++n4) {
            objectArray2 = new Object[4];
            objectArray2 = (Object[])arrayList5.get(n4);
            j3D_Geometry = (J3D_Geometry)objectArray2[0];
            arrayList4 = new ArrayList();
            arrayList4 = (ArrayList)objectArray2[1];
            n = (Integer)objectArray2[2];
            n3 = (Integer)objectArray2[3];
            if (n == 1) continue;
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                arrayList2.add(Integer.valueOf((Integer)arrayList4.get(n2)));
            }
            return false;
        }
        return true;
    }

    private boolean polygonDuplicateNode(int[] nArray, double d) throws Exception {
        int n = this.ordinates.length / 3;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (int i = 0; i < n - 1; ++i) {
            dArray[0] = this.ordinates[3 * i];
            dArray[1] = this.ordinates[3 * i + 1];
            dArray[2] = this.ordinates[3 * i + 2];
            dArray2[0] = this.ordinates[3 * i + 3];
            dArray2[1] = this.ordinates[3 * i + 4];
            dArray2[2] = this.ordinates[3 * i + 5];
            double d2 = Math.sqrt((dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray[2] - dArray2[2]));
            if (!(d2 < d)) continue;
            nArray[0] = i + 1;
            return true;
        }
        return false;
    }

    private boolean polygonFlatness(int[] nArray, double d) throws Exception {
        int n;
        int n2;
        double[][] dArray = new double[4][3];
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[]{0.0, 0.0, 0.0};
        double[][] dArray8 = new double[3][2];
        dArray8 = J3D_Geometry.getMBH(this);
        for (n2 = 0; n2 < 3; ++n2) {
            dArray7[n2] = (dArray8[n2][0] + dArray8[n2][1]) / 2.0;
        }
        int n3 = this.getType();
        int n4 = this.getSRID();
        int[] nArray4 = new int[this.elemInfo.length];
        double[] dArray9 = new double[this.ordinates.length];
        for (n = 0; n < this.elemInfo.length; ++n) {
            nArray4[n] = this.elemInfo[n];
        }
        for (n = 0; n < this.ordinates.length / 3; ++n) {
            dArray9[3 * n] = this.ordinates[3 * n] - dArray7[0];
            dArray9[3 * n + 1] = this.ordinates[3 * n + 1] - dArray7[1];
            dArray9[3 * n + 2] = this.ordinates[3 * n + 2] - dArray7[2];
        }
        J3D_Geometry j3D_Geometry = new J3D_Geometry(n3, n4, nArray4, dArray9);
        int n5 = j3D_Geometry.ordinates.length / 3 - 1;
        int n6 = n5 % 2 == 0 ? n5 / 2 : (n5 + 1) / 2;
        for (n = 0; n < 3; ++n) {
            dArray[0][n] = j3D_Geometry.ordinates[n];
        }
        for (n = 0; n < 3; ++n) {
            dArray[1][n] = j3D_Geometry.ordinates[3 * n6 + n];
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (n2 == 0 || n2 == n6) continue;
            if (n2 > n6) {
                for (n = 0; n < 3; ++n) {
                    dArray[2][n] = j3D_Geometry.ordinates[3 * n2 + n];
                }
            } else {
                for (n = 0; n < 3; ++n) {
                    dArray[1][n] = j3D_Geometry.ordinates[3 * n2 + n];
                    dArray[2][n] = j3D_Geometry.ordinates[3 * n6 + n];
                }
            }
            dArray2[0] = dArray[0][0];
            dArray2[1] = dArray[0][1];
            dArray2[2] = dArray[0][2];
            dArray2[3] = dArray[1][0];
            dArray2[4] = dArray[1][1];
            dArray2[5] = dArray[1][2];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray2[2] = 1;
            J3D_Geometry j3D_Geometry2 = new J3D_Geometry(2, 0, nArray2, dArray2);
            dArray3[0] = dArray[1][0];
            dArray3[1] = dArray[1][1];
            dArray3[2] = dArray[1][2];
            dArray3[3] = dArray[2][0];
            dArray3[4] = dArray[2][1];
            dArray3[5] = dArray[2][2];
            nArray3[0] = 1;
            nArray3[1] = 2;
            nArray3[2] = 1;
            J3D_Geometry j3D_Geometry3 = new J3D_Geometry(2, 0, nArray3, dArray3);
            if (!J3D_Geometry.parallel(j3D_Geometry2, j3D_Geometry3, d)) break;
        }
        for (n = 0; n < 3; ++n) {
            dArray[3][n] = dArray[0][n];
        }
        J3D_Geometry.planeEquation(dArray5, dArray4, dArray);
        for (n = 0; n < j3D_Geometry.ordinates.length / 3; ++n) {
            dArray6[0] = j3D_Geometry.ordinates[3 * n];
            dArray6[1] = j3D_Geometry.ordinates[3 * n + 1];
            dArray6[2] = j3D_Geometry.ordinates[3 * n + 2];
            double d2 = J3D_Geometry.dotProduct(dArray5, dArray6) + dArray4[0];
            if (!(Math.abs(d2) > d)) continue;
            nArray[0] = n == 0 ? n + 1 : n;
            return false;
        }
        return true;
    }

    private boolean polygonClosedness(double d) throws Exception {
        int n = this.ordinates.length;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = this.ordinates[0];
        dArray[1] = this.ordinates[1];
        dArray[2] = this.ordinates[2];
        dArray2[0] = this.ordinates[n - 3];
        dArray2[1] = this.ordinates[n - 2];
        dArray2[2] = this.ordinates[n - 1];
        double d2 = Math.sqrt((dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray[2] - dArray2[2]));
        return !(d2 > d);
    }

    private boolean polygonSelfIntersection(int[] nArray, double d) throws Exception {
        int n;
        int n2;
        J3D_Geometry j3D_Geometry;
        Object[] objectArray;
        int n3;
        int n4;
        J3D_Geometry j3D_Geometry2;
        Object[] objectArray2;
        int n5;
        int n6;
        J3D_Geometry j3D_Geometry3;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int[] nArray2 = new int[1];
        int n7 = 0;
        ElementExtractor elementExtractor = new ElementExtractor(this, 0, 2, 3);
        nArray2[0] = 0;
        while ((j3D_Geometry3 = elementExtractor.nextElement(nArray2)) != null) {
            if (nArray2[0] == 2) {
                nArray[0] = n7++;
                return true;
            }
            Object[] objectArray3 = new Object[]{j3D_Geometry3, ++n7, 1};
            arrayList.add(objectArray3);
        }
        for (n6 = 0; n6 < arrayList.size(); ++n6) {
            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                if (n6 == n5) continue;
                objectArray2 = new Object[3];
                objectArray2 = (Object[])arrayList.get(n6);
                j3D_Geometry2 = (J3D_Geometry)objectArray2[0];
                n4 = (Integer)objectArray2[1];
                n3 = (Integer)objectArray2[2];
                objectArray = new Object[3];
                objectArray = (Object[])arrayList.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray[0];
                n2 = (Integer)objectArray[1];
                n = (Integer)objectArray[2];
                if (!(j3D_Geometry2.distance(j3D_Geometry, d) < d) || !J3D_Geometry.T2reln(j3D_Geometry2, j3D_Geometry, d) && !J3D_Geometry.T3reln(j3D_Geometry2, j3D_Geometry, d) && !J3D_Geometry.T4reln(j3D_Geometry2, j3D_Geometry, d)) continue;
                nArray[0] = n4;
                return true;
            }
        }
        for (n6 = 0; n6 < arrayList.size(); ++n6) {
            for (n5 = n6 + 2; n5 < arrayList.size(); ++n5) {
                if (n6 == 0 || n5 == arrayList.size()) continue;
                objectArray2 = new Object[3];
                objectArray2 = (Object[])arrayList.get(n6);
                j3D_Geometry2 = (J3D_Geometry)objectArray2[0];
                n4 = (Integer)objectArray2[1];
                n3 = (Integer)objectArray2[2];
                objectArray = new Object[3];
                objectArray = (Object[])arrayList.get(n5);
                j3D_Geometry = (J3D_Geometry)objectArray[0];
                n2 = (Integer)objectArray[1];
                n = (Integer)objectArray[2];
                if (!(j3D_Geometry2.distance(j3D_Geometry, d) < d) || !J3D_Geometry.T1reln(j3D_Geometry2, j3D_Geometry, d)) continue;
                nArray[0] = n4;
                return true;
            }
        }
        return false;
    }

    private boolean PgInTouchoncePg(J3D_Geometry j3D_Geometry, double d) throws Exception {
        J3D_Geometry j3D_Geometry2;
        double[][] dArray = new double[3][2];
        double[][] dArray2 = new double[3][2];
        dArray = J3D_Geometry.getMBH(this);
        if (!this.ImbhAB(dArray, dArray2 = J3D_Geometry.getMBH(j3D_Geometry), d)) {
            return false;
        }
        int n = this.ordinates.length / 3 - 1;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(this, 0, 2, 3);
        nArray[0] = 0;
        while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
            arrayList.add(j3D_Geometry2);
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            J3D_Geometry j3D_Geometry3;
            J3D_Geometry j3D_Geometry4;
            J3D_Geometry j3D_Geometry5;
            J3D_Geometry j3D_Geometry6 = (J3D_Geometry)arrayList.get(i);
            double[] dArray3 = new double[]{j3D_Geometry6.ordinates[0], j3D_Geometry6.ordinates[1], j3D_Geometry6.ordinates[2]};
            int n4 = j3D_Geometry.ordinates.length / 3 - 1;
            int[] nArray2 = new int[1];
            ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
            ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry, 0, 2, 3);
            nArray[0] = 0;
            while ((j3D_Geometry5 = elementExtractor2.nextElement(nArray2)) != null) {
                arrayList2.add(j3D_Geometry5);
            }
            n3 = 0;
            for (int j = 0; j < n4; ++j) {
                j3D_Geometry4 = (J3D_Geometry)arrayList.get(i);
                if (J3D_Geometry.T2reln(j3D_Geometry4, j3D_Geometry3 = (J3D_Geometry)arrayList2.get(j), d) || J3D_Geometry.T3reln(j3D_Geometry4, j3D_Geometry3, d) || J3D_Geometry.T4reln(j3D_Geometry4, j3D_Geometry3, d)) {
                    return false;
                }
                if (J3D_Geometry.T1reln(j3D_Geometry4, j3D_Geometry3, d)) {
                    ++n3;
                }
                if (n3 <= 2) continue;
                return false;
            }
            if ((n2 += n3) > 4) {
                return false;
            }
            int[] nArray3 = new int[]{1, 1, 1};
            j3D_Geometry4 = new J3D_Geometry(1, 0, nArray3, dArray3);
            j3D_Geometry3 = new J3D_Geometry(1, 0, new int[]{1, 1, 1}, new double[]{j3D_Geometry6.ordinates[3], j3D_Geometry6.ordinates[4], j3D_Geometry6.ordinates[5]});
            if (j3D_Geometry4.pointInPolygon(j3D_Geometry, d) || j3D_Geometry3.pointInPolygon(j3D_Geometry, d)) continue;
            return false;
        }
        return true;
    }

    private static boolean parallel(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) throws Exception {
        boolean bl = false;
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, j3D_Geometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.ordinates[0], j3D_Geometry.ordinates[1], j3D_Geometry.ordinates[2]});
        J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, j3D_Geometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.ordinates[3], j3D_Geometry.ordinates[4], j3D_Geometry.ordinates[5]});
        J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, j3D_Geometry2.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry2.ordinates[0], j3D_Geometry2.ordinates[1], j3D_Geometry2.ordinates[2]});
        J3D_Geometry j3D_Geometry6 = new J3D_Geometry(1, j3D_Geometry2.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry2.ordinates[3], j3D_Geometry2.ordinates[4], j3D_Geometry2.ordinates[5]});
        return j3D_Geometry3.pointLinePerpendicularDistance(j3D_Geometry2, d) < d && j3D_Geometry4.pointLinePerpendicularDistance(j3D_Geometry2, d) < d || j3D_Geometry5.pointLinePerpendicularDistance(j3D_Geometry, d) < d && j3D_Geometry6.pointLinePerpendicularDistance(j3D_Geometry, d) < d;
    }

    private double pointLinePerpendicularDistance(J3D_Geometry j3D_Geometry, double d) throws Exception {
        int n = 0;
        int n2 = 3;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        J3D_Geometry j3D_Geometry2 = new J3D_Geometry(1, j3D_Geometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.ordinates[0], j3D_Geometry.ordinates[1], j3D_Geometry.ordinates[2]});
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, j3D_Geometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.ordinates[3], j3D_Geometry.ordinates[4], j3D_Geometry.ordinates[5]});
        for (n = 0; n < n2; ++n) {
            dArray[n] = this.getOrdinatesArray()[n] - j3D_Geometry2.getOrdinatesArray()[n];
            dArray2[n] = j3D_Geometry3.getOrdinatesArray()[n] - j3D_Geometry2.getOrdinatesArray()[n];
        }
        double d2 = J3D_Geometry.dotProduct(dArray2, dArray);
        double d3 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        if (Math.abs(d3 - 1.0) > 1.0E-15) {
            d2 /= J3D_Geometry.dotProduct(dArray2, dArray2);
        }
        for (n = 0; n < n2; ++n) {
            dArray3[n] = j3D_Geometry2.getOrdinatesArray()[n] + d2 * dArray2[n];
        }
        J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, j3D_Geometry.getSRID(), new int[]{1, 1, 1}, dArray3);
        return this.distance(j3D_Geometry4, d);
    }

    private static boolean T1reln(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) throws Exception {
        if (j3D_Geometry.anyInteract(j3D_Geometry2, d)) {
            int[] nArray = new int[3];
            double[] dArray = new double[3];
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            dArray[0] = j3D_Geometry.ordinates[0];
            dArray[1] = j3D_Geometry.ordinates[1];
            dArray[2] = j3D_Geometry.ordinates[2];
            J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, 0, nArray, dArray);
            int[] nArray2 = new int[3];
            double[] dArray2 = new double[3];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            dArray2[0] = j3D_Geometry.ordinates[3];
            dArray2[1] = j3D_Geometry.ordinates[4];
            dArray2[2] = j3D_Geometry.ordinates[5];
            J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, 0, nArray2, dArray2);
            int[] nArray3 = new int[3];
            double[] dArray3 = new double[3];
            nArray3[0] = 1;
            nArray3[1] = 1;
            nArray3[2] = 1;
            dArray3[0] = j3D_Geometry2.ordinates[0];
            dArray3[1] = j3D_Geometry2.ordinates[1];
            dArray3[2] = j3D_Geometry2.ordinates[2];
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, 0, nArray3, dArray3);
            int[] nArray4 = new int[3];
            double[] dArray4 = new double[3];
            nArray4[0] = 1;
            nArray4[1] = 1;
            nArray4[2] = 1;
            dArray4[0] = j3D_Geometry2.ordinates[3];
            dArray4[1] = j3D_Geometry2.ordinates[4];
            dArray4[2] = j3D_Geometry2.ordinates[5];
            J3D_Geometry j3D_Geometry6 = new J3D_Geometry(1, 0, nArray4, dArray4);
            int n = 0;
            if (j3D_Geometry3.distance(j3D_Geometry2, d) < d) {
                ++n;
            }
            if (j3D_Geometry4.distance(j3D_Geometry2, d) < d) {
                ++n;
            }
            if (j3D_Geometry5.distance(j3D_Geometry, d) < d) {
                ++n;
            }
            if (j3D_Geometry6.distance(j3D_Geometry, d) < d) {
                ++n;
            }
            if (n == 2) {
                if (j3D_Geometry3.distance(j3D_Geometry5, d) < d || j3D_Geometry3.distance(j3D_Geometry6, d) < d) {
                    return true;
                }
                return j3D_Geometry4.distance(j3D_Geometry5, d) < d || j3D_Geometry4.distance(j3D_Geometry6, d) < d;
            }
            return false;
        }
        return false;
    }

    private static boolean T2reln(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) throws Exception {
        int[] nArray = new int[3];
        double[] dArray = new double[3];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        dArray[0] = j3D_Geometry.ordinates[0];
        dArray[1] = j3D_Geometry.ordinates[1];
        dArray[2] = j3D_Geometry.ordinates[2];
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, 0, nArray, dArray);
        int[] nArray2 = new int[3];
        double[] dArray2 = new double[3];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[2] = 1;
        dArray2[0] = j3D_Geometry.ordinates[3];
        dArray2[1] = j3D_Geometry.ordinates[4];
        dArray2[2] = j3D_Geometry.ordinates[5];
        J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, 0, nArray2, dArray2);
        int[] nArray3 = new int[3];
        double[] dArray3 = new double[3];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[2] = 1;
        dArray3[0] = j3D_Geometry2.ordinates[0];
        dArray3[1] = j3D_Geometry2.ordinates[1];
        dArray3[2] = j3D_Geometry2.ordinates[2];
        J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, 0, nArray3, dArray3);
        int[] nArray4 = new int[3];
        double[] dArray4 = new double[3];
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[2] = 1;
        dArray4[0] = j3D_Geometry2.ordinates[3];
        dArray4[1] = j3D_Geometry2.ordinates[4];
        dArray4[2] = j3D_Geometry2.ordinates[5];
        J3D_Geometry j3D_Geometry6 = new J3D_Geometry(1, 0, nArray4, dArray4);
        return j3D_Geometry.anyInteract(j3D_Geometry2, d) && j3D_Geometry3.distance(j3D_Geometry2, d) > d && j3D_Geometry4.distance(j3D_Geometry2, d) > d && j3D_Geometry5.distance(j3D_Geometry, d) > d && j3D_Geometry6.distance(j3D_Geometry, d) > d;
    }

    private static boolean T3reln(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) throws Exception {
        if (j3D_Geometry.anyInteract(j3D_Geometry2, d) && J3D_Geometry.parallel(j3D_Geometry, j3D_Geometry2, d)) {
            int[] nArray = new int[3];
            double[] dArray = new double[3];
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            dArray[0] = j3D_Geometry.ordinates[0];
            dArray[1] = j3D_Geometry.ordinates[1];
            dArray[2] = j3D_Geometry.ordinates[2];
            J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, 0, nArray, dArray);
            int[] nArray2 = new int[3];
            double[] dArray2 = new double[3];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            dArray2[0] = j3D_Geometry.ordinates[3];
            dArray2[1] = j3D_Geometry.ordinates[4];
            dArray2[2] = j3D_Geometry.ordinates[5];
            J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, 0, nArray2, dArray2);
            int[] nArray3 = new int[3];
            double[] dArray3 = new double[3];
            nArray3[0] = 1;
            nArray3[1] = 1;
            nArray3[2] = 1;
            dArray3[0] = j3D_Geometry2.ordinates[0];
            dArray3[1] = j3D_Geometry2.ordinates[1];
            dArray3[2] = j3D_Geometry2.ordinates[2];
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, 0, nArray3, dArray3);
            int[] nArray4 = new int[3];
            double[] dArray4 = new double[3];
            nArray4[0] = 1;
            nArray4[1] = 1;
            nArray4[2] = 1;
            dArray4[0] = j3D_Geometry2.ordinates[3];
            dArray4[1] = j3D_Geometry2.ordinates[4];
            dArray4[2] = j3D_Geometry2.ordinates[5];
            J3D_Geometry j3D_Geometry6 = new J3D_Geometry(1, 0, nArray4, dArray4);
            int n = 0;
            if (j3D_Geometry3.distance(j3D_Geometry2, d) < d) {
                ++n;
            }
            if (j3D_Geometry4.distance(j3D_Geometry2, d) < d) {
                ++n;
            }
            if (j3D_Geometry5.distance(j3D_Geometry, d) < d) {
                ++n;
            }
            if (j3D_Geometry6.distance(j3D_Geometry, d) < d) {
                ++n;
            }
            if (n >= 2) {
                return !J3D_Geometry.T1reln(j3D_Geometry, j3D_Geometry2, d);
            }
            return false;
        }
        return false;
    }

    private static boolean T4reln(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) throws Exception {
        int[] nArray = new int[3];
        double[] dArray = new double[3];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        dArray[0] = j3D_Geometry.ordinates[0];
        dArray[1] = j3D_Geometry.ordinates[1];
        dArray[2] = j3D_Geometry.ordinates[2];
        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, 0, nArray, dArray);
        int[] nArray2 = new int[3];
        double[] dArray2 = new double[3];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[2] = 1;
        dArray2[0] = j3D_Geometry.ordinates[3];
        dArray2[1] = j3D_Geometry.ordinates[4];
        dArray2[2] = j3D_Geometry.ordinates[5];
        J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, 0, nArray2, dArray2);
        int[] nArray3 = new int[3];
        double[] dArray3 = new double[3];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[2] = 1;
        dArray3[0] = j3D_Geometry2.ordinates[0];
        dArray3[1] = j3D_Geometry2.ordinates[1];
        dArray3[2] = j3D_Geometry2.ordinates[2];
        J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, 0, nArray3, dArray3);
        int[] nArray4 = new int[3];
        double[] dArray4 = new double[3];
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[2] = 1;
        dArray4[0] = j3D_Geometry2.ordinates[3];
        dArray4[1] = j3D_Geometry2.ordinates[4];
        dArray4[2] = j3D_Geometry2.ordinates[5];
        J3D_Geometry j3D_Geometry6 = new J3D_Geometry(1, 0, nArray4, dArray4);
        int n = 0;
        if (j3D_Geometry3.distance(j3D_Geometry2, d) < d) {
            ++n;
        }
        if (j3D_Geometry4.distance(j3D_Geometry2, d) < d) {
            ++n;
        }
        if (j3D_Geometry5.distance(j3D_Geometry, d) < d) {
            ++n;
        }
        if (j3D_Geometry6.distance(j3D_Geometry, d) < d) {
            ++n;
        }
        return j3D_Geometry.anyInteract(j3D_Geometry2, d) && n == 1;
    }

    public double volume(double d) throws Exception {
        String string = "FALSE";
        double d2 = 6378137.0;
        double d3 = 0.003352810664747;
        double d4 = 1.0;
        return this.volume(d, string, d2, d3, d4);
    }

    public double volume(double d, String string, double d2, double d3, double d4) throws Exception {
        int n;
        Object object;
        Cloneable cloneable;
        Object object2;
        double d5 = 0.0;
        int[] nArray = new int[1];
        boolean[] blArray = new boolean[2];
        boolean[] blArray2 = new boolean[2];
        boolean[] blArray3 = new boolean[2];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        int[] nArray2 = new int[this.elemInfo.length];
        System.arraycopy(this.elemInfo, 0, nArray2, 0, this.elemInfo.length);
        double[] dArray = new double[this.ordinates.length];
        System.arraycopy(this.ordinates, 0, dArray, 0, this.ordinates.length);
        int n2 = this.getSRID();
        J3D_Geometry j3D_Geometry = new J3D_Geometry(this.getType(), n2, nArray2, dArray);
        if (string.equals("TRUE")) {
            int n3;
            if (d < 0.05) {
                d = 0.05;
            }
            if (((double[])(object2 = this.getMBR())).length != 6) {
                throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
            }
            cloneable = null;
            int[] nArray3 = null;
            object = null;
            if (this.getElemInfo() == null) {
                nArray3 = new int[]{1, 1, 1};
                object = new double[]{this.getPoint()[0], this.getPoint()[1]};
                cloneable = new JGeometry(this.getType(), this.getSRID(), nArray3, (double[])object);
            } else {
                nArray3 = new int[this.getElemInfo().length];
                for (n3 = 0; n3 < this.getElemInfo().length; ++n3) {
                    nArray3[n3] = this.getElemInfo()[n3];
                }
                object = new double[2 * (this.getOrdinatesArray().length / 3)];
                for (n3 = 0; n3 < this.getOrdinatesArray().length / 3; ++n3) {
                    object[2 * n3] = this.getOrdinatesArray()[3 * n3];
                    object[2 * n3 + 1] = this.getOrdinatesArray()[3 * n3 + 1];
                }
                cloneable = new JGeometry(this.getType(), this.getSRID(), nArray3, (double[])object);
            }
            cloneable = ((JGeometry)cloneable).projectToLTP(d2, d3);
            for (n3 = 0; n3 < j3D_Geometry.getOrdinatesArray().length / 3; ++n3) {
                j3D_Geometry.getOrdinatesArray()[3 * n3] = ((JGeometry)cloneable).getOrdinatesArray()[2 * n3];
                j3D_Geometry.getOrdinatesArray()[3 * n3 + 1] = ((JGeometry)cloneable).getOrdinatesArray()[2 * n3 + 1];
                j3D_Geometry.getOrdinatesArray()[3 * n3 + 2] = d4 * j3D_Geometry.getOrdinatesArray()[3 * n3 + 2];
            }
        }
        if (j3D_Geometry.gtype == 9 || j3D_Geometry.gtype == 7 || j3D_Geometry.gtype == 6 || j3D_Geometry.elemInfo[1] % 1000 == 2 && j3D_Geometry.ordinates.length != 6 || j3D_Geometry.gtype == 5 || j3D_Geometry.elemInfo[1] % 1000 == 8 || j3D_Geometry.elemInfo[1] % 1000 == 6 || j3D_Geometry.gtype == 4) {
            object2 = new ElementExtractor(j3D_Geometry, 0, 0, 3, false);
            nArray[0] = 0;
            while ((cloneable = ((ElementExtractor)object2).nextElement(nArray)) != null) {
                arrayList.add((J3D_Geometry)cloneable);
            }
        } else {
            arrayList.add(j3D_Geometry);
        }
        object2 = new ArrayList();
        cloneable = new ArrayList();
        boolean bl = false;
        for (n = 0; n < arrayList.size(); ++n) {
            J3D_Geometry j3D_Geometry2;
            object = (J3D_Geometry)arrayList.get(n);
            if (object.gtype != 8) continue;
            bl = true;
            ElementExtractor elementExtractor = new ElementExtractor((J3D_Geometry)object, 0, 2, 3, false);
            nArray[0] = 0;
            J3D_Geometry j3D_Geometry3 = elementExtractor.nextElement(nArray);
            ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry3, 0, 1, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry2 = elementExtractor2.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    ((ArrayList)cloneable).add(j3D_Geometry2);
                    continue;
                }
                ((ArrayList)object2).add(j3D_Geometry2);
            }
        }
        if (!bl) {
            return 0.0;
        }
        for (n = 0; n < ((ArrayList)object2).size(); ++n) {
            object = (J3D_Geometry)((ArrayList)object2).get(n);
            double[] dArray2 = new double[]{0.0, 0.0, 0.0};
            d5 += J3D_Geometry.volumeIntegrals((J3D_Geometry)object, dArray2);
        }
        for (n = 0; n < ((ArrayList)cloneable).size(); ++n) {
            object = (J3D_Geometry)((ArrayList)cloneable).get(n);
            double[] dArray3 = new double[]{0.0, 0.0, 0.0};
            d5 += J3D_Geometry.volumeIntegrals((J3D_Geometry)object, dArray3);
        }
        if (d5 <= 0.0) {
            throw new Exception("54546");
        }
        return d5;
    }

    private static double volumeIntegrals(J3D_Geometry j3D_Geometry, double[] dArray) throws Exception {
        double d = 0.0;
        ArrayList arrayList = new ArrayList();
        arrayList = j3D_Geometry.getFaces(true);
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[1];
        for (int i = 0; i < arrayList.size(); ++i) {
            J3D_Geometry j3D_Geometry2 = (J3D_Geometry)arrayList.get(i);
            J3D_Geometry.planeEquation(dArray2, dArray3, j3D_Geometry2);
            double d2 = Math.abs(dArray2[0]);
            double d3 = Math.abs(dArray2[1]);
            double d4 = Math.abs(dArray2[2]);
            int n = d2 > d3 && d2 > d4 ? 0 : (d3 > d4 ? 1 : 2);
            int n2 = (n + 1) % 3;
            int n3 = (n2 + 1) % 3;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            for (int j = 0; j < j3D_Geometry2.ordinates.length / 3 - 1; ++j) {
                double d11 = j3D_Geometry2.ordinates[3 * j + n2];
                double d12 = j3D_Geometry2.ordinates[3 * j + n3];
                double d13 = j3D_Geometry2.ordinates[3 * ((j + 1) % (j3D_Geometry2.ordinates.length / 3 - 1)) + n2];
                double d14 = j3D_Geometry2.ordinates[3 * ((j + 1) % (j3D_Geometry2.ordinates.length / 3 - 1)) + n3];
                double d15 = d13 - d11;
                double d16 = d14 - d12;
                double d17 = d11 * d11;
                double d18 = d17 * d11;
                double d19 = d12 * d12;
                double d20 = d19 * d12;
                double d21 = d13 * d13;
                double d22 = d13 + d11;
                double d23 = d13 * d22 + d17;
                double d24 = d13 * d23 + d18;
                double d25 = d14 * (d14 + d12) + d19;
                double d26 = d14 * d25 + d20;
                double d27 = 3.0 * d21 + 2.0 * d13 * d11 + d17;
                double d28 = d21 + 2.0 * d13 * d11 + 3.0 * d17;
                d10 += d16 * d22;
                d9 += d16 * d23;
                d7 += d16 * d24;
                d8 += d15 * d25;
                d5 += d15 * d26;
                d6 += d16 * (d14 * d27 + d12 * d28);
            }
            d10 /= 2.0;
            d9 /= 6.0;
            d7 /= 12.0;
            d8 /= -6.0;
            d5 /= -12.0;
            d6 /= 24.0;
            double d29 = 1.0 / dArray2[n];
            double d30 = d29 * d29;
            double d31 = d30 * d29;
            double d32 = d29 * d9;
            double d33 = d29 * d8;
            double d34 = -d30 * (dArray2[n2] * d9 + dArray2[n3] * d8 + dArray3[0] * d10);
            double d35 = d29 * d7;
            double d36 = d29 * d5;
            double d37 = d31 * (Math.pow(dArray2[n2], 2.0) * d7 + 2.0 * dArray2[n2] * dArray2[n3] * d6 + Math.pow(dArray2[n3], 2.0) * d5 + dArray3[0] * (2.0 * (dArray2[n2] * d9 + dArray2[n3] * d8) + dArray3[0] * d10));
            d += dArray2[0] * (n2 == 0 ? d32 : (n3 == 0 ? d33 : d34));
            int n4 = n2;
            dArray[n4] = dArray[n4] + dArray2[n2] * d35;
            int n5 = n3;
            dArray[n5] = dArray[n5] + dArray2[n3] * d36;
            int n6 = n;
            dArray[n6] = dArray[n6] + dArray2[n] * d37;
        }
        dArray[0] = dArray[0] / 2.0;
        dArray[1] = dArray[1] / 2.0;
        dArray[2] = dArray[2] / 2.0;
        return d;
    }

    public ArrayList closestPoints(J3D_Geometry j3D_Geometry, double d) throws Exception {
        ArrayList arrayList = new ArrayList();
        double[] dArray = new double[6];
        if (this.getSRID() != j3D_Geometry.getSRID()) {
            throw new Exception("13365");
        }
        String string = "FALSE";
        double d2 = 6378137.0;
        double d3 = 0.003352810664747;
        double d4 = 1.0;
        return this.closestPoints(j3D_Geometry, d, string, d2, d3, d4);
    }

    public ArrayList closestPoints(J3D_Geometry j3D_Geometry, double d, String string, double d2, double d3, double d4) throws Exception {
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        double[] dArray = new double[6];
        boolean bl = false;
        J3D_Geometry j3D_Geometry2 = null;
        J3D_Geometry j3D_Geometry3 = null;
        if (this.getSRID() != j3D_Geometry.getSRID()) {
            throw new Exception("13365");
        }
        dArray = this.distCpa(j3D_Geometry, d, string, d2, d3, d4);
        if (dArray != null) {
            int[] nArray = new int[3];
            double[] dArray2 = new double[3];
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, this.getSRID(), nArray, dArray2);
            int[] nArray2 = new int[3];
            double[] dArray3 = new double[3];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            dArray3[0] = dArray[3];
            dArray3[1] = dArray[4];
            dArray3[2] = dArray[5];
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, this.getSRID(), nArray2, dArray3);
            boolean bl2 = bl = !(this.gtype != 5 && this.gtype != 6 && this.gtype != 1 && this.gtype != 2 || j3D_Geometry.gtype != 5 && j3D_Geometry.gtype != 6 && j3D_Geometry.gtype != 1 && j3D_Geometry.gtype != 2);
            if (bl) {
                j3D_Geometry2 = (J3D_Geometry)this.belongingGeometry.get(0);
                j3D_Geometry3 = (J3D_Geometry)j3D_Geometry.belongingGeometry.get(0);
            }
            if (string.equals("TRUE")) {
                if (j3D_Geometry4.anyInteract(this, d, "TRUE")) {
                    arrayList.add(j3D_Geometry4);
                    arrayList.add(j3D_Geometry5);
                    if (bl) {
                        arrayList.add(j3D_Geometry2);
                        arrayList.add(j3D_Geometry3);
                    }
                } else {
                    arrayList.add(j3D_Geometry5);
                    arrayList.add(j3D_Geometry4);
                    if (bl) {
                        arrayList.add(j3D_Geometry2);
                        arrayList.add(j3D_Geometry3);
                    }
                }
            } else if (j3D_Geometry4.anyInteract(this, d)) {
                arrayList.add(j3D_Geometry4);
                arrayList.add(j3D_Geometry5);
                if (bl) {
                    arrayList.add(j3D_Geometry2);
                    arrayList.add(j3D_Geometry3);
                }
            } else {
                arrayList.add(j3D_Geometry5);
                arrayList.add(j3D_Geometry4);
                if (bl) {
                    arrayList.add(j3D_Geometry2);
                    arrayList.add(j3D_Geometry3);
                }
            }
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    protected ArrayList closestPointsLRS(J3D_Geometry j3D_Geometry, double d, String string, double d2, double d3, double d4) throws Exception {
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        double[] dArray = new double[6];
        boolean bl = false;
        J3D_Geometry j3D_Geometry2 = null;
        J3D_Geometry j3D_Geometry3 = null;
        if (this.getSRID() != j3D_Geometry.getSRID()) {
            throw new Exception("13365");
        }
        dArray = this.distCpaLRS(j3D_Geometry, d, string, d2, d3, d4);
        if (dArray != null) {
            int[] nArray = new int[3];
            double[] dArray2 = new double[3];
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, this.getSRID(), nArray, dArray2);
            int[] nArray2 = new int[3];
            double[] dArray3 = new double[3];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            dArray3[0] = dArray[3];
            dArray3[1] = dArray[4];
            dArray3[2] = dArray[5];
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, this.getSRID(), nArray2, dArray3);
            boolean bl2 = bl = !(this.gtype != 5 && this.gtype != 6 && this.gtype != 1 && this.gtype != 2 || j3D_Geometry.gtype != 5 && j3D_Geometry.gtype != 6 && j3D_Geometry.gtype != 1 && j3D_Geometry.gtype != 2);
            if (bl) {
                j3D_Geometry2 = (J3D_Geometry)this.belongingGeometry.get(0);
                j3D_Geometry3 = (J3D_Geometry)j3D_Geometry.belongingGeometry.get(0);
            }
            if (string.equals("TRUE")) {
                if (j3D_Geometry4.anyInteract(this, d, "TRUE")) {
                    arrayList.add(j3D_Geometry4);
                    arrayList.add(j3D_Geometry5);
                    if (bl) {
                        arrayList.add(j3D_Geometry2);
                        arrayList.add(j3D_Geometry3);
                    }
                } else {
                    arrayList.add(j3D_Geometry5);
                    arrayList.add(j3D_Geometry4);
                    if (bl) {
                        arrayList.add(j3D_Geometry2);
                        arrayList.add(j3D_Geometry3);
                    }
                }
            } else if (j3D_Geometry4.anyInteract(this, d)) {
                arrayList.add(j3D_Geometry4);
                arrayList.add(j3D_Geometry5);
                if (bl) {
                    arrayList.add(j3D_Geometry2);
                    arrayList.add(j3D_Geometry3);
                }
            } else {
                arrayList.add(j3D_Geometry5);
                arrayList.add(j3D_Geometry4);
                if (bl) {
                    arrayList.add(j3D_Geometry2);
                    arrayList.add(j3D_Geometry3);
                }
            }
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    public double area(double d) throws Exception {
        String string = "FALSE";
        double d2 = 6378137.0;
        double d3 = 0.003352810664747;
        double d4 = 1.0;
        return this.area(d, string, d2, d3, d4);
    }

    public double area(double d, String string, double d2, double d3, double d4) throws Exception {
        J3D_Geometry j3D_Geometry;
        Object object;
        int[] nArray;
        int[] nArray2 = new int[this.elemInfo.length];
        System.arraycopy(this.elemInfo, 0, nArray2, 0, this.elemInfo.length);
        double[] dArray = new double[this.ordinates.length];
        System.arraycopy(this.ordinates, 0, dArray, 0, this.ordinates.length);
        int n = this.getSRID();
        J3D_Geometry j3D_Geometry2 = new J3D_Geometry(this.getType(), n, nArray2, dArray);
        if (string.equals("TRUE")) {
            int n2;
            double[] dArray2;
            if (d < 0.05) {
                d = 0.05;
            }
            if ((dArray2 = this.getMBR()).length != 6) {
                throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
            }
            JGeometry jGeometry = null;
            nArray = null;
            object = null;
            if (this.getElemInfo() == null) {
                nArray = new int[]{1, 1, 1};
                object = new double[]{this.getPoint()[0], this.getPoint()[1]};
                jGeometry = new JGeometry(this.getType(), this.getSRID(), nArray, (double[])object);
            } else {
                nArray = new int[this.getElemInfo().length];
                for (n2 = 0; n2 < this.getElemInfo().length; ++n2) {
                    nArray[n2] = this.getElemInfo()[n2];
                }
                object = new double[2 * (this.getOrdinatesArray().length / 3)];
                for (n2 = 0; n2 < this.getOrdinatesArray().length / 3; ++n2) {
                    object[2 * n2] = this.getOrdinatesArray()[3 * n2];
                    object[2 * n2 + 1] = this.getOrdinatesArray()[3 * n2 + 1];
                }
                jGeometry = new JGeometry(this.getType(), this.getSRID(), nArray, (double[])object);
            }
            jGeometry = jGeometry.projectToLTP(d2, d3);
            for (n2 = 0; n2 < j3D_Geometry2.getOrdinatesArray().length / 3; ++n2) {
                j3D_Geometry2.getOrdinatesArray()[3 * n2] = jGeometry.getOrdinatesArray()[2 * n2];
                j3D_Geometry2.getOrdinatesArray()[3 * n2 + 1] = jGeometry.getOrdinatesArray()[2 * n2 + 1];
                j3D_Geometry2.getOrdinatesArray()[3 * n2 + 2] = d4 * j3D_Geometry2.getOrdinatesArray()[3 * n2 + 2];
            }
        }
        if (j3D_Geometry2.getType() != 4) {
            return j3D_Geometry2.computeArea(d);
        }
        double d5 = 0.0;
        nArray = new int[1];
        object = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry2);
        nArray[0] = 0;
        while ((j3D_Geometry = elementExtractor.nextElement(nArray)) != null) {
            ((ArrayList)object).add(j3D_Geometry);
        }
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            J3D_Geometry j3D_Geometry3 = (J3D_Geometry)((ArrayList)object).get(i);
            d5 += j3D_Geometry3.computeArea(d);
        }
        return d5;
    }

    private double computeArea(double d) throws Exception {
        Cloneable cloneable;
        int n;
        Cloneable cloneable2;
        Object object;
        double d2 = 0.0;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        if (this.gtype == 9 || this.gtype == 7 || this.gtype == 6 || this.elemInfo[1] % 1000 == 2 && this.ordinates.length != 6 || this.gtype == 5 || this.elemInfo[1] % 1000 == 8 || this.elemInfo[1] % 1000 == 6) {
            object = new ElementExtractor(this, 0, 0, 3, false);
            nArray[0] = 0;
            while ((cloneable2 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                arrayList.add((J3D_Geometry)cloneable2);
            }
        } else {
            arrayList.add(this);
        }
        object = new ArrayList();
        for (n = 0; n < arrayList.size(); ++n) {
            cloneable2 = (J3D_Geometry)arrayList.get(n);
            if (((J3D_Geometry)cloneable2).gtype == 8) {
                cloneable = new ArrayList();
                cloneable = super.getFaces2(false);
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)((ArrayList)cloneable).get(i);
                    ((ArrayList)object).add(j3D_Geometry);
                }
                continue;
            }
            ((ArrayList)object).add(cloneable2);
        }
        cloneable2 = new ArrayList();
        for (n = 0; n < ((ArrayList)object).size(); ++n) {
            Object[] objectArray;
            cloneable = (J3D_Geometry)((ArrayList)object).get(n);
            boolean bl = false;
            for (int i = 0; i < ((J3D_Geometry)cloneable).elemInfo.length; i += 3) {
                if (((J3D_Geometry)cloneable).elemInfo[i + 1] / 1000 != 2) continue;
                bl = true;
                break;
            }
            if (bl) {
                J3D_Geometry j3D_Geometry;
                ElementExtractor elementExtractor = new ElementExtractor((J3D_Geometry)cloneable, 0, 1, 3, false);
                nArray[0] = 0;
                while ((j3D_Geometry = elementExtractor.nextElement(nArray)) != null) {
                    if (nArray[0] == 2) {
                        objectArray = new Object[]{j3D_Geometry, 2};
                        ((ArrayList)cloneable2).add(objectArray);
                        continue;
                    }
                    objectArray = new Object[]{j3D_Geometry, 1};
                    ((ArrayList)cloneable2).add(objectArray);
                }
                continue;
            }
            objectArray = new Object[]{cloneable, 1};
            ((ArrayList)cloneable2).add(objectArray);
        }
        for (n = 0; n < ((ArrayList)cloneable2).size(); ++n) {
            Object[] objectArray = new Object[2];
            objectArray = (Object[])((ArrayList)cloneable2).get(n);
            cloneable = (J3D_Geometry)objectArray[0];
            int n2 = (Integer)objectArray[1];
            if (((JGeometry)cloneable).getElemInfo()[2] == 3) {
                ElementExtractor elementExtractor = new ElementExtractor((J3D_Geometry)cloneable, 0, 1, 3, false);
                nArray[0] = 0;
                cloneable = elementExtractor.nextElement(nArray);
            }
            if (((J3D_Geometry)cloneable).gtype == 3 && n2 == 1) {
                d2 += Math.abs(((J3D_Geometry)cloneable).getAreaPolygon());
                continue;
            }
            if (((J3D_Geometry)cloneable).gtype == 3 && n2 == 2) {
                d2 -= Math.abs(((J3D_Geometry)cloneable).getAreaPolygon());
                continue;
            }
            d2 += 0.0;
        }
        return d2;
    }

    protected double getAreaPolygon() throws Exception {
        int n;
        double d = 0.0;
        int n2 = this.ordinates.length / 3;
        double[] dArray = new double[3 * n2];
        double[] dArray2 = new double[3];
        for (n = 0; n < 3 * n2; ++n) {
            dArray[n] = this.ordinates[n];
        }
        dArray2[0] = 0.0;
        dArray2[1] = 0.0;
        dArray2[2] = 0.0;
        for (n = 0; n < n2 - 1; ++n) {
            int n3 = n < n2 - 2 ? n + 1 : 0;
            dArray2[0] = dArray2[0] + dArray[1 + n * 3] * dArray[2 + n3 * 3] - dArray[2 + n * 3] * dArray[1 + n3 * 3];
            dArray2[1] = dArray2[1] + dArray[2 + n * 3] * dArray[0 + n3 * 3] - dArray[0 + n * 3] * dArray[2 + n3 * 3];
            dArray2[2] = dArray2[2] + dArray[0 + n * 3] * dArray[1 + n3 * 3] - dArray[1 + n * 3] * dArray[0 + n3 * 3];
        }
        d = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        if (d != 0.0) {
            dArray2[0] = dArray2[0] / d;
            dArray2[1] = dArray2[1] / d;
            dArray2[2] = dArray2[2] / d;
        } else {
            dArray2[0] = 1.0;
            dArray2[1] = 0.0;
            dArray2[2] = 0.0;
        }
        d = 0.5 * d;
        return d;
    }

    public double length(double d) throws Exception {
        int n = 1;
        return this.length(n, d);
    }

    public double length(double d, String string, double d2, double d3, double d4) throws Exception {
        int n = 1;
        return this.length(n, d, string, d2, d3, d4);
    }

    public double length(int n, double d) throws Exception {
        String string = "FALSE";
        double d2 = 6378137.0;
        double d3 = 0.003352810664747;
        double d4 = 1.0;
        return this.length(n, d, string, d2, d3, d4);
    }

    public double length(int n, double d, String string, double d2, double d3, double d4) throws Exception {
        J3D_Geometry j3D_Geometry;
        if (n != 2 && n != 1) {
            throw new Exception("54547");
        }
        if (this.getType() != 4) {
            return this.computeLength(n, d, string, d2, d3, d4);
        }
        double d5 = 0.0;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ElementExtractor elementExtractor = new ElementExtractor(this);
        nArray[0] = 0;
        while ((j3D_Geometry = elementExtractor.nextElement(nArray)) != null) {
            arrayList.add(j3D_Geometry);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            J3D_Geometry j3D_Geometry2 = (J3D_Geometry)arrayList.get(i);
            d5 += j3D_Geometry2.computeLength(n, d, string, d2, d3, d4);
        }
        return d5;
    }

    private double computeLength(int n, double d, String string, double d2, double d3, double d4) throws Exception {
        int n2;
        int n3;
        int n4;
        int n5;
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        J3D_Geometry j3D_Geometry;
        Object object;
        Object object2;
        J3D_Geometry j3D_Geometry2;
        Object object3;
        int n6;
        ArrayList arrayList;
        int n7;
        Cloneable cloneable;
        Object object4;
        double d5 = 0.0;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        if (this.gtype == 9 || this.gtype == 7 || this.gtype == 6 || this.elemInfo[1] % 1000 == 2 && this.ordinates.length != 6 || this.gtype == 5 || this.elemInfo[1] % 1000 == 8 || this.elemInfo[1] % 1000 == 6) {
            object4 = new ElementExtractor(this, 0, 0, 3, false);
            nArray[0] = 0;
            while ((cloneable = ((ElementExtractor)object4).nextElement(nArray)) != null) {
                arrayList2.add((J3D_Geometry)cloneable);
            }
        } else {
            arrayList2.add(this);
        }
        if (this.gtype == 6) {
            J3D_Geometry.decomposeLnStrIntoLnSgts(arrayList2);
        }
        object4 = new ArrayList();
        for (n7 = 0; n7 < arrayList2.size(); ++n7) {
            cloneable = (J3D_Geometry)arrayList2.get(n7);
            if (((J3D_Geometry)cloneable).gtype == 8) {
                arrayList = new ArrayList();
                arrayList = ((J3D_Geometry)cloneable).getFaces2(false);
                for (n6 = 0; n6 < arrayList.size(); ++n6) {
                    J3D_Geometry j3D_Geometry3 = (J3D_Geometry)arrayList.get(n6);
                    ((ArrayList)object4).add(j3D_Geometry3);
                }
                continue;
            }
            ((ArrayList)object4).add(cloneable);
        }
        cloneable = new ArrayList();
        for (n7 = 0; n7 < ((ArrayList)object4).size(); ++n7) {
            arrayList = (J3D_Geometry)((ArrayList)object4).get(n7);
            boolean bl = false;
            for (int i = 0; i < ((J3D_Geometry)((Object)arrayList)).elemInfo.length; i += 3) {
                if (((J3D_Geometry)((Object)arrayList)).elemInfo[i + 1] / 1000 != 2) continue;
                bl = true;
                break;
            }
            if (bl) {
                ElementExtractor elementExtractor = new ElementExtractor((J3D_Geometry)((Object)arrayList), 0, 1, 3, false);
                nArray[0] = 0;
                while ((object3 = elementExtractor.nextElement(nArray)) != null) {
                    if (nArray[0] == 2) {
                        ((ArrayList)cloneable).add(object3);
                        continue;
                    }
                    ((ArrayList)cloneable).add(object3);
                }
                continue;
            }
            ((ArrayList)cloneable).add(arrayList);
        }
        double d6 = 0.0;
        for (n7 = 0; n7 < ((ArrayList)cloneable).size(); ++n7) {
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)((ArrayList)cloneable).get(n7);
            if (j3D_Geometry4.gtype == 3) {
                if (j3D_Geometry4.getElemInfo()[2] == 3) {
                    object3 = new ElementExtractor(j3D_Geometry4, 0, 1, 3, false);
                    nArray[0] = 0;
                    j3D_Geometry4 = ((ElementExtractor)object3).nextElement(nArray);
                }
                object3 = new ArrayList();
                ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry4, 0, 2, 3, false);
                nArray[0] = 0;
                while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
                    if (nArray[0] == 2) {
                        throw new Exception("54501");
                    }
                    ((ArrayList)object3).add(j3D_Geometry2);
                }
                for (n6 = 0; n6 < ((ArrayList)object3).size(); ++n6) {
                    object2 = (J3D_Geometry)((ArrayList)object3).get(n6);
                    d6 = string.equals("TRUE") ? J3D_Geometry.geodetic3DLength((JGeometry)object2, d2, d3, d4) : Math.sqrt((((J3D_Geometry)object2).ordinates[0] - ((J3D_Geometry)object2).ordinates[3]) * (((J3D_Geometry)object2).ordinates[0] - ((J3D_Geometry)object2).ordinates[3]) + (((J3D_Geometry)object2).ordinates[1] - ((J3D_Geometry)object2).ordinates[4]) * (((J3D_Geometry)object2).ordinates[1] - ((J3D_Geometry)object2).ordinates[4]) + (((J3D_Geometry)object2).ordinates[2] - ((J3D_Geometry)object2).ordinates[5]) * (((J3D_Geometry)object2).ordinates[2] - ((J3D_Geometry)object2).ordinates[5]));
                    d5 += d6;
                }
            }
            if (j3D_Geometry4.gtype != 2) continue;
            d6 = string.equals("TRUE") ? J3D_Geometry.geodetic3DLength(j3D_Geometry4, d2, d3, d4) : Math.sqrt((j3D_Geometry4.ordinates[0] - j3D_Geometry4.ordinates[3]) * (j3D_Geometry4.ordinates[0] - j3D_Geometry4.ordinates[3]) + (j3D_Geometry4.ordinates[1] - j3D_Geometry4.ordinates[4]) * (j3D_Geometry4.ordinates[1] - j3D_Geometry4.ordinates[4]) + (j3D_Geometry4.ordinates[2] - j3D_Geometry4.ordinates[5]) * (j3D_Geometry4.ordinates[2] - j3D_Geometry4.ordinates[5]));
            d5 += d6;
        }
        if (n == 2) {
            return d5;
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        object3 = new ArrayList();
        int n8 = 0;
        for (n7 = 0; n7 < ((ArrayList)cloneable).size(); ++n7) {
            j3D_Geometry2 = (J3D_Geometry)((ArrayList)cloneable).get(n7);
            object2 = new double[3][2];
            if (j3D_Geometry2.gtype == 3) {
                ++n8;
                object = new ElementExtractor(j3D_Geometry2, 0, 2, 3, false);
                nArray[0] = 0;
                while ((j3D_Geometry = ((ElementExtractor)object).nextElement(nArray)) != null) {
                    if (nArray[0] == 2) {
                        throw new Exception("54501");
                    }
                    if (j3D_Geometry2.elemInfo[1] / 1000 == 2) {
                        objectArray3 = new Object[]{j3D_Geometry, new Integer(n8), new Integer(2)};
                        arrayList3.add(objectArray3);
                        object2 = J3D_Geometry.getMBH(j3D_Geometry);
                        ((ArrayList)object3).add(object2);
                        continue;
                    }
                    objectArray3 = new Object[]{j3D_Geometry, new Integer(n8), new Integer(1)};
                    arrayList3.add(objectArray3);
                    object2 = J3D_Geometry.getMBH(j3D_Geometry);
                    ((ArrayList)object3).add(object2);
                }
                continue;
            }
            object = new Object[]{j3D_Geometry2, new Integer(-1), new Integer(-1)};
            arrayList3.add(object);
            object2 = J3D_Geometry.getMBH(j3D_Geometry2);
            ((ArrayList)object3).add(object2);
        }
        j3D_Geometry2 = new RTree(3, 8, 2, d);
        J3D_Geometry.createRTree2((RTree)j3D_Geometry2, (ArrayList)object3, arrayList3);
        object2 = new ArrayList();
        j3D_Geometry2.anyInteract((RTree)j3D_Geometry2, (ArrayList)object2);
        for (n7 = 0; n7 < ((ArrayList)object2).size(); ++n7) {
            objectArray3 = (Object[])((ArrayList)object2).get(n7);
            objectArray2 = new Object[3];
            objectArray = new Object[3];
            objectArray2 = (Object[])objectArray3.ptr1;
            objectArray = (Object[])objectArray3.ptr2;
            object = (J3D_Geometry)objectArray2[0];
            j3D_Geometry = (J3D_Geometry)objectArray[0];
            n5 = (Integer)objectArray2[1];
            n4 = (Integer)objectArray[1];
            n3 = (Integer)objectArray2[2];
            n2 = (Integer)objectArray[2];
            if (n5 != n4 || object != j3D_Geometry) continue;
            ((ArrayList)object2).remove(n7);
        }
        for (n7 = 0; n7 < ((ArrayList)object2).size(); ++n7) {
            objectArray3 = (RTreeJoinRes)((ArrayList)object2).get(n7);
            objectArray2 = new Object[3];
            objectArray = new Object[3];
            objectArray2 = (Object[])objectArray3.ptr1;
            objectArray = (Object[])objectArray3.ptr2;
            object = (J3D_Geometry)objectArray2[0];
            j3D_Geometry = (J3D_Geometry)objectArray[0];
            n5 = (Integer)objectArray2[1];
            n4 = (Integer)objectArray[1];
            n3 = (Integer)objectArray2[2];
            n2 = (Integer)objectArray[2];
            if (n5 == n4) continue;
            int[] nArray2 = new int[((J3D_Geometry)object).elemInfo.length];
            System.arraycopy(((J3D_Geometry)object).elemInfo, 0, nArray2, 0, ((J3D_Geometry)object).elemInfo.length);
            double[] dArray = new double[((J3D_Geometry)object).ordinates.length];
            System.arraycopy(((J3D_Geometry)object).ordinates, 0, dArray, 0, ((J3D_Geometry)object).ordinates.length);
            int n9 = ((JGeometry)object).getSRID();
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(((JGeometry)object).getType(), n9, nArray2, dArray);
            int[] nArray3 = new int[j3D_Geometry.elemInfo.length];
            System.arraycopy(j3D_Geometry.elemInfo, 0, nArray3, 0, j3D_Geometry.elemInfo.length);
            double[] dArray2 = new double[j3D_Geometry.ordinates.length];
            System.arraycopy(j3D_Geometry.ordinates, 0, dArray2, 0, j3D_Geometry.ordinates.length);
            int n10 = j3D_Geometry.getSRID();
            J3D_Geometry j3D_Geometry6 = new J3D_Geometry(j3D_Geometry.getType(), n10, nArray3, dArray2);
            double d7 = 0.0;
            double d8 = 0.0;
            if (string.equals("TRUE")) {
                if (d < 0.05) {
                    d = 0.05;
                }
                d7 = Math.PI / 180 * ((JGeometry)object).getOrdinatesArray()[0];
                d8 = Math.PI / 180 * ((JGeometry)object).getOrdinatesArray()[1];
                j3D_Geometry5 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry5, d7, d8);
                j3D_Geometry6 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry6, d7, d8);
            }
            if (!(j3D_Geometry5.distance(j3D_Geometry6, d) < d) || !J3D_Geometry.T3reln(j3D_Geometry5, j3D_Geometry6, d)) continue;
            double d9 = string.equals("TRUE") ? J3D_Geometry.geodetic3DLength((JGeometry)object, d2, d3, d4) : Math.sqrt((((J3D_Geometry)object).ordinates[0] - ((J3D_Geometry)object).ordinates[3]) * (((J3D_Geometry)object).ordinates[0] - ((J3D_Geometry)object).ordinates[3]) + (((J3D_Geometry)object).ordinates[1] - ((J3D_Geometry)object).ordinates[4]) * (((J3D_Geometry)object).ordinates[1] - ((J3D_Geometry)object).ordinates[4]) + (((J3D_Geometry)object).ordinates[2] - ((J3D_Geometry)object).ordinates[5]) * (((J3D_Geometry)object).ordinates[2] - ((J3D_Geometry)object).ordinates[5]));
            double d10 = string.equals("TRUE") ? J3D_Geometry.geodetic3DLength(j3D_Geometry, d2, d3, d4) : Math.sqrt((j3D_Geometry.ordinates[0] - j3D_Geometry.ordinates[3]) * (j3D_Geometry.ordinates[0] - j3D_Geometry.ordinates[3]) + (j3D_Geometry.ordinates[1] - j3D_Geometry.ordinates[4]) * (j3D_Geometry.ordinates[1] - j3D_Geometry.ordinates[4]) + (j3D_Geometry.ordinates[2] - j3D_Geometry.ordinates[5]) * (j3D_Geometry.ordinates[2] - j3D_Geometry.ordinates[5]));
            double d11 = Math.min(d9, d10);
            if (n == 1) {
                d5 -= d11 / 2.0;
                continue;
            }
            throw new Exception("54547");
        }
        return d5;
    }

    public static JGeometry extrusion(JGeometry jGeometry, double d, double d2, Connection connection, double d3) throws Exception, SQLException {
        int n = 0;
        return J3D_Geometry.extrusion(jGeometry, d, d2, connection, d3, n);
    }

    public static JGeometry extrusion(JGeometry jGeometry, double d, double d2, Connection connection, double d3, int n) throws Exception, SQLException {
        Object object;
        Object object2;
        ArrayList<JGeometry> arrayList = new ArrayList<JGeometry>();
        JGeometry jGeometry2 = null;
        int[] nArray = new int[]{0};
        int n2 = 0;
        GML2 gML2 = new GML2();
        if (gML2.geometryHasArcs(jGeometry)) {
            throw new Exception("13199 input 2D polygon contains arcs");
        }
        int n3 = jGeometry.getElemInfo().length / 3;
        for (n2 = 1; n2 <= n3; ++n2) {
            object2 = connection.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?,?)}");
            object2.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
            object2.setObject(2, JGeometry.storeJS(jGeometry, connection));
            object2.setInt(3, 1);
            object2.setInt(4, n2);
            object2.execute();
            object = (Struct)object2.getObject(1);
            jGeometry2 = JGeometry.loadJS((Struct)object);
            arrayList.add(jGeometry2);
            object2.close();
            continue;
        }
        if (arrayList.size() > 1) {
            Object object3;
            Object object4;
            object2 = null;
            object = null;
            Object object5 = connection.prepareCall("{ ? = call sdo_util.remove_inner_rings(?,?)}");
            object5.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
            object5.setObject(2, JGeometry.storeJS(jGeometry, connection));
            object5.setDouble(3, d3);
            object5.execute();
            Object object6 = (Struct)object5.getObject(1);
            object = JGeometry.loadJS((Struct)object6);
            object5.close();
            object5 = new ArrayList();
            n3 = ((JGeometry)object).getElemInfo().length / 3;
            for (n2 = 1; n2 <= n3; ++n2) {
                object6 = connection.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?,?)}");
                object6.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                object6.setObject(2, JGeometry.storeJS((JGeometry)object, connection));
                object6.setInt(3, n2);
                object6.setInt(4, 1);
                object6.execute();
                object4 = (Struct)object6.getObject(1);
                object3 = JGeometry.loadJS((Struct)object4);
                ((ArrayList)object5).add(object3);
                object6.close();
                continue;
            }
            for (n2 = 0; n2 < ((ArrayList)object5).size(); ++n2) {
                int n4;
                double[] dArray;
                object6 = (JGeometry)((ArrayList)object5).get(n2);
                object4 = J3D_Geometry.extrusion2((JGeometry)object6, d, d2, connection, d3, n);
                if (object2 == null) {
                    if (((JGeometry)object4).ordinates.length / 3 > 349525) {
                        throw new Exception("13019");
                    }
                    object3 = new int[((JGeometry)object4).elemInfo.length + 3];
                    dArray = new double[((JGeometry)object4).ordinates.length];
                    object3[0] = true;
                    object3[1] = 1008;
                    object3[2] = true;
                    System.arraycopy(((JGeometry)object4).elemInfo, 0, object3, 3, ((JGeometry)object4).elemInfo.length);
                    System.arraycopy(((JGeometry)object4).ordinates, 0, dArray, 0, ((JGeometry)object4).ordinates.length);
                    n4 = ((JGeometry)object4).getSRID();
                    object2 = new JGeometry(3008, n4, (int[])object3, dArray);
                    continue;
                }
                if ((((JGeometry)object2).ordinates.length + ((JGeometry)object4).ordinates.length) / 3 > 349525) {
                    throw new Exception("13019");
                }
                object3 = new int[((JGeometry)object2).elemInfo.length + ((JGeometry)object4).elemInfo.length];
                dArray = new double[((JGeometry)object2).ordinates.length + ((JGeometry)object4).ordinates.length];
                n4 = 0;
                object3[0] = true;
                object3[1] = 1008;
                object3[2] = ((ArrayList)object5).size();
                for (n4 = 3; n4 < ((JGeometry)object2).elemInfo.length; ++n4) {
                    object3[n4] = ((JGeometry)object2).elemInfo[n4];
                }
                for (n4 = 0; n4 < ((JGeometry)object4).elemInfo.length; ++n4) {
                    object3[n4 + ((JGeometry)object2).elemInfo.length] = n4 % 3 == 0 ? (Object)(((JGeometry)object4).elemInfo[n4] + ((JGeometry)object2).ordinates.length) : (Object)((JGeometry)object4).elemInfo[n4];
                }
                for (n4 = 0; n4 < ((JGeometry)object2).ordinates.length; ++n4) {
                    dArray[n4] = ((JGeometry)object2).ordinates[n4];
                }
                for (n4 = 0; n4 < ((JGeometry)object4).ordinates.length; ++n4) {
                    dArray[n4 + ((JGeometry)object2).ordinates.length] = ((JGeometry)object4).ordinates[n4];
                }
                object2 = new JGeometry(3008, ((JGeometry)object2).srid, (int[])object3, dArray);
            }
            return object2;
        }
        return J3D_Geometry.extrusion2(jGeometry, d, d2, connection, d3, n);
    }

    public static JGeometry extrusion(JGeometry jGeometry, double[] dArray, double[] dArray2, Connection connection, double d) throws Exception, SQLException {
        int n = 0;
        return J3D_Geometry.extrusion(jGeometry, dArray, dArray2, connection, d, n);
    }

    public static JGeometry extrusion(JGeometry jGeometry, double[] dArray, double[] dArray2, Connection connection, double d, int n) throws Exception, SQLException {
        Object object;
        Object object2;
        ArrayList<JGeometry> arrayList = new ArrayList<JGeometry>();
        JGeometry jGeometry2 = null;
        int[] nArray = new int[]{0};
        int n2 = 0;
        int n3 = jGeometry.getElemInfo().length / 3;
        for (n2 = 1; n2 <= n3; ++n2) {
            object2 = connection.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?,?)}");
            object2.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
            object2.setObject(2, JGeometry.storeJS(jGeometry, connection));
            object2.setInt(3, 1);
            object2.setInt(4, n2);
            object2.execute();
            object = (Struct)object2.getObject(1);
            jGeometry2 = JGeometry.loadJS((Struct)object);
            arrayList.add(jGeometry2);
            object2.close();
            continue;
        }
        if (arrayList.size() > 1) {
            Cloneable cloneable;
            Object object3;
            object2 = null;
            object = null;
            JGeometry jGeometry3 = (JGeometry)arrayList.get(0);
            double[][] dArray3 = new double[jGeometry3.ordinates.length / 2][3];
            double[][] dArray4 = new double[jGeometry3.ordinates.length / 2][3];
            for (n2 = 0; n2 < jGeometry3.ordinates.length / 2 - 1; ++n2) {
                dArray3[n2][0] = jGeometry.ordinates[2 * n2];
                dArray3[n2][1] = jGeometry.ordinates[2 * n2 + 1];
                dArray3[n2][2] = dArray[n2];
                dArray4[n2][0] = jGeometry.ordinates[2 * n2];
                dArray4[n2][1] = jGeometry.ordinates[2 * n2 + 1];
                dArray4[n2][2] = dArray2[n2];
            }
            dArray3[n2][0] = dArray3[0][0];
            dArray3[n2][1] = dArray3[0][1];
            dArray3[n2][2] = dArray3[0][2];
            dArray4[n2][0] = dArray4[0][0];
            dArray4[n2][1] = dArray4[0][1];
            dArray4[n2][2] = dArray4[0][2];
            double[] dArray5 = new double[1];
            double[] dArray6 = new double[3];
            J3D_Geometry.planeEquation(dArray6, dArray5, dArray4);
            double[] dArray7 = new double[1];
            double[] dArray8 = new double[3];
            J3D_Geometry.planeEquation(dArray8, dArray7, dArray3);
            double[] dArray9 = new double[jGeometry.ordinates.length / 2];
            double[] dArray10 = new double[jGeometry.ordinates.length / 2];
            for (n2 = 0; n2 < dArray.length; ++n2) {
                dArray9[n2] = dArray[n2];
                dArray10[n2] = dArray2[n2];
            }
            for (int i = 1; i < arrayList.size(); ++i) {
                object3 = (JGeometry)arrayList.get(i);
                for (int j = 0; j < ((JGeometry)object3).getOrdinatesArray().length / 2; ++j) {
                    dArray9[n2] = (-dArray7[0] - dArray8[0] * ((JGeometry)object3).ordinates[2 * j] - dArray8[1] * ((JGeometry)object3).ordinates[2 * j + 1]) / dArray8[2];
                    dArray10[n2] = (-dArray5[0] - dArray6[0] * ((JGeometry)object3).ordinates[2 * j] - dArray6[1] * ((JGeometry)object3).ordinates[2 * j + 1]) / dArray6[2];
                    ++n2;
                }
            }
            Object object4 = connection.prepareCall("{ ? = call sdo_util.remove_inner_rings(?,?)}");
            object4.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
            object4.setObject(2, JGeometry.storeJS(jGeometry, connection));
            object4.setDouble(3, d);
            object4.execute();
            object3 = (Struct)object4.getObject(1);
            object = JGeometry.loadJS((Struct)object3);
            object4.close();
            object4 = new ArrayList();
            n3 = ((JGeometry)object).getElemInfo().length / 3;
            for (n2 = 1; n2 <= n3; ++n2) {
                object3 = connection.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?,?)}");
                object3.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                object3.setObject(2, JGeometry.storeJS((JGeometry)object, connection));
                object3.setInt(3, n2);
                object3.setInt(4, 1);
                object3.execute();
                Struct struct = (Struct)object3.getObject(1);
                cloneable = JGeometry.loadJS(struct);
                ((ArrayList)object4).add(cloneable);
                object3.close();
                continue;
            }
            for (n2 = 0; n2 < ((ArrayList)object4).size(); ++n2) {
                int n4;
                double[] dArray11;
                int[] nArray2;
                int n5;
                Object object5;
                object3 = (JGeometry)((ArrayList)object4).get(n2);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                cloneable = new ArrayList();
                block13: for (int i = 0; i < ((JGeometry)object3).getOrdinatesArray().length / 2; ++i) {
                    int n6;
                    int n7 = 0;
                    for (n6 = 0; n6 < arrayList.size(); ++n6) {
                        object5 = (JGeometry)arrayList.get(n6);
                        for (n5 = 0; n5 < ((JGeometry)object5).getOrdinatesArray().length / 2; ++n5) {
                            if (!(Math.sqrt((((JGeometry)object5).ordinates[2 * n5] - ((JGeometry)object3).ordinates[2 * i]) * (((JGeometry)object5).ordinates[2 * n5] - ((JGeometry)object3).ordinates[2 * i]) + (((JGeometry)object5).ordinates[2 * n5 + 1] - ((JGeometry)object3).ordinates[2 * i + 1]) * (((JGeometry)object5).ordinates[2 * n5 + 1] - ((JGeometry)object3).ordinates[2 * i + 1])) < d)) continue;
                            arrayList2.add(dArray9[n7 / 2 + n5]);
                            ((ArrayList)cloneable).add(dArray10[n7 / 2 + n5]);
                            continue block13;
                        }
                        n7 += ((JGeometry)object5).getOrdinatesArray().length;
                    }
                    n7 = 0;
                    for (n6 = 0; n6 < arrayList.size(); ++n6) {
                        object5 = (JGeometry)arrayList.get(n6);
                        for (n5 = 0; n5 < ((JGeometry)object5).getOrdinatesArray().length / 2 - 1; ++n5) {
                            nArray2 = new int[3];
                            dArray11 = new double[3];
                            nArray2[0] = 1;
                            nArray2[1] = 1;
                            nArray2[2] = 1;
                            dArray11[0] = ((JGeometry)object3).ordinates[2 * i];
                            dArray11[1] = ((JGeometry)object3).ordinates[2 * i + 1];
                            dArray11[2] = 0.0;
                            J3D_Geometry j3D_Geometry = new J3D_Geometry(3001, ((JGeometry)object3).getSRID(), nArray2, dArray11);
                            int[] nArray3 = new int[3];
                            double[] dArray12 = new double[6];
                            nArray3[0] = 1;
                            nArray3[1] = 2;
                            nArray3[2] = 1;
                            dArray12[0] = ((JGeometry)object5).ordinates[2 * n5];
                            dArray12[1] = ((JGeometry)object5).ordinates[2 * n5 + 1];
                            dArray12[2] = 0.0;
                            dArray12[3] = ((JGeometry)object5).ordinates[2 * n5 + 2];
                            dArray12[4] = ((JGeometry)object5).ordinates[2 * n5 + 3];
                            dArray12[5] = 0.0;
                            J3D_Geometry j3D_Geometry2 = new J3D_Geometry(3002, ((JGeometry)object5).getSRID(), nArray3, dArray12);
                            if (!j3D_Geometry.anyInteract(j3D_Geometry2, d)) continue;
                            double d2 = Math.sqrt((((JGeometry)object3).ordinates[2 * i] - ((JGeometry)object5).ordinates[2 * n5]) * (((JGeometry)object3).ordinates[2 * i] - ((JGeometry)object5).ordinates[2 * n5]) + (((JGeometry)object3).ordinates[2 * i + 1] - ((JGeometry)object5).ordinates[2 * n5 + 1]) * (((JGeometry)object3).ordinates[2 * i + 1] - ((JGeometry)object5).ordinates[2 * n5 + 1]));
                            double d3 = Math.sqrt((((JGeometry)object3).ordinates[2 * i] - ((JGeometry)object5).ordinates[2 * n5 + 2]) * (((JGeometry)object3).ordinates[2 * i] - ((JGeometry)object5).ordinates[2 * n5 + 2]) + (((JGeometry)object3).ordinates[2 * i + 1] - ((JGeometry)object5).ordinates[2 * n5 + 3]) * (((JGeometry)object3).ordinates[2 * i + 1] - ((JGeometry)object5).ordinates[2 * n5 + 3]));
                            double d4 = dArray9[n7 / 2 + n5] - dArray9[n7 / 2 + n5 + 1];
                            double d5 = dArray10[n7 / 2 + n5] - dArray10[n7 / 2 + n5 + 1];
                            arrayList2.add(dArray9[n7 / 2 + n5] - d4 * (d2 / (d2 + d3)));
                            ((ArrayList)cloneable).add(dArray10[n7 / 2 + n5] - d5 * (d2 / (d2 + d3)));
                            continue block13;
                        }
                        n7 += ((JGeometry)object5).getOrdinatesArray().length;
                    }
                }
                Object[] objectArray = arrayList2.toArray();
                Object[] objectArray2 = ((ArrayList)cloneable).toArray();
                double[] dArray13 = new double[objectArray.length];
                object5 = new double[objectArray2.length];
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    dArray13[n5] = (Double)objectArray[n5];
                }
                for (n5 = 0; n5 < objectArray2.length; ++n5) {
                    object5[n5] = (Double)objectArray2[n5];
                }
                JGeometry jGeometry4 = J3D_Geometry.extrusion2((JGeometry)object3, dArray13, (double[])object5, connection, d, n);
                if (object2 == null) {
                    if (jGeometry4.ordinates.length / 3 > 349525) {
                        throw new Exception("13019");
                    }
                    nArray2 = new int[jGeometry4.elemInfo.length + 3];
                    dArray11 = new double[jGeometry4.ordinates.length];
                    nArray2[0] = 1;
                    nArray2[1] = 1008;
                    nArray2[2] = 1;
                    System.arraycopy(jGeometry4.elemInfo, 0, nArray2, 3, jGeometry4.elemInfo.length);
                    System.arraycopy(jGeometry4.ordinates, 0, dArray11, 0, jGeometry4.ordinates.length);
                    n4 = jGeometry4.getSRID();
                    object2 = new JGeometry(3008, n4, nArray2, dArray11);
                    continue;
                }
                if ((((JGeometry)object2).ordinates.length + jGeometry4.ordinates.length) / 3 > 349525) {
                    throw new Exception("13019");
                }
                nArray2 = new int[((JGeometry)object2).elemInfo.length + jGeometry4.elemInfo.length];
                dArray11 = new double[((JGeometry)object2).ordinates.length + jGeometry4.ordinates.length];
                n4 = 0;
                nArray2[0] = 1;
                nArray2[1] = 1008;
                nArray2[2] = ((ArrayList)object4).size();
                for (n4 = 3; n4 < ((JGeometry)object2).elemInfo.length; ++n4) {
                    nArray2[n4] = ((JGeometry)object2).elemInfo[n4];
                }
                for (n4 = 0; n4 < jGeometry4.elemInfo.length; ++n4) {
                    nArray2[n4 + ((JGeometry)object2).elemInfo.length] = n4 % 3 == 0 ? jGeometry4.elemInfo[n4] + ((JGeometry)object2).ordinates.length : jGeometry4.elemInfo[n4];
                }
                for (n4 = 0; n4 < ((JGeometry)object2).ordinates.length; ++n4) {
                    dArray11[n4] = ((JGeometry)object2).ordinates[n4];
                }
                for (n4 = 0; n4 < jGeometry4.ordinates.length; ++n4) {
                    dArray11[n4 + ((JGeometry)object2).ordinates.length] = jGeometry4.ordinates[n4];
                }
                object2 = new JGeometry(3008, ((JGeometry)object2).srid, nArray2, dArray11);
            }
            return object2;
        }
        return J3D_Geometry.extrusion2(jGeometry, dArray, dArray2, connection, d, n);
    }

    protected static JGeometry extrusion2(JGeometry jGeometry, double d, double d2, Connection connection, double d3, int n) throws Exception, SQLException {
        Object object;
        if (jGeometry.gtype != 3 || jGeometry.gtype != 3) {
            throw new Exception("54548");
        }
        if (jGeometry.elemInfo.length != 3) {
            throw new Exception("54549");
        }
        if (jGeometry.getElemInfo()[2] == 3) {
            CallableStatement callableStatement = connection.prepareCall("{ ? = call mdsys.sdo_util.expand_geom(?)}");
            callableStatement.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
            callableStatement.setObject(2, (Object)JGeometry.storeJS(jGeometry, connection));
            callableStatement.execute();
            object = (Struct)callableStatement.getObject(1);
            jGeometry = JGeometry.loadJS((Struct)object);
            callableStatement.close();
        }
        int n2 = 0;
        object = new double[jGeometry.ordinates.length / 2];
        double[] dArray = new double[jGeometry.ordinates.length / 2];
        for (n2 = 0; n2 < jGeometry.ordinates.length / 2; ++n2) {
            object[n2] = d;
            dArray[n2] = d2;
        }
        return J3D_Geometry.extrusion2(jGeometry, object, dArray, connection, d3, n);
    }

    protected static JGeometry extrusion2(JGeometry jGeometry, double[] dArray, double[] dArray2, Connection connection, double d, int n) throws Exception, SQLException {
        JGeometry jGeometry2;
        Object object;
        Object object2;
        int n2 = 0;
        int n3 = 0;
        if (jGeometry.gtype != 3 || jGeometry.gtype != 3) {
            throw new Exception("54548");
        }
        if (jGeometry.elemInfo.length != 3) {
            throw new Exception("54549");
        }
        if (jGeometry.getElemInfo()[2] == 3) {
            object2 = connection.prepareCall("{ ? = call mdsys.sdo_util.expand_geom(?)}");
            object2.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
            object2.setObject(2, JGeometry.storeJS(jGeometry, connection));
            object2.execute();
            object = (Struct)object2.getObject(1);
            jGeometry = JGeometry.loadJS((Struct)object);
            object2.close();
        }
        int[] nArray = new int[jGeometry.elemInfo.length];
        double[] dArray3 = new double[jGeometry.ordinates.length / 2 * 3];
        nArray[0] = 1;
        nArray[1] = 1003;
        nArray[2] = 1;
        for (n2 = 0; n2 < jGeometry.ordinates.length / 2; ++n2) {
            dArray3[3 * n2] = jGeometry.ordinates[2 * n2];
            dArray3[3 * n2 + 1] = jGeometry.ordinates[2 * n2 + 1];
            dArray3[3 * n2 + 2] = 0.0;
        }
        object2 = new J3D_Geometry(3003, 0, nArray, dArray3);
        object = "";
        Object object3 = connection.prepareCall("begin ? := mdsys.sdo_geom.validate_geometry_with_context(?,?); end;");
        object3.registerOutParameter(1, 12);
        object3.setObject(2, JGeometry.storeJS(jGeometry, connection));
        object3.setDouble(3, d);
        object3.execute();
        object = object3.getString(1);
        object3.close();
        if (!((String)object).equals("TRUE")) {
            throw new Exception("54550 input 2D polygon not valid");
        }
        object3 = new double[1];
        double[] dArray4 = new double[3];
        J3D_Geometry.planeEquation(dArray4, (double[])object3, (J3D_Geometry)object2);
        double[] dArray5 = new double[]{0.0, 0.0, 1.0};
        if (J3D_Geometry.dotProduct(dArray4, dArray5) <= 0.0) {
            throw new Exception("13367");
        }
        if (dArray2.length != jGeometry.ordinates.length / 2 || dArray.length != jGeometry.ordinates.length / 2) {
            throw new Exception("54551");
        }
        for (n2 = 0; n2 < jGeometry.ordinates.length / 2; ++n2) {
            if (!(dArray[n2] > dArray2[n2])) continue;
            throw new Exception("54552");
        }
        double[] dArray6 = new double[jGeometry.ordinates.length / 2 * 3];
        double[] dArray7 = new double[jGeometry.ordinates.length / 2 * 3];
        double[] dArray8 = new double[(jGeometry.ordinates.length / 2 - 1) * 5 * 3];
        for (n2 = 0; n2 < jGeometry.ordinates.length / 2 - 1; ++n2) {
            dArray6[3 * n2] = jGeometry.ordinates[2 * n2];
            dArray6[3 * n2 + 1] = jGeometry.ordinates[2 * n2 + 1];
            dArray6[3 * n2 + 2] = dArray[n2];
            dArray7[3 * n2] = jGeometry.ordinates[2 * n2];
            dArray7[3 * n2 + 1] = jGeometry.ordinates[2 * n2 + 1];
            dArray7[3 * n2 + 2] = dArray2[n2];
            dArray8[15 * n2] = jGeometry.ordinates[2 * n2];
            dArray8[15 * n2 + 1] = jGeometry.ordinates[2 * n2 + 1];
            dArray8[15 * n2 + 2] = dArray[n2];
            dArray8[15 * n2 + 3] = jGeometry.ordinates[2 * (n2 + 1)];
            dArray8[15 * n2 + 4] = jGeometry.ordinates[2 * (n2 + 1) + 1];
            dArray8[15 * n2 + 5] = dArray[n2 + 1];
            dArray8[15 * n2 + 6] = jGeometry.ordinates[2 * (n2 + 1)];
            dArray8[15 * n2 + 7] = jGeometry.ordinates[2 * (n2 + 1) + 1];
            dArray8[15 * n2 + 8] = dArray2[n2 + 1];
            dArray8[15 * n2 + 9] = jGeometry.ordinates[2 * n2];
            dArray8[15 * n2 + 10] = jGeometry.ordinates[2 * n2 + 1];
            dArray8[15 * n2 + 11] = dArray2[n2];
            dArray8[15 * n2 + 12] = jGeometry.ordinates[2 * n2];
            dArray8[15 * n2 + 13] = jGeometry.ordinates[2 * n2 + 1];
            dArray8[15 * n2 + 14] = dArray[n2];
        }
        dArray6[3 * n2] = dArray6[0];
        dArray6[3 * n2 + 1] = dArray6[1];
        dArray6[3 * n2 + 2] = dArray6[2];
        dArray7[3 * n2] = dArray7[0];
        dArray7[3 * n2 + 1] = dArray7[1];
        dArray7[3 * n2 + 2] = dArray7[2];
        double[] dArray9 = new double[jGeometry.ordinates.length / 2 * 3];
        for (n2 = 0; n2 < dArray6.length / 3; ++n2) {
            dArray9[3 * n2] = dArray6[dArray6.length - 3 * n2 - 3];
            dArray9[3 * n2 + 1] = dArray6[dArray6.length - 3 * n2 - 2];
            dArray9[3 * n2 + 2] = dArray6[dArray6.length - 3 * n2 - 1];
        }
        nArray = new int[12 + 3 * (jGeometry.ordinates.length / 2 - 1)];
        dArray3 = new double[dArray9.length + dArray7.length + dArray8.length];
        nArray[0] = 1;
        nArray[1] = 1007;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1006;
        nArray[5] = 2 + (jGeometry.ordinates.length / 2 - 1);
        nArray[6] = 1;
        nArray[7] = 1003;
        nArray[8] = 1;
        nArray[9] = dArray9.length + 1;
        nArray[10] = 1003;
        nArray[11] = 1;
        for (n2 = 0; n2 < jGeometry.ordinates.length / 2 - 1; ++n2) {
            nArray[3 * n2 + 12] = 15 * n2 + 1 + dArray9.length + dArray7.length;
            nArray[3 * n2 + 13] = 1003;
            nArray[3 * n2 + 14] = 1;
        }
        for (n2 = 0; n2 < dArray9.length; ++n2) {
            dArray3[n2] = dArray9[n2];
        }
        for (n2 = 0; n2 < dArray7.length; ++n2) {
            dArray3[n2 + dArray9.length] = dArray7[n2];
        }
        for (n2 = 0; n2 < dArray8.length; ++n2) {
            dArray3[n2 + dArray9.length + dArray7.length] = dArray8[n2];
        }
        if (n != 0) {
            int n4 = 0;
            OracleResultSet oracleResultSet = null;
            Statement statement = connection.createStatement();
            oracleResultSet = (OracleResultSet)statement.executeQuery("select count(*) from sdo_coord_ref_sys where coord_ref_sys_kind in ('COMPOUND', 'GEOGRAPHIC3D') and srid = " + n);
            oracleResultSet.next();
            n4 = oracleResultSet.getInt(1);
            statement.close();
            if (n4 == 0) {
                throw new Exception("54668");
            }
            jGeometry2 = new JGeometry(3008, n, nArray, dArray3);
        } else if (jGeometry.srid == 0) {
            jGeometry2 = new JGeometry(3008, 0, nArray, dArray3);
        } else {
            CallableStatement callableStatement = connection.prepareCall("begin ? := mdsys.sdo_cs.convert_2d_srid_to_3d(?); end;");
            callableStatement.registerOutParameter(1, 4);
            callableStatement.setInt(2, jGeometry.srid);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
            if (n3 == 0) {
                throw new Exception("54558");
            }
            jGeometry2 = new JGeometry(3008, n3, nArray, dArray3);
            callableStatement.close();
        }
        return jGeometry2;
    }

    public static JGeometry appendToCollection(JGeometry jGeometry, JGeometry jGeometry2) throws Exception {
        JGeometry jGeometry3 = null;
        boolean bl = false;
        if (jGeometry == null) {
            if (jGeometry2.ordinates.length / 3 > 349525) {
                throw new Exception("13019");
            }
            int[] nArray = new int[jGeometry2.elemInfo.length];
            System.arraycopy(jGeometry2.elemInfo, 0, nArray, 0, jGeometry2.elemInfo.length);
            double[] dArray = new double[jGeometry2.ordinates.length];
            System.arraycopy(jGeometry2.ordinates, 0, dArray, 0, jGeometry2.ordinates.length);
            int n = jGeometry2.getSRID();
            jGeometry3 = new JGeometry(3004, n, nArray, dArray);
            return jGeometry3;
        }
        if (jGeometry.srid != jGeometry2.srid) {
            throw new Exception("13295");
        }
        if (jGeometry.gtype == 9) {
            if (jGeometry2.gtype != 8) {
                throw new Exception("54553");
            }
            if ((jGeometry.ordinates.length + jGeometry2.ordinates.length) / 3 > 349525) {
                throw new Exception("13019");
            }
            int[] nArray = new int[jGeometry.elemInfo.length + jGeometry2.elemInfo.length];
            double[] dArray = new double[jGeometry.ordinates.length + jGeometry2.ordinates.length];
            J3D_Geometry.getEiOrds(nArray, dArray, jGeometry, jGeometry2);
            jGeometry3 = new JGeometry(3009, jGeometry.srid, nArray, dArray);
            return jGeometry3;
        }
        if (jGeometry.gtype == 7 || jGeometry.gtype == 7) {
            if (jGeometry2.gtype != 3 && jGeometry2.gtype != 3) {
                throw new Exception("54553");
            }
            if ((jGeometry.ordinates.length + jGeometry2.ordinates.length) / 3 > 349525) {
                throw new Exception("13019");
            }
            int[] nArray = new int[jGeometry.elemInfo.length + jGeometry2.elemInfo.length];
            double[] dArray = new double[jGeometry.ordinates.length + jGeometry2.ordinates.length];
            J3D_Geometry.getEiOrds(nArray, dArray, jGeometry, jGeometry2);
            jGeometry3 = new JGeometry(3007, jGeometry.srid, nArray, dArray);
            return jGeometry3;
        }
        if (jGeometry.gtype == 6) {
            if (jGeometry2.gtype != 2) {
                throw new Exception("54553");
            }
            if ((jGeometry.ordinates.length + jGeometry2.ordinates.length) / 3 > 349525) {
                throw new Exception("13019");
            }
            int[] nArray = new int[jGeometry.elemInfo.length + jGeometry2.elemInfo.length];
            double[] dArray = new double[jGeometry.ordinates.length + jGeometry2.ordinates.length];
            J3D_Geometry.getEiOrds(nArray, dArray, jGeometry, jGeometry2);
            jGeometry3 = new JGeometry(3006, jGeometry.srid, nArray, dArray);
            return jGeometry3;
        }
        if (jGeometry.gtype == 5) {
            if (jGeometry2.gtype != 1) {
                throw new Exception("54553");
            }
            if ((jGeometry.ordinates.length + jGeometry2.ordinates.length) / 3 > 349525) {
                throw new Exception("13019");
            }
            int[] nArray = new int[jGeometry.elemInfo.length + jGeometry2.elemInfo.length];
            double[] dArray = new double[jGeometry.ordinates.length + jGeometry2.ordinates.length];
            J3D_Geometry.getEiOrds(nArray, dArray, jGeometry, jGeometry2);
            jGeometry3 = new JGeometry(3005, jGeometry.srid, nArray, dArray);
            return jGeometry3;
        }
        if (jGeometry.gtype == 4) {
            if ((jGeometry.ordinates.length + jGeometry2.ordinates.length) / 3 > 349525) {
                throw new Exception("13019");
            }
            int[] nArray = new int[jGeometry.elemInfo.length + jGeometry2.elemInfo.length];
            double[] dArray = new double[jGeometry.ordinates.length + jGeometry2.ordinates.length];
            J3D_Geometry.getEiOrds(nArray, dArray, jGeometry, jGeometry2);
            jGeometry3 = new JGeometry(3004, jGeometry.srid, nArray, dArray);
            return jGeometry3;
        }
        throw new Exception("54553");
    }

    private static void getEiOrds(int[] nArray, double[] dArray, JGeometry jGeometry, JGeometry jGeometry2) throws Exception {
        int n = 0;
        for (n = 0; n < jGeometry.elemInfo.length; ++n) {
            nArray[n] = jGeometry.elemInfo[n];
        }
        for (n = 0; n < jGeometry2.elemInfo.length; ++n) {
            nArray[n + jGeometry.elemInfo.length] = n % 3 == 0 ? jGeometry2.elemInfo[n] + jGeometry.ordinates.length : jGeometry2.elemInfo[n];
        }
        for (n = 0; n < jGeometry.ordinates.length; ++n) {
            dArray[n] = jGeometry.ordinates[n];
        }
        for (n = 0; n < jGeometry2.ordinates.length; ++n) {
            dArray[n + jGeometry.ordinates.length] = jGeometry2.ordinates[n];
        }
    }

    public J3D_Geometry centroid3d(double d) throws Exception {
        int n;
        Object object;
        J3D_Geometry j3D_Geometry;
        int n2;
        Cloneable cloneable;
        Object object2;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        J3D_Geometry j3D_Geometry2 = new J3D_Geometry(1, this.getSRID(), new int[]{1, 1, 1}, dArray);
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        double d2 = 0.0;
        double d3 = 0.0;
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        if (this.gtype == 4 || this.gtype == 6 || this.gtype == 2) {
            j3D_Geometry2 = null;
            return j3D_Geometry2;
        }
        if (this.gtype == 9 || this.gtype == 7 || this.gtype == 5 || this.elemInfo[1] % 1000 == 8 || this.elemInfo[1] % 1000 == 6) {
            object2 = new ElementExtractor(this, 0, 0, 3, false);
            nArray[0] = 0;
            while ((cloneable = ((ElementExtractor)object2).nextElement(nArray)) != null) {
                arrayList.add((J3D_Geometry)cloneable);
            }
            if (this.gtype != 5) {
                double[][] dArray3 = new double[3][2];
                dArray3 = J3D_Geometry.getMBH(this);
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray2[n2] = (dArray3[n2][0] + dArray3[n2][1]) / 2.0;
                }
            }
        } else {
            arrayList.add(this);
            if (this.gtype != 1) {
                object2 = new double[3][2];
                object2 = J3D_Geometry.getMBH(this);
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray2[n2] = (double)((object2[n2][0] + object2[n2][1]) / 2.0);
                }
            }
        }
        object2 = new ArrayList();
        cloneable = new ArrayList();
        boolean bl = false;
        block3: for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Object object3;
            j3D_Geometry = (J3D_Geometry)arrayList.get(n2);
            if (j3D_Geometry.gtype != 1) {
                int n3 = j3D_Geometry.getType();
                int n4 = j3D_Geometry.getSRID();
                object3 = new int[j3D_Geometry.elemInfo.length];
                object = new double[j3D_Geometry.ordinates.length];
                for (n = 0; n < j3D_Geometry.elemInfo.length; ++n) {
                    object3[n] = j3D_Geometry.elemInfo[n];
                }
                for (n = 0; n < j3D_Geometry.ordinates.length / 3; ++n) {
                    object[3 * n] = j3D_Geometry.ordinates[3 * n] - dArray2[0];
                    object[3 * n + 1] = j3D_Geometry.ordinates[3 * n + 1] - dArray2[1];
                    object[3 * n + 2] = j3D_Geometry.ordinates[3 * n + 2] - dArray2[2];
                }
                j3D_Geometry = new J3D_Geometry(n3, n4, (int[])object3, (double[])object);
            }
            if (j3D_Geometry.gtype != 8) {
                if (j3D_Geometry.gtype == 3) {
                    int n5;
                    ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
                    ArrayList<double[]> arrayList3 = new ArrayList<double[]>();
                    object3 = new ElementExtractor(j3D_Geometry, 0, 1, 3, false);
                    nArray[0] = 0;
                    while (true) {
                        J3D_Geometry j3D_Geometry3 = ((ElementExtractor)object3).nextElement(nArray);
                        object = j3D_Geometry3;
                        if (j3D_Geometry3 == null) break;
                        if (nArray[0] == 2) {
                            arrayList2.add((double[])object);
                            continue;
                        }
                        arrayList3.add((double[])object);
                    }
                    J3D_Geometry j3D_Geometry4 = (J3D_Geometry)arrayList3.get(0);
                    double d4 = Math.abs(j3D_Geometry4.getAreaPolygon());
                    double[] dArray4 = new double[]{0.0, 0.0, 0.0};
                    d3 += d4;
                    int n6 = j3D_Geometry4.ordinates.length / 3 - 1;
                    for (n = 0; n < 3; ++n) {
                        for (n5 = 0; n5 < n6; ++n5) {
                            int n7 = n;
                            dArray4[n7] = dArray4[n7] + j3D_Geometry4.ordinates[3 * n5 + n];
                        }
                        int n8 = n;
                        dArray4[n8] = dArray4[n8] / (double)n6;
                        dArray[n] = (dArray[n] * (d3 - d4) + dArray4[n] * d4) / d3;
                    }
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        j3D_Geometry4 = (J3D_Geometry)arrayList2.get(i);
                        d4 = Math.abs(j3D_Geometry4.getAreaPolygon());
                        dArray4 = new double[]{0.0, 0.0, 0.0};
                        d3 -= d4;
                        n6 = j3D_Geometry4.ordinates.length / 3 - 1;
                        for (n = 0; n < 3; ++n) {
                            for (n5 = 0; n5 < n6; ++n5) {
                                int n9 = n;
                                dArray4[n9] = dArray4[n9] + j3D_Geometry4.ordinates[3 * n5 + n];
                            }
                            int n10 = n;
                            dArray4[n10] = dArray4[n10] / (double)n6;
                            dArray[n] = (dArray[n] * (d3 + d4) - dArray4[n] * d4) / d3;
                        }
                    }
                }
                if (j3D_Geometry.gtype != 1) continue;
                for (n = 0; n < 3; ++n) {
                    dArray[n] = (dArray[n] * (double)n2 + j3D_Geometry.ordinates[n]) / (double)(n2 + 1);
                }
                continue;
            }
            bl = true;
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 2, 3, false);
            nArray[0] = 0;
            J3D_Geometry j3D_Geometry5 = elementExtractor.nextElement(nArray);
            object3 = new ElementExtractor(j3D_Geometry5, 0, 1, 3, false);
            nArray[0] = 0;
            while (true) {
                J3D_Geometry j3D_Geometry6 = ((ElementExtractor)object3).nextElement(nArray);
                object = j3D_Geometry6;
                if (j3D_Geometry6 == null) continue block3;
                if (nArray[0] == 2) {
                    ((ArrayList)cloneable).add(object);
                    continue;
                }
                ((ArrayList)object2).add(object);
            }
        }
        if (!bl) {
            if (((J3D_Geometry)arrayList.get(0)).getType() != 1) {
                for (n = 0; n < 3; ++n) {
                    int n11 = n;
                    dArray[n11] = dArray[n11] + dArray2[n];
                }
            }
            j3D_Geometry2 = new J3D_Geometry(1, this.getSRID(), new int[]{1, 1, 1}, dArray);
            return j3D_Geometry2;
        }
        for (n2 = 0; n2 < ((ArrayList)object2).size(); ++n2) {
            j3D_Geometry = (J3D_Geometry)((ArrayList)object2).get(n2);
            double[] dArray5 = new double[]{0.0, 0.0, 0.0};
            double d5 = J3D_Geometry.volumeIntegrals(j3D_Geometry, dArray5);
            d2 += d5;
            object = new double[]{0.0, 0.0, 0.0};
            object[0] = dArray5[0] / d5;
            object[1] = dArray5[1] / d5;
            object[2] = dArray5[2] / d5;
            for (n = 0; n < 3; ++n) {
                dArray[n] = (dArray[n] * (d2 - d5) + object[n] * d5) / d2;
            }
        }
        for (n2 = 0; n2 < ((ArrayList)cloneable).size(); ++n2) {
            j3D_Geometry = (J3D_Geometry)((ArrayList)cloneable).get(n2);
            double[] dArray6 = new double[]{0.0, 0.0, 0.0};
            double d6 = J3D_Geometry.volumeIntegrals(j3D_Geometry, dArray6);
            d2 += d6;
            object = new double[]{0.0, 0.0, 0.0};
            object[0] = dArray6[0] / d6;
            object[1] = dArray6[1] / d6;
            object[2] = dArray6[2] / d6;
            for (n = 0; n < 3; ++n) {
                dArray[n] = (dArray[n] * (d2 - d6) + object[n] * d6) / d2;
            }
        }
        for (n = 0; n < 3; ++n) {
            int n12 = n;
            dArray[n12] = dArray[n12] + dArray2[n];
        }
        j3D_Geometry2 = new J3D_Geometry(1, this.getSRID(), new int[]{1, 1, 1}, dArray);
        return j3D_Geometry2;
    }

    public boolean inside3d(J3D_Geometry j3D_Geometry, double d) throws Exception {
        String string = "FALSE";
        return this.inside3d(j3D_Geometry, d, string);
    }

    public boolean inside3d(J3D_Geometry j3D_Geometry, double d, String string) throws Exception {
        Object object;
        J3D_Geometry j3D_Geometry2;
        Object object2;
        J3D_Geometry j3D_Geometry3;
        Cloneable cloneable;
        ArrayList<J3D_Geometry> arrayList;
        ArrayList arrayList2;
        ArrayList<J3D_Geometry> arrayList3;
        Object object3;
        Object object4;
        Object object5;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[1];
        boolean bl = false;
        int[] nArray2 = new int[this.elemInfo.length];
        System.arraycopy(this.elemInfo, 0, nArray2, 0, this.elemInfo.length);
        double[] dArray = new double[this.ordinates.length];
        System.arraycopy(this.ordinates, 0, dArray, 0, this.ordinates.length);
        int n5 = this.getSRID();
        J3D_Geometry j3D_Geometry4 = new J3D_Geometry(this.getType(), n5, nArray2, dArray);
        int[] nArray3 = new int[j3D_Geometry.elemInfo.length];
        System.arraycopy(j3D_Geometry.elemInfo, 0, nArray3, 0, j3D_Geometry.elemInfo.length);
        double[] dArray2 = new double[j3D_Geometry.ordinates.length];
        System.arraycopy(j3D_Geometry.ordinates, 0, dArray2, 0, j3D_Geometry.ordinates.length);
        int n6 = j3D_Geometry.getSRID();
        J3D_Geometry j3D_Geometry5 = new J3D_Geometry(j3D_Geometry.getType(), n6, nArray3, dArray2);
        if (string.equals("TRUE")) {
            int n7;
            int n8;
            if (d < 0.05) {
                d = 0.05;
            }
            if (((double[][])(object5 = (Object)j3D_Geometry4.getMBR())).length != ((double[][])(object4 = (Object)j3D_Geometry5.getMBR())).length) {
                throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
            }
            object3 = new double[((double[][])object5).length];
            for (n8 = 0; n8 < ((double[][])object5).length; ++n8) {
                object3[n8] = 0.0;
            }
            for (n8 = 0; n8 < ((double[][])object5).length / 2; ++n8) {
                for (n7 = 0; n7 < 2; ++n7) {
                    object3[((double[][])object5).length / 2 * n7 + n8] = (object5[((double[][])object5).length / 2 * n7 + n8] + object4[((double[][])object4).length / 2 * n7 + n8]) / 2.0;
                }
            }
            arrayList3 = (ArrayList<J3D_Geometry>)new double[((double[])object3).length / 2];
            for (n7 = 0; n7 < ((double[])object3).length / 2; ++n7) {
                arrayList3[n7] = (object3[n7 + ((Object)object3).length / 2] + object3[n7]) / 2.0;
            }
            double d2 = Math.PI / 180 * arrayList3[0];
            double d3 = Math.PI / 180 * arrayList3[1];
            j3D_Geometry4 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry4, d2, d3);
            j3D_Geometry5 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry5, d2, d3);
        }
        object5 = new double[3][2];
        object4 = new double[3][2];
        object5 = J3D_Geometry.getMBH(j3D_Geometry4);
        if (!this.ImbhAB((double[][])object5, (double[][])(object4 = J3D_Geometry.getMBH(j3D_Geometry5)), d)) {
            return false;
        }
        object3 = new ArrayList();
        if (j3D_Geometry4.gtype == 9 || j3D_Geometry4.gtype == 7 || j3D_Geometry4.gtype == 6 || j3D_Geometry4.elemInfo[1] % 1000 == 2 && j3D_Geometry4.ordinates.length != 6 || j3D_Geometry4.gtype == 5 || j3D_Geometry4.elemInfo[1] % 1000 == 8 || j3D_Geometry4.elemInfo[1] % 1000 == 6 || j3D_Geometry4.gtype == 4) {
            J3D_Geometry j3D_Geometry6;
            arrayList3 = new ElementExtractor(j3D_Geometry4, 0, 0, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry6 = ((ElementExtractor)((Object)arrayList3)).nextElement(nArray)) != null) {
                ((ArrayList)object3).add(j3D_Geometry6);
            }
        } else {
            ((ArrayList)object3).add(j3D_Geometry4);
        }
        arrayList3 = new ArrayList<J3D_Geometry>();
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            J3D_Geometry j3D_Geometry7 = (J3D_Geometry)((ArrayList)object3).get(n);
            if (j3D_Geometry7.gtype == 8) {
                arrayList2 = new ArrayList();
                arrayList2 = j3D_Geometry7.getFaces2(false);
                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                    J3D_Geometry j3D_Geometry8 = (J3D_Geometry)arrayList2.get(n2);
                    arrayList3.add(j3D_Geometry8);
                }
                continue;
            }
            arrayList3.add(j3D_Geometry7);
        }
        ArrayList<ArrayList> arrayList4 = new ArrayList<ArrayList>();
        for (n = 0; n < arrayList3.size(); ++n) {
            arrayList2 = (J3D_Geometry)arrayList3.get(n);
            boolean bl2 = false;
            for (int i = 0; i < ((J3D_Geometry)((Object)arrayList2)).elemInfo.length; i += 3) {
                if (((J3D_Geometry)((Object)arrayList2)).elemInfo[i + 1] / 1000 != 2) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                ElementExtractor elementExtractor = new ElementExtractor((J3D_Geometry)((Object)arrayList2), 0, 1, 3, false);
                nArray[0] = 0;
                while ((arrayList = elementExtractor.nextElement(nArray)) != null) {
                    if (nArray[0] == 2) continue;
                    arrayList4.add(arrayList);
                }
                continue;
            }
            arrayList4.add(arrayList2);
        }
        arrayList2 = new ArrayList();
        for (n = 0; n < arrayList4.size(); ++n) {
            J3D_Geometry j3D_Geometry9 = (J3D_Geometry)arrayList4.get(n);
            if (j3D_Geometry9.gtype == 3) {
                if (j3D_Geometry9.getElemInfo()[2] == 3) {
                    ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry9, 0, 1, 3, false);
                    nArray[0] = 0;
                    j3D_Geometry9 = elementExtractor.nextElement(nArray);
                }
                arrayList2.add(j3D_Geometry9);
                continue;
            }
            arrayList2.add(j3D_Geometry9);
        }
        boolean bl3 = false;
        ArrayList<J3D_Geometry> arrayList5 = new ArrayList<J3D_Geometry>();
        if (j3D_Geometry5.gtype == 9 || j3D_Geometry5.gtype == 7 || j3D_Geometry5.gtype == 6 || j3D_Geometry5.elemInfo[1] % 1000 == 2 && j3D_Geometry5.ordinates.length != 6 || j3D_Geometry5.gtype == 5 || j3D_Geometry5.elemInfo[1] % 1000 == 8 || j3D_Geometry5.elemInfo[1] % 1000 == 6 || j3D_Geometry5.gtype == 4) {
            arrayList = new ElementExtractor(j3D_Geometry5, 0, 0, 3, false);
            nArray[0] = 0;
            while ((cloneable = ((ElementExtractor)((Object)arrayList)).nextElement(nArray)) != null) {
                arrayList5.add((J3D_Geometry)cloneable);
            }
        } else {
            arrayList5.add(j3D_Geometry5);
        }
        arrayList = new ArrayList<J3D_Geometry>();
        cloneable = new ArrayList();
        bl3 = false;
        for (n = 0; n < arrayList5.size(); ++n) {
            J3D_Geometry j3D_Geometry10;
            j3D_Geometry3 = (J3D_Geometry)arrayList5.get(n);
            if (j3D_Geometry3.gtype != 8) continue;
            bl3 = true;
            object2 = new ElementExtractor(j3D_Geometry3, 0, 2, 3, false);
            nArray[0] = 0;
            j3D_Geometry2 = ((ElementExtractor)object2).nextElement(nArray);
            object = new ElementExtractor(j3D_Geometry2, 0, 1, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry10 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    ((ArrayList)cloneable).add(j3D_Geometry10);
                    continue;
                }
                arrayList.add(j3D_Geometry10);
            }
        }
        if (!bl3) {
            return false;
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            j3D_Geometry3 = (J3D_Geometry)arrayList2.get(n3);
            for (n = 0; n <= j3D_Geometry3.ordinates.length / 3 - 1; ++n) {
                object2 = new J3D_Geometry(1, j3D_Geometry3.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry3.ordinates[3 * n], j3D_Geometry3.ordinates[3 * n + 1], j3D_Geometry3.ordinates[3 * n + 2]});
                bl = false;
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    j3D_Geometry2 = (J3D_Geometry)arrayList.get(n4);
                    if (!super.pointInSolid(j3D_Geometry2, false, d)) continue;
                    bl = true;
                    for (n2 = 0; n2 < ((ArrayList)cloneable).size(); ++n2) {
                        object = (J3D_Geometry)((ArrayList)cloneable).get(n2);
                        if (!super.pointInOnSolid((J3D_Geometry)object, false, d)) continue;
                        return false;
                    }
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    protected int getFirstEtype() throws Exception {
        return this.getElemInfo()[1];
    }

    public J3D_Geometry getElementByLabel(String string) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        String string2 = "";
        n3 = 0;
        n4 = 0;
        if (!string.substring(0, 1).equals(",")) {
            string2 = ",";
            string = string2.concat(string);
        }
        string2 = "";
        while (string.indexOf(",") != -1) {
            string2 = string.substring(string.indexOf(",") + 1);
            if (string2.indexOf(",") == -1) {
                n4 = Integer.valueOf(string2);
            } else {
                String string3 = string2.substring(0, string2.indexOf(","));
                n4 = Integer.valueOf(string3);
                string2 = string2.substring(string2.indexOf(","));
            }
            string = string2;
            switch (n3 + 1) {
                case 1: {
                    if (n4 < 0) {
                        throw new Exception("16549: invalid string (label)");
                    }
                    n11 = n4;
                    break;
                }
                case 2: {
                    if (n4 < 0) {
                        throw new Exception("16549: invalid string (label)");
                    }
                    n10 = n4;
                    break;
                }
                case 3: {
                    if (n4 < 0) {
                        throw new Exception("16549: invalid string (label)");
                    }
                    n9 = n4;
                    break;
                }
                case 4: {
                    if (n4 < 0) {
                        throw new Exception("16549: invalid string (label)");
                    }
                    n8 = n4;
                    break;
                }
                case 5: {
                    if (n4 < 0) {
                        throw new Exception("16549: invalid string (label)");
                    }
                    n7 = n4;
                    break;
                }
                case 6: {
                    if (n4 < 0) {
                        throw new Exception("16549: invalid string (label)");
                    }
                    n6 = n4;
                    break;
                }
                case 7: {
                    if (n4 < 0) {
                        throw new Exception("16549: invalid string (label)");
                    }
                    n5 = n4;
                }
            }
            ++n3;
        }
        n2 = n3;
        return this.findTargetGeom(n5, n6, n7, n8, n9, n10, n11, n, n2);
    }

    private J3D_Geometry findTargetGeom(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws Exception {
        ElementExtractor elementExtractor;
        int n10 = 0;
        J3D_Geometry j3D_Geometry = null;
        J3D_Geometry j3D_Geometry2 = null;
        J3D_Geometry j3D_Geometry3 = null;
        J3D_Geometry j3D_Geometry4 = null;
        J3D_Geometry j3D_Geometry5 = null;
        J3D_Geometry j3D_Geometry6 = null;
        int[] nArray = new int[1];
        int n11 = this.getElemInfo()[1] % 1000;
        int n12 = this.getType();
        if (n12 == 4) {
            ElementExtractor elementExtractor2 = new ElementExtractor(this);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n; ++n10) {
                j3D_Geometry = elementExtractor2.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (j3D_Geometry.getElemInfo()[1] % 1000 == 7 && n2 != 1 || j3D_Geometry.getElemInfo()[1] % 1000 == 6 && (n2 != 0 || n3 != 0) || j3D_Geometry.getElemInfo()[1] % 1000 == 3 && (n2 != 0 || n3 != 0 || n4 != 0) || j3D_Geometry.getElemInfo()[1] % 1000 == 2 && (n2 != 0 || n3 != 0 || n4 != 0 || n5 != 0) || j3D_Geometry.getElemInfo()[1] % 1000 == 1 && (n2 != 0 || n3 != 0 || n4 != 0 || n5 != 0 || n6 != 0) || j3D_Geometry.getElemInfo()[1] % 1000 == 1 && n7 != 1) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0 && n7 == 0) {
                return j3D_Geometry;
            }
            return j3D_Geometry.findTargetGeom(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        if (n12 == 9) {
            ElementExtractor elementExtractor3 = new ElementExtractor(this);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n; ++n10) {
                j3D_Geometry = elementExtractor3.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (j3D_Geometry.getElemInfo()[1] % 1000 == 7 && n2 > 1) {
                throw new Exception("16549: invalid string (label)");
            }
            if (j3D_Geometry.getElemInfo()[1] % 1000 == 7 && n2 == 0 && (n3 != 0 || n4 != 0 || n5 != 0 || n6 != 0 || n7 != 0)) {
                throw new Exception("16549: invalid string (label)");
            }
            if ((n2 == 0 || j3D_Geometry.getElemInfo()[1] % 1000 == 7 && n2 == 1) && n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0 && n7 == 0) {
                return j3D_Geometry;
            }
            return j3D_Geometry.findTargetGeom(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        if (n12 != 9 && n12 != 4 && n11 == 8) {
            if (n8 == 0 && n9 != 6) {
                throw new Exception("16549: invalid string (label)");
            }
            ElementExtractor elementExtractor4 = new ElementExtractor(this);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n2; ++n10) {
                j3D_Geometry = elementExtractor4.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0 && n7 == 0) {
                return j3D_Geometry;
            }
            return j3D_Geometry.findTargetGeom(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        if (n12 != 9 && n12 != 4 && n11 != 8 && n11 == 7) {
            if (n8 == 0 && n9 != 5) {
                throw new Exception("16549: invalid string (label)");
            }
            ElementExtractor elementExtractor5 = new ElementExtractor(this, 0, 2, 3);
            nArray[0] = 0;
            j3D_Geometry2 = elementExtractor5.nextElement(nArray);
            ElementExtractor elementExtractor6 = new ElementExtractor(j3D_Geometry2, 0, 1, 3);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n3; ++n10) {
                j3D_Geometry3 = elementExtractor6.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry3 == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n4 == 0 && n5 == 0 && n6 == 0 && n7 == 0) {
                return j3D_Geometry3.reverseOrientation();
            }
            elementExtractor = new ElementExtractor(j3D_Geometry3, 0, 0, 3);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n4; ++n10) {
                j3D_Geometry4 = elementExtractor.nextElement(nArray);
            }
            if (j3D_Geometry4 == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n5 > 1) {
                throw new Exception("16549: invalid string (label)");
            }
            if ((n5 == 0 || n5 == 1) && n6 == 0 && n7 == 0) {
                return j3D_Geometry4.reverseOrientation();
            }
            elementExtractor = new ElementExtractor(j3D_Geometry4, 0, 2, 3);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n6; ++n10) {
                j3D_Geometry5 = elementExtractor.nextElement(nArray);
            }
            if (j3D_Geometry5 == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n7 > 2) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n7 == 0) {
                return j3D_Geometry5;
            }
            if (n7 == 1 || n7 == 2) {
                double[] dArray = new double[3];
                if (n7 == 1) {
                    dArray[0] = j3D_Geometry5.ordinates[0];
                    dArray[1] = j3D_Geometry5.ordinates[1];
                    dArray[2] = j3D_Geometry5.ordinates[2];
                } else {
                    dArray[0] = j3D_Geometry5.ordinates[3];
                    dArray[1] = j3D_Geometry5.ordinates[4];
                    dArray[2] = j3D_Geometry5.ordinates[5];
                }
                int[] nArray2 = new int[]{1, 1, 1};
                j3D_Geometry6 = new J3D_Geometry(1, 0, nArray2, dArray);
                return j3D_Geometry6;
            }
        }
        if (n12 == 7) {
            if (n2 != 0) {
                throw new Exception("16549: invalid string (label)");
            }
            elementExtractor = new ElementExtractor(this);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n; ++n10) {
                j3D_Geometry = elementExtractor.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (j3D_Geometry.getElemInfo()[1] % 1000 == 6 && n3 > 1 || j3D_Geometry.getElemInfo()[1] % 1000 == 3 && n4 > 1) {
                throw new Exception("16549: invalid string (label)");
            }
            if (!(n2 != 0 || n3 != 0 && n3 != 1 || n4 != 0 && n4 != 1 || n5 != 0 || n6 != 0 || n7 != 0)) {
                return j3D_Geometry;
            }
            return j3D_Geometry.findTargetGeom(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        if (n12 != 7 && n12 != 4 && n11 == 6) {
            if (n8 == 0 && n9 != 4) {
                throw new Exception("16549: invalid string (label)");
            }
            elementExtractor = new ElementExtractor(this, 0, 0, 3);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n4; ++n10) {
                j3D_Geometry = elementExtractor.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n5 == 0 && n6 == 0 && n7 == 0) {
                return j3D_Geometry;
            }
            return j3D_Geometry.findTargetGeom(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        if (n12 != 7 && n12 != 4 && n11 != 6 && n11 == 3) {
            if (n8 == 0 && n9 != 3) {
                throw new Exception("16549: invalid string (label)");
            }
            elementExtractor = new ElementExtractor(this, 0, 1, 3);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n5; ++n10) {
                j3D_Geometry = elementExtractor.nextElement(nArray);
            }
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n6 == 0 && n7 == 0) {
                return j3D_Geometry.reverseOrientation();
            }
            elementExtractor = new ElementExtractor(j3D_Geometry, 0, 2, 3);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n6; ++n10) {
                j3D_Geometry5 = elementExtractor.nextElement(nArray);
            }
            if (j3D_Geometry5 == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n7 > 2) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n7 == 0) {
                return j3D_Geometry5;
            }
            if (n7 == 1 || n7 == 2) {
                double[] dArray = new double[3];
                if (n7 == 1) {
                    dArray[0] = j3D_Geometry5.ordinates[0];
                    dArray[1] = j3D_Geometry5.ordinates[1];
                    dArray[2] = j3D_Geometry5.ordinates[2];
                } else {
                    dArray[0] = j3D_Geometry5.ordinates[3];
                    dArray[1] = j3D_Geometry5.ordinates[4];
                    dArray[2] = j3D_Geometry5.ordinates[5];
                }
                int[] nArray3 = new int[]{1, 1, 1};
                j3D_Geometry6 = new J3D_Geometry(1, 0, nArray3, dArray);
                return j3D_Geometry6;
            }
        }
        if (n12 == 6) {
            if (n2 != 0 || n3 != 0 || n4 != 0 || n5 != 0) {
                throw new Exception("16549: invalid string (label)");
            }
            elementExtractor = new ElementExtractor(this);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n; ++n10) {
                j3D_Geometry = elementExtractor.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n7 == 0) {
                return j3D_Geometry;
            }
            return j3D_Geometry.findTargetGeom(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        if (n12 != 6 && n12 != 4 && n11 == 2 && this.getOrdinatesArray().length > 6) {
            if (n8 == 0 && n9 != 2) {
                throw new Exception("16549: invalid string (label)");
            }
            elementExtractor = new ElementExtractor(this);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n6; ++n10) {
                j3D_Geometry = elementExtractor.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n7 == 0) {
                return j3D_Geometry;
            }
            return j3D_Geometry.findTargetGeom(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        if (n12 != 6 && n12 != 4 && n11 == 2 && this.getOrdinatesArray().length == 6) {
            if (n8 == 0 && n9 != 2) {
                throw new Exception("16549: invalid string (label)");
            }
            if (n7 == 1 || n7 == 2) {
                double[] dArray = new double[3];
                if (n7 == 1) {
                    dArray[0] = this.ordinates[0];
                    dArray[1] = this.ordinates[1];
                    dArray[2] = this.ordinates[2];
                } else {
                    dArray[0] = this.ordinates[3];
                    dArray[1] = this.ordinates[4];
                    dArray[2] = this.ordinates[5];
                }
                int[] nArray4 = new int[]{1, 1, 1};
                j3D_Geometry6 = new J3D_Geometry(1, 0, nArray4, dArray);
                return j3D_Geometry6;
            }
            if (n7 == 0) {
                return this;
            }
            throw new Exception("16549: invalid string (label)");
        }
        if (n12 == 5) {
            if (n != 0 || n2 != 0 || n3 != 0 || n4 != 0 || n5 != 0 || n6 != 0 || n9 != 1) {
                throw new Exception("16549: invalid string (label)");
            }
            elementExtractor = new ElementExtractor(this);
            nArray[0] = 0;
            for (n10 = 1; n10 <= n7; ++n10) {
                j3D_Geometry = elementExtractor.nextElement(nArray);
            }
            ++n8;
            if (j3D_Geometry == null) {
                throw new Exception("16549: invalid string (label)");
            }
            return j3D_Geometry.findTargetGeom(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        if (n12 == 1) {
            if (n8 == 0 && (n9 != 1 || n7 != 1)) {
                throw new Exception("16549: invalid string (label)");
            }
            return this;
        }
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        int[] nArray5 = new int[]{1, 1, 1};
        J3D_Geometry j3D_Geometry7 = new J3D_Geometry(1, 0, nArray5, dArray);
        return j3D_Geometry7;
    }

    private J3D_Geometry reverseOrientation() throws Exception {
        Object object;
        int n = this.getFirstEtype();
        if (Math.floor(n / 1000) != 2.0) {
            return this;
        }
        J3D_Geometry j3D_Geometry = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getElemInfo().length;
        int[] nArray = new int[n5];
        for (n2 = 0; n2 < n5 / 3; ++n2) {
            nArray[3 * n2] = this.getElemInfo()[3 * n2];
            if (Math.floor(this.getElemInfo()[3 * n2 + 1] / 1000) == 2.0) {
                nArray[3 * n2 + 1] = 1000 + this.getElemInfo()[3 * n2 + 1] % 10;
            }
            nArray[3 * n2 + 2] = this.getElemInfo()[3 * n2 + 2];
        }
        if (n == 2003) {
            double[] dArray = new double[this.getOrdinatesArray().length];
            for (int i = 0; i < this.getOrdinatesArray().length / 3; ++i) {
                dArray[3 * i] = this.getOrdinatesArray()[this.getOrdinatesArray().length - 3 * i - 3];
                dArray[3 * i + 1] = this.getOrdinatesArray()[this.getOrdinatesArray().length - 3 * i - 2];
                dArray[3 * i + 2] = this.getOrdinatesArray()[this.getOrdinatesArray().length - 3 * i - 1];
            }
            j3D_Geometry = new J3D_Geometry(this.getType(), this.getSRID(), nArray, dArray);
            return j3D_Geometry;
        }
        J3D_Geometry j3D_Geometry2 = new J3D_Geometry(this.getType(), this.getSRID(), nArray, this.getOrdinatesArray());
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        int[] nArray2 = new int[1];
        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry2);
        nArray2[0] = 0;
        int n6 = j3D_Geometry2.getElemInfo()[2];
        for (n2 = 0; n2 < n6; ++n2) {
            arrayList.add(elementExtractor.nextElement(nArray2));
        }
        JGeometry jGeometry = null;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object = (J3D_Geometry)arrayList.get(n2);
            JGeometry jGeometry2 = null;
            int n7 = ((JGeometry)object).getOrdinatesArray().length;
            double[] dArray = new double[n7];
            for (n4 = 0; n4 < n7 / 3; ++n4) {
                dArray[3 * n4] = ((JGeometry)object).getOrdinatesArray()[n7 - 3 * n4 - 3];
                dArray[3 * n4 + 1] = ((JGeometry)object).getOrdinatesArray()[n7 - 3 * n4 - 2];
                dArray[3 * n4 + 2] = ((JGeometry)object).getOrdinatesArray()[n7 - 3 * n4 - 1];
            }
            jGeometry2 = new JGeometry(((JGeometry)object).getType(), ((JGeometry)object).getSRID(), ((JGeometry)object).getElemInfo(), dArray);
            jGeometry = J3D_Geometry.appendToCollection(jGeometry, jGeometry2);
        }
        object = new int[3 + jGeometry.getElemInfo().length];
        object[0] = true;
        object[1] = 1006;
        object[2] = n6;
        n4 = 3;
        for (n3 = 0; n3 < jGeometry.getElemInfo().length; ++n3) {
            object[n4] = jGeometry.getElemInfo()[n3];
            ++n4;
        }
        j3D_Geometry = new J3D_Geometry(3, this.getSRID(), (int[])object, jGeometry.getOrdinatesArray());
        return j3D_Geometry;
    }

    public String getLabelByElement(J3D_Geometry j3D_Geometry, double d) throws Exception {
        Cloneable cloneable;
        Object object;
        Object object2 = "";
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 1;
        int n4 = 2;
        int n5 = 0;
        int n6 = 0;
        ArrayList arrayList = new ArrayList();
        int n7 = this.getType();
        int n8 = this.getFirstEtype() % 1000;
        int n9 = j3D_Geometry.getType();
        int n10 = j3D_Geometry.getFirstEtype() % 1000;
        String string = "";
        if (n9 == 4 || n9 == 9 || n9 == 7 || n9 == 6 || n9 == 5) {
            return "54560, 0000, query element can not be collection or multi type geometry";
        }
        if (this.equals3d(j3D_Geometry, d)) {
            return "54559, 0000, query element and source geometry can not be the same";
        }
        if (n9 == 8 && n10 == 8 && (n7 != 8 || n8 != 8) && n7 != 9 && n7 != 4) {
            return "54666, 0000, query gtype is a superset of the source geometry";
        }
        if (!(n9 != 8 || n10 != 7 || n7 == 8 && n8 == 7 || n7 == 8 && n8 == 8 || n7 == 9 || n7 == 4)) {
            return "54666, 0000, query gtype is a superset of the source geometry";
        }
        if (!(n9 != 3 || n10 != 6 || n7 == 3 && n8 == 6 || n7 == 7 || n7 == 8 && n8 == 7 || n7 == 8 && n8 == 8 || n7 == 9 || n7 == 4)) {
            return "54666, 0000, query gtype is a superset of the source geometry";
        }
        if (!(n9 != 3 || n10 != 3 || n7 == 3 && n8 == 3 || n7 == 3 && n8 == 6 || n7 == 7 || n7 == 8 && n8 == 7 || n7 == 8 && n8 == 8 || n7 == 9 || n7 == 4)) {
            return "54666, 0000, query gtype is a superset of the source geometry";
        }
        if (!(n9 != 2 || n7 == 2 || n7 == 6 || n7 == 3 && n8 == 3 || n7 == 3 && n8 == 6 || n7 == 7 || n7 == 8 && n8 == 7 || n7 == 8 && n8 == 8 || n7 == 9 || n7 == 4)) {
            return "54666, 0000, query gtype is a superset of the source geometry";
        }
        if (n7 == 4 || n7 == 9 || n7 == 7 || n7 == 6) {
            string = "0,0,0,0,0,0,0";
        } else if (n7 == 8 && n8 == 8) {
            string = "0,0,0,0,0,0";
        } else if (n7 == 8 && n8 == 7) {
            string = "0,0,0,0,0";
        } else if (n7 == 3 && n8 == 6) {
            string = "0,0,0,0";
        } else if (n7 == 3 && n8 == 3) {
            string = "0,0,0";
        } else if (n7 == 2) {
            string = "0,0";
        } else if (n7 == 1) {
            string = "1";
        } else if (n7 == 5) {
            string = "0";
        } else {
            return "13028: Invalid Gtype in the SDO_GEOMETRY object";
        }
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        ArrayList arrayList3 = new ArrayList();
        int n11 = j3D_Geometry.getElemInfo()[1];
        if (n11 == 1003 || n11 == 1006) {
            j3D_Geometry.extract_next_level_elements(arrayList2, arrayList3, n3, j3D_Geometry.getType());
        } else if (n11 == 1007) {
            j3D_Geometry.extract_next_level_elements(arrayList2, arrayList3, n4, j3D_Geometry.getType());
            object = (J3D_Geometry)arrayList2.get(0);
            arrayList2.clear();
            arrayList3.clear();
            super.extract_next_level_elements(arrayList2, arrayList3, n3, ((JGeometry)object).getType());
        } else {
            if (n11 == 1008) {
                return "54667, 0000, query element can not be matched to an element in source geometry (4)";
            }
            arrayList2.add(j3D_Geometry);
        }
        object = new Object[]{this, string};
        arrayList.add(object);
        try {
            arrayList = this.getAllElements(j3D_Geometry, arrayList);
        }
        catch (Exception exception) {
            return exception.toString().substring(21);
        }
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        for (n6 = 0; n6 < arrayList.size(); ++n6) {
            object = new Object[2];
            object = (Object[])arrayList.get(n6);
            cloneable = (J3D_Geometry)object[0];
            string = (String)object[1];
            if (((J3D_Geometry)cloneable).elemInfo[1] / 1000 == 2) {
                arrayList5.add(object);
                continue;
            }
            arrayList4.add(object);
        }
        if (arrayList3.size() == 0 && arrayList2.size() == 1) {
            cloneable = (J3D_Geometry)arrayList2.get(0);
            object2 = this.matching((J3D_Geometry)cloneable, arrayList4, n5, d);
            if (object2 == "") {
                J3D_Geometry j3D_Geometry2;
                Cloneable cloneable2;
                ArrayList<Object[]> arrayList6 = new ArrayList<Object[]>();
                for (n = 0; n < arrayList5.size(); ++n) {
                    object = new Object[2];
                    object = (Object[])arrayList5.get(n);
                    cloneable2 = (J3D_Geometry)object[0];
                    string = (String)object[1];
                    j3D_Geometry2 = ((J3D_Geometry)cloneable2).reverseOrientation();
                    Object[] objectArray = new Object[]{j3D_Geometry2, string};
                    arrayList6.add(objectArray);
                }
                object2 = this.matching((J3D_Geometry)cloneable, arrayList6, n5, d);
                if (object2 == "" && ((J3D_Geometry)cloneable).elemInfo[1] == 1003) {
                    cloneable2 = new ArrayList();
                    for (n = 0; n < arrayList5.size(); ++n) {
                        object = new Object[2];
                        object = (Object[])arrayList5.get(n);
                        j3D_Geometry2 = (J3D_Geometry)object[0];
                        string = (String)object[1];
                        int n12 = j3D_Geometry2.getType();
                        int n13 = j3D_Geometry2.getSRID();
                        int[] nArray = new int[j3D_Geometry2.getElemInfo().length];
                        for (int i = 0; i < j3D_Geometry2.getElemInfo().length; ++i) {
                            nArray[i] = j3D_Geometry2.getElemInfo()[i];
                        }
                        double[] dArray = new double[j3D_Geometry2.getOrdinatesArray().length];
                        for (int i = 0; i < j3D_Geometry2.getOrdinatesArray().length; ++i) {
                            dArray[i] = j3D_Geometry2.getOrdinatesArray()[i];
                        }
                        J3D_Geometry j3D_Geometry3 = new J3D_Geometry(n12, n13, nArray, dArray);
                        if (j3D_Geometry3.elemInfo[1] == 2003) {
                            j3D_Geometry3.elemInfo[1] = 1003;
                        }
                        Object[] objectArray = new Object[]{j3D_Geometry3, string};
                        ((ArrayList)cloneable2).add(objectArray);
                    }
                    object2 = this.matching((J3D_Geometry)cloneable, (ArrayList)cloneable2, n5, d);
                }
            }
        } else if (arrayList3.size() == 0 && arrayList2.size() > 1) {
            string = "dummy";
            for (n = 0; n < arrayList2.size() && string != ""; ++n) {
                string = "";
                cloneable = (J3D_Geometry)arrayList2.get(n);
                string = this.matching((J3D_Geometry)cloneable, arrayList4, n5, d);
                if (string == "") continue;
                object2 = string;
            }
            if (n != arrayList2.size()) {
                object2 = "";
            }
        } else if (arrayList3.size() > 0 && arrayList2.size() > 0) {
            string = "dummy";
            for (n = 0; n < arrayList2.size() && string != ""; ++n) {
                string = "";
                cloneable = (J3D_Geometry)arrayList2.get(n);
                string = this.matching((J3D_Geometry)cloneable, arrayList4, n5, d);
                if (string == "") continue;
                object2 = string;
            }
            if (n != arrayList2.size()) {
                object2 = "";
            }
            if (object2 != "") {
                ArrayList arrayList7;
                Object object3;
                cloneable = new ArrayList();
                for (n2 = 0; n2 < arrayList5.size(); ++n2) {
                    object = new Object[2];
                    object = (Object[])arrayList5.get(n2);
                    object3 = (J3D_Geometry)object[0];
                    string = (String)object[1];
                    arrayList7 = super.reverseOrientation();
                    Object[] objectArray = new Object[]{arrayList7, string};
                    ((ArrayList)cloneable).add(objectArray);
                }
                string = "dummy";
                for (n2 = 0; n2 < arrayList3.size() && string != ""; ++n2) {
                    string = "";
                    object3 = (J3D_Geometry)arrayList3.get(n2);
                    arrayList7 = super.reverseOrientation();
                    string = this.matching((J3D_Geometry)((Object)arrayList7), (ArrayList)cloneable, n5, d);
                }
                if (n2 != arrayList3.size()) {
                    object2 = "";
                } else {
                    object3 = "";
                    arrayList7 = new ArrayList();
                    arrayList7 = j3D_Geometry.getIDs((String)object2);
                    for (int i = 0; i < arrayList7.size(); ++i) {
                        int n14 = (Integer)arrayList7.get(i);
                        object3 = i == 0 ? ((String)object3).concat(String.valueOf(n14)) : (i == 2 && (j3D_Geometry.getElemInfo()[1] == 1003 || j3D_Geometry.getElemInfo()[1] == 1006) ? ((String)object3).concat(",").concat(String.valueOf(0)) : (i == 4 && j3D_Geometry.getElemInfo()[1] == 1006 ? ((String)object3).concat(String.valueOf(0)) : ((String)object3).concat(",").concat(String.valueOf(n14))));
                    }
                    object2 = object3;
                }
            }
        }
        if (object2 != "") {
            return object2;
        }
        return "54667, 0000, query element can not be matched to an element in source geometry (0)";
    }

    private ArrayList getAllElements(J3D_Geometry j3D_Geometry, ArrayList arrayList) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 2;
        int n6 = this.getType();
        int n7 = this.getFirstEtype() % 1000;
        int n8 = j3D_Geometry.getType();
        int n9 = j3D_Geometry.getFirstEtype() % 1000;
        String string = "";
        Object[] objectArray = new Object[2];
        objectArray = (Object[])arrayList.get(0);
        J3D_Geometry j3D_Geometry2 = null;
        J3D_Geometry j3D_Geometry3 = (J3D_Geometry)objectArray[0];
        string = (String)objectArray[1];
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            int n10;
            int n11;
            String string2;
            Object[] objectArray2;
            J3D_Geometry j3D_Geometry4;
            int n12;
            objectArray = new Object[2];
            objectArray = (Object[])arrayList.get(n2);
            j3D_Geometry3 = (J3D_Geometry)objectArray[0];
            string = (String)objectArray[1];
            ArrayList<Object[]> arrayList3 = new ArrayList<Object[]>();
            ArrayList<Object[]> arrayList4 = new ArrayList<Object[]>();
            ArrayList<Object[]> arrayList5 = new ArrayList<Object[]>();
            ArrayList<Object[]> arrayList6 = new ArrayList<Object[]>();
            if (j3D_Geometry3.gtype == 9 || j3D_Geometry3.gtype == 7 || j3D_Geometry3.gtype == 6 || j3D_Geometry3.elemInfo[1] % 1000 == 2 && j3D_Geometry3.ordinates.length != 6 || j3D_Geometry3.gtype == 5 || j3D_Geometry3.elemInfo[1] % 1000 == 8 || j3D_Geometry3.elemInfo[1] % 1000 == 6 || j3D_Geometry3.gtype == 4) {
                j3D_Geometry3.extract_next_level_elements_with_labels(arrayList3, arrayList4, string, n3);
            } else {
                Object[] objectArray3 = new Object[]{j3D_Geometry3, string};
                arrayList3.add(objectArray3);
            }
            bl = j3D_Geometry3.dealOrNodeal(j3D_Geometry, arrayList3, arrayList4, arrayList2);
            if (bl && j3D_Geometry.gtype == 8) {
                bl3 = true;
            }
            bl2 = false;
            for (n12 = 0; n12 < j3D_Geometry3.elemInfo.length; n12 += 3) {
                if (j3D_Geometry3.elemInfo[n12 + 1] / 1000 != 2) continue;
                bl2 = true;
                break;
            }
            if (bl && !bl2) {
                arrayList3.clear();
                arrayList4.clear();
                arrayList5.clear();
                arrayList6.clear();
                continue;
            }
            for (n = 0; n < arrayList3.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList3.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                n12 = j3D_Geometry2.getType();
                int n13 = j3D_Geometry2.getElemInfo()[1];
                if (n13 == 2 && j3D_Geometry2.ordinates.length != 6) {
                    j3D_Geometry2.extract_next_level_elements_with_labels(arrayList5, arrayList6, string, n3);
                    continue;
                }
                if (n13 == 1007 && n12 == 8) {
                    j3D_Geometry2.extract_next_level_elements_with_labels(arrayList5, arrayList6, string, n5);
                    continue;
                }
                Object[] objectArray4 = new Object[]{j3D_Geometry2, string};
                arrayList5.add(objectArray4);
            }
            bl = super.dealOrNodeal(j3D_Geometry, arrayList5, arrayList6, arrayList2);
            if (bl && !bl2) {
                arrayList3.clear();
                arrayList4.clear();
                arrayList5.clear();
                arrayList6.clear();
                continue;
            }
            arrayList3.clear();
            arrayList4.clear();
            arrayList2.clear();
            for (n = 0; n < arrayList5.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList5.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                n12 = j3D_Geometry2.getElemInfo()[1];
                if (n12 == 1003 || n12 == 1006) {
                    j3D_Geometry2.extract_next_level_elements_with_labels(arrayList3, arrayList4, string, n4);
                    continue;
                }
                Object[] objectArray5 = new Object[]{j3D_Geometry2, string};
                arrayList3.add(objectArray5);
            }
            bl = j3D_Geometry2.dealOrNodeal(j3D_Geometry, arrayList3, arrayList4, arrayList2);
            if (bl) {
                arrayList3.clear();
                arrayList4.clear();
                arrayList5.clear();
                arrayList6.clear();
                continue;
            }
            if (bl3) {
                for (n12 = 0; n12 < arrayList3.size(); ++n12) {
                    objectArray = new Object[2];
                    objectArray = (Object[])arrayList3.get(n12);
                    arrayList2.add(objectArray);
                }
                for (n12 = 0; n12 < arrayList4.size(); ++n12) {
                    objectArray = new Object[2];
                    objectArray = (Object[])arrayList4.get(n12);
                    arrayList2.add(objectArray);
                }
                arrayList3.clear();
                arrayList4.clear();
                arrayList5.clear();
                arrayList6.clear();
                continue;
            }
            arrayList5.clear();
            arrayList6.clear();
            arrayList2.clear();
            for (n = 0; n < arrayList3.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList3.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                n12 = j3D_Geometry2.getElemInfo()[1];
                if (n12 == 1006) {
                    j3D_Geometry2.extract_next_level_elements_with_labels(arrayList5, arrayList6, string, n3);
                    continue;
                }
                Object[] objectArray6 = new Object[]{j3D_Geometry2, string};
                arrayList5.add(objectArray6);
            }
            arrayList3.clear();
            for (n = 0; n < arrayList5.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList5.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                n12 = j3D_Geometry2.getElemInfo()[1];
                if (n12 % 1000 == 3) {
                    j3D_Geometry2.extract_next_level_elements_with_labels(arrayList3, arrayList4, string, n4);
                    continue;
                }
                Object[] objectArray7 = new Object[]{j3D_Geometry2, string};
                arrayList3.add(objectArray7);
            }
            arrayList5.clear();
            for (n = 0; n < arrayList3.size(); ++n) {
                Object[] objectArray8 = new Object[2];
                objectArray8 = (Object[])arrayList3.get(n);
                arrayList5.add(objectArray8);
            }
            for (n = 0; n < arrayList4.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList4.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                int n14 = j3D_Geometry2.getElemInfo()[1];
                if (n14 == 2006) {
                    j3D_Geometry2.extract_next_level_elements_with_labels(arrayList5, arrayList6, string, n3);
                    continue;
                }
                Object[] objectArray9 = new Object[]{j3D_Geometry2, string};
                arrayList6.add(objectArray9);
            }
            bl = j3D_Geometry2.dealOrNodeal(j3D_Geometry, arrayList5, arrayList6, arrayList2);
            if (bl) {
                arrayList3.clear();
                arrayList4.clear();
                arrayList5.clear();
                arrayList6.clear();
                continue;
            }
            arrayList3.clear();
            arrayList4.clear();
            arrayList2.clear();
            for (n = 0; n < arrayList5.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList5.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                int n15 = j3D_Geometry2.getElemInfo()[1];
                if (n15 % 1000 == 3) {
                    j3D_Geometry2.extract_next_level_elements_with_labels(arrayList3, arrayList4, string, n5);
                    continue;
                }
                Object[] objectArray10 = new Object[]{j3D_Geometry2, string};
                arrayList3.add(objectArray10);
            }
            for (n = 0; n < arrayList6.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList6.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                int n16 = j3D_Geometry2.getElemInfo()[1];
                if (n16 % 1000 == 3) {
                    j3D_Geometry2.extract_next_level_elements_with_labels(arrayList3, arrayList4, string, n5);
                    continue;
                }
                Object[] objectArray11 = new Object[]{j3D_Geometry2, string};
                arrayList4.add(objectArray11);
            }
            bl = j3D_Geometry2.dealOrNodeal(j3D_Geometry, arrayList3, arrayList4, arrayList2);
            if (bl) {
                arrayList3.clear();
                arrayList4.clear();
                arrayList5.clear();
                arrayList6.clear();
                continue;
            }
            arrayList5.clear();
            arrayList6.clear();
            arrayList2.clear();
            for (n = 0; n < arrayList3.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList3.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                int n17 = j3D_Geometry2.getElemInfo()[1];
                if (n17 == 2 && j3D_Geometry2.ordinates.length == 6) {
                    ArrayList arrayList7 = new ArrayList();
                    arrayList7 = j3D_Geometry2.getIDs(string);
                    for (int i = 0; i < j3D_Geometry2.ordinates.length / 3; ++i) {
                        j3D_Geometry4 = new J3D_Geometry(1, j3D_Geometry2.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry2.ordinates[3 * i], j3D_Geometry2.ordinates[3 * i + 1], j3D_Geometry2.ordinates[3 * i + 2]});
                        objectArray2 = new Object[2];
                        objectArray2[0] = j3D_Geometry4;
                        string2 = "";
                        for (n11 = 0; n11 < arrayList7.size(); ++n11) {
                            n10 = (Integer)arrayList7.get(n11);
                            string2 = n11 == 0 && i == 0 ? string2.concat(String.valueOf(++n10)) : (n11 == 0 && i == 1 ? string2.concat(String.valueOf(n10 += 2)) : (n11 == 1 && n10 == 0 ? string2.concat(",").concat(String.valueOf(++n10)) : string2.concat(",").concat(String.valueOf(n10))));
                        }
                        objectArray2[1] = string2;
                        arrayList5.add(objectArray2);
                    }
                    continue;
                }
                if (n17 == 1) {
                    arrayList5.add(objectArray);
                    continue;
                }
                throw new Exception("54667, 0000, query element can not be matched to an element in source geometry (1)");
            }
            for (n = 0; n < arrayList4.size(); ++n) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList4.get(n);
                j3D_Geometry2 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                int n18 = j3D_Geometry2.getElemInfo()[1];
                if (n18 == 2 && j3D_Geometry2.ordinates.length == 6) {
                    ArrayList arrayList8 = new ArrayList();
                    arrayList8 = j3D_Geometry2.getIDs(string);
                    for (int i = 0; i < j3D_Geometry2.ordinates.length / 3; ++i) {
                        j3D_Geometry4 = new J3D_Geometry(1, j3D_Geometry2.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry2.ordinates[3 * i], j3D_Geometry2.ordinates[3 * i + 1], j3D_Geometry2.ordinates[3 * i + 2]});
                        objectArray2 = new Object[2];
                        objectArray2[0] = j3D_Geometry4;
                        string2 = "";
                        for (n11 = 0; n11 < arrayList8.size(); ++n11) {
                            n10 = (Integer)arrayList8.get(n11);
                            string2 = n11 == 0 && i == 0 ? string2.concat(String.valueOf(++n10)) : (n11 == 0 && i == 1 ? string2.concat(String.valueOf(n10 += 2)) : (n11 == 1 && n10 == 0 ? string2.concat(",").concat(String.valueOf(++n10)) : string2.concat(",").concat(String.valueOf(n10))));
                        }
                        objectArray2[1] = string2;
                        arrayList6.add(objectArray2);
                    }
                    continue;
                }
                if (n18 == 1) {
                    arrayList6.add(objectArray);
                    continue;
                }
                throw new Exception("54667, 0000, query element can not be matched to an element in source geometry (1)");
            }
            bl = j3D_Geometry2.dealOrNodeal(j3D_Geometry, arrayList5, arrayList6, arrayList2);
            if (bl) {
                arrayList3.clear();
                arrayList4.clear();
                arrayList5.clear();
                arrayList6.clear();
                continue;
            }
            arrayList3.clear();
            arrayList4.clear();
            throw new Exception("54667, 0000, query element can not be matched to an element in source geometry (2)");
        }
        return arrayList2;
    }

    private String matching(J3D_Geometry j3D_Geometry, ArrayList arrayList, int n, double d) throws Exception {
        String string = "";
        int n2 = 0;
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        ArrayList<Object[]> arrayList3 = new ArrayList<Object[]>();
        ArrayList<double[][]> arrayList4 = new ArrayList<double[][]>();
        ArrayList<double[][]> arrayList5 = new ArrayList<double[][]>();
        double[][] dArray = new double[3][2];
        if (arrayList.size() > n) {
            Object object;
            Object[] objectArray;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList.get(n2);
                object = (J3D_Geometry)objectArray[0];
                dArray = J3D_Geometry.getMBH((J3D_Geometry)object);
                arrayList4.add(dArray);
            }
            object = new RTree(3, 8, 2, d);
            J3D_Geometry.createRTree2(object, arrayList4, arrayList);
            dArray = J3D_Geometry.getMBH(j3D_Geometry);
            arrayList5.add(dArray);
            RTree rTree = new RTree(3, 8, 2, d);
            objectArray = new Object[]{j3D_Geometry, ""};
            arrayList2.add(objectArray);
            J3D_Geometry.createRTree2(rTree, arrayList5, arrayList2);
            object.anyInteract(rTree, arrayList3);
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                RTreeJoinRes rTreeJoinRes = (RTreeJoinRes)arrayList3.get(n2);
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = new Object[2];
                objectArray2 = (Object[])rTreeJoinRes.ptr1;
                objectArray3 = (Object[])rTreeJoinRes.ptr2;
                J3D_Geometry j3D_Geometry2 = (J3D_Geometry)objectArray2[0];
                string = (String)objectArray2[1];
                if (!j3D_Geometry2.equals3d(j3D_Geometry, d)) continue;
                return string;
            }
        } else {
            J3D_Geometry j3D_Geometry3;
            Object[] objectArray;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList.get(n2);
                j3D_Geometry3 = (J3D_Geometry)objectArray[0];
                if (!j3D_Geometry3.anyInteract(j3D_Geometry, d)) continue;
                arrayList3.add(objectArray);
            }
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                objectArray = new Object[2];
                objectArray = (Object[])arrayList3.get(n2);
                j3D_Geometry3 = (J3D_Geometry)objectArray[0];
                string = (String)objectArray[1];
                if (!j3D_Geometry3.equals3d(j3D_Geometry, d, false)) continue;
                return string;
            }
        }
        return "";
    }

    private boolean dealOrNodeal(J3D_Geometry j3D_Geometry, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws Exception {
        int n;
        int n2;
        J3D_Geometry j3D_Geometry2;
        int n3;
        Object[] objectArray = new Object[2];
        int n4 = j3D_Geometry.getType();
        int n5 = j3D_Geometry.getFirstEtype() % 1000;
        int n6 = 0;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            objectArray = new Object[2];
            objectArray = (Object[])arrayList.get(n3);
            j3D_Geometry2 = (J3D_Geometry)objectArray[0];
            n2 = j3D_Geometry2.getType();
            n = j3D_Geometry2.getFirstEtype() % 1000;
            if (n4 == n2 && n5 == n && n2 == 2 && j3D_Geometry2.ordinates.length > j3D_Geometry.ordinates.length) {
                return false;
            }
            if (n5 >= n) continue;
            ++n6;
        }
        if (n6 > 0) {
            return false;
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            objectArray = new Object[2];
            objectArray = (Object[])arrayList2.get(n3);
            j3D_Geometry2 = (J3D_Geometry)objectArray[0];
            n2 = j3D_Geometry2.getType();
            n = j3D_Geometry2.getFirstEtype() % 1000;
            if (n4 == n2 && n5 == n && n2 == 2 && j3D_Geometry2.ordinates.length > j3D_Geometry.ordinates.length) {
                return false;
            }
            if (n5 == n) continue;
            return false;
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            objectArray = new Object[2];
            objectArray = (Object[])arrayList.get(n3);
            arrayList3.add(objectArray);
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            objectArray = new Object[2];
            objectArray = (Object[])arrayList2.get(n3);
            arrayList3.add(objectArray);
        }
        return true;
    }

    private ArrayList getIDs(String string) {
        int n = 0;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string2 = "";
        if (!string.substring(0, 1).equals(",")) {
            string2 = ",";
            string = string2.concat(string);
        }
        string2 = "";
        while (string.indexOf(",") != -1) {
            string2 = string.substring(string.indexOf(",") + 1);
            if (string2.indexOf(",") == -1) {
                n2 = Integer.valueOf(string2);
            } else {
                String string3 = string2.substring(0, string2.indexOf(","));
                n2 = Integer.valueOf(string3);
                string2 = string2.substring(string2.indexOf(","));
            }
            string = string2;
            switch (n + 1) {
                case 1: {
                    arrayList.add(n2);
                    break;
                }
                case 2: {
                    arrayList.add(n2);
                    break;
                }
                case 3: {
                    arrayList.add(n2);
                    break;
                }
                case 4: {
                    arrayList.add(n2);
                    break;
                }
                case 5: {
                    arrayList.add(n2);
                    break;
                }
                case 6: {
                    arrayList.add(n2);
                    break;
                }
                case 7: {
                    arrayList.add(n2);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private void extract_next_level_elements_with_labels(ArrayList arrayList, ArrayList arrayList2, String string, int n) throws Exception {
        J3D_Geometry j3D_Geometry;
        int[] nArray = new int[1];
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        String string2 = "";
        int n12 = 0;
        ArrayList arrayList3 = new ArrayList();
        arrayList3 = this.getIDs(string);
        block9: for (n12 = 0; n12 < arrayList3.size(); ++n12) {
            switch (n12 + 1) {
                case 1: {
                    n5 = (Integer)arrayList3.get(n12);
                    continue block9;
                }
                case 2: {
                    n6 = (Integer)arrayList3.get(n12);
                    continue block9;
                }
                case 3: {
                    n7 = (Integer)arrayList3.get(n12);
                    continue block9;
                }
                case 4: {
                    n8 = (Integer)arrayList3.get(n12);
                    continue block9;
                }
                case 5: {
                    n9 = (Integer)arrayList3.get(n12);
                    continue block9;
                }
                case 6: {
                    n10 = (Integer)arrayList3.get(n12);
                    continue block9;
                }
                case 7: {
                    n11 = (Integer)arrayList3.get(n12);
                }
            }
        }
        nArray[0] = 0;
        ElementExtractor elementExtractor = new ElementExtractor(this, 0, n, true);
        while ((j3D_Geometry = elementExtractor.nextElement(nArray)) != null) {
            Object[] objectArray;
            if (nArray[0] == 2) {
                if ((this.elemInfo[1] == 1003 || this.elemInfo[1] == 1006) && n == n3) {
                    if (j3D_Geometry.elemInfo[1] == 2003) {
                        ++n7;
                    }
                    if (j3D_Geometry.elemInfo[1] == 2006) {
                        ++n9;
                    }
                    string2 = "";
                    string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(n6)).concat(",").concat(String.valueOf(n7));
                    if (n12 >= 4) {
                        string2 = string2.concat(",").concat(String.valueOf(n8));
                    }
                    if (n12 >= 5) {
                        string2 = string2.concat(",").concat(String.valueOf(n9));
                    }
                    if (n12 >= 6) {
                        string2 = string2.concat(",").concat(String.valueOf(n10));
                    }
                    if (n12 == 7) {
                        string2 = string2.concat(",").concat(String.valueOf(n11));
                    }
                    objectArray = new Object[]{j3D_Geometry, string2};
                    arrayList2.add(objectArray);
                }
                if (this.elemInfo[1] != 2006 || n != n2) continue;
                ++n8;
                n7 = 1;
                string2 = "";
                string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(n6)).concat(",").concat(String.valueOf(n7));
                if (n12 >= 4) {
                    string2 = string2.concat(",").concat(String.valueOf(n8));
                }
                if (n12 >= 5) {
                    string2 = string2.concat(",").concat(String.valueOf(n9));
                }
                if (n12 >= 6) {
                    string2 = string2.concat(",").concat(String.valueOf(n10));
                }
                if (n12 == 7) {
                    string2 = string2.concat(",").concat(String.valueOf(n11));
                }
                objectArray = new Object[]{j3D_Geometry, string2};
                arrayList2.add(objectArray);
                continue;
            }
            if ((this.gtype == 9 || this.gtype == 7 || this.gtype == 6 || this.gtype == 4) && n == n2) {
                string2 = "";
                string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(n6)).concat(",").concat(String.valueOf(n7)).concat(",").concat(String.valueOf(n8)).concat(",").concat(String.valueOf(n9)).concat(",").concat(String.valueOf(n10)).concat(",").concat(String.valueOf(++n11));
                objectArray = new Object[]{j3D_Geometry, string2};
                arrayList.add(objectArray);
            }
            if (this.gtype == 5 && n == n2) {
                string2 = "";
                string2 = string2.concat(String.valueOf(++n5));
                objectArray = new Object[]{j3D_Geometry, string2};
                arrayList.add(objectArray);
            }
            if (this.elemInfo[1] % 1000 == 8 && n == n2) {
                string2 = "";
                string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(n6)).concat(",").concat(String.valueOf(n7)).concat(",").concat(String.valueOf(n8)).concat(",").concat(String.valueOf(n9)).concat(",").concat(String.valueOf(++n10));
                if (n12 == 7) {
                    string2 = string2.concat(",").concat(String.valueOf(n11));
                }
                objectArray = new Object[]{j3D_Geometry, string2};
                arrayList.add(objectArray);
            }
            if (this.gtype == 3 && this.elemInfo[1] % 1000 == 6 && n == n2) {
                ++n8;
                n7 = 1;
                string2 = "";
                string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(n6)).concat(",").concat(String.valueOf(n7));
                if (n12 >= 4) {
                    string2 = string2.concat(",").concat(String.valueOf(n8));
                }
                if (n12 >= 5) {
                    string2 = string2.concat(",").concat(String.valueOf(n9));
                }
                if (n12 >= 6) {
                    string2 = string2.concat(",").concat(String.valueOf(n10));
                }
                if (n12 == 7) {
                    string2 = string2.concat(",").concat(String.valueOf(n11));
                }
                objectArray = new Object[]{j3D_Geometry, string2};
                arrayList.add(objectArray);
            }
            if (this.gtype == 2 && this.elemInfo[1] % 1000 == 2 && this.ordinates.length != 6 && n == n2) {
                string2 = "";
                string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(++n6));
                if (n12 >= 3) {
                    string2 = string2.concat(",").concat(String.valueOf(n7));
                }
                if (n12 >= 4) {
                    string2 = string2.concat(",").concat(String.valueOf(n8));
                }
                if (n12 >= 5) {
                    string2 = string2.concat(",").concat(String.valueOf(n9));
                }
                if (n12 >= 6) {
                    string2 = string2.concat(",").concat(String.valueOf(n10));
                }
                if (n12 == 7) {
                    string2 = string2.concat(",").concat(String.valueOf(n11));
                }
                objectArray = new Object[]{j3D_Geometry, string2};
                arrayList.add(objectArray);
            }
            if (this.elemInfo[1] == 1007 && this.gtype == 8 && n == n4) {
                string2 = "";
                string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(n6)).concat(",").concat(String.valueOf(n7)).concat(",").concat(String.valueOf(n8)).concat(",").concat(String.valueOf(n9));
                if (n12 >= 6) {
                    string2 = string2.concat(",").concat(String.valueOf(n10));
                }
                if (n12 == 7) {
                    string2 = string2.concat(",").concat(String.valueOf(n11));
                }
                objectArray = new Object[]{j3D_Geometry, string2};
                arrayList.add(objectArray);
            }
            if ((this.elemInfo[1] == 1003 || this.elemInfo[1] == 1006) && n == n3) {
                if (this.elemInfo[1] == 1006) {
                    ++n9;
                }
                if (this.elemInfo[1] == 1003) {
                    if (n8 == -1 || n8 == 0) {
                        n8 = 1;
                    }
                    n7 = 1;
                }
                string2 = "";
                string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(n6)).concat(",").concat(String.valueOf(n7));
                if (n12 >= 4) {
                    string2 = string2.concat(",").concat(String.valueOf(n8));
                }
                if (n12 >= 5) {
                    string2 = string2.concat(",").concat(String.valueOf(n9));
                }
                if (n12 >= 6) {
                    string2 = string2.concat(",").concat(String.valueOf(n10));
                }
                if (n12 == 7) {
                    string2 = string2.concat(",").concat(String.valueOf(n11));
                }
                objectArray = new Object[]{j3D_Geometry, string2};
                arrayList.add(objectArray);
            }
            if (this.elemInfo[1] != 1003 && this.elemInfo[1] != 2003 || n != n4) continue;
            string2 = "";
            string2 = string2.concat(String.valueOf(n5)).concat(",").concat(String.valueOf(++n6));
            if (n12 >= 3) {
                string2 = string2.concat(",").concat(String.valueOf(n7));
            }
            if (n12 >= 4) {
                string2 = string2.concat(",").concat(String.valueOf(n8));
            }
            if (n12 >= 5) {
                string2 = string2.concat(",").concat(String.valueOf(n9));
            }
            if (n12 >= 6) {
                string2 = string2.concat(",").concat(String.valueOf(n10));
            }
            if (n12 == 7) {
                string2 = string2.concat(",").concat(String.valueOf(n11));
            }
            objectArray = new Object[]{j3D_Geometry, string2};
            arrayList.add(objectArray);
        }
    }

    private boolean equals3d(J3D_Geometry j3D_Geometry, double d) throws Exception {
        return this.equals3d(j3D_Geometry, d, true);
    }

    private boolean equals3d(J3D_Geometry j3D_Geometry, double d, boolean bl) throws Exception {
        J3D_Geometry j3D_Geometry2;
        J3D_Geometry j3D_Geometry3;
        int n;
        int n2;
        J3D_Geometry j3D_Geometry4;
        int n3;
        if (this.getType() != j3D_Geometry.getType() || this.getFirstEtype() != j3D_Geometry.getFirstEtype()) {
            return false;
        }
        double[][] dArray = new double[3][2];
        double[][] dArray2 = new double[3][2];
        dArray = J3D_Geometry.getMBH(this);
        if (!(Math.abs(dArray[0][0] - (dArray2 = J3D_Geometry.getMBH(j3D_Geometry))[0][0]) <= d && Math.abs(dArray[0][1] - dArray2[0][1]) <= d && Math.abs(dArray[1][0] - dArray2[1][0]) <= d && Math.abs(dArray[1][1] - dArray2[1][1]) <= d && Math.abs(dArray[2][0] - dArray2[2][0]) <= d && Math.abs(dArray[2][1] - dArray2[2][1]) <= d)) {
            return false;
        }
        if (bl && !this.anyInteract(j3D_Geometry, d)) {
            return false;
        }
        ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        ArrayList arrayList4 = new ArrayList();
        ArrayList<J3D_Geometry> arrayList5 = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList6 = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList7 = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList8 = new ArrayList<J3D_Geometry>();
        int n4 = 0;
        int n5 = 1;
        int n6 = 2;
        int n7 = 0;
        int n8 = 0;
        if (this.gtype == 9 || this.gtype == 7 || this.gtype == 6 || this.elemInfo[1] % 1000 == 2 && this.ordinates.length != 6 || this.gtype == 5 || this.elemInfo[1] % 1000 == 8 || this.elemInfo[1] % 1000 == 6 || this.gtype == 4) {
            this.extract_next_level_elements(arrayList, arrayList2, n4, this.getType());
        } else {
            arrayList.add(this);
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            j3D_Geometry4 = (J3D_Geometry)arrayList.get(n3);
            n2 = j3D_Geometry4.getType();
            n = j3D_Geometry4.getElemInfo()[1];
            if (n == 2 && j3D_Geometry4.ordinates.length != 6) {
                j3D_Geometry4.extract_next_level_elements(arrayList5, arrayList6, n4, j3D_Geometry4.getType());
                continue;
            }
            if (n == 1007 && n2 == 8) {
                j3D_Geometry4.extract_next_level_elements(arrayList5, arrayList6, n6, j3D_Geometry4.getType());
                continue;
            }
            arrayList5.add(j3D_Geometry4);
        }
        arrayList.clear();
        arrayList2.clear();
        for (n3 = 0; n3 < arrayList5.size(); ++n3) {
            j3D_Geometry4 = (J3D_Geometry)arrayList5.get(n3);
            n2 = j3D_Geometry4.getElemInfo()[1];
            if (n2 == 1003 || n2 == 1006) {
                j3D_Geometry4.extract_next_level_elements(arrayList, arrayList2, n5, j3D_Geometry4.getType());
                continue;
            }
            arrayList.add(j3D_Geometry4);
        }
        arrayList5.clear();
        arrayList6.clear();
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            j3D_Geometry4 = (J3D_Geometry)arrayList.get(n3);
            n2 = j3D_Geometry4.getElemInfo()[1];
            if (n2 == 1006) {
                j3D_Geometry4.extract_next_level_elements(arrayList5, arrayList6, n4, j3D_Geometry4.getType());
                continue;
            }
            arrayList5.add(j3D_Geometry4);
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            j3D_Geometry4 = (J3D_Geometry)arrayList2.get(n3);
            n2 = j3D_Geometry4.getElemInfo()[1];
            if (n2 == 2006) {
                j3D_Geometry4.extract_next_level_elements(arrayList5, arrayList6, n4, j3D_Geometry4.getType());
                continue;
            }
            arrayList6.add(j3D_Geometry4);
        }
        arrayList.clear();
        arrayList2.clear();
        if (j3D_Geometry.gtype == 9 || j3D_Geometry.gtype == 7 || j3D_Geometry.gtype == 6 || j3D_Geometry.elemInfo[1] % 1000 == 2 && j3D_Geometry.ordinates.length != 6 || j3D_Geometry.gtype == 5 || j3D_Geometry.elemInfo[1] % 1000 == 8 || j3D_Geometry.elemInfo[1] % 1000 == 6 || j3D_Geometry.gtype == 4) {
            j3D_Geometry.extract_next_level_elements(arrayList3, arrayList4, n4, j3D_Geometry.getType());
        } else {
            arrayList3.add(j3D_Geometry);
        }
        for (n3 = 0; n3 < arrayList3.size(); ++n3) {
            j3D_Geometry4 = (J3D_Geometry)arrayList3.get(n3);
            n2 = j3D_Geometry4.getType();
            n = j3D_Geometry4.getElemInfo()[1];
            if (n == 2 && j3D_Geometry4.ordinates.length != 6) {
                j3D_Geometry4.extract_next_level_elements(arrayList7, arrayList8, n4, j3D_Geometry4.getType());
                continue;
            }
            if (n == 1007 && n2 == 8) {
                j3D_Geometry4.extract_next_level_elements(arrayList7, arrayList8, n6, j3D_Geometry4.getType());
                continue;
            }
            arrayList7.add(j3D_Geometry4);
        }
        arrayList3.clear();
        arrayList4.clear();
        for (n3 = 0; n3 < arrayList7.size(); ++n3) {
            j3D_Geometry4 = (J3D_Geometry)arrayList7.get(n3);
            n2 = j3D_Geometry4.getElemInfo()[1];
            if (n2 == 1003 || n2 == 1006) {
                j3D_Geometry4.extract_next_level_elements(arrayList3, arrayList4, n5, j3D_Geometry4.getType());
                continue;
            }
            arrayList3.add(j3D_Geometry4);
        }
        arrayList7.clear();
        arrayList8.clear();
        for (n3 = 0; n3 < arrayList3.size(); ++n3) {
            j3D_Geometry4 = (J3D_Geometry)arrayList3.get(n3);
            n2 = j3D_Geometry4.getElemInfo()[1];
            if (n2 == 1006) {
                j3D_Geometry4.extract_next_level_elements(arrayList7, arrayList8, n4, j3D_Geometry4.getType());
                continue;
            }
            arrayList7.add(j3D_Geometry4);
        }
        for (n3 = 0; n3 < arrayList4.size(); ++n3) {
            j3D_Geometry4 = (J3D_Geometry)arrayList4.get(n3);
            n2 = j3D_Geometry4.getElemInfo()[1];
            if (n2 == 2006) {
                j3D_Geometry4.extract_next_level_elements(arrayList7, arrayList8, n4, j3D_Geometry4.getType());
                continue;
            }
            arrayList8.add(j3D_Geometry4);
        }
        arrayList3.clear();
        arrayList4.clear();
        n3 = arrayList5.size();
        int n9 = arrayList7.size();
        n2 = arrayList6.size();
        n = arrayList8.size();
        if (n3 != n9 || n2 != n) {
            return false;
        }
        int n10 = 0;
        int n11 = 0;
        boolean bl2 = false;
        while (arrayList5.size() != 0) {
            bl2 = false;
            n11 = 0;
            j3D_Geometry3 = (J3D_Geometry)arrayList5.get(n10);
            while (n11 < arrayList7.size()) {
                j3D_Geometry2 = (J3D_Geometry)arrayList7.get(n11);
                if (j3D_Geometry3.anyInteract(j3D_Geometry2, d) && j3D_Geometry3.getType() == j3D_Geometry2.getType() && j3D_Geometry3.getFirstEtype() == j3D_Geometry2.getFirstEtype() && j3D_Geometry3.perfectOverlap(j3D_Geometry2, d)) {
                    ++n7;
                    bl2 = true;
                    arrayList5.remove(n10);
                    arrayList7.remove(n11);
                    break;
                }
                if (bl2) continue;
                ++n11;
            }
            if (bl2) continue;
            return false;
        }
        if (n7 != n3) {
            return false;
        }
        n10 = 0;
        n11 = 0;
        while (arrayList6.size() != 0) {
            bl2 = false;
            n11 = 0;
            j3D_Geometry3 = ((J3D_Geometry)arrayList6.get(n10)).reverseOrientation();
            while (n11 < arrayList8.size()) {
                j3D_Geometry2 = ((J3D_Geometry)arrayList8.get(n11)).reverseOrientation();
                if (j3D_Geometry3.anyInteract(j3D_Geometry2, d) && j3D_Geometry3.getType() == j3D_Geometry2.getType() && j3D_Geometry3.getFirstEtype() == j3D_Geometry2.getFirstEtype() && j3D_Geometry3.perfectOverlap(j3D_Geometry2, d)) {
                    ++n8;
                    bl2 = true;
                    arrayList6.remove(n10);
                    arrayList8.remove(n11);
                    break;
                }
                if (bl2) continue;
                ++n11;
            }
            if (bl2) continue;
            return false;
        }
        return n8 == n2;
    }

    private void extract_next_level_elements(ArrayList arrayList, ArrayList arrayList2, int n, int n2) throws Exception {
        J3D_Geometry j3D_Geometry;
        int[] nArray = new int[]{0};
        ElementExtractor elementExtractor = new ElementExtractor(this, 0, n, false);
        while ((j3D_Geometry = elementExtractor.nextElement(nArray)) != null) {
            if (nArray[0] == 2) {
                arrayList2.add(j3D_Geometry);
                continue;
            }
            arrayList.add(j3D_Geometry);
        }
    }

    private boolean perfectOverlap(J3D_Geometry j3D_Geometry, double d) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (this.getType() != j3D_Geometry.getType() || this.getFirstEtype() != j3D_Geometry.getFirstEtype()) {
            return false;
        }
        if (this.getType() == 1) {
            return this.pointEquals(j3D_Geometry, d);
        }
        if (this.getType() == 2) {
            J3D_Geometry j3D_Geometry2 = new J3D_Geometry(1, this.getSRID(), new int[]{1, 1, 1}, new double[]{this.ordinates[0], this.ordinates[1], this.ordinates[2]});
            J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, this.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.ordinates[0], j3D_Geometry.ordinates[1], j3D_Geometry.ordinates[2]});
            J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, this.getSRID(), new int[]{1, 1, 1}, new double[]{this.ordinates[3], this.ordinates[4], this.ordinates[5]});
            J3D_Geometry j3D_Geometry5 = new J3D_Geometry(1, this.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.ordinates[3], j3D_Geometry.ordinates[4], j3D_Geometry.ordinates[5]});
            return j3D_Geometry2.pointEquals(j3D_Geometry3, d) && j3D_Geometry4.pointEquals(j3D_Geometry5, d) || j3D_Geometry2.pointEquals(j3D_Geometry5, d) && j3D_Geometry3.pointEquals(j3D_Geometry4, d);
        }
        if (this.getType() == 3) {
            J3D_Geometry j3D_Geometry6;
            int n;
            Object object;
            int n2;
            J3D_Geometry j3D_Geometry7;
            J3D_Geometry j3D_Geometry8;
            double[][] dArray = new double[3][2];
            double[][] dArray2 = new double[3][2];
            dArray = J3D_Geometry.getMBH(this);
            if (!(Math.abs(dArray[0][0] - (dArray2 = J3D_Geometry.getMBH(j3D_Geometry))[0][0]) <= d && Math.abs(dArray[0][1] - dArray2[0][1]) <= d && Math.abs(dArray[1][0] - dArray2[1][0]) <= d && Math.abs(dArray[1][1] - dArray2[1][1]) <= d && Math.abs(dArray[2][0] - dArray2[2][0]) <= d && Math.abs(dArray[2][1] - dArray2[2][1]) <= d)) {
                return false;
            }
            int[] nArray = new int[1];
            ArrayList<double[][]> arrayList2 = new ArrayList<double[][]>();
            ArrayList<double[][]> arrayList3 = new ArrayList<double[][]>();
            ArrayList<RTree> arrayList4 = new ArrayList<RTree>();
            ArrayList<RTree> arrayList5 = new ArrayList<RTree>();
            ElementExtractor elementExtractor = new ElementExtractor(this, 0, 2, 3);
            nArray[0] = 0;
            ArrayList<J3D_Geometry> arrayList6 = new ArrayList<J3D_Geometry>();
            while ((j3D_Geometry8 = elementExtractor.nextElement(nArray)) != null) {
                arrayList6.add(j3D_Geometry8);
            }
            ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry, 0, 2, 3);
            nArray[0] = 0;
            ArrayList<J3D_Geometry> arrayList7 = new ArrayList<J3D_Geometry>();
            while ((j3D_Geometry7 = elementExtractor2.nextElement(nArray)) != null) {
                arrayList7.add(j3D_Geometry7);
            }
            ArrayList<RTree> arrayList8 = new ArrayList<RTree>();
            for (n2 = 0; n2 < arrayList6.size(); ++n2) {
                J3D_Geometry j3D_Geometry9 = (J3D_Geometry)arrayList6.get(n2);
                double[] dArray3 = new double[]{(j3D_Geometry9.ordinates[0] + j3D_Geometry9.ordinates[3]) / 2.0, (j3D_Geometry9.ordinates[1] + j3D_Geometry9.ordinates[4]) / 2.0, (j3D_Geometry9.ordinates[2] + j3D_Geometry9.ordinates[5]) / 2.0};
                object = new J3D_Geometry(1, 0, new int[]{1, 1, 1}, dArray3);
                arrayList8.add((RTree)object);
                arrayList2.add(J3D_Geometry.getMBH((J3D_Geometry)object));
                arrayList4.add((RTree)object);
            }
            ArrayList<RTree> arrayList9 = new ArrayList<RTree>();
            for (n = 0; n < arrayList7.size(); ++n) {
                J3D_Geometry j3D_Geometry10 = (J3D_Geometry)arrayList7.get(n);
                double[] dArray4 = new double[]{(j3D_Geometry10.ordinates[0] + j3D_Geometry10.ordinates[3]) / 2.0, (j3D_Geometry10.ordinates[1] + j3D_Geometry10.ordinates[4]) / 2.0, (j3D_Geometry10.ordinates[2] + j3D_Geometry10.ordinates[5]) / 2.0};
                object = new J3D_Geometry(1, 0, new int[]{1, 1, 1}, dArray4);
                arrayList9.add((RTree)object);
                arrayList3.add(J3D_Geometry.getMBH((J3D_Geometry)object));
                arrayList5.add((RTree)object);
            }
            for (n2 = 0; n2 < arrayList9.size(); ++n2) {
                j3D_Geometry6 = (J3D_Geometry)arrayList9.get(n2);
                if (this.pointBoundaryIntersect(j3D_Geometry6, d)) continue;
                return false;
            }
            for (n = 0; n < arrayList8.size(); ++n) {
                j3D_Geometry6 = (J3D_Geometry)arrayList8.get(n);
                if (j3D_Geometry.pointBoundaryIntersect(j3D_Geometry6, d)) continue;
                return false;
            }
            if (this.ordinates.length == j3D_Geometry.ordinates.length) {
                object = new RTree(3, 8, 2, d);
                RTree rTree = new RTree(3, 8, 2, d);
                J3D_Geometry.createRTree(object, arrayList2, arrayList4);
                J3D_Geometry.createRTree(rTree, arrayList3, arrayList5);
                object.anyInteract(rTree, arrayList);
                double d2 = 1.0E-15;
                if (arrayList.size() == this.ordinates.length / 3 - 1) {
                    double[] dArray5 = new double[1];
                    double[] dArray6 = new double[1];
                    double[] dArray7 = new double[3];
                    double[] dArray8 = new double[3];
                    J3D_Geometry.planeEquation(dArray7, dArray5, this);
                    J3D_Geometry.planeEquation(dArray8, dArray6, j3D_Geometry);
                    double d3 = Math.abs(dArray7[0] - dArray8[0]);
                    double d4 = Math.abs(dArray7[1] - dArray8[1]);
                    double d5 = Math.abs(dArray7[2] - dArray8[2]);
                    if (d3 <= d2 && d4 <= d2 && d5 <= d2) {
                        return true;
                    }
                    d3 = Math.abs(dArray7[0] + dArray8[0]);
                    d4 = Math.abs(dArray7[1] + dArray8[1]);
                    d5 = Math.abs(dArray7[2] + dArray8[2]);
                    if (d3 <= d2 && d4 <= d2 && d5 <= d2) {
                        return true;
                    }
                }
            }
            return false;
        }
        throw new Exception("54667, 0000, query element can not be matched to an element in source geometry (3)");
    }

    private boolean pointEquals(J3D_Geometry j3D_Geometry, double d) throws Exception {
        return Math.abs(this.getOrdinatesArray()[0] - j3D_Geometry.getOrdinatesArray()[0]) <= d && Math.abs(this.getOrdinatesArray()[1] - j3D_Geometry.getOrdinatesArray()[1]) <= d && Math.abs(this.getOrdinatesArray()[2] - j3D_Geometry.getOrdinatesArray()[2]) <= d;
    }

    public static J3D_Geometry expandGeom(J3D_Geometry j3D_Geometry) throws Exception {
        J3D_Geometry j3D_Geometry2 = null;
        int[] nArray = new int[1];
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n + 2 < j3D_Geometry.getElemInfo().length) {
            if (j3D_Geometry.getElemInfo()[n + 1] == 1007 && j3D_Geometry.getElemInfo()[n + 2] == 3) {
                bl = true;
            }
            if (j3D_Geometry.getElemInfo()[n + 1] == 1003 && j3D_Geometry.getElemInfo()[n + 2] == 3) {
                bl2 = true;
            }
            if (j3D_Geometry.getElemInfo()[n + 1] == 2003 && j3D_Geometry.getElemInfo()[n + 2] == 3) {
                bl3 = true;
            }
            n += 3;
        }
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        int n5 = j3D_Geometry.getType();
        int n6 = j3D_Geometry.getElemInfo()[1] % 1000;
        int n7 = j3D_Geometry.getElemInfo()[2];
        int n8 = j3D_Geometry.getElemInfo()[1] / 1000;
        int n9 = j3D_Geometry.getOrdinatesArray().length;
        if (n5 == 1 || n5 == 2 || n5 == 5 || n5 == 6) {
            return j3D_Geometry;
        }
        if (!(bl || bl2 || bl3)) {
            return j3D_Geometry;
        }
        int n10 = n5 == 9 || n5 == 7 || n5 == 6 || n5 == 5 || n6 == 2 && n9 != 6 || n5 == 4 || n6 == 8 ? n2 : (n6 == 3 || n6 == 6 ? n3 : (n6 == 7 || n5 == 8 ? n4 : n2));
        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, n10, 3, false);
        j3D_Geometry2 = elementExtractor.expandSolid(j3D_Geometry);
        j3D_Geometry2 = J3D_Geometry.expandRing(j3D_Geometry2);
        j3D_Geometry2.gtype = j3D_Geometry.getType();
        j3D_Geometry2.dim = j3D_Geometry.dim;
        j3D_Geometry2.linfo = j3D_Geometry.linfo;
        j3D_Geometry2.srid = j3D_Geometry.getSRID();
        return j3D_Geometry2;
    }

    private static J3D_Geometry expandRing(J3D_Geometry j3D_Geometry) throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n + 2 < j3D_Geometry.getElemInfo().length) {
            if (j3D_Geometry.getElemInfo()[n + 1] == 1003 && j3D_Geometry.getElemInfo()[n + 2] == 3) {
                arrayList.add(new Integer(n));
            } else if (j3D_Geometry.getElemInfo()[n + 1] == 2003 && j3D_Geometry.getElemInfo()[n + 2] == 3) {
                arrayList.add(new Integer(n));
            }
            n += 3;
        }
        if (arrayList.size() == 0) {
            return j3D_Geometry;
        }
        double[] dArray = new double[j3D_Geometry.getOrdinatesArray().length + 9 * arrayList.size()];
        int[] nArray = new int[j3D_Geometry.getElemInfo().length + 0 * arrayList.size()];
        double[] dArray2 = new double[j3D_Geometry.getOrdinatesArray().length];
        int[] nArray2 = new int[j3D_Geometry.getElemInfo().length];
        for (n = 0; n < j3D_Geometry.getElemInfo().length; ++n) {
            nArray2[n] = j3D_Geometry.getElemInfo()[n];
            nArray[n] = j3D_Geometry.getElemInfo()[n];
        }
        for (n = 0; n < j3D_Geometry.getOrdinatesArray().length; ++n) {
            dArray2[n] = j3D_Geometry.getOrdinatesArray()[n];
            dArray[n] = j3D_Geometry.getOrdinatesArray()[n];
        }
        for (n = 0; n < arrayList.size(); ++n) {
            int n2;
            int n3 = (Integer)arrayList.get(n);
            nArray[n3] = nArray2[n3] + n * 9;
            nArray[n3 + 2] = 1;
            J3D_Geometry.expandOrdinates(dArray, nArray2[n3] + n * 9 - 1, dArray2, nArray2[n3] - 1);
            if (n3 + 3 >= nArray2.length) continue;
            int n4 = n3 + 3 + (n + 1) * 0;
            for (n2 = n3 + 3; n2 < nArray2.length; ++n2) {
                nArray[n4] = n2 % 3 == 0 ? nArray2[n2] + (n + 1) * 9 : nArray2[n2];
                ++n4;
            }
            n4 = nArray2[n3 + 3] + (n + 1) * 9 - 1;
            for (n2 = nArray2[n3 + 3] - 1; n2 < dArray2.length; ++n2) {
                dArray[n4] = dArray2[n2];
                ++n4;
            }
        }
        int n5 = j3D_Geometry.getType();
        int n6 = j3D_Geometry.getSRID();
        J3D_Geometry j3D_Geometry2 = new J3D_Geometry(n5, n6, nArray, dArray);
        return j3D_Geometry2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void expandOrdinates(double[] dArray, int n, double[] dArray2, int n2) throws Exception {
        double d = 1.0E-16;
        if (dArray2[0 + n2] <= dArray2[3 + n2] && dArray2[1 + n2] <= dArray2[4 + n2] && dArray2[2 + n2] <= dArray2[5 + n2]) {
            if (Math.abs(dArray2[0 + n2] - dArray2[3 + n2]) <= d && Math.abs(dArray2[1 + n2] - dArray2[4 + n2]) > d && Math.abs(dArray2[2 + n2] - dArray2[5 + n2]) > d) {
                dArray[0 + n] = dArray2[0 + n2];
                dArray[1 + n] = dArray2[1 + n2];
                dArray[2 + n] = dArray2[2 + n2];
                dArray[3 + n] = dArray2[0 + n2];
                dArray[4 + n] = dArray2[4 + n2];
                dArray[5 + n] = dArray2[2 + n2];
                dArray[6 + n] = dArray2[0 + n2];
                dArray[7 + n] = dArray2[4 + n2];
                dArray[8 + n] = dArray2[5 + n2];
                dArray[9 + n] = dArray2[0 + n2];
                dArray[10 + n] = dArray2[1 + n2];
                dArray[11 + n] = dArray2[5 + n2];
                dArray[12 + n] = dArray2[0 + n2];
                dArray[13 + n] = dArray2[1 + n2];
                dArray[14 + n] = dArray2[2 + n2];
                return;
            } else if (Math.abs(dArray2[1 + n2] - dArray2[4 + n2]) <= d && Math.abs(dArray2[0 + n2] - dArray2[3 + n2]) > d && Math.abs(dArray2[2 + n2] - dArray2[5 + n2]) > d) {
                dArray[0 + n] = dArray2[0 + n2];
                dArray[1 + n] = dArray2[1 + n2];
                dArray[2 + n] = dArray2[2 + n2];
                dArray[3 + n] = dArray2[0 + n2];
                dArray[4 + n] = dArray2[1 + n2];
                dArray[5 + n] = dArray2[5 + n2];
                dArray[6 + n] = dArray2[3 + n2];
                dArray[7 + n] = dArray2[1 + n2];
                dArray[8 + n] = dArray2[5 + n2];
                dArray[9 + n] = dArray2[3 + n2];
                dArray[10 + n] = dArray2[1 + n2];
                dArray[11 + n] = dArray2[2 + n2];
                dArray[12 + n] = dArray2[0 + n2];
                dArray[13 + n] = dArray2[1 + n2];
                dArray[14 + n] = dArray2[2 + n2];
                return;
            } else {
                if (!(Math.abs(dArray2[2 + n2] - dArray2[5 + n2]) <= d) || !(Math.abs(dArray2[0 + n2] - dArray2[3 + n2]) > d) || !(Math.abs(dArray2[1 + n2] - dArray2[4 + n2]) > d)) throw new Exception("54535");
                dArray[0 + n] = dArray2[0 + n2];
                dArray[1 + n] = dArray2[1 + n2];
                dArray[2 + n] = dArray2[2 + n2];
                dArray[3 + n] = dArray2[3 + n2];
                dArray[4 + n] = dArray2[1 + n2];
                dArray[5 + n] = dArray2[2 + n2];
                dArray[6 + n] = dArray2[3 + n2];
                dArray[7 + n] = dArray2[4 + n2];
                dArray[8 + n] = dArray2[2 + n2];
                dArray[9 + n] = dArray2[0 + n2];
                dArray[10 + n] = dArray2[4 + n2];
                dArray[11 + n] = dArray2[2 + n2];
                dArray[12 + n] = dArray2[0 + n2];
                dArray[13 + n] = dArray2[1 + n2];
                dArray[14 + n] = dArray2[2 + n2];
            }
            return;
        } else {
            if (!(dArray2[0 + n2] >= dArray2[3 + n2]) || !(dArray2[1 + n2] >= dArray2[4 + n2]) || !(dArray2[2 + n2] >= dArray2[5 + n2])) throw new Exception("54537");
            if (Math.abs(dArray2[0 + n2] - dArray2[3 + n2]) <= d && Math.abs(dArray2[1 + n2] - dArray2[4 + n2]) > d && Math.abs(dArray2[2 + n2] - dArray2[5 + n2]) > d) {
                dArray[0 + n] = dArray2[0 + n2];
                dArray[1 + n] = dArray2[1 + n2];
                dArray[2 + n] = dArray2[2 + n2];
                dArray[3 + n] = dArray2[0 + n2];
                dArray[4 + n] = dArray2[1 + n2];
                dArray[5 + n] = dArray2[5 + n2];
                dArray[6 + n] = dArray2[0 + n2];
                dArray[7 + n] = dArray2[4 + n2];
                dArray[8 + n] = dArray2[5 + n2];
                dArray[9 + n] = dArray2[0 + n2];
                dArray[10 + n] = dArray2[4 + n2];
                dArray[11 + n] = dArray2[2 + n2];
                dArray[12 + n] = dArray2[0 + n2];
                dArray[13 + n] = dArray2[1 + n2];
                dArray[14 + n] = dArray2[2 + n2];
                return;
            } else if (Math.abs(dArray2[1 + n2] - dArray2[4 + n2]) <= d && Math.abs(dArray2[0 + n2] - dArray2[3 + n2]) > d && Math.abs(dArray2[2 + n2] - dArray2[5 + n2]) > d) {
                dArray[0 + n] = dArray2[0 + n2];
                dArray[1 + n] = dArray2[1 + n2];
                dArray[2 + n] = dArray2[2 + n2];
                dArray[3 + n] = dArray2[3 + n2];
                dArray[4 + n] = dArray2[1 + n2];
                dArray[5 + n] = dArray2[2 + n2];
                dArray[6 + n] = dArray2[3 + n2];
                dArray[7 + n] = dArray2[1 + n2];
                dArray[8 + n] = dArray2[5 + n2];
                dArray[9 + n] = dArray2[0 + n2];
                dArray[10 + n] = dArray2[1 + n2];
                dArray[11 + n] = dArray2[5 + n2];
                dArray[12 + n] = dArray2[0 + n2];
                dArray[13 + n] = dArray2[1 + n2];
                dArray[14 + n] = dArray2[2 + n2];
                return;
            } else {
                if (!(Math.abs(dArray2[2 + n2] - dArray2[5 + n2]) <= d) || !(Math.abs(dArray2[0 + n2] - dArray2[3 + n2]) > d) || !(Math.abs(dArray2[1 + n2] - dArray2[4 + n2]) > d)) throw new Exception("54535");
                dArray[0 + n] = dArray2[0 + n2];
                dArray[1 + n] = dArray2[1 + n2];
                dArray[2 + n] = dArray2[2 + n2];
                dArray[3 + n] = dArray2[0 + n2];
                dArray[4 + n] = dArray2[4 + n2];
                dArray[5 + n] = dArray2[2 + n2];
                dArray[6 + n] = dArray2[3 + n2];
                dArray[7 + n] = dArray2[4 + n2];
                dArray[8 + n] = dArray2[2 + n2];
                dArray[9 + n] = dArray2[3 + n2];
                dArray[10 + n] = dArray2[1 + n2];
                dArray[11 + n] = dArray2[2 + n2];
                dArray[12 + n] = dArray2[0 + n2];
                dArray[13 + n] = dArray2[1 + n2];
                dArray[14 + n] = dArray2[2 + n2];
            }
        }
    }

    protected static J3D_Geometry findPointOnGeodetic3DLineSegment(J3D_Geometry j3D_Geometry, double d) throws Exception {
        J3D_Geometry j3D_Geometry2 = null;
        int n = j3D_Geometry.getSRID();
        double d2 = j3D_Geometry.getOrdinatesArray()[2];
        double d3 = j3D_Geometry.getOrdinatesArray()[5];
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        dArray[0] = Math.PI * j3D_Geometry.getOrdinatesArray()[0] / 180.0;
        dArray[1] = Math.PI * j3D_Geometry.getOrdinatesArray()[1] / 180.0;
        dArray[2] = 0.0;
        J3D_Geometry.jMdsphgcu(dArray);
        dArray2[0] = Math.PI * j3D_Geometry.getOrdinatesArray()[3] / 180.0;
        dArray2[1] = Math.PI * j3D_Geometry.getOrdinatesArray()[4] / 180.0;
        dArray2[2] = 0.0;
        J3D_Geometry.jMdsphgcu(dArray2);
        J3D_Geometry.jMdsphintp(dArray, dArray2, d, dArray3);
        J3D_Geometry.jMdsphgdu(dArray3);
        dArray3[0] = dArray3[0] * 57.29577951308232;
        dArray3[1] = dArray3[1] * 57.29577951308232;
        dArray3[2] = Math.abs(d2 - d3) < 1.0E-15 ? d2 : (d2 >= d3 ? d2 - (d2 - d3) * d : d2 + (d3 - d2) * d);
        j3D_Geometry2 = new J3D_Geometry(1, n, new int[]{1, 1, 1}, dArray3);
        return j3D_Geometry2;
    }

    private static void jMdsphgcu(double[] dArray) {
        double d = Math.cos(dArray[1]);
        double d2 = Math.sin(dArray[1]);
        double d3 = Math.cos(dArray[0]);
        double d4 = Math.sin(dArray[0]);
        dArray[0] = d * d3;
        dArray[1] = d * d4;
        dArray[2] = d2;
    }

    private static void jMdsphgdu(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        dArray[0] = Math.atan2(dArray[1], dArray[0]);
        dArray[1] = Math.atan(dArray[2] / d);
    }

    private static double jMdsphab(double[] dArray, double[] dArray2, Object[] objectArray) {
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        if (Math.abs(dArray[0] - dArray2[0]) < 1.0E-15 && Math.abs(dArray[1] - dArray2[1]) < 1.0E-15 && Math.abs(dArray[2] - dArray2[2]) < 1.0E-15) {
            return 0.0;
        }
        dArray4 = J3D_Geometry.crossProduct(dArray, dArray2);
        dArray3[2] = 0.0;
        if (Math.abs(dArray[0]) < 1.0E-15 && Math.abs(dArray[1]) < 1.0E-15) {
            dArray3[0] = 0.0;
            dArray3[1] = dArray[2] > 0.0 ? 1.0 : -1.0;
        } else {
            dArray3[0] = dArray[1];
            dArray3[1] = -dArray[0];
        }
        dArray5 = J3D_Geometry.crossProduct(dArray4, dArray3);
        if (objectArray != null) {
            double d = (Double)objectArray[0];
            return Math.atan2((1.0 - d * dArray[2] * dArray[2]) / (1.0 - d) * J3D_Geometry.dotProduct(dArray5, dArray), J3D_Geometry.dotProduct(dArray4, dArray3));
        }
        return Math.atan2(J3D_Geometry.dotProduct(dArray5, dArray), J3D_Geometry.dotProduct(dArray4, dArray3));
    }

    private static void jMdsphvr(double[] dArray, double[] dArray2, double d, double[] dArray3) {
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        dArray4 = J3D_Geometry.crossProduct(dArray2, dArray);
        dArray5 = J3D_Geometry.crossProduct(dArray4, dArray2);
        double d2 = Math.sin(d);
        double d3 = Math.cos(d) - 1.0;
        dArray3[0] = dArray[0] + d3 * dArray5[0] + d2 * dArray4[0];
        dArray3[1] = dArray[1] + d3 * dArray5[1] + d2 * dArray4[1];
        dArray3[2] = dArray[2] + d3 * dArray5[2] + d2 * dArray4[2];
    }

    private static void jMdsphbd(double[] dArray, double d, double d2, double[] dArray2) {
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        dArray3[2] = 0.0;
        if (Math.abs(dArray[0]) < 1.0E-15 && Math.abs(dArray[1]) < 1.0E-15) {
            dArray3[0] = 0.0;
            dArray3[1] = dArray[2] > 0.0 ? 1.0 : -1.0;
        } else {
            dArray3[0] = dArray[1];
            dArray3[1] = -dArray[0];
        }
        J3D_Geometry.jMdsphvr(dArray3, dArray, -d2, dArray4);
        double d3 = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
        dArray4[0] = dArray4[0] / d3;
        dArray4[1] = dArray4[1] / d3;
        dArray4[2] = dArray4[2] / d3;
        J3D_Geometry.jMdsphvr(dArray, dArray4, d, dArray2);
    }

    private static void jMdsphintp(double[] dArray, double[] dArray2, double d, double[] dArray3) {
        int n = 0;
        if (dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2] || d == 0.0) {
            for (n = 0; n < 3; ++n) {
                dArray3[n] = dArray[n];
            }
            return;
        }
        if (d == 1.0) {
            for (n = 0; n < 3; ++n) {
                dArray3[n] = dArray2[n];
            }
            return;
        }
        double d2 = d * Math.acos(J3D_Geometry.dotProduct(dArray, dArray2));
        double d3 = J3D_Geometry.jMdsphab(dArray, dArray2, null);
        J3D_Geometry.jMdsphbd(dArray, d2, d3, dArray3);
    }

    protected static ArrayList findLRSProjectPtInfo(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d, String string, double d2, double d3, double d4) throws Exception {
        Object object;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        double d5 = -1.0;
        if (j3D_Geometry2.gtype != 1) {
            return arrayList;
        }
        ArrayList arrayList2 = j3D_Geometry.closestPointsLRS(j3D_Geometry2, d, string, d2, d3, d4);
        J3D_Geometry j3D_Geometry3 = (J3D_Geometry)arrayList2.get(0);
        J3D_Geometry j3D_Geometry4 = (J3D_Geometry)arrayList2.get(1);
        J3D_Geometry j3D_Geometry5 = (J3D_Geometry)arrayList2.get(2);
        J3D_Geometry j3D_Geometry6 = (J3D_Geometry)arrayList2.get(3);
        d5 = j3D_Geometry3.distance(j3D_Geometry4, d, string, d2, d3, d4);
        arrayList.add(j3D_Geometry3);
        arrayList.add(j3D_Geometry4);
        arrayList.add(j3D_Geometry5);
        arrayList.add(j3D_Geometry6);
        String string2 = j3D_Geometry.getLabelByElement(j3D_Geometry5, d);
        String string3 = "";
        string2 = ",".concat(string2);
        int n9 = 0;
        int n10 = 0;
        while (string2.indexOf(",") != -1) {
            string3 = string2.substring(string2.indexOf(",") + 1);
            if (string3.indexOf(",") == -1) {
                n10 = Integer.valueOf(string3);
            } else {
                object = string3.substring(0, string3.indexOf(","));
                n10 = Integer.valueOf((String)object);
                string3 = string3.substring(string3.indexOf(","));
            }
            string2 = string3;
            switch (n9 + 1) {
                case 1: {
                    n4 = n10;
                }
                case 2: {
                    n3 = n10;
                }
                case 3: {
                    n5 = n10;
                }
                case 4: {
                    n6 = n10;
                }
                case 5: {
                    n7 = n10;
                }
                case 6: {
                    n8 = n10;
                }
                case 7: {
                    n2 = n10;
                }
            }
            ++n9;
        }
        if (j3D_Geometry.gtype == 6) {
            if (j3D_Geometry5.gtype == 2) {
                n = j3D_Geometry.getElemInfo()[(n2 - 1) * 3] + (n3 - 1) * 3 - 1;
            } else if (j3D_Geometry5.gtype == 1) {
                n = j3D_Geometry.getElemInfo()[(n2 - 1) * 3] + (n3 - 1) * 3 + (n4 - 1) * 3 - 1;
            }
        }
        if (j3D_Geometry.gtype == 5) {
            n = (n4 - 1) * 3;
        }
        if (j3D_Geometry.gtype == 2 && j3D_Geometry.elemInfo[1] % 1000 == 2) {
            if (j3D_Geometry5.gtype == 2) {
                n = (n3 - 1) * 3;
            } else if (j3D_Geometry5.gtype == 1) {
                n = (n3 - 1) * 3 + (n4 - 1) * 3;
            }
        }
        arrayList.add(Integer.valueOf(n));
        arrayList.add(Integer.valueOf(0));
        object = new double[3];
        object[0] = j3D_Geometry5.getOrdinatesArray()[3] - j3D_Geometry5.getOrdinatesArray()[0];
        object[1] = j3D_Geometry5.getOrdinatesArray()[4] - j3D_Geometry5.getOrdinatesArray()[1];
        object[2] = 0.0;
        double[] dArray = new double[]{j3D_Geometry2.getOrdinatesArray()[0] - j3D_Geometry5.getOrdinatesArray()[0], j3D_Geometry2.getOrdinatesArray()[1] - j3D_Geometry5.getOrdinatesArray()[1], 0.0};
        double[] dArray2 = J3D_Geometry.crossProduct((double[])object, dArray);
        double d6 = J3D_Geometry.dotProduct(dArray2, new double[]{0.0, 0.0, 1.0});
        if (d6 > 0.0) {
            arrayList.add(Double.valueOf(d5));
        } else if (d6 < 0.0) {
            arrayList.add(Double.valueOf(-1.0 * d5));
        } else {
            arrayList.add(Double.valueOf(0.0));
        }
        return arrayList;
    }

    private static String shareEdge(ArrayList arrayList, double d) throws Exception {
        int n;
        String string = "";
        int[] nArray = new int[1];
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
        ArrayList<Object[]> arrayList4 = new ArrayList<Object[]>();
        ArrayList<double[][]> arrayList5 = new ArrayList<double[][]>();
        String string2 = "";
        ArrayList arrayList6 = new ArrayList();
        ArrayList arrayList7 = new ArrayList();
        ArrayList arrayList8 = new ArrayList();
        double[][] dArray = new double[3][2];
        for (n = 0; n < arrayList.size(); ++n) {
            Object[] objectArray = new Object[3];
            objectArray = (Object[])arrayList.get(n);
            J3D_Geometry j3D_Geometry = (J3D_Geometry)objectArray[0];
            arrayList6 = new ArrayList();
            arrayList6 = (ArrayList)objectArray[1];
            int n2 = (Integer)objectArray[2];
            arrayList4.add(objectArray);
            dArray = J3D_Geometry.getMBH(j3D_Geometry);
            arrayList5.add(dArray);
        }
        RTree rTree = new RTree(3, 8, 2, d);
        J3D_Geometry.createRTree2(rTree, arrayList5, arrayList4);
        ArrayList arrayList9 = new ArrayList();
        rTree.anyInteract(rTree, arrayList9);
        for (n = 0; n < arrayList9.size(); ++n) {
            J3D_Geometry j3D_Geometry;
            J3D_Geometry j3D_Geometry2;
            int n3;
            RTreeJoinRes rTreeJoinRes = (RTreeJoinRes)arrayList9.get(n);
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = new Object[3];
            objectArray = (Object[])rTreeJoinRes.ptr1;
            objectArray2 = (Object[])rTreeJoinRes.ptr2;
            J3D_Geometry j3D_Geometry3 = (J3D_Geometry)objectArray[0];
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)objectArray2[0];
            arrayList7 = new ArrayList();
            arrayList8 = new ArrayList();
            arrayList7 = (ArrayList)objectArray[1];
            arrayList8 = (ArrayList)objectArray2[1];
            int n4 = (Integer)objectArray[2];
            int n5 = (Integer)objectArray2[2];
            int n6 = (Integer)arrayList7.get(6);
            if (n6 == (n3 = ((Integer)arrayList8.get(6)).intValue()) || !j3D_Geometry3.anyInteract(j3D_Geometry4, d)) continue;
            arrayList2 = new ArrayList();
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry3, 0, 2, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry2 = elementExtractor.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    throw new Exception("54501");
                }
                arrayList2.add(j3D_Geometry2);
            }
            arrayList3 = new ArrayList();
            ElementExtractor elementExtractor2 = new ElementExtractor(j3D_Geometry4, 0, 2, 3, false);
            nArray[0] = 0;
            while ((j3D_Geometry = elementExtractor2.nextElement(nArray)) != null) {
                if (nArray[0] == 2) {
                    throw new Exception("54501");
                }
                arrayList3.add(j3D_Geometry);
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                for (int j = 0; j < arrayList3.size(); ++j) {
                    int n7;
                    if (!J3D_Geometry.T3reln((J3D_Geometry)arrayList2.get(i), (J3D_Geometry)arrayList3.get(j), d)) continue;
                    string2 = "13350: Members of MultiSurface can not share edge";
                    StringBuilder stringBuilder = new StringBuilder("");
                    for (n7 = 0; n7 < 1; ++n7) {
                        stringBuilder.append(",");
                        stringBuilder.append(String.valueOf((Integer)arrayList7.get(n7)));
                    }
                    stringBuilder.append(",");
                    stringBuilder.append(String.valueOf(i + 1));
                    stringBuilder.append(",");
                    stringBuilder.append(String.valueOf(1));
                    for (n7 = 3; n7 < arrayList7.size(); ++n7) {
                        stringBuilder.append(",");
                        stringBuilder.append(String.valueOf((Integer)arrayList7.get(n7)));
                    }
                    string = string.concat(string2 + ";").concat(stringBuilder.toString());
                    return string;
                }
            }
        }
        return string;
    }

    private static String valdtnStr(int n, int n2, ArrayList arrayList, String string, String string2) {
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder("");
        for (n3 = 0; n3 < n; ++n3) {
            stringBuilder.append(",");
            stringBuilder.append(String.valueOf((Integer)arrayList.get(n3)));
        }
        stringBuilder.append(",");
        stringBuilder.append(string);
        for (n3 = n2; n3 < arrayList.size(); ++n3) {
            stringBuilder.append(",");
            stringBuilder.append(String.valueOf((Integer)arrayList.get(n3)));
        }
        StringBuilder stringBuilder2 = new StringBuilder("");
        stringBuilder2.append(string2);
        stringBuilder2.append(";");
        stringBuilder2.append(stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private static String valdtnStr2(ArrayList arrayList, String string) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("");
        for (n = 0; n < arrayList.size(); ++n) {
            stringBuilder.append(",");
            stringBuilder.append(String.valueOf((Integer)arrayList.get(n)));
        }
        StringBuilder stringBuilder2 = new StringBuilder("");
        stringBuilder2.append(string);
        stringBuilder2.append(";");
        stringBuilder2.append(stringBuilder.toString());
        return stringBuilder2.toString();
    }

    private static String valdtnStr3(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append(string);
        stringBuilder.append(string2);
        stringBuilder.append(string3);
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    private static void main(String[] stringArray) throws Exception {
        J3D_Geometry j3D_Geometry = null;
        J3D_Geometry j3D_Geometry2 = null;
        J3D_Geometry j3D_Geometry3 = null;
        J3D_Geometry j3D_Geometry4 = null;
        int n = 3;
        double d = 1.0E-9;
        int[] nArray = new int[]{1, 1003, 1, 16, 1003, 1};
        double[] dArray = new double[]{6.0, 6.0, 6.0, 5.0, 6.0, 10.0, 3.0, 4.0, 8.0, 4.0, 4.0, 4.0, 6.0, 6.0, 6.0, 0.5, 0.0, 0.0, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.5, 0.0, 0.0};
        j3D_Geometry = new J3D_Geometry(7, 0, nArray, dArray);
        int[] nArray2 = new int[]{1, 1, 2};
        double[] dArray2 = new double[]{0.0, 1.0, 1.0, 0.5, 6.0, 0.0};
        j3D_Geometry2 = new J3D_Geometry(5, 0, nArray2, dArray2);
        System.out.println("Output must be TRUE-TRUE ; 0.0-0.0 ; TRUE-TRUE ; (0.0;0.0;0.0 and 0.0;0.0;0.0)-(0.0;0.0;0.0 and 0.0;0.0;0.0) ; 14.079515385565616-0.0 ; 0.0-0.0 ; 19.410482459010616-0.0");
        System.out.println(j3D_Geometry.anyInteract(j3D_Geometry2, d));
        System.out.println(j3D_Geometry2.anyInteract(j3D_Geometry, d));
        System.out.println(j3D_Geometry.distance(j3D_Geometry2, d));
        System.out.println(j3D_Geometry2.distance(j3D_Geometry, d));
        System.out.println(j3D_Geometry.validate(false, d));
        System.out.println(j3D_Geometry2.validate(false, d));
        ArrayList arrayList = new ArrayList();
        arrayList = j3D_Geometry.closestPoints(j3D_Geometry2, d);
        if (arrayList != null) {
            j3D_Geometry3 = (J3D_Geometry)arrayList.get(0);
            j3D_Geometry4 = (J3D_Geometry)arrayList.get(1);
            System.out.println(j3D_Geometry3.getOrdinatesArray()[0] + ";" + j3D_Geometry3.getOrdinatesArray()[1] + ";" + j3D_Geometry3.getOrdinatesArray()[2] + " and " + j3D_Geometry4.getOrdinatesArray()[0] + ";" + j3D_Geometry4.getOrdinatesArray()[1] + ";" + j3D_Geometry4.getOrdinatesArray()[2]);
        } else {
            System.out.println("NULL ");
        }
        arrayList = new ArrayList();
        arrayList = j3D_Geometry2.closestPoints(j3D_Geometry, d);
        if (arrayList != null) {
            j3D_Geometry3 = (J3D_Geometry)arrayList.get(0);
            j3D_Geometry4 = (J3D_Geometry)arrayList.get(1);
            System.out.println(j3D_Geometry3.getOrdinatesArray()[0] + ";" + j3D_Geometry3.getOrdinatesArray()[1] + ";" + j3D_Geometry3.getOrdinatesArray()[2] + " and " + j3D_Geometry4.getOrdinatesArray()[0] + ";" + j3D_Geometry4.getOrdinatesArray()[1] + ";" + j3D_Geometry4.getOrdinatesArray()[2]);
        } else {
            System.out.println("NULL ");
        }
        System.out.println(j3D_Geometry.area(d));
        System.out.println(j3D_Geometry2.area(d));
        System.out.println(j3D_Geometry.volume(d));
        System.out.println(j3D_Geometry2.volume(d));
        System.out.println(j3D_Geometry.length(1, d));
        System.out.println(j3D_Geometry2.length(1, d));
    }
}

