/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.rules.parser;

import java.text.MessageFormat;
import java.util.Properties;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.migration.applications.rules.parser.RegexUtil;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Regex {
    private static final String DOTALL = "dotall";
    private static final String CANON_EQ = "canon_eq";
    private static final String UNIX_LINES = "unix_lines";
    private static final String CASE_INSENSITIVE = "case_insensitive";
    private static final String COMMENTS = "comments";
    private static final String MULTILINE = "multiline";
    private static final String LITERAL = "literal";
    private static final String UNICODE_CASE = "unicode_case";
    private static final String PARAMS = "params";
    private static final String TYPE = "type";
    private static final String CLASS = "class";
    private static final String TRANSLATOR = "translator";
    private static final String SCRIPT = "script";
    private static final String REGEX = "regex";
    private static final String TEXT = "text";
    private Properties patternOptions = new Properties();
    private String m_name;
    private String m_description;
    private boolean m_recognizer;
    private String m_codeType;
    private String m_category;
    private String m_exampleCode;
    private String m_expression;
    private String m_replacement;
    private Pattern m_pattern;
    private int m_params = 0;
    private String m_classString;
    private String m_recommendation;
    private String m_scriptType;
    private String m_type;

    public Regex(Node node) {
        this.setName(XMLHelper.getAttributeNode((Node)node, (String)"name"));
        this.setDescription(XMLHelper.getAttributeNode((Node)node, (String)"description"));
        this.setRecognizer(XMLHelper.getAttributeNode((Node)node, (String)"recognizer"));
        this.setCodeType(XMLHelper.getAttributeNode((Node)node, (String)"codetype"));
        this.setCategory(XMLHelper.getAttributeNode((Node)node, (String)"codetype"));
        this.setExampleCode(XMLHelper.getNodeValue((Node)node, (String)"example"));
        this.setReplacement(XMLHelper.getNodeValue((Node)node, (String)"replacement"));
        this.setRecommendation(XMLHelper.getNodeValue((Node)node, (String)"recommendation"));
        this.setExpression(XMLHelper.getNodeValue((Node)node, (String)"expression"));
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            String string2;
            int n;
            NamedNodeMap namedNodeMap;
            if (nodeList.item(i).getNodeName().toLowerCase().equals("expression")) {
                namedNodeMap = nodeList.item(i).getAttributes();
                for (n = 0; n < namedNodeMap.getLength(); ++n) {
                    string2 = namedNodeMap.item(n).getNodeName();
                    string = namedNodeMap.item(n).getNodeValue();
                    if (string2.toLowerCase().equals(PARAMS)) {
                        this.setParams(Integer.parseInt(string));
                    }
                    if (string2.toLowerCase().equals(CASE_INSENSITIVE)) {
                        this.patternOptions.put(CASE_INSENSITIVE, string);
                    }
                    if (string2.toLowerCase().equals(MULTILINE)) {
                        this.patternOptions.put(MULTILINE, string);
                    }
                    if (string2.toLowerCase().equals(UNIX_LINES)) {
                        this.patternOptions.put(UNIX_LINES, string);
                    }
                    if (string2.toLowerCase().equals(UNICODE_CASE)) {
                        this.patternOptions.put(UNICODE_CASE, string);
                    }
                    if (string2.toLowerCase().equals(COMMENTS)) {
                        this.patternOptions.put(COMMENTS, string);
                    }
                    if (string2.toLowerCase().equals(DOTALL)) {
                        this.patternOptions.put(DOTALL, string);
                    }
                    if (string2.toLowerCase().equals(LITERAL)) {
                        this.patternOptions.put(LITERAL, string);
                    }
                    if (!string2.toLowerCase().equals(CANON_EQ)) continue;
                    this.patternOptions.put(CANON_EQ, string);
                }
            }
            if (!nodeList.item(i).getNodeName().toLowerCase().equals("replacement")) continue;
            namedNodeMap = nodeList.item(i).getAttributes();
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                string2 = namedNodeMap.item(n).getNodeName();
                string = namedNodeMap.item(n).getNodeValue();
                if (string2.toLowerCase().equals(TYPE)) {
                    this.setType(string);
                }
                if (string2.toLowerCase().equals(CLASS)) {
                    this.setClassString(string);
                }
                if (!string2.toLowerCase().equals(SCRIPT)) continue;
                this.setScriptType(string);
            }
        }
    }

    private void setType(String string) {
        this.m_type = string;
    }

    private void setScriptType(String string) {
        this.m_scriptType = string;
    }

    private void setCategory(String string) {
        this.m_category = string;
    }

    public String getCategory() {
        return this.m_category;
    }

    private void setClassString(String string) {
        this.m_classString = string;
    }

    public String getClassString() {
        return this.m_classString;
    }

    public boolean isRegex() {
        String string = this.getExpression();
        return string.indexOf("\\") > 0 || string.indexOf("(") > 0 || string.indexOf(")") > 0 || string.indexOf("^") > 0 || string.indexOf("$") > 0 || string.indexOf("[") > 0 || string.indexOf("+") > 0 || string.indexOf("*") > 0 || string.indexOf("]") > 0;
    }

    public final Pattern getPattern(int n) {
        if (this.m_pattern == null) {
            if (n == -1) {
                this.m_pattern = Pattern.compile(this.getExpression());
            }
            this.m_pattern = Pattern.compile(this.getExpression(), n);
        }
        return this.m_pattern;
    }

    public final Pattern getPattern() {
        this.m_pattern = this.getPatternOptions() != 0 ? Pattern.compile(this.getExpression(), this.getPatternOptions()) : Pattern.compile(this.getExpression());
        return this.m_pattern;
    }

    private final int getPatternOptions() {
        int n = 0;
        if (this.isCaseInsensitive()) {
            n |= 2;
        }
        if (this.isMultiLine()) {
            n |= 8;
        }
        if (this.isDotAll()) {
            n |= 0x20;
        }
        if (this.isUnixLines()) {
            n |= 1;
        }
        if (this.isCommentsOn()) {
            n |= 4;
        }
        if (this.isLiteralOn()) {
            n |= 0x10;
        }
        if (this.isUnicodeCaseOn()) {
            n |= 0x40;
        }
        if (this.isCanonEqOn()) {
            n |= 0x80;
        }
        return n;
    }

    public final boolean isMultiLine() {
        return this.patternOptions.get(MULTILINE) != null;
    }

    private boolean isCanonEqOn() {
        return this.patternOptions.get(CANON_EQ) != null;
    }

    private boolean isUnicodeCaseOn() {
        return this.patternOptions.get(UNICODE_CASE) != null;
    }

    private boolean isLiteralOn() {
        return this.patternOptions.get(LITERAL) != null;
    }

    private boolean isCommentsOn() {
        return this.patternOptions.get(COMMENTS) != null;
    }

    private boolean isUnixLines() {
        return this.patternOptions.get(UNIX_LINES) != null;
    }

    private boolean isDotAll() {
        return this.patternOptions.get(DOTALL) != null;
    }

    public final void setPattern(Pattern pattern) {
        this.m_pattern = pattern;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String string) {
        this.m_name = string;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final void setDescription(String string) {
        this.m_description = string;
    }

    public final boolean isRecognizer() {
        return this.m_recognizer;
    }

    public final void setRecognizer(boolean bl) {
        this.m_recognizer = bl;
    }

    public void setRecognizer(String string) {
        if (string != null && string.toLowerCase().trim().equals("true")) {
            this.setRecognizer(true);
        } else {
            this.setRecognizer(false);
        }
    }

    public final String getcodeType() {
        return this.m_codeType;
    }

    public final void setCodeType(String string) {
        this.m_codeType = string;
    }

    public final String getExampleCode() {
        return this.m_exampleCode;
    }

    public final void setExampleCode(String string) {
        this.m_exampleCode = string;
    }

    public final String getExpression() {
        return this.m_expression;
    }

    public final String getExpressionWithParameters() {
        if (this.hasParams()) {
            return RegexUtil.getExpression(this.getParams(), this.m_expression);
        }
        return this.m_expression;
    }

    public final void setExpression(String string) {
        this.m_expression = string;
    }

    public final String getReplacement() {
        return this.m_replacement;
    }

    public final void setReplacement(String string) {
        this.m_replacement = string;
    }

    public boolean isDirectReplacement() {
        return this.m_type == null || this.m_type.toLowerCase().equals(TEXT) || this.m_type.toLowerCase().equals(REGEX);
    }

    public boolean isScriptReplacement() {
        return this.m_type.toLowerCase().equals(SCRIPT) && this.getScriptType() != null && this.getScriptType().length() > 0;
    }

    public final boolean isClassReplacementSet() {
        return this.m_type.toLowerCase().equals(CLASS) && this.m_classString != null && !this.m_classString.equals("");
    }

    public final boolean isTranslatorSet() {
        return this.m_type.toLowerCase().equals(TRANSLATOR);
    }

    public final void generatePattern() {
        if (this.getExpression() != null && !this.getExpression().equals("")) {
            try {
                this.m_pattern = Pattern.compile(this.getExpression());
            }
            catch (Exception exception) {
                System.out.println(MessageFormat.format("Pattern compilation failed for: {0} : {1}", this.getName(), this.getExpression()));
            }
        }
    }

    public boolean hasParams() {
        return this.m_params > 0;
    }

    public int getParams() {
        if (this.hasParams()) {
            return this.m_params;
        }
        return 0;
    }

    public void setParams(int n) {
        this.m_params = n;
    }

    public boolean isCaseInsensitive() {
        return this.patternOptions.get(CASE_INSENSITIVE) != null;
    }

    public String getRecommendation() {
        return this.m_recommendation;
    }

    public void setRecommendation(String string) {
        this.m_recommendation = string;
    }

    public boolean hasRecommendation() {
        return this.m_recommendation != null && !this.m_recommendation.trim().equals("");
    }

    public String getErrorTags() {
        return "My Tag\n";
    }

    public boolean validReplacement() {
        if (this.getReplacementType() != null) {
            if (this.getReplacementType().equals(CLASS) && this.getClassString() != null && !this.getClassString().equals("")) {
                return true;
            }
            if (this.getReplacementType().toLowerCase().equals(TRANSLATOR)) {
                return true;
            }
            if (this.getReplacementType().toLowerCase().equals(SCRIPT) && this.getScriptType() != null && this.getScriptType().length() > 0 && this.getReplacement() != null && this.getReplacement().length() > 0) {
                return true;
            }
            if (this.getReplacementType().toLowerCase().equals(TEXT)) {
                return true;
            }
            return this.getReplacementType().toLowerCase().equals(REGEX);
        }
        return false;
    }

    public String getScriptType() {
        return this.m_scriptType;
    }

    public String getReplacementType() {
        return this.m_type;
    }
}

