/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.rules;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.migration.applications.Messages;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.rules.parser.RulesParser;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.ide.net.URLFactory;

public class RulesRegistry {
    private static final String RAPTOR_APP_RULES = "rulesdir";
    private static Logger logger = Logger.getLogger(RulesRegistry.class.getName());
    private static RulesRegistry _instance;
    private static Object REGISTEREDPACKAGESLOCK;
    private static Object INSTANCELOCK;
    private static List<String> _registeredPackages;
    private static List<URL> _registeredRules;
    private static String rulesfailure;
    private boolean LOADED = false;
    private ScannerDetails m_options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RulesRegistry getInstance() {
        Object object = INSTANCELOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new RulesRegistry();
            }
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void registerPackage(String string) {
        Object object = REGISTEREDPACKAGESLOCK;
        synchronized (object) {
            if (!_registeredPackages.contains(string)) {
                _registeredPackages.add(string);
            }
        }
    }

    public static synchronized void registerRules(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = URLFactory.newFileURL((File)new File(string));
        }
        if (uRL != null) {
            _registeredRules.add(uRL);
        } else {
            logger.info(MessageFormat.format(Messages.getString("RulesRegistry.2"), string));
        }
    }

    public void loadXML(URL uRL) {
        File file;
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getPath());
        }
        arrayList.addAll(this.buildFileList(file));
        this.processFiles(arrayList);
    }

    public void loadXML(ScannerDetails scannerDetails) {
        this.m_options = scannerDetails;
        this.loadXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadXML() {
        Object object = INSTANCELOCK;
        synchronized (object) {
            if (!this.LOADED) {
                List<File> list;
                if (DBConfig.getInstance() != null && DBConfig.getInstance().getExtensions("RULES") != null && (list = DBConfig.getInstance().getExtensions("RULES")) != null) {
                    for (String object22 : list) {
                        RulesRegistry.registerRules(object22);
                    }
                }
                list = new ArrayList();
                Object object3 = null;
                Object var4_5 = null;
                if (System.getProperty(RAPTOR_APP_RULES) != null) {
                    object3 = System.getProperty(RAPTOR_APP_RULES);
                    File file = new File((String)object3);
                    ((ArrayList)list).addAll(this.buildFileList(file));
                }
                if (this.m_options != null && this.m_options.getRulesDir() != null) {
                    object3 = this.m_options.getRulesDir();
                    File file = new File((String)object3);
                    ((ArrayList)list).addAll(this.buildFileList(file));
                }
                RulesParser rulesParser = this.processFiles((ArrayList<File>)list);
                this.addPackages(rulesParser);
                for (URL uRL : RulesRegistry.getRegisteredRules()) {
                    try {
                        InputStream inputStream = uRL.openStream();
                        rulesParser.processXML(inputStream, uRL);
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        logger.log(Level.INFO, rulesfailure, exception);
                    }
                }
                rulesParser.closeParser();
                this.LOADED = true;
            }
        }
    }

    public void loadSpecificRules(ScannerDetails scannerDetails) {
        this.m_options = scannerDetails;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = null;
        File file = null;
        if (this.m_options.getRulesDir() != null) {
            string = this.m_options.getRulesDir();
            file = new File(string);
            arrayList.addAll(this.buildFileList(file));
        }
        this.processFiles(arrayList);
    }

    private RulesParser processFiles(ArrayList<File> arrayList) {
        RulesParser rulesParser = new RulesParser();
        Iterator<File> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(iterator.next());
                rulesParser.processXML(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                logger.log(Level.INFO, rulesfailure, exception);
            }
        }
        return rulesParser;
    }

    private ArrayList<File> buildFileList(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().endsWith(".xml");
                }
            })) {
                arrayList.addAll(this.buildFileList(file2));
            }
        } else {
            arrayList.add(file);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackages(RulesParser rulesParser) {
        Object object = REGISTEREDPACKAGESLOCK;
        synchronized (object) {
            for (String string : RulesRegistry.getRegisteredPackages()) {
                try {
                    for (URL uRL : FileUtils.getFilesInPackage((String)string, (ClassLoader)this.getClass().getClassLoader(), (String)"xml")) {
                        try {
                            rulesParser.processXML(uRL.openStream(), uRL);
                        }
                        catch (Exception exception) {
                            logger.log(Level.INFO, rulesfailure, exception);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, rulesfailure, exception);
                }
            }
        }
    }

    public static synchronized List<String> getRegisteredPackages() {
        return _registeredPackages;
    }

    public static synchronized List<URL> getRegisteredRules() {
        return _registeredRules;
    }

    static {
        REGISTEREDPACKAGESLOCK = new Object();
        INSTANCELOCK = new Object();
        _registeredPackages = new ArrayList<String>();
        _registeredRules = new ArrayList<URL>();
        rulesfailure = Messages.getString("RulesRegistry.1");
    }
}

