/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.BrowserInfo;
import oracle.ideimpl.webbrowser.BrowserOptions;
import oracle.ideimpl.webbrowser.WebBrowserExtArb;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class PreviewInBrowserSplitButton
extends ActionMenuToolButton
implements ChangeListener {
    public static final int PREVIEW_IN_BROWSER_FROM_DESIGN_OR_SOURCE_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"ToolbarIdeCommands.PREVIEW_IN_BROWSER_CMD_ID");
    public static final int PREVIEW_IN_BROWSER_FROM_PREVIEW_TAB_CMD_ID = Ide.findOrCreateCmdID((String)"ToolbarIdeCommands.PREVIEW_IN_BROWSER_FROM_PREVIEW_TAB_CMD_ID");
    private Context context;
    private List browserIsDefaultList;
    private List<String> browserNameList;
    private List<String> browserPathList;
    private List<String> browserParamList;
    private List<String> browserIconList;
    private boolean useEmbeddedBrowserForPreview;
    private boolean isPreviewFromDesignOrSourceTab;
    private boolean showTextLabel;

    public PreviewInBrowserSplitButton() {
        this(true);
    }

    public PreviewInBrowserSplitButton(boolean isPreviewFromDesignOrSourceTab) {
        this(isPreviewFromDesignOrSourceTab, true);
    }

    public PreviewInBrowserSplitButton(boolean isPreviewFromDesignOrSourceTab, boolean showTextLabel) {
        super(null);
        this.setIconTextGap(4);
        this.isPreviewFromDesignOrSourceTab = isPreviewFromDesignOrSourceTab;
        this.showTextLabel = showTextLabel;
        Preferences p = Preferences.getPreferences();
        BrowserOptions browserOptions = BrowserOptions.getInstance((PropertyStorage)p);
        this.updateLocalMemoOfBrowserOptions(browserOptions);
        this.refreshButtonAndMenuActions(browserOptions);
        browserOptions.addChangeListener(this);
    }

    private void refreshButtonAndMenuActions(BrowserOptions browserOptions) {
        int browserIndex = browserOptions.getDefaultBrowserIndex();
        BrowserInfo defaultBrowserInfo = browserOptions.getBrowserInfo(browserIndex);
        int cmdId = this.isPreviewFromDesignOrSourceTab ? PREVIEW_IN_BROWSER_FROM_DESIGN_OR_SOURCE_TAB_CMD_ID : PREVIEW_IN_BROWSER_FROM_PREVIEW_TAB_CMD_ID;
        Icon defaultBrowserIcon = BrowserOptions.getOracleIcon(defaultBrowserInfo.getIconId());
        String buttonLabel = this.showTextLabel ? BrowserArb.getString(78) : null;
        IdeAction topLevelAction = IdeAction.findOrCreate((int)cmdId, null, (String)buttonLabel, null, (Integer)-1, (Icon)defaultBrowserIcon, null, (boolean)true);
        topLevelAction.putValue("SmallIcon", (Object)defaultBrowserIcon);
        this.setAction((Action)topLevelAction);
        this.setText(buttonLabel);
        this.setToolTipText(defaultBrowserInfo.getName());
        Action[] actions = PreviewInBrowserSplitButton.generatePreviewInBrowserActions(this.browserNameList, this.browserIconList);
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null) continue;
            ((AbstractAction)actions[i]).putValue("TOP_LEVEL_ACTION", topLevelAction);
            ((AbstractAction)actions[i]).putValue("TOP_LEVEL_BUTTON", new WeakReference<PreviewInBrowserSplitButton>(this));
        }
        this.setMenuActions(actions);
    }

    public void setAction(Action action) {
        if (action == null) {
            this.dispose();
        }
        super.setAction(action);
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void dispose() {
        if (this.getAction() != null) {
            this.setMenuActions(null);
            Preferences p = Preferences.getPreferences();
            BrowserOptions browserOptions = BrowserOptions.getInstance((PropertyStorage)p);
            browserOptions.removeChangeListener(this);
            this.setContext(null);
        }
    }

    public static PreviewInBrowserAction[] generatePreviewInBrowserActions(List<String> browserNameList, List<String> browserIconList) {
        int numOfBrowsers = browserNameList.size();
        ArrayList<PreviewInBrowserAction> previewActions = new ArrayList<PreviewInBrowserAction>();
        for (int i = 0; i < numOfBrowsers; ++i) {
            String buttonLabel = BrowserArb.format(79, browserNameList.get(i));
            String iconId = browserIconList.get(i);
            Icon icon = BrowserOptions.getOracleIcon(iconId);
            PreviewInBrowserAction action = new PreviewInBrowserAction(i, buttonLabel, icon);
            previewActions.add(action);
            action.putValue("ShortDescription", buttonLabel);
            action.putValue("SmallIcon", icon);
        }
        OpenBrowserOptionsAction openBrowserOptionAction = new OpenBrowserOptionsAction();
        openBrowserOptionAction.putValue("ShortDescription", BrowserArb.getString(80));
        openBrowserOptionAction.putValue("SmallIcon", null);
        PreviewInBrowserAction[] actions = new PreviewInBrowserAction[previewActions.size() + 2];
        for (int i = 0; i < previewActions.size(); ++i) {
            actions[i] = (PreviewInBrowserAction)previewActions.get(i);
        }
        actions[actions.length - 2] = null;
        actions[actions.length - 1] = openBrowserOptionAction;
        return actions;
    }

    private void updateLocalMemoOfBrowserOptions(BrowserOptions browserOptions) {
        this.browserIsDefaultList = ListStructure.newInstance();
        this.browserNameList = ListStructure.newInstance();
        this.browserPathList = ListStructure.newInstance();
        this.browserParamList = ListStructure.newInstance();
        this.browserIconList = ListStructure.newInstance();
        this.browserIsDefaultList.addAll(browserOptions.getBrowserIsDefaultList());
        this.browserNameList.addAll((Collection<String>)browserOptions.getBrowserNameList());
        this.browserPathList.addAll((Collection<String>)browserOptions.getBrowserPathList());
        this.browserParamList.addAll((Collection<String>)browserOptions.getBrowserParamList());
        this.browserIconList.addAll((Collection<String>)browserOptions.getBrowserIconList());
        this.useEmbeddedBrowserForPreview = browserOptions.getUseEmbeddedBrowserForPreview();
    }

    private boolean needToUpdateSplitButton(BrowserOptions browserOptions) {
        return !this.browserIsDefaultList.equals(browserOptions.getBrowserIsDefaultList()) || !this.browserNameList.equals(browserOptions.getBrowserNameList()) || !this.browserPathList.equals(browserOptions.getBrowserPathList()) || !this.browserParamList.equals(browserOptions.getBrowserParamList()) || !this.browserIconList.equals(browserOptions.getBrowserIconList()) || this.useEmbeddedBrowserForPreview != browserOptions.getUseEmbeddedBrowserForPreview();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Preferences p = Preferences.getPreferences();
        BrowserOptions browserOptions = BrowserOptions.getInstance((PropertyStorage)p);
        if (!this.needToUpdateSplitButton(browserOptions)) {
            return;
        }
        this.updateLocalMemoOfBrowserOptions(browserOptions);
        this.refreshButtonAndMenuActions(browserOptions);
    }

    private static class PreviewInBrowserAction
    extends AbstractAction {
        public static final String BROWSER_INDEX = "BROWSER_INDEX";
        public static final String TOP_LEVEL_BUTTON = "TOP_LEVEL_BUTTON";
        public static final String TOP_LEVEL_ACTION = "TOP_LEVEL_ACTION";

        public PreviewInBrowserAction(int index, String buttonLabel, Icon icon) {
            super(buttonLabel, icon);
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", buttonLabel);
            this.putValue(BROWSER_INDEX, index);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WeakReference topLevelButtonRef;
            JMenuItem clickedItem = (JMenuItem)e.getSource();
            PreviewInBrowserAction selectedAction = (PreviewInBrowserAction)clickedItem.getAction();
            Preferences p = Preferences.getPreferences();
            BrowserOptions browserOptions = BrowserOptions.getInstance((PropertyStorage)p);
            int selectedBrowserIndex = selectedAction.getBrowserIndex();
            browserOptions.setPreviewBrowserIndex(selectedBrowserIndex);
            if (selectedBrowserIndex != -1) {
                BrowserInfo previewBrowserInfo = browserOptions.getPreviewBrowserInfo();
                String defaultBrowserPath = previewBrowserInfo.getPath();
                String defaultBrowserParam = previewBrowserInfo.getParam();
                browserOptions.setBrowserCmdLine(defaultBrowserPath, defaultBrowserParam);
            }
            if ((topLevelButtonRef = (WeakReference)this.getValue(TOP_LEVEL_BUTTON)) != null) {
                ActionMenuToolButton topLevelButton = (ActionMenuToolButton)topLevelButtonRef.get();
                if (topLevelButton != null) {
                    Action topLevelAction = (Action)this.getValue(TOP_LEVEL_ACTION);
                    topLevelButton.setIcon((Icon)selectedAction.getValue("SmallIcon"));
                    topLevelButton.setToolTipText((String)selectedAction.getValue("ShortDescription"));
                    topLevelAction.actionPerformed(new ActionEvent(topLevelButton, 0, PreviewInBrowserAction.class.getName()));
                }
            } else {
                IdeAction topLevelAction = IdeAction.findOrCreate((int)PREVIEW_IN_BROWSER_FROM_DESIGN_OR_SOURCE_TAB_CMD_ID, null, null);
                topLevelAction.actionPerformed(new ActionEvent(this, 0, PreviewInBrowserAction.class.getName()));
            }
        }

        public int getBrowserIndex() {
            return (Integer)this.getValue(BROWSER_INDEX);
        }
    }

    private static class OpenBrowserOptionsAction
    extends PreviewInBrowserAction {
        public OpenBrowserOptionsAction() {
            super(Short.MAX_VALUE, BrowserArb.getString(80), null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectionPath = WebBrowserExtArb.get("WEBBROWSER_PANEL_NAME");
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{selectionPath});
        }
    }
}

