/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.shell;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.kv.KVStore;
import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.avro.JsonAvroBinding;
import oracle.kv.avro.JsonRecord;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.api.table.TableJsonUtils;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.shell.CommandUtils;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;

public class PutCommand
extends CommandWithSubs {
    static final String VALUE_FLAG = "-value";
    static final String JSON_FLAG = "-json";
    static final String FILE_FLAG = "-file";
    static final String IFABSENT_FLAG = "-if-absent";
    static final String IFABSENT_FLAG_DESC = "-if-absent";
    static final String IFPRESENT_FLAG = "-if-present";
    static final String IFPRESENT_FLAG_DESC = "-if-present";
    static final String COMMAND_OVERVIEW = "The put command encapsulates commands that put key/value pairs into a store" + eol + "and rows into a table.";
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new PutKVCommand(), new PutTableCommand());

    public PutCommand() {
        super(subs, "put", 3, 2);
    }

    @Override
    protected String getCommandOverview() {
        return COMMAND_OVERVIEW;
    }

    static class PutTableCommand
    extends CommandWithSubs.SubCommand {
        static final String TABLE_COMMAND = "table";
        static final String TABLE_FLAG = "-name";
        static final String TABLE_FLAG_DESC = "-name <name>";
        static final String FIELD_FLAG = "-field";
        static final String FIELD_FLAG_DESC = "-field <name>";
        static final String VALUE_FLAG_DESC = "-value <value>";
        static final String NULL_VALUE_FLAG = "-null-value";
        static final String NULL_VALUE_FLAG_DESC = "-null-value";
        static final String JSON_FLAG_DESC = "-json <string>";
        static final String FILE_FLAG_DESC = "-file <file>";
        static final String UPDATE_FLAG = "-update";
        static final String UPDATE_FLAG_DESC = "-update";
        static final String EXACT_FLAG = "-exact";
        static final String EXACT_FLAG_DESC = "-exact";
        static final String PUT_TABLE_SYNTAX = "put table -name <name> [-if-absent | -if-present]" + eolt + "[" + "-json <string>" + "] [" + "-file <file>" + "]" + "[" + "-exact" + "] [" + "-update" + "]";
        static final String PUT_TABLE_DESCRIPTION = "Put a row into the named table.  The table name is a dot-separated" + eolt + "name with the format " + "tableName[.childTableName]+." + eolt + "-if-absent" + " indicates to put a row only if the row does " + "not exist." + eolt + "-if-present" + " indicates to put a row only if the row " + "already exists." + eolt + "-json" + " indicates that the value is a JSON string." + eolt + "-file" + " can be used to load JSON strings from a file." + eolt + "-exact" + " indicates that the input json string or file" + " must contain values for all columns in the table, and cannot " + "contain extraneous fields." + eolt + "-update" + " can be used to partially update the " + "existing record.";
        private static final String currentPutParams = "currentPutParams";
        private TableCmdWithSubs cmdSubs = new TablePutSubs();

        PutTableCommand() {
            super(TABLE_COMMAND, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            PutArgs putParams = (PutArgs)this.getVariable(currentPutParams);
            if (putParams == null) {
                Shell.checkHelp(args, this);
                String tableName = null;
                String jsonString = null;
                String fileName = null;
                Boolean ifAbsent = null;
                boolean isUpdate = false;
                boolean jsonExact = false;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (TABLE_FLAG.equals(arg)) {
                        tableName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-if-absent".equals(arg)) {
                        ifAbsent = true;
                        continue;
                    }
                    if ("-if-present".equals(arg)) {
                        ifAbsent = false;
                        continue;
                    }
                    if (PutCommand.JSON_FLAG.equals(arg)) {
                        jsonString = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (PutCommand.FILE_FLAG.equals(arg)) {
                        fileName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-update".equals(arg)) {
                        isUpdate = true;
                        ifAbsent = false;
                        continue;
                    }
                    if ("-exact".equals(arg)) {
                        jsonExact = true;
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (tableName == null) {
                    shell.requiredArg(TABLE_FLAG, this);
                }
                TableAPI tableImpl = ((CommandShell)shell).getStore().getTableAPI();
                Table table = CommandUtils.findTable(tableImpl, tableName);
                if (fileName != null) {
                    return this.putJsonFromFile(tableImpl, table, fileName, ifAbsent, isUpdate, jsonExact);
                }
                Row row = null;
                if (jsonString != null) {
                    try {
                        row = this.createRowFromJson(tableImpl, table, jsonString, isUpdate, jsonExact);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage());
                    }
                    return PutTableCommand.doPutRow(tableImpl, row, ifAbsent, false);
                }
                row = table.createRow();
                ShellCommand cmd = this.clone();
                cmd.addVariable(currentPutParams, new PutArgs(row, ifAbsent, isUpdate));
                cmd.setPrompt(tableName);
                shell.pushCurrentCommand(cmd);
                return null;
            }
            return this.cmdSubs.execute(putParams, args, shell);
        }

        private Row createRowFromJson(TableAPI tableImpl, Table table, String json, boolean isUpdate, boolean isExact) {
            Row row;
            if (isUpdate) {
                PrimaryKey key = table.createPrimaryKeyFromJson(json, false);
                row = tableImpl.get(key, null);
                if (row == null) {
                    throw new IllegalArgumentException("No existing record was present with the given primary key: " + key.toJsonString(false));
                }
                row.copyFrom(table.createRowFromJson(json, isExact));
            } else {
                row = table.createRowFromJson(json, isExact);
            }
            return row;
        }

        private String putJsonFromFile(TableAPI tableImpl, Table table, String fileName, Boolean ifAbsent, boolean isUpdate, boolean jsonExact) throws ShellException {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(fileName));
                Row row = null;
                int numRows = 0;
                while ((line = br.readLine()) != null) {
                    if (PutTableCommand.isComment(line)) continue;
                    try {
                        row = this.createRowFromJson(tableImpl, table, line, isUpdate, jsonExact);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage());
                    }
                    ++numRows;
                    String error = PutTableCommand.doPutRow(tableImpl, row, ifAbsent, true);
                    if (error == null) continue;
                    String string = error;
                    return string;
                }
                String string = (isUpdate ? "Updated " : "Inserted ") + numRows + (numRows > 1 ? " rows in " : " row in ") + table.getFullName() + " table";
                return string;
            }
            catch (FileNotFoundException fnf) {
                throw new ShellException("File not found: " + fileName, fnf);
            }
            catch (IOException ioe) {
                throw new ShellException("IO error reading file: " + fileName, ioe);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }

        private static boolean isComment(String line) {
            int jsonStartIdx = line.indexOf(123);
            int commentIdx = line.indexOf(35);
            return jsonStartIdx < 0 || commentIdx >= 0 && jsonStartIdx > commentIdx;
        }

        @Override
        protected String getCommandSyntax() {
            return PUT_TABLE_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return PUT_TABLE_DESCRIPTION;
        }

        private static String doPutRow(final TableAPI tableImpl, final Row row, final Boolean ifAbsent, final boolean returnErrorOnly) throws ShellException {
            final StringBuilder sb = new StringBuilder();
            new CommandUtils.RunTableAPIOperation(){

                @Override
                void doOperation() {
                    boolean updated = false;
                    if (ifAbsent != null) {
                        if (ifAbsent.booleanValue()) {
                            if (tableImpl.putIfAbsent(row, null, null) == null) {
                                sb.append("Operation failed, ");
                                sb.append("A record was already present ");
                                sb.append("with the given primary key: ");
                                sb.append(row.createPrimaryKey().toJsonString(false));
                            }
                        } else if (tableImpl.putIfPresent(row, null, null) == null) {
                            sb.append("Operation failed, ");
                            sb.append("No existing record was present ");
                            sb.append("with the given primary key: ");
                            sb.append(row.createPrimaryKey().toJsonString(false));
                        } else {
                            updated = true;
                        }
                    } else if (tableImpl.putIfAbsent(row, null, null) == null) {
                        tableImpl.putIfPresent(row, null, null);
                        updated = true;
                    }
                    if (sb.length() == 0 && !returnErrorOnly) {
                        sb.append("Operation successful, row ");
                        sb.append(updated ? "updated." : "inserted.");
                    }
                }
            }.run();
            if (sb.length() == 0) {
                return null;
            }
            return sb.toString();
        }

        static class TableExitSub
        extends TableCmdSubCommand {
            static final String COMMAND = "exit";
            static final String COMMAND_DESCRIPTION = "Exit the current operation.";

            protected TableExitSub() {
                super(COMMAND, 4);
            }

            @Override
            public String execute(String[] args, Shell shell) throws ShellException {
                Shell.checkHelp(args, this);
                if (args.length != 1) {
                    shell.badArgCount(this);
                }
                String retString = null;
                TableAPI tableImpl = ((CommandShell)shell).getStore().getTableAPI();
                FieldValue fieldValue = this.getCurrentFieldValue();
                if (fieldValue.isRow()) {
                    retString = PutTableCommand.doPutRow(tableImpl, fieldValue.asRow(), this.isPutIfAbsent(), false);
                    shell.popCurrentCommand();
                } else {
                    String fieldName = this.getCurrentFieldName();
                    shell.popCurrentCommand();
                    shell.getCurrentCommand().addVariable(fieldName, fieldValue);
                    shell.runLine("add-value -field \"" + fieldName + "\"");
                }
                return retString;
            }

            @Override
            protected String getCommandDescription() {
                return COMMAND_DESCRIPTION;
            }
        }

        static class TableCancelSub
        extends TableCmdSubCommand {
            static final String COMMAND = "cancel";
            static final String COMMAND_DESCRIPTION = "Cancel the current operation.";

            protected TableCancelSub() {
                super(COMMAND, 4);
            }

            @Override
            public String execute(String[] args, Shell shell) throws ShellException {
                Shell.checkHelp(args, this);
                if (args.length != 1) {
                    shell.badArgCount(this);
                }
                shell.popCurrentCommand();
                return null;
            }

            @Override
            protected String getCommandDescription() {
                return COMMAND_DESCRIPTION;
            }
        }

        static class TableShowSub
        extends TableCmdSubCommand {
            static final String COMMAND = "show";
            static final String COMMAND_DESCRIPTION = "Show field value.";

            protected TableShowSub() {
                super(COMMAND, 2);
            }

            @Override
            public String execute(String[] args, Shell shell) throws ShellException {
                Shell.checkHelp(args, this);
                if (args.length != 1) {
                    shell.badArgCount(this);
                }
                FieldValue value = this.getCurrentFieldValue();
                return value.toJsonString(true);
            }

            @Override
            protected String getCommandDescription() {
                return COMMAND_DESCRIPTION;
            }
        }

        static class TableAddRecordValueSub
        extends TableAddComplexValueSub {
            static final String COMMAND = "add-record-value";
            static final String COMMAND_DESCRIPTION = "Set record field value.";
            private static TableCmdWithSubs cmdSubs = new RecordValueSubs();

            TableAddRecordValueSub() {
                super(COMMAND, 5);
            }

            TableAddRecordValueSub(boolean fieldIsRequired) {
                super(COMMAND, 5, fieldIsRequired);
            }

            @Override
            TableCmdWithSubs getCmdSubs() {
                return cmdSubs;
            }

            @Override
            FieldValue createValue(FieldDef fieldDef) throws ShellException {
                try {
                    return fieldDef.createRecord();
                }
                catch (ClassCastException cce) {
                    throw new ShellException(cce.getMessage());
                }
            }

            @Override
            protected String getCommandDescription() {
                return COMMAND_DESCRIPTION;
            }

            private static class RecordValueSubs
            extends TableCmdWithSubs {
                private static List<? extends TableCmdSubCommand> complexValueSubs = Arrays.asList(new TableAddArrayValueSub(), new TableAddMapValueSub(), new TableAddRecordValueSub(), new TableAddValueSub(), new TableCancelSub(), new TableExitSub(), new TableShowSub());

                RecordValueSubs() {
                    super(complexValueSubs, "", 0, 2);
                }

                @Override
                public String getCommandOverview() {
                    return TableAddRecordValueSub.COMMAND_DESCRIPTION;
                }
            }
        }

        static class TableAddArrayValueSub
        extends TableAddComplexValueSub {
            static final String COMMAND = "add-array-value";
            static final String COMMAND_DESCRIPTION = "Set array field value.";
            private static TableCmdWithSubs cmdSubs = new ArrayValueSubs();

            TableAddArrayValueSub() {
                super(COMMAND, 5);
            }

            TableAddArrayValueSub(boolean fieldIsRequired) {
                super(COMMAND, 5, fieldIsRequired);
            }

            @Override
            TableCmdWithSubs getCmdSubs() {
                return cmdSubs;
            }

            @Override
            FieldValue createValue(FieldDef fieldDef) throws ShellException {
                try {
                    return fieldDef.createArray();
                }
                catch (ClassCastException cce) {
                    throw new ShellException(cce.getMessage());
                }
            }

            @Override
            protected String getCommandDescription() {
                return COMMAND_DESCRIPTION;
            }

            private static class ArrayValueSubs
            extends TableCmdWithSubs {
                private static List<? extends TableCmdSubCommand> complexValueSubs = Arrays.asList(new TableAddArrayValueSub(false), new TableAddMapValueSub(false), new TableAddRecordValueSub(false), new TableAddValueSub(false, false), new TableCancelSub(), new TableExitSub(), new TableShowSub());

                ArrayValueSubs() {
                    super(complexValueSubs, "", 0, 2);
                }

                @Override
                public String getCommandOverview() {
                    return TableAddArrayValueSub.COMMAND_DESCRIPTION;
                }
            }
        }

        static class TableAddMapValueSub
        extends TableAddComplexValueSub {
            static final String COMMAND = "add-map-value";
            static final String COMMAND_DESCRIPTION = "Set map field value.";
            private static TableCmdWithSubs cmdSubs = new MapValueSubs();

            TableAddMapValueSub() {
                super(COMMAND, 5);
            }

            TableAddMapValueSub(boolean fieldIsRequired) {
                super(COMMAND, 5, fieldIsRequired);
            }

            @Override
            TableCmdWithSubs getCmdSubs() {
                return cmdSubs;
            }

            @Override
            FieldValue createValue(FieldDef fieldDef) throws ShellException {
                try {
                    return fieldDef.createMap();
                }
                catch (ClassCastException cce) {
                    throw new ShellException(cce.getMessage());
                }
            }

            @Override
            protected String getCommandDescription() {
                return COMMAND_DESCRIPTION;
            }

            private static class MapValueSubs
            extends TableCmdWithSubs {
                private static List<? extends TableCmdSubCommand> complexValueSubs = Arrays.asList(new TableAddArrayValueSub(), new TableAddMapValueSub(), new TableAddRecordValueSub(), new TableAddValueSub(true, false), new TableCancelSub(), new TableExitSub(), new TableShowSub());

                MapValueSubs() {
                    super(complexValueSubs, "", 0, 2);
                }

                @Override
                public String getCommandOverview() {
                    return TableAddMapValueSub.COMMAND_DESCRIPTION;
                }
            }
        }

        static abstract class TableAddComplexValueSub
        extends TableCmdSubCommand {
            private static final String VAR_NAME = "currentVariable";
            private boolean fieldIsRequired;

            TableAddComplexValueSub(String name, int prefixMatchLength) {
                this(name, prefixMatchLength, true);
            }

            TableAddComplexValueSub(String name, int prefixMatchLength, boolean fieldIsRequired) {
                super(name, prefixMatchLength);
                this.fieldIsRequired = fieldIsRequired;
            }

            abstract FieldValue createValue(FieldDef var1) throws ShellException;

            abstract TableCmdWithSubs getCmdSubs();

            @Override
            public String execute(String[] args, Shell shell) throws ShellException {
                String varName = VAR_NAME;
                PutArgs putArgs = (PutArgs)this.getVariable(varName);
                if (putArgs == null) {
                    Shell.checkHelp(args, this);
                    FieldValue currentVal = this.getCurrentFieldValue();
                    String fieldName = null;
                    for (int i = 1; i < args.length; ++i) {
                        String arg = args[i];
                        if (PutTableCommand.FIELD_FLAG.equals(arg)) {
                            fieldName = Shell.nextArg(args, i++, this);
                            continue;
                        }
                        shell.unknownArgument(arg, this);
                    }
                    if (this.fieldIsRequired && fieldName == null) {
                        shell.requiredArg(PutTableCommand.FIELD_FLAG, this);
                    }
                    FieldDef fieldDef = CommandUtils.getFieldDef(currentVal, fieldName);
                    FieldValue retVal = this.createValue(fieldDef);
                    ShellCommand cmd = this.clone();
                    if (fieldName == null) {
                        fieldName = "element";
                    }
                    cmd.addVariable(varName, new PutArgs(fieldName, retVal));
                    cmd.setPrompt(fieldName);
                    shell.pushCurrentCommand(cmd);
                    return null;
                }
                return this.getCmdSubs().execute(putArgs, args, shell);
            }

            @Override
            protected String getCommandSyntax() {
                return this.getCommandName() + " " + (this.fieldIsRequired ? PutTableCommand.FIELD_FLAG_DESC : CommandParser.optional(PutTableCommand.FIELD_FLAG_DESC));
            }
        }

        static class TableAddValueSub
        extends TableCmdSubCommand {
            static final String COMMAND = "add-value";
            static final String FILE_BINARY_DESC = "-file <file-with-binary-content>";
            static final String COMMAND_DESCRIPTION = "Set field value." + eolt + "-file flag can be used to input binary value from " + "a file" + eolt + "for BINARY or FIXED_BINARY field.";
            private boolean valueIsNullable;
            private boolean fieldIsRequired;

            protected TableAddValueSub() {
                this(true, true);
            }

            protected TableAddValueSub(boolean fieldIsRequired, boolean valueIsNullable) {
                super(COMMAND, 5);
                this.fieldIsRequired = fieldIsRequired;
                this.valueIsNullable = valueIsNullable;
            }

            @Override
            public String execute(String[] args, Shell shell) throws ShellException {
                TableAPI tableImpl;
                Row newRow;
                Shell.checkHelp(args, this);
                String fieldName = null;
                String sValue = null;
                boolean nullValue = false;
                boolean isFile = false;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (PutTableCommand.FIELD_FLAG.equals(arg)) {
                        fieldName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (PutCommand.VALUE_FLAG.equals(arg)) {
                        sValue = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (this.valueIsNullable && "-null-value".equals(arg)) {
                        nullValue = true;
                        continue;
                    }
                    if (PutCommand.FILE_FLAG.equals(arg)) {
                        sValue = Shell.nextArg(args, i++, this);
                        isFile = true;
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                FieldValue currentVal = this.getCurrentFieldValue();
                if (this.fieldIsRequired && fieldName == null) {
                    shell.requiredArg(PutTableCommand.FIELD_FLAG, this);
                }
                if (nullValue) {
                    this.putNull(currentVal, fieldName);
                    return null;
                }
                FieldValue fdVal = null;
                if (sValue == null) {
                    ShellCommand cmd = shell.getCurrentCommand();
                    fdVal = (FieldValue)cmd.getVariable(fieldName);
                    if (fdVal == null) {
                        shell.requiredArg(PutCommand.VALUE_FLAG, this);
                    } else {
                        cmd.removeVariable(fieldName);
                    }
                } else {
                    FieldDef def = CommandUtils.getFieldDef(currentVal, fieldName);
                    if (isFile && !def.isBinary() && !def.isFixedBinary()) {
                        shell.invalidArgument("-file can not be used for " + (Object)((Object)def.getType()) + " field", this);
                    }
                    if (def.isArray() || def.isMap() || def.isRecord()) {
                        String sType = def.getType().toString().toLowerCase();
                        throw new ShellException("Can't use add-value for " + sType + " field, please run add-" + sType + "-value to add value.");
                    }
                    fdVal = CommandUtils.createFieldValue(def, sValue, isFile);
                }
                this.putValue(currentVal, fieldName, fdVal);
                if (currentVal.isRow() && this.isPutUpdate() && (newRow = this.updateIfExists(tableImpl = ((CommandShell)shell).getStore().getTableAPI(), currentVal.asRow())) != null) {
                    this.setCurrentFieldValue(newRow);
                }
                return null;
            }

            private void putNull(FieldValue currentVal, String fieldName) throws ShellException {
                if (currentVal instanceof RecordValue) {
                    try {
                        currentVal.asRecord().putNull(fieldName);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage());
                    }
                } else {
                    throw new ShellException("Can not set null to the field: " + fieldName);
                }
            }

            private void putValue(FieldValue currentVal, String field, FieldValue value) throws ShellException {
                try {
                    if (currentVal.isRecord()) {
                        currentVal.asRecord().put(field, value);
                    } else if (currentVal.isArray()) {
                        currentVal.asArray().add(value);
                    } else if (currentVal.isMap()) {
                        currentVal.asMap().put(field, value);
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new ShellException(iae.getMessage());
                }
            }

            private Row updateIfExists(TableAPI tableImpl, Row row) {
                if (row.size() == row.getTable().getFields().size()) {
                    return null;
                }
                List<String> pkFields = row.getTable().getPrimaryKey();
                for (String fname : pkFields) {
                    if (row.get(fname) != null) continue;
                    return null;
                }
                PrimaryKey key = row.createPrimaryKey();
                Row retRow = tableImpl.get(key, null);
                if (retRow == null) {
                    return null;
                }
                retRow.copyFrom(row);
                return retRow;
            }

            @Override
            protected String getCommandDescription() {
                return COMMAND_DESCRIPTION;
            }

            @Override
            protected String getCommandSyntax() {
                String fieldDesc = this.fieldIsRequired ? " -field <name>" : "";
                String nullValueDesc = this.valueIsNullable ? "-null-value | " + eolt : "";
                return COMMAND + fieldDesc + " [" + PutTableCommand.VALUE_FLAG_DESC + " | " + nullValueDesc + FILE_BINARY_DESC + "]";
            }
        }

        static abstract class TableCmdSubCommand
        extends CommandWithSubs.SubCommand {
            CommandWithSubs parentCommand = null;

            protected TableCmdSubCommand(String name, int prefixMatchLength) {
                super(name, prefixMatchLength);
            }

            protected void setParentCommand(CommandWithSubs command) {
                this.parentCommand = command;
            }

            protected FieldValue getCurrentFieldValue() {
                return ((TableCmdWithSubs)this.parentCommand).getFieldValue();
            }

            protected void setCurrentFieldValue(FieldValue value) {
                ((TableCmdWithSubs)this.parentCommand).setFieldValue(value);
            }

            protected String getCurrentFieldName() {
                return ((TableCmdWithSubs)this.parentCommand).getFieldName();
            }

            protected Boolean isPutIfAbsent() {
                return ((TableCmdWithSubs)this.parentCommand).isPutIfAbsent();
            }

            protected boolean isPutUpdate() {
                return ((TableCmdWithSubs)this.parentCommand).isUpdate();
            }
        }

        static abstract class TableCmdWithSubs
        extends CommandWithSubs {
            private PutArgs putArgs = null;

            TableCmdWithSubs(List<? extends CommandWithSubs.SubCommand> subCommands, String name, int prefixLength, int minArgCount) {
                super(subCommands, name, prefixLength, minArgCount);
                this.initSubs(subCommands);
            }

            private void initSubs(List<? extends CommandWithSubs.SubCommand> tblSubs) {
                for (CommandWithSubs.SubCommand subCommand : tblSubs) {
                    ((TableCmdSubCommand)subCommand).setParentCommand(this);
                }
            }

            protected String execute(PutArgs opArgs, String[] args, Shell shell) throws ShellException {
                if (this.isHelpCommand(args[1], shell)) {
                    String[] argsEx = new String[args.length - 1];
                    argsEx[0] = args[0];
                    System.arraycopy(args, 2, argsEx, 1, args.length - 2);
                    return this.getHelp(argsEx, shell);
                }
                this.putArgs = opArgs;
                return this.execute(args, shell);
            }

            protected FieldValue getFieldValue() {
                return this.putArgs.getFieldValue();
            }

            protected void setFieldValue(FieldValue value) {
                this.putArgs.setFieldValue(value);
            }

            protected Boolean isPutIfAbsent() {
                return this.putArgs.isPutIfAbsent();
            }

            protected String getFieldName() {
                return this.putArgs.getFieldName();
            }

            protected boolean isUpdate() {
                return this.putArgs.isUpdate();
            }

            private boolean isHelpCommand(String commandName, Shell shell) {
                ShellCommand cmd = shell.findCommand(commandName);
                return cmd instanceof Shell.HelpCommand;
            }
        }

        private static class PutArgs {
            private String fieldName;
            private FieldValue fieldValue;
            private Boolean ifAbsent;
            private boolean isUpdate;

            PutArgs(String name, FieldValue value) {
                this(name, value, null, false);
            }

            PutArgs(FieldValue value, Boolean ifAbsent, boolean isUpdate) {
                this(null, value, ifAbsent, isUpdate);
            }

            PutArgs(String name, FieldValue value, Boolean ifAbsent, boolean isUpdate) {
                this.fieldName = name;
                this.fieldValue = value;
                this.ifAbsent = ifAbsent;
                this.isUpdate = isUpdate;
            }

            FieldValue getFieldValue() {
                return this.fieldValue;
            }

            void setFieldValue(FieldValue value) {
                this.fieldValue = value;
            }

            Boolean isPutIfAbsent() {
                return this.ifAbsent;
            }

            String getFieldName() {
                return this.fieldName;
            }

            boolean isUpdate() {
                return this.isUpdate;
            }
        }

        private static class TablePutSubs
        extends TableCmdWithSubs {
            private static final List<? extends TableCmdSubCommand> tablePutSubs = Arrays.asList(new TableAddArrayValueSub(), new TableAddMapValueSub(), new TableAddRecordValueSub(), new TableAddValueSub(), new TableCancelSub(), new TableExitSub(), new TableShowSub());

            TablePutSubs() {
                super(tablePutSubs, "", 0, 2);
            }

            @Override
            protected String getCommandOverview() {
                return "Set field value.";
            }
        }
    }

    static class PutKVCommand
    extends CommandWithSubs.SubCommand {
        static final String KV_COMMAND = "kv";
        static final String KEY_FLAG = "-key";
        static final String KEY_FLAG_DESC = "-key <key>";
        static final String HEX_FLAG = "-hex";
        static final String HEX_FLAG_DESC = "-hex";
        static final String VALUE_FLAG_DESC = "-value <valueString>";
        static final String JSON_SCHEMA_FLAG_DESC = "-json <schemaName>";
        static final String FILE_FLAG_DESC = "-file";
        static final String PUT_KV_SYNTAX = "put kv -key <key> -value <valueString> [-file] [-hex | -json <schemaName>]" + eolt + "[" + "-if-absent" + " | " + "-if-present" + "]";
        static final String PUT_KV_DESCRIPTION = "Puts the specified key, value pair into the store" + eolt + "-file" + " indicates that the value parameter is a file that " + "contains the" + eolt + "actual value" + eolt + "-hex" + " indates that the value is a BinHex encoded byte " + "value with Base64" + eolt + "-json" + " indicates that the value is a JSON string." + eolt + "-json" + " and -file can be used together." + eolt + "-if-absent" + " indicates to put a key/value pair only if " + "no value for " + eolt + "the given key is present. " + eolt + "-if-present" + " indicates to put a key/value pair only if " + "a value for " + eolt + "the given key is present. ";

        PutKVCommand() {
            super(KV_COMMAND, 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            Key key = null;
            Value value = null;
            byte[] valueBytes = null;
            String stringValue = null;
            String schemaName = null;
            boolean isPutIfAbsent = false;
            boolean isPutIfPresent = false;
            boolean isJson = false;
            boolean isFile = false;
            boolean isBinHex = false;
            KVStore store = ((CommandShell)shell).getStore();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (KEY_FLAG.equals(arg)) {
                    String keyString = Shell.nextArg(args, i++, this);
                    try {
                        key = CommandUtils.createKeyFromURI(keyString);
                    }
                    catch (IllegalArgumentException iae) {
                        shell.invalidArgument(iae.getMessage(), this);
                    }
                    continue;
                }
                if (PutCommand.VALUE_FLAG.equals(arg)) {
                    stringValue = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-file".equals(arg)) {
                    isFile = true;
                    continue;
                }
                if ("-hex".equals(arg)) {
                    isBinHex = true;
                    continue;
                }
                if (PutCommand.JSON_FLAG.equals(arg)) {
                    schemaName = Shell.nextArg(args, i++, this);
                    isJson = true;
                    continue;
                }
                if ("-if-absent".equals(arg)) {
                    isPutIfAbsent = true;
                    continue;
                }
                if ("-if-present".equals(arg)) {
                    isPutIfPresent = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (key == null) {
                shell.requiredArg(KEY_FLAG, this);
            }
            if (stringValue == null) {
                shell.requiredArg(PutCommand.VALUE_FLAG, this);
            }
            if (!isPutIfAbsent && !isPutIfPresent) {
                isPutIfAbsent = true;
                isPutIfPresent = true;
            }
            valueBytes = isFile ? CommandUtils.readFromFile(stringValue) : stringValue.getBytes();
            if (isJson) {
                ByteArrayInputStream in = null;
                in = new ByteArrayInputStream(valueBytes);
                value = this.createJsonValue(schemaName, in, store);
            } else if (isBinHex) {
                byte[] decoded = CommandUtils.decodeBase64(new String(valueBytes));
                value = Value.createValue(decoded);
            } else {
                value = Value.createValue(valueBytes);
            }
            String retString = null;
            boolean updated = false;
            try {
                if (isPutIfAbsent && isPutIfPresent) {
                    if (store.putIfAbsent(key, value) == null) {
                        store.putIfPresent(key, value);
                        updated = true;
                    }
                } else if (isPutIfAbsent) {
                    if (store.putIfAbsent(key, value) == null) {
                        retString = "A value was already present with the given key " + CommandUtils.createURI(key) + ".";
                    }
                } else {
                    updated = true;
                    if (store.putIfPresent(key, value) == null) {
                        retString = "No existing value was present with the given key " + CommandUtils.createURI(key) + ".";
                    }
                }
            }
            catch (Exception e) {
                throw new ShellException("Exception from NoSQL DB in put. " + e.getMessage(), e);
            }
            retString = retString == null ? "Operation successful, record " + (updated ? "updated." : "inserted.") : "Operation failed, " + retString;
            return retString;
        }

        @Override
        protected String getCommandSyntax() {
            return PUT_KV_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return PUT_KV_DESCRIPTION;
        }

        private Value createJsonValue(String schema, InputStream content, KVStore store) throws ShellException {
            try {
                AvroCatalog catalog = store.getAvroCatalog();
                catalog.refreshSchemaCache(null);
                Map<String, Schema> schemaMap = catalog.getCurrentSchemas();
                Schema sch = schemaMap.get(schema);
                if (sch == null) {
                    throw new ShellException("Schema does not exist in the catalog: " + schema);
                }
                JsonNode obj = TableJsonUtils.getObjectMapper().readTree(content);
                JsonAvroBinding jsonBinding = catalog.getJsonBinding(sch);
                return jsonBinding.toValue(new JsonRecord(obj, sch));
            }
            catch (JsonProcessingException jpe) {
                throw new ShellException(eolt + "Could not create JSON from input: " + eolt + jpe.getMessage(), jpe);
            }
            catch (IOException ioe) {
                throw new ShellException(eolt + "Could not create JSON from input: " + eolt + ioe.getMessage(), ioe);
            }
            catch (IllegalArgumentException iae) {
                String errMsg = iae.getCause() != null ? iae.getCause().getMessage() : iae.getMessage();
                throw new ShellException(eolt + "Could not create JSON from input: " + eolt + errMsg, iae);
            }
        }
    }
}

