/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.shell;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.kv.Direction;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.ParallelScanIterator;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.StoreIteratorException;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.avro.JsonAvroBinding;
import oracle.kv.avro.JsonRecord;
import oracle.kv.avro.SchemaNotAllowedException;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.util.FileUtils;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.shell.CommandUtils;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.KeyPair;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Row;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIterator;
import oracle.kv.table.TableUtils;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellInputReader;
import org.apache.avro.Schema;
import org.codehaus.jackson.map.ObjectWriter;

public class GetCommand
extends CommandWithSubs {
    static final String FILE_FLAG = "-file";
    static final String FILE_FLAG_DESC = "-file <output>";
    static final String START_FLAG = "-start";
    static final String END_FLAG = "-end";
    static final String JSON_FLAG = "-json";
    static final String KEY_ONLY_FLAG = "-keyonly";
    static final String KEY_ONLY_FLAG_DESC = "-keyonly";
    static final String COMMAND_OVERVIEW = "The get command encapsulates commands that get key/value" + eol + "pairs from a store or get rows from a table.";
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new GetKVCommand(), new GetTableCommand());

    public GetCommand() {
        super(subs, "get", 3, 1);
    }

    @Override
    protected String getCommandOverview() {
        return COMMAND_OVERVIEW;
    }

    private static class ResultOutput {
        private static final int MAX_OUTFILE_BUFF_SIZE = 524288;
        private int pageHeight;
        private int pageLines;
        private int pageRecords;
        private int totalRecords;
        private final StringBuilder output;
        private Shell shell = null;
        private Writer writer = null;

        ResultOutput(Writer writer) {
            this.totalRecords = 0;
            this.output = new StringBuilder();
            this.writer = writer;
        }

        ResultOutput(Shell shell) {
            this.shell = shell;
            this.pageLines = 0;
            this.totalRecords = 0;
            this.pageRecords = 0;
            this.pageHeight = this.getTermHeight();
            this.output = new StringBuilder();
        }

        public void flushWriting() throws ShellException {
            if (this.IsOutputFile()) {
                try {
                    this.writer.write(this.output.toString());
                }
                catch (IOException ioe) {
                    throw new ShellException("Can not write to the output file", ioe);
                }
                this.output.setLength(0);
            } else if (this.output.length() > 0) {
                this.shell.println(this.output.toString());
            }
        }

        public boolean writeRecord(String record) throws ShellException {
            if (this.IsOutputFile()) {
                this.writeToFile(record);
                return true;
            }
            return this.writeToTerm(record);
        }

        private void writeToFile(String record) throws ShellException {
            if (this.output.length() >= 524288) {
                try {
                    this.writer.write(this.output.toString());
                }
                catch (IOException ioe) {
                    throw new ShellException("Can not write to the output file", ioe);
                }
                this.output.setLength(0);
            }
            if (record != null) {
                this.output.append(record);
                this.output.append(eol);
            }
        }

        private boolean writeToTerm(String record) throws ShellException {
            if (this.pageHeight < 0) {
                if (this.output.length() >= 524288) {
                    this.shell.println(this.output.toString());
                }
                this.output.append(record);
                this.output.append(eol);
                return true;
            }
            if (this.pageLines >= this.pageHeight) {
                this.output.append("--More--(");
                this.output.append(this.totalRecords - this.pageRecords + 1);
                this.output.append("~");
                this.output.append(this.totalRecords);
                this.output.append(")");
                this.shell.println(this.output.toString());
                this.output.setLength(0);
                this.pageLines = 0;
                this.pageRecords = 0;
                try {
                    String ret = this.shell.getInput().readLine("");
                    if (ret.toLowerCase().startsWith("q")) {
                        return false;
                    }
                }
                catch (IOException e) {
                    throw new ShellException("Exception reading input");
                }
            }
            ++this.pageRecords;
            this.output.append(record);
            this.output.append(eol);
            this.pageLines += this.countLines(record);
            ++this.totalRecords;
            return true;
        }

        boolean IsOutputFile() {
            return this.writer != null;
        }

        private int countLines(String str) {
            return str.split("\r\n|\r|\n").length;
        }

        private int getTermHeight() {
            ShellInputReader inputReader = this.shell.getInput();
            if (inputReader != null) {
                return inputReader.getTerminalHeight();
            }
            return -1;
        }
    }

    static class GetTableCommand
    extends CommandWithSubs.SubCommand {
        static final String COMMAND_NAME = "table";
        static final String TABLE_FLAG = "-name";
        static final String TABLE_FLAG_DESC = "-name <name>";
        static final String FIELD_FLAG = "-field";
        static final String FIELD_FLAG_DESC = "-field <name>";
        static final String VALUE_FLAG = "-value";
        static final String VALUE_FLAG_DESC = "-value <value>";
        static final String NULL_VALUE_FLAG = "-null-value";
        static final String NULL_VALUE_FLAG_DESC = "-null-value";
        static final String ANCESTOR_FLAG = "-ancestor";
        static final String ANCESTOR_FLAG_DESC = "-ancestor <name>";
        static final String CHILD_FLAG = "-child";
        static final String CHILD_FLAG_DESC = "-child <name>";
        static final String INDEX_FLAG = "-index";
        static final String INDEX_FLAG_DESC = "-index <name>";
        static final String JSON_FLAG_DESC = "-json <string>";
        static final String END_FLAG_DESC = "-end <value>";
        static final String START_FLAG_DESC = "-start <value>";
        static final String REPORT_SIZE_FLAG = "-report-size";
        static final String REPORT_SIZE_FLAG_DESC = "-report-size";
        static final String PRETTY_FLAG = "-pretty";
        static final String PRETTY_FLAG_DESC = "-pretty";
        static final String COMMAND_SYNTAX = "get table -name <name> [-index <name>]" + eolt + "[" + "-field <name>" + " " + "-value <value>" + "]+ " + eolt + "[" + "-field <name>" + " [" + "-start <value>" + "] [" + "-end <value>" + "]]" + eolt + "[" + "-ancestor <name>" + "]+ [" + "-child <name>" + "]+" + eolt + "[" + "-json <string>" + "] [" + "-file <output>" + "] " + "[" + "-keyonly" + "]" + eolt + "[" + "-pretty" + "] [" + "-report-size" + "]";
        static final String COMMAND_DESCRIPTION = "Performs a get operation to retrieve one or more rows from a named table." + eolt + "The table name is a dot-separated name with the format" + eolt + "tableName[.childTableName]+." + eolt + "-field" + " and " + "-value" + " pairs are used to " + "used to specify fields of the" + eolt + "primary key or " + "index key used for the operation.  If no fields are" + eolt + "specified an iteration of the entire table or index is " + "performed" + eolt + "-field" + "," + "-start" + " and " + "-end" + " flags " + "can be used to define a value range for" + eolt + "the last field specified." + eolt + "-ancestor" + " and " + "-child" + " flags can be " + "used to return results from" + eolt + "specified ancestor and/or descendant tables as well as " + "the target" + eolt + "table." + eolt + "-json" + " indicates that the key field values are in " + "JSON format." + eolt + "-file" + " is used to specify an output file, " + "which is truncated." + eolt + "-keyonly" + " is used to restrict information to " + "keys only." + eolt + "-pretty" + " is used for a nicely formatted JSON string " + "with indentation" + eolt + "and carriage returns." + eolt + "-report-size" + " is used to show key and data size " + "information for primary" + eolt + "keys, data values, and " + "index keys for matching records.  When" + eolt + "-report-size is specified no data is displayed.";

        public GetTableCommand() {
            super(COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String tableName = null;
            String indexName = null;
            String rgStart = null;
            String rgEnd = null;
            String jsonString = null;
            String outFile = null;
            String frFieldName = null;
            boolean pretty = false;
            boolean reportSize = false;
            boolean keyOnly = false;
            ArrayList<String> lstAncestor = new ArrayList<String>();
            ArrayList<String> lstChild = new ArrayList<String>();
            HashMap<String, String> mapVals = new HashMap<String, String>();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TABLE_FLAG.equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (FIELD_FLAG.equals(arg)) {
                    String fname = Shell.nextArg(args, i++, this);
                    if (++i < args.length) {
                        arg = args[i];
                        if (VALUE_FLAG.equals(arg)) {
                            String fVal = Shell.nextArg(args, i++, this);
                            mapVals.put(fname, fVal);
                            continue;
                        }
                        while (i < args.length) {
                            arg = args[i];
                            if (GetCommand.START_FLAG.equals(arg)) {
                                rgStart = Shell.nextArg(args, i++, this);
                            } else {
                                if (!GetCommand.END_FLAG.equals(arg)) break;
                                rgEnd = Shell.nextArg(args, i++, this);
                            }
                            ++i;
                        }
                        if (rgStart == null && rgEnd == null) {
                            shell.invalidArgument(arg + ", " + VALUE_FLAG + " or " + GetCommand.START_FLAG + " | " + GetCommand.END_FLAG + " is reqired", this);
                        }
                        frFieldName = fname;
                        --i;
                        continue;
                    }
                    shell.requiredArg("-value or -start | -end", this);
                    continue;
                }
                if (INDEX_FLAG.equals(arg)) {
                    indexName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (ANCESTOR_FLAG.equals(arg)) {
                    lstAncestor.add(Shell.nextArg(args, i++, this));
                    continue;
                }
                if (CHILD_FLAG.equals(arg)) {
                    lstChild.add(Shell.nextArg(args, i++, this));
                    continue;
                }
                if (GetCommand.FILE_FLAG.equals(arg)) {
                    outFile = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (GetCommand.JSON_FLAG.equals(arg)) {
                    jsonString = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-pretty".equals(arg)) {
                    pretty = true;
                    continue;
                }
                if ("-report-size".equals(arg)) {
                    reportSize = true;
                    continue;
                }
                if ("-keyonly".equals(arg)) {
                    keyOnly = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (tableName == null) {
                shell.requiredArg(TABLE_FLAG, this);
            }
            String retString = null;
            TableAPI tableImpl = ((CommandShell)shell).getStore().getTableAPI();
            Table table = CommandUtils.findTable(tableImpl, tableName);
            RecordValue key = null;
            if (jsonString == null) {
                key = indexName == null ? table.createPrimaryKey() : CommandUtils.findIndex(table, indexName).createIndexKey();
                for (Map.Entry entry : mapVals.entrySet()) {
                    String fname = CommandUtils.translateField((String)entry.getKey());
                    CommandUtils.putIndexKeyValues(key, table, fname, (String)entry.getValue());
                }
            } else {
                key = CommandUtils.createKeyFromJson(table, indexName, jsonString);
            }
            MultiRowOptions mro = null;
            if (rgStart != null || rgEnd != null || !lstAncestor.isEmpty() || !lstChild.isEmpty()) {
                mro = CommandUtils.createMultiRowOptions(tableImpl, table, key, lstAncestor, lstChild, frFieldName, rgStart, rgEnd);
            }
            ResultOutput output = null;
            Writer fwriter = null;
            if (outFile != null) {
                try {
                    File file = new File(outFile);
                    fwriter = new BufferedWriter(new FileWriter(file));
                }
                catch (IOException ioe) {
                    throw new ShellException("Could not open the output file " + outFile, ioe);
                }
                output = new ResultOutput(fwriter);
            } else {
                output = new ResultOutput(shell);
            }
            try {
                retString = this.doGetOperation(tableImpl, key, mro, keyOnly, output, pretty, reportSize);
            }
            catch (ShellException se) {
                throw se;
            }
            finally {
                if (fwriter != null) {
                    try {
                        fwriter.flush();
                        fwriter.close();
                    }
                    catch (IOException ioe) {
                        throw new ShellException("Could not flush to file " + outFile, ioe);
                    }
                    if (retString != null && retString.length() > 0) {
                        retString = retString + eol;
                    }
                    retString = retString + "Wrote result to file " + outFile;
                }
            }
            return retString == null || retString.length() == 0 ? null : retString;
        }

        private String doGetOperation(final TableAPI tableImpl, final RecordValue key, final MultiRowOptions mro, final boolean keyOnly, final ResultOutput output, final boolean pretty, final boolean reportSize) throws ShellException {
            final StringBuilder sb = new StringBuilder();
            new CommandUtils.RunTableAPIOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                void doOperation() throws ShellException {
                    block14: {
                        block15: {
                            if (!key.isPrimaryKey()) break block15;
                            PrimaryKey pKey = key.asPrimaryKey();
                            if (mro == null && CommandUtils.matchFullPrimaryKey(pKey)) {
                                Row row = tableImpl.get(pKey, null);
                                if (row != null) {
                                    output.writeRecord(this.formatReturnInfo(row));
                                    break block14;
                                } else {
                                    sb.append("Key not found in store: ");
                                    sb.append(key.toJsonString(false));
                                }
                                break block14;
                            } else {
                                Iterator<Row> itr = null;
                                try {
                                    itr = CommandUtils.matchFullMajorKey(pKey) ? (keyOnly ? tableImpl.multiGetKeys(pKey, mro, null).iterator() : tableImpl.multiGet(pKey, mro, null).iterator()) : (keyOnly ? tableImpl.tableKeysIterator(pKey, mro, null) : tableImpl.tableIterator(pKey, mro, null));
                                    SizeInfo[] stInfo = null;
                                    if (reportSize) {
                                        stInfo = this.initSizeInfos(pKey.getTable(), false);
                                    }
                                    this.doIteration(itr, stInfo, pKey.getTable().getFullName());
                                }
                                catch (Throwable throwable) {
                                    if (itr instanceof TableIterator) {
                                        ((TableIterator)itr).close();
                                    }
                                    throw throwable;
                                }
                                if (itr instanceof TableIterator) {
                                    itr.close();
                                }
                            }
                            break block14;
                        }
                        TableIterator<Comparable<KeyPair>> itr = null;
                        IndexKey idxKey = (IndexKey)key;
                        try {
                            itr = keyOnly ? tableImpl.tableKeysIterator(idxKey, mro, null) : tableImpl.tableIterator(idxKey, mro, null);
                            SizeInfo[] stInfo = null;
                            if (reportSize) {
                                stInfo = this.initSizeInfos(((IndexKey)key).getIndex().getTable(), true);
                            }
                            this.doIteration(itr, stInfo, idxKey.getIndex().getTable().getFullName());
                        }
                        finally {
                            if (itr != null) {
                                itr.close();
                            }
                        }
                    }
                    output.flushWriting();
                }

                private String formatReturnInfo(Row row) {
                    if (reportSize) {
                        return this.getSizeTitle(SizeInfo.Type.PRIMARY_KEY) + " size: " + this.getKeySize(row) + eol + this.getSizeTitle(SizeInfo.Type.DATA) + " size: " + (keyOnly ? "Not available" : Integer.valueOf(this.getDataSize(row)));
                    }
                    return keyOnly ? row.createPrimaryKey().toJsonString(pretty) : row.toJsonString(pretty);
                }

                private SizeInfo[] initSizeInfos(Table table, boolean indexScan) {
                    SizeInfo[] sizeInfos = null;
                    if (keyOnly) {
                        sizeInfos = indexScan ? new SizeInfo[]{new SizeInfo(SizeInfo.Type.PRIMARY_KEY), new SizeInfo(SizeInfo.Type.INDEX_KEY)} : new SizeInfo[]{new SizeInfo(SizeInfo.Type.PRIMARY_KEY)};
                    } else {
                        int i = 0;
                        sizeInfos = new SizeInfo[2 + table.getIndexes().size()];
                        sizeInfos[i++] = new SizeInfo(SizeInfo.Type.PRIMARY_KEY);
                        sizeInfos[i++] = new SizeInfo(SizeInfo.Type.DATA);
                        for (Map.Entry<String, Index> entry : table.getIndexes().entrySet()) {
                            sizeInfos[i++] = new SizeInfo(SizeInfo.Type.INDEX_KEY, entry.getKey());
                        }
                    }
                    return sizeInfos;
                }

                private void doIteration(Iterator<?> iterator, SizeInfo[] stInfo, String tableName) throws ShellException {
                    long nRec = 0L;
                    try {
                        while (iterator.hasNext()) {
                            Object obj = iterator.next();
                            if (stInfo != null) {
                                this.tallySize(obj, stInfo);
                                continue;
                            }
                            if (output.writeRecord(this.getJsonString(obj))) {
                                ++nRec;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (StoreIteratorException sie) {
                        Throwable t = sie.getCause();
                        if (t != null && t instanceof FaultException) {
                            throw (FaultException)t;
                        }
                        throw new ShellException(t != null ? t.getMessage() : sie.getMessage());
                    }
                    if (stInfo != null) {
                        output.writeRecord(this.formatOutputSizesInfo(stInfo));
                    } else {
                        sb.append(nRec);
                        sb.append(nRec > 1L ? " rows returned" : " row returned");
                        if (output.IsOutputFile()) {
                            sb.append(" from ");
                            sb.append(tableName);
                            sb.append(" table");
                        }
                    }
                }

                private String getJsonString(Object obj) {
                    if (obj instanceof KeyPair) {
                        return ((KeyPair)obj).getPrimaryKey().toJsonString(pretty);
                    }
                    return ((Row)obj).toJsonString(pretty);
                }

                private void tallySize(Object obj, SizeInfo[] stInfo) {
                    block5: for (SizeInfo info : stInfo) {
                        switch (info.getType()) {
                            case PRIMARY_KEY: {
                                info.tally(this.getKeySize(obj));
                                continue block5;
                            }
                            case DATA: {
                                info.tally(this.getDataSize(obj));
                                continue block5;
                            }
                            case INDEX_KEY: {
                                info.tally(this.getIndexKeySize(obj, info.getName()));
                                continue block5;
                            }
                        }
                    }
                }

                private int getKeySize(Object obj) {
                    if (obj instanceof KeyPair) {
                        return TableUtils.getKeySize(((KeyPair)obj).getPrimaryKey());
                    }
                    return TableUtils.getKeySize((Row)obj);
                }

                private int getDataSize(Object obj) {
                    if (!(obj instanceof Row)) {
                        return 0;
                    }
                    return TableUtils.getDataSize((Row)obj);
                }

                private int getIndexKeySize(Object obj, String indexName) {
                    if (obj instanceof PrimaryKey) {
                        return 0;
                    }
                    if (obj instanceof KeyPair) {
                        return TableUtils.getKeySize(((KeyPair)obj).getIndexKey());
                    }
                    if (indexName == null) {
                        return 0;
                    }
                    Row row = (Row)obj;
                    Index index = row.getTable().getIndex(indexName);
                    if (index == null) {
                        return 0;
                    }
                    return TableUtils.getKeySize(index.createIndexKey(row));
                }

                private String getSizeTitle(SizeInfo.Type type) {
                    switch (type) {
                        case PRIMARY_KEY: {
                            return "Primary Key";
                        }
                        case DATA: {
                            return "Data";
                        }
                        case INDEX_KEY: {
                            return "Index Key";
                        }
                    }
                    return null;
                }

                private String formatOutputSizesInfo(SizeInfo[] stInfo) {
                    StringBuilder buf = new StringBuilder();
                    Formatter fmt = new Formatter(buf);
                    int nRec = stInfo[0].getCount();
                    fmt.format("Number of records: %d", nRec);
                    for (SizeInfo info : stInfo) {
                        if (info.getName() != null) {
                            fmt.format(eol + "%s sizes of %s:", this.getSizeTitle(info.getType()), info.getName());
                        } else {
                            fmt.format(eol + "%s sizes:", this.getSizeTitle(info.getType()));
                        }
                        if (nRec > 0) {
                            fmt.format(eolt + "Minimum size: %d", info.getMin());
                            fmt.format(eolt + "Maximum size: %d", info.getMax());
                            fmt.format(eolt + "Average size: %.1f", info.getAvg());
                            continue;
                        }
                        fmt.format(" Not available", new Object[0]);
                    }
                    if (stInfo.length == 1) {
                        fmt.format(eol + "%s sizes: Not available", this.getSizeTitle(SizeInfo.Type.DATA));
                    }
                    fmt.close();
                    return buf.toString();
                }
            }.run();
            return sb.toString();
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESCRIPTION;
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        private static final class SizeInfo {
            private final Type type;
            private final String name;
            private int min;
            private int max;
            private double sum;
            private int count;

            SizeInfo(Type type) {
                this(type, null);
            }

            SizeInfo(Type type, String name) {
                this.name = name;
                this.type = type;
                this.min = 0;
                this.max = 0;
                this.sum = 0.0;
                this.count = 0;
            }

            void tally(int size) {
                if (this.min == 0 || size < this.min) {
                    this.min = size;
                }
                if (size > this.max) {
                    this.max = size;
                }
                this.sum += (double)size;
                ++this.count;
            }

            String getName() {
                return this.name;
            }

            Type getType() {
                return this.type;
            }

            int getMin() {
                return this.min;
            }

            int getMax() {
                return this.max;
            }

            double getAvg() {
                if (this.count == 0) {
                    return 0.0;
                }
                return this.sum / (double)this.count;
            }

            int getCount() {
                return this.count;
            }

            static enum Type {
                PRIMARY_KEY,
                DATA,
                INDEX_KEY;

            }
        }
    }

    static class GetKVCommand
    extends CommandWithSubs.SubCommand {
        static final String COMMAND_NAME = "kv";
        static final String KEY_FLAG = "-key";
        static final String KEY_FLAG_DESC = "-key <key>";
        static final String VALUE_ONLY_FLAG = "-valueonly";
        static final String VALUE_ONLY_FLAG_DESC = "-valueonly";
        static final String END_FLAG_DESC = "-end <prefixString>";
        static final String START_FLAG_DESC = "-start <prefixString>";
        static final String JSON_FLAG_DESC = "-json";
        static final String MULTI_FLAG = "-all";
        static final String MULTI_FLAG_DESC = "-all";
        static final String COMMAND_SYNTAX = "get kv -key <key> [-json] [-file <output>] [-all] [-keyonly] " + eolt + "[" + "-valueonly" + "] " + "[" + "-start <prefixString>" + "] [" + "-end <prefixString>" + "]";
        static final String COMMAND_DESCRIPTION = "Performs a simple get operation on the key in the store." + eolt + "-key" + " indicates the key (prefix) to use.  Optional with " + "-all" + "." + eolt + "-json" + " should be specified if the record is JSON." + eolt + "-all" + " is specified for iteration starting at the key, " + "or with" + eolt + "an empty key to iterate the entire store." + eolt + "-start" + " and " + "-end" + " flags can be used " + "for restricting the range used" + eolt + "for iteration." + eolt + "-keyonly" + " works with " + "-all" + " and restricts " + "information to keys." + eolt + "-valueonly" + " works with " + "-all" + " and restricts " + "information to values." + eolt + "-file" + " is used to specify an output file, which is " + "truncated.";

        public GetKVCommand() {
            super(COMMAND_NAME, 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            boolean iterate = false;
            Key key = null;
            String keyString = null;
            boolean isJson = false;
            String outFile = null;
            String rangeStart = null;
            String rangeEnd = null;
            boolean keyOnly = false;
            boolean valueOnly = false;
            KVStore store = ((CommandShell)shell).getStore();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (KEY_FLAG.equals(arg)) {
                    keyString = Shell.nextArg(args, i++, this);
                    try {
                        key = CommandUtils.createKeyFromURI(keyString);
                    }
                    catch (IllegalArgumentException iae) {
                        shell.invalidArgument(iae.getMessage(), this);
                    }
                    continue;
                }
                if ("-json".equals(arg)) {
                    isJson = true;
                    continue;
                }
                if ("-all".equals(arg)) {
                    iterate = true;
                    continue;
                }
                if ("-keyonly".equals(arg)) {
                    keyOnly = true;
                    continue;
                }
                if ("-valueonly".equals(arg)) {
                    valueOnly = true;
                    continue;
                }
                if (GetCommand.FILE_FLAG.equals(arg)) {
                    isJson = true;
                    outFile = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (GetCommand.START_FLAG.equals(arg)) {
                    rangeStart = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (GetCommand.END_FLAG.equals(arg)) {
                    rangeEnd = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            String retString = "";
            if (!iterate) {
                if (key == null) {
                    shell.requiredArg(KEY_FLAG, this);
                }
                ValueVersion valueVersion = null;
                try {
                    valueVersion = store.get(key);
                    if (valueVersion == null) {
                        return "Key not found in store: " + keyString;
                    }
                }
                catch (Exception e) {
                    throw new ShellException("Exception from NoSQL DB in get:" + eolt + e.getMessage(), e);
                }
                Value value = valueVersion.getValue();
                retString = isJson || value.getFormat() == Value.Format.AVRO ? this.jsonRecord(store, value) : this.printableString(value.getValue());
                if (outFile != null) {
                    try {
                        FileUtils.writeStringToFile(new File(outFile), retString);
                        retString = "Wrote value to file " + outFile + ".";
                    }
                    catch (IOException ioe) {
                        throw new ShellException("Could not write to file " + outFile, ioe);
                    }
                }
                return retString;
            }
            KeyRange kr = null;
            if (rangeStart != null || rangeEnd != null) {
                try {
                    kr = new KeyRange(rangeStart, true, rangeEnd, true);
                }
                catch (IllegalArgumentException iae) {
                    shell.invalidArgument(iae.getMessage(), this);
                }
            }
            Writer fwriter = null;
            ResultOutput output = null;
            if (outFile != null) {
                try {
                    File file = new File(outFile);
                    fwriter = new BufferedWriter(new FileWriter(file));
                }
                catch (IOException ioe) {
                    throw new ShellException("Could not open the output file " + outFile, ioe);
                }
                output = new ResultOutput(fwriter);
            } else {
                output = new ResultOutput(shell);
            }
            try {
                retString = keyOnly ? this.iterateKeys(store, key, kr, output) : this.iterateValues(store, key, kr, valueOnly, output);
            }
            catch (ShellException se) {
                throw se;
            }
            finally {
                if (fwriter != null) {
                    try {
                        fwriter.flush();
                        fwriter.close();
                    }
                    catch (IOException ioe) {
                        throw new ShellException("Could not flush to file " + outFile, ioe);
                    }
                    retString = retString + eol + "Wrote value to file " + outFile;
                }
            }
            return retString;
        }

        private String iterateKeys(KVStore store, Key key, KeyRange kr, ResultOutput output) throws ShellException {
            Iterator<Key> it = null;
            try {
                if (key != null && key.getMinorPath() != null && key.getMinorPath().size() > 0) {
                    it = store.multiGetKeysIterator(Direction.FORWARD, 100, key, kr, null);
                } else {
                    it = store.storeKeysIterator(Direction.UNORDERED, 100, key, kr, null, null, 0L, null, this.getIteratorConfig());
                    if (!it.hasNext() && key != null) {
                        this.closeIterator(it);
                        it = store.multiGetKeysIterator(Direction.FORWARD, 100, key, kr, null);
                    }
                }
                long totalNumKeys = 0L;
                StringBuilder sb = new StringBuilder();
                while (it.hasNext() && output.writeRecord(CommandUtils.createURI(it.next()))) {
                    ++totalNumKeys;
                }
                output.flushWriting();
                sb.append(eol);
                sb.append(totalNumKeys);
                sb.append(totalNumKeys > 1L ? " Keys" : " Key");
                sb.append(" returned");
                String string = sb.toString();
                return string;
            }
            catch (Exception e) {
                throw new ShellException("Failed to iterate keys :" + eolt + e.getMessage(), e);
            }
            finally {
                if (it != null) {
                    this.closeIterator(it);
                }
            }
        }

        private String iterateValues(KVStore store, Key key, KeyRange kr, boolean valueOnly, ResultOutput output) throws ShellException {
            Iterator<KeyValueVersion> it = null;
            try {
                if (key != null && key.getMinorPath() != null && key.getMinorPath().size() > 0) {
                    it = store.multiGetIterator(Direction.FORWARD, 100, key, kr, null);
                } else {
                    it = store.storeIterator(Direction.UNORDERED, 100, key, kr, null, null, 0L, null, this.getIteratorConfig());
                    if (!it.hasNext() && key != null) {
                        this.closeIterator(it);
                        it = store.multiGetIterator(Direction.FORWARD, 100, key, kr, null);
                    }
                }
                long totalNumRecords = 0L;
                StringBuilder sb = new StringBuilder();
                while (it.hasNext()) {
                    KeyValueVersion kvv = it.next();
                    Value value = kvv.getValue();
                    if (value == null) continue;
                    String record = "";
                    if (!valueOnly) {
                        record = record + CommandUtils.createURI(kvv.getKey()) + eol;
                    }
                    if (value.getFormat() == Value.Format.AVRO) {
                        try {
                            record = record + this.jsonRecord(store, value);
                        }
                        catch (ShellException ignored) {}
                    } else {
                        record = record + this.printableString(value.getValue());
                    }
                    if (!output.writeRecord(record)) break;
                    ++totalNumRecords;
                }
                output.flushWriting();
                sb.append(eol);
                sb.append(totalNumRecords);
                sb.append(totalNumRecords > 1L ? " Records returned" : " Record returned");
                String string = sb.toString();
                return string;
            }
            catch (Exception e) {
                throw new ShellException("Failed to iterate records :" + eolt + e.getMessage(), e);
            }
            finally {
                if (it != null) {
                    this.closeIterator(it);
                }
            }
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESCRIPTION;
        }

        private StoreIteratorConfig getIteratorConfig() {
            return new StoreIteratorConfig().setMaxConcurrentRequests(0);
        }

        private void closeIterator(Iterator<?> iterator) {
            if (iterator instanceof ParallelScanIterator) {
                ((ParallelScanIterator)iterator).close();
            }
        }

        private String jsonRecord(KVStore store, Value value) throws ShellException {
            AvroCatalog catalog = store.getAvroCatalog();
            catalog.refreshSchemaCache(null);
            Map<String, Schema> schemaMap = catalog.getCurrentSchemas();
            JsonAvroBinding binding = catalog.getJsonMultiBinding(schemaMap);
            try {
                ObjectWriter writer = JsonUtils.createWriter(true);
                JsonRecord jsonRec = binding.toObject(value);
                return writer.writeValueAsString(jsonRec.getJsonNode());
            }
            catch (SchemaNotAllowedException sna) {
                throw new ShellException("The schema associated with this record is not of the correct type", sna);
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException("The record is not Avro format", iae);
            }
            catch (IOException ioe) {
                throw new ShellException("Error formatting the record", ioe);
            }
        }

        private String printableString(byte[] buf) throws ShellException {
            if (this.isAsciiPrintable(buf)) {
                return new String(buf);
            }
            return CommandUtils.encodeBase64(buf) + " [Base64]";
        }

        private boolean isAsciiPrintable(byte[] buf) {
            if (buf == null) {
                return true;
            }
            for (byte element : buf) {
                if (element >= 32 && element <= 126) continue;
                return false;
            }
            return true;
        }
    }
}

