/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.server;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.monitor.AdminDirectHandler;
import oracle.kv.impl.monitor.AgentRepository;
import oracle.kv.impl.monitor.LogToMonitorHandler;
import oracle.kv.impl.monitor.MonitorAgentHandler;
import oracle.kv.impl.monitor.MonitorKeeper;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.CommonLoggerUtils;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.LogFormatter;
import oracle.kv.util.ConsoleHandler;
import oracle.kv.util.FileHandler;
import oracle.kv.util.StoreConsoleHandler;

public class LoggerUtils {
    private static final ConcurrentHashMap<ServiceHandlerKey, FileHandler> FILE_HANDLER_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ServiceHandlerKey, FileHandler> PERF_FILE_HANDLER_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ServiceHandlerKey, FileHandler> STAT_FILE_HANDLER_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ServiceHandlerKey, LogToMonitorHandler> MONITOR_HANDLER_MAP = new ConcurrentHashMap();
    private static Logger bootstrapLogger;

    public static String getStorewideLogName(String rootDirPath, String kvStoreName) {
        File loggingDir = FileNames.getLoggingDir(new File(rootDirPath), kvStoreName);
        return loggingDir.getPath() + File.separator + kvStoreName + "_{0..N}." + "log";
    }

    public static Logger getBootstrapLogger(String kvdir, String filename, String label) {
        if (bootstrapLogger == null) {
            bootstrapLogger = Logger.getLogger(filename);
            bootstrapLogger.setUseParentHandlers(false);
            String logFilePattern = LoggerUtils.makeFilePattern(kvdir, filename, "log");
            try {
                FileHandler newHandler = new FileHandler(logFilePattern, 1000000, 20, true);
                newHandler.setFormatter(new LogFormatter(label));
                bootstrapLogger.addHandler(newHandler);
                LoggerUtils.addConsoleHandler(bootstrapLogger, label);
            }
            catch (IOException e) {
                throw new IllegalStateException("Problem creating bootstrap log file: " + logFilePattern);
            }
        }
        return bootstrapLogger;
    }

    public static Logger getLogger(Class<?> cl, ClientId clientId) {
        return LoggerUtils.getLogger(cl, clientId.toString(), clientId, null, null);
    }

    public static Logger getLogger(Class<?> cl, String label) {
        return LoggerUtils.getLogger(cl, label, null, null, null);
    }

    public static Logger getLogger(Class<?> cl, AdminServiceParams params) {
        AdminId adminId = params.getAdminParams().getAdminId();
        return LoggerUtils.getLogger(cl, adminId.toString(), adminId, params.getGlobalParams(), params.getStorageNodeParams());
    }

    public static Logger getLogger(Class<?> cl, RepNodeService.Params params) {
        RepNodeId repNodeId = params.getRepNodeParams().getRepNodeId();
        return LoggerUtils.getLogger(cl, repNodeId.toString(), repNodeId, params.getGlobalParams(), params.getStorageNodeParams());
    }

    public static Logger getLogger(Class<?> cl, GlobalParams globalParams, StorageNodeParams storageNodeParams) {
        StorageNodeId storageNodeId = storageNodeParams.getStorageNodeId();
        return LoggerUtils.getLogger(cl, storageNodeId.toString(), storageNodeId, globalParams, storageNodeParams);
    }

    public static Logger getConsoleOnlyLogger(Class<?> cl, RepNodeId repNodeId) {
        return LoggerUtils.getLogger(cl, repNodeId.toString(), repNodeId, null, null);
    }

    public static Logger getFileOnlyLogger(Class<?> cl, ResourceId resourceId, GlobalParams globalParams, StorageNodeParams storageNodeParams) {
        Logger logger = Logger.getLogger(cl.getName() + ".TEMP_" + resourceId);
        logger.setUseParentHandlers(false);
        boolean hasFileHandler = false;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                if (!(h instanceof FileHandler)) continue;
                hasFileHandler = true;
            }
        }
        if (!hasFileHandler) {
            LoggerUtils.addLogFileHandler(logger, resourceId.toString(), resourceId.toString(), globalParams.getKVStoreName(), new File(storageNodeParams.getRootDirPath()), storageNodeParams.getLogFileLimit(), storageNodeParams.getLogFileCount());
        }
        return logger;
    }

    public static Logger getPerfFileLogger(Class<?> cl, GlobalParams globalParams, StorageNodeParams snParams) {
        String kvName = globalParams.getKVStoreName();
        Logger logger = Logger.getLogger(cl.getName() + ".PERF_" + kvName);
        logger.setUseParentHandlers(false);
        Handler[] handlers = logger.getHandlers();
        boolean hasFileHandler = false;
        if (handlers != null) {
            for (Handler h : handlers) {
                if (!(h instanceof FileHandler)) continue;
                hasFileHandler = true;
                break;
            }
        }
        if (hasFileHandler) {
            return logger;
        }
        LoggerUtils.addFileHandler(PERF_FILE_HANDLER_MAP, logger, new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        }, kvName, kvName, new File(snParams.getRootDirPath()), "perf", snParams.getLogFileLimit(), snParams.getLogFileCount());
        return logger;
    }

    public static Logger getStatFileLogger(Class<?> cl, GlobalParams globalParams, StorageNodeParams snParams) {
        String kvName = globalParams.getKVStoreName();
        Logger logger = Logger.getLogger(cl.getName() + ".STAT_" + kvName);
        logger.setUseParentHandlers(false);
        Handler[] handlers = logger.getHandlers();
        boolean hasFileHandler = false;
        if (handlers != null) {
            for (Handler h : handlers) {
                if (!(h instanceof FileHandler)) continue;
                hasFileHandler = true;
                break;
            }
        }
        if (hasFileHandler) {
            return logger;
        }
        LoggerUtils.addFileHandler(STAT_FILE_HANDLER_MAP, logger, new LogFormatter(kvName), kvName, kvName, new File(snParams.getRootDirPath()), "stat", snParams.getLogFileLimit(), snParams.getLogFileCount());
        return logger;
    }

    public static Logger getLogger(Class<?> cl, String prefix, ResourceId resourceId, GlobalParams globalParams, StorageNodeParams storageNodeParams) {
        Logger logger = Logger.getLogger(cl.getName() + "." + resourceId);
        logger.setUseParentHandlers(false);
        boolean hasConsoleHandler = false;
        boolean hasFileHandler = false;
        boolean hasAdminDirectHandler = false;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                if (h instanceof ConsoleHandler) {
                    hasConsoleHandler = true;
                    continue;
                }
                if (h instanceof FileHandler) {
                    hasFileHandler = true;
                    continue;
                }
                if (!(h instanceof LogToMonitorHandler)) continue;
                hasAdminDirectHandler = true;
            }
        }
        if (!hasConsoleHandler) {
            LoggerUtils.addConsoleHandler(logger, prefix);
        }
        if (globalParams != null) {
            if (storageNodeParams != null && !hasFileHandler) {
                LoggerUtils.addLogFileHandler(logger, prefix, resourceId.toString(), globalParams.getKVStoreName(), new File(storageNodeParams.getRootDirPath()), storageNodeParams.getLogFileLimit(), storageNodeParams.getLogFileCount());
            }
            if (!hasAdminDirectHandler) {
                LoggerUtils.addMonitorHandler(logger, globalParams.getKVStoreName(), resourceId);
            }
        }
        return logger;
    }

    public static Logger getStorewideViewLogger(Class<?> cl, AdminServiceParams adminParams) {
        String storeName = adminParams.getGlobalParams().getKVStoreName();
        Logger logger = Logger.getLogger(cl.getName() + "." + storeName);
        logger.setUseParentHandlers(false);
        boolean hasConsoleHandler = false;
        boolean hasFileHandler = false;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                if (h instanceof StoreConsoleHandler) {
                    hasConsoleHandler = true;
                    continue;
                }
                if (!(h instanceof FileHandler)) continue;
                hasFileHandler = true;
            }
        }
        if (!hasConsoleHandler) {
            StoreConsoleHandler handler = new StoreConsoleHandler();
            handler.setFormatter(new LogFormatter());
            logger.addHandler(handler);
        }
        if (!hasFileHandler) {
            StorageNodeParams snp = adminParams.getStorageNodeParams();
            GlobalParams gp = adminParams.getGlobalParams();
            AdminParams ap = adminParams.getAdminParams();
            LoggerUtils.addLogFileHandler(logger, null, gp.getKVStoreName(), gp.getKVStoreName(), new File(snp.getRootDirPath()), ap.getLogFileLimit(), ap.getLogFileCount());
        }
        return logger;
    }

    public static void registerMonitorAgentBuffer(String kvName, ResourceId resourceId, AgentRepository agentRepository) {
        MonitorAgentHandler handler = new MonitorAgentHandler(agentRepository);
        String resourceName = resourceId.toString();
        handler.setFormatter(new LogFormatter(resourceName));
        MONITOR_HANDLER_MAP.put(new ServiceHandlerKey(resourceName, kvName), handler);
    }

    public static void registerMonitorAdminHandler(String kvName, AdminId adminId, MonitorKeeper admin) {
        AdminDirectHandler handler = new AdminDirectHandler(admin);
        String resourceName = adminId.toString();
        handler.setFormatter(new LogFormatter(resourceName));
        MONITOR_HANDLER_MAP.put(new ServiceHandlerKey(resourceName, kvName), handler);
    }

    private static void addMonitorHandler(Logger logger, String kvName, ResourceId resourceId) {
        Handler handler = MONITOR_HANDLER_MAP.get(new ServiceHandlerKey(resourceId.toString(), kvName));
        if (handler != null) {
            logger.addHandler(handler);
        }
    }

    private static void addConsoleHandler(Logger logger, String prefix) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormatter(prefix));
        logger.addHandler(handler);
    }

    private static void addLogFileHandler(Logger logger, String label, String resourceName, String kvName, File rootDir, int fileLimit, int fileCount) {
        LoggerUtils.addFileHandler(FILE_HANDLER_MAP, logger, new LogFormatter(label), resourceName, kvName, rootDir, "log", fileLimit, fileCount);
    }

    private static void addFileHandler(ConcurrentMap<ServiceHandlerKey, FileHandler> map, Logger logger, Formatter formatter, String resourceName, String kvName, File rootDir, String suffix, int fileLimit, int fileCount) {
        FileHandler newHandler;
        ServiceHandlerKey handlerKey = new ServiceHandlerKey(resourceName, kvName);
        Handler existing = (Handler)map.get(handlerKey);
        if (existing != null) {
            FileHandler fh = (FileHandler)existing;
            if (fh.getLimit() == fileLimit && fh.getCount() == fileCount) {
                logger.addHandler(existing);
                return;
            }
            existing.close();
            map.remove(handlerKey);
            existing = null;
        }
        try {
            FileNames.makeLoggingDir(rootDir, kvName);
            String logFilePattern = LoggerUtils.makeFilePattern(FileNames.getLoggingDir(rootDir, kvName).getPath(), resourceName, suffix);
            newHandler = new FileHandler(logFilePattern, fileLimit, fileCount, true);
            newHandler.setFormatter(formatter);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Problem creating log file for logger " + resourceName, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem creating log file for logger " + resourceName, e);
        }
        existing = map.putIfAbsent(handlerKey, newHandler);
        if (existing == null) {
            logger.addHandler(newHandler);
        } else {
            newHandler.close();
            logger.addHandler(existing);
        }
    }

    private static String makeFilePattern(String parent, String fileName, String suffix) {
        return parent + File.separator + fileName + "_%g." + suffix;
    }

    public static void closeHandlers(String kvName) {
        for (Map.Entry<ServiceHandlerKey, FileHandler> entry : FILE_HANDLER_MAP.entrySet()) {
            if (!entry.getKey().belongs(kvName)) continue;
            entry.getValue().close();
            FILE_HANDLER_MAP.remove(entry.getKey());
        }
        for (Map.Entry<ServiceHandlerKey, FileHandler> entry : PERF_FILE_HANDLER_MAP.entrySet()) {
            if (!entry.getKey().belongs(kvName)) continue;
            entry.getValue().close();
            PERF_FILE_HANDLER_MAP.remove(entry.getKey());
        }
        for (Map.Entry<ServiceHandlerKey, FileHandler> entry : STAT_FILE_HANDLER_MAP.entrySet()) {
            if (!entry.getKey().belongs(kvName)) continue;
            entry.getValue().close();
            STAT_FILE_HANDLER_MAP.remove(entry.getKey());
        }
        for (Map.Entry<ServiceHandlerKey, Handler> entry : MONITOR_HANDLER_MAP.entrySet()) {
            if (!entry.getKey().belongs(kvName)) continue;
            ((LogToMonitorHandler)entry.getValue()).close();
            MONITOR_HANDLER_MAP.remove(entry.getKey());
        }
    }

    public static void closeAllHandlers() {
        Handler[] handlers;
        LoggerUtils.closeHandlers(null);
        if (bootstrapLogger != null && (handlers = bootstrapLogger.getHandlers()) != null) {
            for (Handler h : handlers) {
                h.close();
            }
        }
    }

    public static String getLoggerProperty(String property) {
        return CommonLoggerUtils.getLoggerProperty(property);
    }

    public static String getStackTrace(Throwable t) {
        return CommonLoggerUtils.getStackTrace(t);
    }

    public static void removeHandler(Handler handler) {
        LogManager lm = LogManager.getLogManager();
        Enumeration<String> loggerNames = lm.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            Handler[] handlers;
            String name = loggerNames.nextElement();
            Logger logger = lm.getLogger(name);
            if (logger == null || (handlers = logger.getHandlers()) == null) continue;
            for (Handler h : handlers) {
                if (h != handler) continue;
                logger.removeHandler(h);
            }
        }
    }

    public static class KVAuditInfo {
        private static String BASIC_INFO_FORMAT = "KVAuditInfo [User: %s, ClientHost: %s, AuthHost: %s, Operation Desc: %s";

        public static String failure(String user, String clientHost, String authHost, String opDesc, String reason) {
            return String.format(BASIC_INFO_FORMAT + ", Status: FAILED, Reason: %s]", user, clientHost, authHost, opDesc, reason);
        }

        public static String failure(String user, String clientHost, String opDesc, String reason) {
            return KVAuditInfo.failure(user, clientHost, "", opDesc, reason);
        }

        public static String success(String user, String clientHost, String authHost, String opDesc) {
            return String.format(BASIC_INFO_FORMAT + ", Status: SUCCEEDED]", user, clientHost, authHost, opDesc);
        }

        public static String success(String user, String clientHost, String opDesc) {
            return KVAuditInfo.success(user, clientHost, "", opDesc);
        }
    }

    public static class SecurityLevel
    extends Level {
        private static final long serialVersionUID = 1L;
        private static final int SEC_WARNING_VALUE = 950;
        private static final int SEC_INFO_VALUE = 850;
        public static final SecurityLevel SEC_WARNING = new SecurityLevel("SEC_WARNING", 950);
        public static final SecurityLevel SEC_INFO = new SecurityLevel("SEC_INFO", 850);

        private SecurityLevel(String name, int value) {
            super(name, value);
        }

        private Object readResolve() {
            if (this.intValue() == 950) {
                return SEC_WARNING;
            }
            if (this.intValue() == 850) {
                return SEC_INFO;
            }
            throw new RuntimeException("Encounter unrecognized value in resolving security level: " + this.intValue());
        }
    }

    private static class ServiceHandlerKey {
        private final String resourceName;
        private final String kvName;

        ServiceHandlerKey(String resourceName, String kvName) {
            this.resourceName = resourceName;
            this.kvName = kvName;
        }

        boolean belongs(String kvStoreName) {
            if (kvStoreName == null) {
                return true;
            }
            return this.kvName.equals(kvStoreName);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.kvName == null ? 0 : this.kvName.hashCode());
            result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceHandlerKey other = (ServiceHandlerKey)obj;
            if (this.kvName == null ? other.kvName != null : !this.kvName.equals(other.kvName)) {
                return false;
            }
            return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
        }

        public String toString() {
            return this.kvName + "/" + this.resourceName;
        }
    }
}

