/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.kv.impl.admin.CommandService;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.RequestHandler;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.client.admin.ClientAdminService;
import oracle.kv.impl.client.admin.ClientAdminServiceAPI;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.monitor.MonitorAgent;
import oracle.kv.impl.monitor.MonitorAgentAPI;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.TrustedLogin;
import oracle.kv.impl.security.login.TrustedLoginAPI;
import oracle.kv.impl.security.login.UserLogin;
import oracle.kv.impl.security.login.UserLoginAPI;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeAgentInterface;
import oracle.kv.impl.test.RemoteTestAPI;
import oracle.kv.impl.test.RemoteTestInterface;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.ServerSocketFactory;
import oracle.kv.impl.util.registry.ssl.SSLClientSocketFactory;

public class RegistryUtils {
    private static ClientSocketFactory registryCSF = null;
    private static final Map<String, ClientSocketFactory> storeToRegistryCSFMap = new ConcurrentHashMap<String, ClientSocketFactory>();
    private final Topology topology;
    private final LoginManager loginMgr;
    private static final String BINDING_NAME_SEPARATOR = ":";
    private static String DEFAULT_REGISTRY_OPEN_TIMEOUT = Integer.toString(3000);
    private static String REGISTRY_OPEN_TIMEOUT_KEY = "registryOpenTimeout";

    public RegistryUtils(Topology topology, LoginManager loginMgr) {
        this.topology = topology;
        this.loginMgr = loginMgr;
    }

    public RequestHandlerAPI getRequestHandler(RepNodeId repNodeId) throws RemoteException, NotBoundException {
        RepNode repNode = this.topology.get(repNodeId);
        return repNode == null ? null : RequestHandlerAPI.wrap((RequestHandler)this.lookup(repNodeId.getFullName(), InterfaceType.MAIN, repNode.getStorageNodeId()));
    }

    public RepNodeAdminAPI getRepNodeAdmin(RepNodeId repNodeId) throws RemoteException, NotBoundException {
        RepNode repNode = this.topology.get(repNodeId);
        return RepNodeAdminAPI.wrap((RepNodeAdmin)this.lookup(repNodeId.getFullName(), InterfaceType.ADMIN, repNode.getStorageNodeId()), this.getLogin(repNodeId));
    }

    public static boolean isRepNodeAdmin(String serviceName) {
        if (serviceName.toLowerCase().indexOf("rg") > 0) {
            return serviceName.endsWith(InterfaceType.ADMIN.toString());
        }
        return false;
    }

    public UserLoginAPI getRepNodeLogin(RepNodeId repNodeId) throws RemoteException, NotBoundException {
        RepNode repNode = this.topology.get(repNodeId);
        LoginHandle loginHdl = this.getLogin(repNodeId);
        return UserLoginAPI.wrap((UserLogin)this.lookup(repNodeId.getFullName(), InterfaceType.LOGIN, repNode.getStorageNodeId()), loginHdl);
    }

    public static String isRepNodeLogin(String serviceName) {
        int firstSep = serviceName.indexOf(BINDING_NAME_SEPARATOR);
        if (firstSep < 0) {
            return null;
        }
        if (serviceName.toLowerCase().indexOf(RepGroupId.getPrefix(), firstSep) > 0 && serviceName.endsWith(BINDING_NAME_SEPARATOR + InterfaceType.LOGIN.toString())) {
            return serviceName.substring(0, firstSep);
        }
        return null;
    }

    public static boolean isRepNodeLogin(String serviceName, String storeName) {
        return storeName.equals(RegistryUtils.isRepNodeLogin(serviceName));
    }

    public RemoteTestAPI getRepNodeTest(RepNodeId repNodeId) throws RemoteException, NotBoundException {
        RepNode repNode = this.topology.get(repNodeId);
        return RemoteTestAPI.wrap((RemoteTestInterface)this.lookup(repNodeId.getFullName(), InterfaceType.TEST, repNode.getStorageNodeId()));
    }

    public static MonitorAgentAPI getMonitor(String storeName, String snHostname, int snRegistryPort, ResourceId resourceId, LoginManager loginMgr) throws RemoteException, NotBoundException {
        return MonitorAgentAPI.wrap((MonitorAgent)RegistryUtils.getInterface(storeName, snHostname, snRegistryPort, resourceId.getFullName(), InterfaceType.MONITOR), RegistryUtils.getLogin(loginMgr, snHostname, snRegistryPort, resourceId.getType()));
    }

    public static CommandServiceAPI getAdmin(String hostname, int registryPort, LoginManager loginMgr) throws RemoteException, NotBoundException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        return CommandServiceAPI.wrap((CommandService)registry.lookup("commandService"), RegistryUtils.getLogin(loginMgr, hostname, registryPort, ResourceId.ResourceType.ADMIN));
    }

    public CommandServiceAPI getAdmin(StorageNodeId snid) throws RemoteException, NotBoundException {
        Registry registry = this.getRegistry(snid);
        return CommandServiceAPI.wrap((CommandService)registry.lookup("commandService"), this.getLogin(snid));
    }

    public RemoteTestAPI getAdminTest(StorageNodeId snid) throws RemoteException, NotBoundException {
        Registry registry = this.getRegistry(snid);
        return RemoteTestAPI.wrap((RemoteTestInterface)registry.lookup("commandServiceTest"));
    }

    public static RemoteTestAPI getAdminTest(String hostname, int registryPort) throws RemoteException, NotBoundException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        return RemoteTestAPI.wrap((RemoteTestInterface)registry.lookup("commandServiceTest"));
    }

    public UserLoginAPI getAdminLogin(StorageNodeId snid) throws RemoteException, NotBoundException {
        Registry registry = this.getRegistry(snid);
        return UserLoginAPI.wrap((UserLogin)registry.lookup("admin:LOGIN"), this.getLogin(snid));
    }

    public static UserLoginAPI getAdminLogin(String hostname, int registryPort, LoginManager loginMgr) throws RemoteException, NotBoundException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        return UserLoginAPI.wrap((UserLogin)registry.lookup("admin:LOGIN"), RegistryUtils.getLogin(loginMgr, hostname, registryPort, ResourceId.ResourceType.ADMIN));
    }

    public static ClientAdminServiceAPI getAdminDDL(String hostname, int registryPort, LoginManager loginMgr) throws RemoteException, NotBoundException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        return ClientAdminServiceAPI.wrap((ClientAdminService)registry.lookup("admin:CLIENT_ADMIN"), RegistryUtils.getLogin(loginMgr, hostname, registryPort, ResourceId.ResourceType.ADMIN));
    }

    public ClientAdminServiceAPI getAdminDDL(StorageNodeId snid) throws RemoteException, NotBoundException {
        Registry registry = this.getRegistry(snid);
        return ClientAdminServiceAPI.wrap((ClientAdminService)registry.lookup("admin:CLIENT_ADMIN"), this.getLogin(snid));
    }

    public static RepNodeAdminAPI getRepNodeAdmin(String storeName, String snHostname, int snRegistryPort, RepNodeId rnId, LoginManager loginMgr) throws RemoteException, NotBoundException {
        return RepNodeAdminAPI.wrap((RepNodeAdmin)RegistryUtils.getInterface(storeName, snHostname, snRegistryPort, rnId.getFullName(), InterfaceType.ADMIN), RegistryUtils.getLogin(loginMgr, snHostname, snRegistryPort, ResourceId.ResourceType.REP_NODE));
    }

    public static UserLoginAPI getRepNodeLogin(String storeName, String snHostname, int snRegistryPort, RepNodeId rnId, LoginManager loginMgr) throws RemoteException, NotBoundException {
        return RegistryUtils.getRepNodeLogin(storeName, snHostname, snRegistryPort, rnId.getFullName(), loginMgr);
    }

    public static UserLoginAPI getRepNodeLogin(String storeName, String snHostname, int snRegistryPort, String rnFullName, LoginManager loginMgr) throws RemoteException, NotBoundException {
        return UserLoginAPI.wrap((UserLogin)RegistryUtils.getInterface(storeName, snHostname, snRegistryPort, rnFullName, InterfaceType.LOGIN), RegistryUtils.getLogin(loginMgr, snHostname, snRegistryPort, ResourceId.ResourceType.REP_NODE));
    }

    public static void checkForStartupProblem(String storeName, String snHostname, int snRegistryPort, ResourceId rId, StorageNodeId snId, LoginManager loginMgr) {
        StringBuilder startupProblem = null;
        try {
            StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(storeName, snHostname, snRegistryPort, snId, loginMgr);
            startupProblem = sna.getStartupBuffer(rId);
        }
        catch (Exception secondaryProblem) {
            // empty catch block
        }
        if (startupProblem != null) {
            throw new OperationFaultException("Problem starting process for " + rId + BINDING_NAME_SEPARATOR + startupProblem.toString());
        }
    }

    private static Remote getInterface(String storeName, String snHostname, int snRegistryPort, String rnName, InterfaceType interfaceType) throws RemoteException, NotBoundException {
        Registry registry = RegistryUtils.getRegistry(snHostname, snRegistryPort, storeName);
        return registry.lookup(RegistryUtils.bindingName(storeName, rnName, interfaceType));
    }

    public static StorageNodeAgentAPI getStorageNodeAgent(String hostname, int registryPort, String serviceName, LoginManager loginMgr) throws RemoteException, NotBoundException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        StorageNodeAgentInterface snai = (StorageNodeAgentInterface)registry.lookup(serviceName);
        LoginHandle loginHdl = RegistryUtils.getLogin(loginMgr, hostname, registryPort, ResourceId.ResourceType.STORAGE_NODE);
        return StorageNodeAgentAPI.wrap(snai, loginHdl);
    }

    public StorageNodeAgentAPI getStorageNodeAgent(StorageNodeId storageNodeId) throws RemoteException, NotBoundException {
        StorageNodeAgentInterface snai = (StorageNodeAgentInterface)this.lookup(storageNodeId.getFullName(), InterfaceType.MAIN, storageNodeId);
        LoginHandle loginHdl = this.getLogin(storageNodeId);
        return StorageNodeAgentAPI.wrap(snai, loginHdl);
    }

    public static RemoteTestAPI getStorageNodeAgentTest(String storeName, String hostname, int registryPort, StorageNodeId snid) throws RemoteException, NotBoundException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        String serviceName = RegistryUtils.bindingName(storeName, snid.getFullName(), InterfaceType.TEST);
        return RemoteTestAPI.wrap((RemoteTestInterface)registry.lookup(serviceName));
    }

    public RemoteTestAPI getStorageNodeAgentTest(StorageNodeId storageNodeId) throws RemoteException, NotBoundException {
        return RemoteTestAPI.wrap((RemoteTestInterface)this.lookup(storageNodeId.getFullName(), InterfaceType.TEST, storageNodeId));
    }

    public static TrustedLoginAPI getStorageNodeAgentLogin(String hostname, int registryPort) throws RemoteException, NotBoundException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        return TrustedLoginAPI.wrap((TrustedLogin)registry.lookup("SNA:TRUSTED_LOGIN"));
    }

    public static boolean isStorageNodeAgentLogin(String serviceName) {
        return serviceName.equals("SNA:TRUSTED_LOGIN");
    }

    public static StorageNodeAgentAPI getStorageNodeAgent(String storeName, String snHostname, int snRegistryPort, StorageNodeId snId, LoginManager loginMgr) throws RemoteException, NotBoundException {
        StorageNodeAgentInterface snai = (StorageNodeAgentInterface)RegistryUtils.getInterface(storeName, snHostname, snRegistryPort, snId.getFullName(), InterfaceType.MAIN);
        LoginHandle loginHdl = RegistryUtils.getLogin(loginMgr, snHostname, snRegistryPort, ResourceId.ResourceType.STORAGE_NODE);
        return StorageNodeAgentAPI.wrap(snai, loginHdl);
    }

    public static StorageNodeAgentAPI getStorageNodeAgent(String storename, StorageNode sn, LoginManager loginMgr) throws RemoteException, NotBoundException {
        return RegistryUtils.getStorageNodeAgent(storename, sn.getHostname(), sn.getRegistryPort(), (StorageNodeId)sn.getResourceId(), loginMgr);
    }

    public static StorageNodeAgentAPI getStorageNodeAgent(Parameters parameters, StorageNodeId snId, LoginManager loginMgr) throws RemoteException, NotBoundException {
        String storename = parameters.getGlobalParams().getKVStoreName();
        return RegistryUtils.getStorageNodeAgent(storename, parameters.get(snId), snId, loginMgr);
    }

    public static StorageNodeAgentAPI getStorageNodeAgent(String storename, StorageNodeParams snp, StorageNodeId snId, LoginManager loginMgr) throws RemoteException, NotBoundException {
        return RegistryUtils.getStorageNodeAgent(storename, snp.getHostname(), snp.getRegistryPort(), snId, loginMgr);
    }

    public void rebind(RepNodeId repNodeId, RequestHandler requestHandler) throws RemoteException {
        RepNode repNode = this.topology.get(repNodeId);
        this.rebind(repNodeId.getFullName(), InterfaceType.MAIN, repNode.getStorageNodeId(), requestHandler);
    }

    public void rebind(RepNodeId repNodeId, MonitorAgent monitorAgent) throws RemoteException {
        RepNode repNode = this.topology.get(repNodeId);
        this.rebind(repNodeId.getFullName(), InterfaceType.MONITOR, repNode.getStorageNodeId(), monitorAgent);
    }

    public void rebind(RepNodeId repNodeId, RepNodeAdmin repNodeAdmin) throws RemoteException {
        RepNode repNode = this.topology.get(repNodeId);
        this.rebind(repNodeId.getFullName(), InterfaceType.ADMIN, repNode.getStorageNodeId(), repNodeAdmin);
    }

    private void rebind(String baseName, InterfaceType interfaceType, StorageNodeId storageNodeId, Remote object) throws RemoteException {
        Registry registry = this.getRegistry(storageNodeId);
        Remote stub = RegistryUtils.export(object, null, null);
        try {
            registry.rebind(this.bindingName(baseName, interfaceType), stub);
        }
        catch (RemoteException re) {
            UnicastRemoteObject.unexportObject(object, true);
            throw re;
        }
    }

    public static void rebind(String hostname, int registryPort, String storeName, String baseName, InterfaceType interfaceType, Remote object, ClientSocketFactory clientSocketFactory, ServerSocketFactory serverSocketFactory) throws RemoteException {
        RegistryUtils.rebind(hostname, registryPort, RegistryUtils.bindingName(storeName, baseName, interfaceType), object, clientSocketFactory, serverSocketFactory);
    }

    public static void rebind(String hostname, int registryPort, String storeName, String baseName, InterfaceType interfaceType, Remote object) throws RemoteException {
        RegistryUtils.rebind(hostname, registryPort, storeName, baseName, interfaceType, object, null, null);
    }

    public static void rebind(String hostname, int registryPort, String serviceName, Remote object, ClientSocketFactory clientSocketFactory, ServerSocketFactory serverSocketFactory) throws RemoteException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        Remote stub = RegistryUtils.export(object, clientSocketFactory, serverSocketFactory);
        try {
            registry.rebind(serviceName, stub);
        }
        catch (RemoteException re) {
            UnicastRemoteObject.unexportObject(object, true);
            throw new RemoteException("Can't rebind " + serviceName + " at " + hostname + BINDING_NAME_SEPARATOR + registryPort + " csf: " + clientSocketFactory + " ssf: " + serverSocketFactory, re);
        }
    }

    public static boolean unbind(String hostname, int registryPort, String storeName, String baseName, InterfaceType interfaceType, Remote object) throws RemoteException {
        return RegistryUtils.unbind(hostname, registryPort, RegistryUtils.bindingName(storeName, baseName, interfaceType), object);
    }

    public static boolean unbind(String hostname, int registryPort, String serviceName, Remote object) throws RemoteException {
        Registry registry = RegistryUtils.getRegistry(hostname, registryPort);
        try {
            registry.unbind(serviceName);
            UnicastRemoteObject.unexportObject(object, true);
            return true;
        }
        catch (NotBoundException e) {
            return false;
        }
    }

    public static String bindingName(String storeName, String baseName, InterfaceType interfaceType) {
        return storeName + BINDING_NAME_SEPARATOR + baseName + BINDING_NAME_SEPARATOR + (Object)((Object)interfaceType);
    }

    public static void initRegistryCSF() {
        RMISocketPolicy rmiPolicy = ClientSocketFactory.ensureRMISocketPolicy();
        String registryCsfName = ClientSocketFactory.registryFactoryName();
        String timeoutProp = System.getProperty(REGISTRY_OPEN_TIMEOUT_KEY, DEFAULT_REGISTRY_OPEN_TIMEOUT);
        int connectTimeOutMs = Integer.parseInt(timeoutProp);
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs().setCsfName(registryCsfName).setCsfConnectTimeout(connectTimeOutMs);
        RegistryUtils.setRegistryCSF(rmiPolicy.getRegistryCSF(args), null);
    }

    public static synchronized void setRegistrySocketTimeouts(int connectMs, int readMs, String storeName) {
        RMISocketPolicy rmiPolicy = ClientSocketFactory.ensureRMISocketPolicy();
        String registryCsfName = ClientSocketFactory.registryFactoryName();
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs().setKvStoreName(storeName).setCsfName(registryCsfName).setCsfConnectTimeout(connectMs).setCsfReadTimeout(readMs);
        RegistryUtils.setRegistryCSF(rmiPolicy.getRegistryCSF(args), storeName);
    }

    public static synchronized void setServerRegistryCSF(ClientSocketFactory clientSocketFactory) {
        RegistryUtils.setRegistryCSF(clientSocketFactory, null);
    }

    public static synchronized void setRegistryCSF(ClientSocketFactory clientSocketFactory, String storeName) {
        if (!TestStatus.isActive() || clientSocketFactory == null || clientSocketFactory.getClass() == SSLClientSocketFactory.class) {
            registryCSF = clientSocketFactory;
            if (storeName != null) {
                storeToRegistryCSFMap.put(storeName, clientSocketFactory);
            }
        }
    }

    public static synchronized Registry getRegistry(String hostname, int port, String storeName) throws RemoteException {
        ClientSocketFactory csf;
        ClientSocketFactory clientSocketFactory = csf = storeName == null ? null : storeToRegistryCSFMap.get(storeName);
        if (csf == null) {
            csf = registryCSF;
        }
        return new ExceptionWrappingRegistry(LocateRegistry.getRegistry(hostname, port, csf));
    }

    public static synchronized Registry getRegistry(String hostname, int port) throws RemoteException {
        return RegistryUtils.getRegistry(hostname, port, null);
    }

    public static int findFreePort(int start, int end, String hostname) {
        ServerSocket serverSocket = null;
        for (int current = start; current <= end; ++current) {
            try {
                serverSocket = new ServerSocket(current);
                serverSocket.close();
                serverSocket = new ServerSocket();
                InetSocketAddress sa = new InetSocketAddress(hostname, current);
                serverSocket.bind(sa);
                serverSocket.close();
                return current;
            }
            catch (IOException e) {
                continue;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Remote export(Remote object, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        int port = 0;
        ServerSocket ss = null;
        if (ssf != null) {
            try {
                ss = ssf.prepareServerSocket();
                if (ss != null) {
                    port = ss.getLocalPort();
                }
            }
            catch (IOException ioe) {
                throw new ExportException("Unable to create ServerSocket for export", ioe);
            }
        }
        try {
            Remote remote = UnicastRemoteObject.exportObject(object, port, csf, ssf);
            ss = null;
            Remote remote2 = remote;
            return remote2;
        }
        finally {
            if (ss != null && ssf != null) {
                ssf.discardServerSocket(ss);
            }
        }
    }

    private String bindingName(String baseName, InterfaceType interfaceType) {
        return RegistryUtils.bindingName(this.topology.getKVStoreName(), baseName, interfaceType);
    }

    public Registry getRegistry(StorageNodeId storageNodeId) throws RemoteException {
        StorageNode storageNode = this.topology.get(storageNodeId);
        return RegistryUtils.getRegistry(storageNode.getHostname(), storageNode.getRegistryPort(), this.topology.getKVStoreName());
    }

    private Remote lookup(String baseName, InterfaceType interfaceType, StorageNodeId storageNodeId) throws RemoteException, NotBoundException {
        Registry registry = this.getRegistry(storageNodeId);
        return registry.lookup(this.bindingName(baseName, interfaceType));
    }

    private LoginHandle getLogin(ResourceId resourceId) {
        StorageNodeId snId;
        StorageNode sn;
        Topology.Component<?> comp;
        if (this.loginMgr == null) {
            return null;
        }
        if (this.topology != null && (comp = this.topology.get(resourceId)) != null && (sn = this.topology.get(snId = comp.getStorageNodeId())) != null) {
            return this.loginMgr.getHandle(new HostPort(sn.getHostname(), sn.getRegistryPort()), resourceId.getType());
        }
        return this.loginMgr.getHandle(resourceId);
    }

    private static LoginHandle getLogin(LoginManager loginMgr, String hostname, int registryPort, ResourceId.ResourceType rtype) {
        if (loginMgr == null) {
            return null;
        }
        return loginMgr.getHandle(new HostPort(hostname, registryPort), rtype);
    }

    private static class ExceptionWrappingRegistry
    implements Registry {
        private final Registry registry;

        private ExceptionWrappingRegistry(Registry registry) {
            this.registry = registry;
        }

        @Override
        public Remote lookup(String name) throws RemoteException, NotBoundException, AccessException {
            try {
                return this.registry.lookup(name);
            }
            catch (RemoteException re) {
                this.rethrow(re);
                return null;
            }
        }

        @Override
        public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
            try {
                this.registry.bind(name, obj);
            }
            catch (RemoteException re) {
                this.rethrow(re);
            }
        }

        @Override
        public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
            try {
                this.registry.unbind(name);
            }
            catch (RemoteException re) {
                this.rethrow(re);
            }
        }

        @Override
        public void rebind(String name, Remote obj) throws RemoteException, AccessException {
            try {
                this.registry.rebind(name, obj);
            }
            catch (RemoteException re) {
                this.rethrow(re);
            }
        }

        @Override
        public String[] list() throws RemoteException, AccessException {
            try {
                return this.registry.list();
            }
            catch (RemoteException re) {
                this.rethrow(re);
                return null;
            }
        }

        private void rethrow(RemoteException re) throws RemoteException {
            if (re instanceof ConnectIOException) {
                throw new ConnectIOException("Problem connecting to the KVStore server, which may be caused by a security mismatch between the client and server", re);
            }
            if (re instanceof ConnectException) {
                throw new ConnectException("Unable to connect to the storage node agent, which may not be running", re);
            }
            throw re;
        }
    }

    public static enum InterfaceType {
        MAIN,
        MONITOR,
        ADMIN,
        TEST,
        LOGIN,
        TRUSTED_LOGIN;


        public String interfaceName() {
            return this.name().toLowerCase();
        }
    }
}

