/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.registry.RegistryUtils;

public class ServiceUtils {
    public static RepNodeAdminAPI waitForRepNodeAdmin(String storeName, String hostName, int port, RepNodeId rnid, StorageNodeId snid, LoginManager loginMgr, long timeoutSec, ConfigurableService.ServiceStatus[] targetStatus) throws Exception {
        Exception exception = null;
        RepNodeAdminAPI rnai = null;
        ConfigurableService.ServiceStatus status = null;
        long limitMs = System.currentTimeMillis() + 1000L * timeoutSec;
        while (System.currentTimeMillis() <= limitMs) {
            if (exception != null) {
                rnai = null;
            }
            try {
                if (rnai == null) {
                    rnai = RegistryUtils.getRepNodeAdmin(storeName, hostName, port, rnid, loginMgr);
                }
                status = rnai.ping().getServiceStatus();
                for (ConfigurableService.ServiceStatus tstatus : targetStatus) {
                    if (tstatus == ConfigurableService.ServiceStatus.UNREACHABLE) {
                        return rnai;
                    }
                    if (status != tstatus) continue;
                    return rnai;
                }
                exception = null;
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (NotBoundException e) {
                exception = e;
            }
            if (snid != null) {
                RegistryUtils.checkForStartupProblem(storeName, hostName, port, rnid, snid, loginMgr);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                throw new IllegalStateException("unexpected interrupt");
            }
        }
        if (status != null) {
            throw new IllegalStateException("RN current status: " + (Object)((Object)status) + " target status: " + Arrays.toString((Object[])targetStatus));
        }
        throw exception;
    }

    public static RepNodeAdminAPI waitForRepNodeAdmin(Topology topology, RepNodeId rnid, LoginManager loginMgr, long timeoutSec, ConfigurableService.ServiceStatus[] targetStatus) throws Exception {
        RepNode rn = topology.get(rnid);
        StorageNode sn = topology.get(rn.getStorageNodeId());
        return ServiceUtils.waitForRepNodeAdmin(topology.getKVStoreName(), sn.getHostname(), sn.getRegistryPort(), rnid, sn.getStorageNodeId(), loginMgr, timeoutSec, targetStatus);
    }

    public static CommandServiceAPI waitForAdmin(String hostname, int registryPort, LoginManager loginMgr, long timeoutSec, ConfigurableService.ServiceStatus targetStatus) throws Exception {
        Exception exception = null;
        CommandServiceAPI admin = null;
        ConfigurableService.ServiceStatus status = null;
        long limitMs = System.currentTimeMillis() + 1000L * timeoutSec;
        while (System.currentTimeMillis() <= limitMs) {
            if (exception != null) {
                admin = null;
            }
            try {
                if (admin == null) {
                    admin = RegistryUtils.getAdmin(hostname, registryPort, loginMgr);
                }
                status = admin.ping();
                if (targetStatus == ConfigurableService.ServiceStatus.UNREACHABLE) {
                    return admin;
                }
                if (status == targetStatus) {
                    return admin;
                }
                exception = null;
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (NotBoundException e) {
                exception = e;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                throw new IllegalStateException("unexpected interrupt");
            }
        }
        if (status != null) {
            throw new IllegalStateException("Admin status: " + (Object)((Object)status) + "Target status: " + (Object)((Object)targetStatus));
        }
        throw exception;
    }
}

