/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.kv.impl.security.util.PasswordReader;
import oracle.kv.impl.security.util.ShellPasswordReader;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.PwdfileCommand;
import oracle.kv.impl.util.SecurityConfigCommand;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

public class SecurityShell
extends Shell {
    private static final String WALLET_COMMAND_CLASS = "oracle.kv.impl.util.WalletCommand";
    public static final String COMMAND_NAME = "securityconfig";
    public static final String COMMAND_DESC = "runs the security configuration command line interface";
    public static final String COMMAND_ARGS = CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + " [single command and arguments]";
    private CommandParser parser;
    private boolean noprompt = false;
    private int nextCommandIdx = 0;
    private String[] commandToRun;
    private PasswordReader passwordReader;
    static final String prompt = "security-> ";
    static final String usageHeader = "Oracle NoSQL Database Security Configuration Commands:" + eol;
    private final List<ShellCommand> commands;

    public SecurityShell(InputStream input, PrintStream output, PasswordReader passwordReader) {
        super(input, output);
        this.passwordReader = passwordReader;
        this.commands = new ArrayList<ShellCommand>();
        List<ShellCommand> basicCommands = Arrays.asList(new Shell.ExitCommand(), new Shell.HelpCommand(), new PwdfileCommand(), new SecurityConfigCommand());
        this.commands.addAll(basicCommands);
        ShellCommand walletCommand = this.findWalletCommand();
        if (walletCommand != null) {
            this.commands.add(walletCommand);
        }
        Collections.sort(this.commands, new Shell.CommandComparator());
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<? extends ShellCommand> getCommands() {
        return this.commands;
    }

    @Override
    public String getPrompt() {
        return this.noprompt ? null : prompt;
    }

    @Override
    public String getUsageHeader() {
        return usageHeader;
    }

    @Override
    public boolean doRetry() {
        return false;
    }

    public void start() {
        this.init();
        if (this.commandToRun != null) {
            try {
                String result = this.run(this.commandToRun[0], this.commandToRun);
                this.output.println(result);
            }
            catch (ShellException se) {
                this.handleShellException(this.commandToRun[0], se);
            }
            catch (Exception e) {
                this.handleUnknownException(this.commandToRun[0], e);
            }
        } else {
            this.loop();
        }
        this.shutdown();
    }

    void enableHidden() {
        if (!this.showHidden()) {
            this.toggleHidden();
        }
    }

    public void parseArgs(String[] args) {
        this.parser = new ShellParser(args);
        this.parser.parseArgs();
    }

    public static void main(String[] args) {
        SecurityShell shell = new SecurityShell(System.in, System.out, new ShellPasswordReader());
        shell.parseArgs(args);
        shell.start();
        if (shell.getExitCode() != 0) {
            System.exit(shell.getExitCode());
        }
    }

    PasswordReader getPasswordReader() {
        return this.passwordReader;
    }

    private ShellCommand findWalletCommand() {
        Class<?> walletCommandClass;
        try {
            walletCommandClass = Class.forName(WALLET_COMMAND_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        try {
            return (ShellCommand)walletCommandClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        catch (InstantiationException ie) {
            return null;
        }
        catch (ExceptionInInitializerError eiie) {
            return null;
        }
        catch (SecurityException se) {
            return null;
        }
    }

    static /* synthetic */ String[] access$002(SecurityShell x0, String[] x1) {
        x0.commandToRun = x1;
        return x1;
    }

    private final class ShellParser
    extends CommandParser {
        public static final String NOPROMPT_FLAG = "-noprompt";

        private ShellParser(String[] args) {
            super(args, true);
        }

        @Override
        protected void verifyArgs() {
            if (SecurityShell.this.commandToRun != null && SecurityShell.this.nextCommandIdx < SecurityShell.this.commandToRun.length) {
                this.usage("Flags may not follow commands");
            }
        }

        @Override
        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar securityconfig" + Shell.eolt + COMMAND_ARGS);
            System.exit(1);
        }

        @Override
        protected boolean checkArg(String arg) {
            if (NOPROMPT_FLAG.equals(arg)) {
                SecurityShell.this.noprompt = true;
                return true;
            }
            this.addToCommand(arg);
            return true;
        }

        private void addToCommand(String arg) {
            if (SecurityShell.this.commandToRun == null) {
                SecurityShell.access$002(SecurityShell.this, new String[this.getNRemainingArgs() + 1]);
            }
            ((SecurityShell)SecurityShell.this).commandToRun[((SecurityShell)SecurityShell.this).nextCommandIdx++] = arg;
        }
    }
}

