/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.File;
import java.util.Arrays;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStoreException;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.SecurityConfigCreator;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;

class SecurityConfigCommand
extends CommandWithSubs {
    static final String ROOT_FLAG = "-root";
    static final String PWDMGR_FLAG = "-pwdmgr";
    static final String PASSMGR_WALLET = "wallet";
    static final String PASSMGR_PWDFILE = "pwdfile";
    static final String KEYSTORE_PASSWORD_FLAG = "-kspwd";
    static final String SECURITY_DIR_FLAG = "-secdir";
    static final String CERT_MODE_FLAG = "-certmode";
    static final String SECURITY_PARAM_FLAG = "-security-param";
    static final String PARAM_FLAG = "-param";
    static final String CONFIG_FLAG = "-config";
    static final String SOURCE_ROOT_FLAG = "-source-root";
    static final String SOURCE_SECURITY_DIR_FLAG = "-source-secdir";
    private static final String BASIC_CREATE_COMMAND_ARGS = "[-secdir <security dir>] [-pwdmgr {pwdfile | wallet | <class-name>}] \n\t[-kspwd <password>] [-param <param=value>]*";
    private static final String CREATE_COMMAND_ARGS = "-root <secroot> \n\t[-secdir <security dir>] [-pwdmgr {pwdfile | wallet | <class-name>}] \n\t[-kspwd <password>] [-param <param=value>]*";
    private static final String OTHER_ARGS = " [-certmode { shared | server }] ";
    private static final String ADD_SECURITY_COMMAND_ARGS = "-root <kvroot> [-secdir <security dir>] [-config <config.xml>]";
    private static final String REMOVE_SECURITY_COMMAND_ARGS = "-root <kvroot> [-config <config.xml>]";
    private static final String MERGE_TRUST_COMMAND_ARGS = "-root <secroot> [-secdir <security dir>] -source-root <source secroot> [-source-secdir <source secdir>]";

    SecurityConfigCommand() {
        super(Arrays.asList(new SecurityConfigCreate(), new SecurityConfigAddSecurity(), new SecurityConfigRemoveSecurity(), new SecurityConfigMergeTrust()), "config", 4, 1);
    }

    @Override
    public String getCommandOverview() {
        return "The config command allows configuration of security settings for a NoSQL installation.";
    }

    public static String getPwdmgrClass(String pwdmgr) {
        if (pwdmgr == null) {
            return PasswordManager.preferredManagerClass();
        }
        if (pwdmgr.equals(PASSMGR_PWDFILE)) {
            return "oracle.kv.impl.security.filestore.FileStoreManager";
        }
        if (pwdmgr.equals(PASSMGR_WALLET)) {
            return "oracle.kv.impl.security.wallet.WalletManager";
        }
        return pwdmgr;
    }

    private static final class SecurityConfigMergeTrust
    extends CommandWithSubs.SubCommand {
        private static final String MERGE_TRUST_COMMAND_NAME = "merge-trust";
        private static final String MERGE_TRUST_COMMAND_DESC = "Merges trust information from a source security directory into a security configuration.";

        private SecurityConfigMergeTrust() {
            super(MERGE_TRUST_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String kvRoot = null;
            String secDir = null;
            String srcKvRoot = null;
            String srcSecDir = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (SecurityConfigCommand.ROOT_FLAG.equals(arg)) {
                    kvRoot = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SecurityConfigCommand.SECURITY_DIR_FLAG.equals(arg)) {
                    secDir = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SecurityConfigCommand.SOURCE_ROOT_FLAG.equals(arg)) {
                    srcKvRoot = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SecurityConfigCommand.SOURCE_SECURITY_DIR_FLAG.equals(arg)) {
                    srcSecDir = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (kvRoot == null) {
                shell.requiredArg(SecurityConfigCommand.ROOT_FLAG, this);
            }
            if (srcKvRoot == null) {
                shell.requiredArg(SecurityConfigCommand.SOURCE_ROOT_FLAG, this);
            }
            return this.doMergeTrust(kvRoot, secDir, srcKvRoot, srcSecDir);
        }

        private String doMergeTrust(String kvRoot, String secDir, String srcKvRoot, String srcSecDir) throws ShellException {
            if (secDir == null) {
                secDir = "security";
            }
            if (srcSecDir == null) {
                srcSecDir = "security";
            }
            File kvRootFile = new File(kvRoot);
            File secDirFile = new File(secDir);
            File srcKvRootFile = new File(srcKvRoot);
            File srcSecDirFile = new File(srcSecDir);
            if (!kvRootFile.exists()) {
                throw new ShellException("The -root argument " + kvRootFile + " does not exist.");
            }
            if (!kvRootFile.isDirectory()) {
                throw new ShellException("The -root argument " + kvRootFile + " is not a directory.");
            }
            if (secDirFile.isAbsolute()) {
                throw new ShellException("The -secdir argument must be a relative file name.");
            }
            File rootedSecDirFile = new File(kvRootFile, secDir);
            if (!rootedSecDirFile.exists()) {
                throw new ShellException("The file " + secDir + " does not exist in " + kvRoot);
            }
            if (!rootedSecDirFile.isDirectory()) {
                throw new ShellException(rootedSecDirFile.toString() + " is not a directory.");
            }
            if (!srcKvRootFile.exists()) {
                throw new ShellException("The -source-root argument " + srcKvRootFile + " does not exist.");
            }
            if (!srcKvRootFile.isDirectory()) {
                throw new ShellException("The -source-root argument " + srcKvRootFile + " is not a directory.");
            }
            if (srcSecDirFile.isAbsolute()) {
                throw new ShellException("The -source-secdir argument must be a relative file name.");
            }
            File rootedSrcSecDirFile = new File(srcKvRootFile, srcSecDir);
            if (!rootedSrcSecDirFile.exists()) {
                throw new ShellException("The file " + srcSecDir + " does not exist in " + srcKvRoot);
            }
            if (!rootedSrcSecDirFile.isDirectory()) {
                throw new ShellException(rootedSrcSecDirFile.toString() + " is not a directory.");
            }
            SecurityUtils.mergeTrust(rootedSrcSecDirFile, rootedSecDirFile);
            return "Configuration updated.";
        }

        @Override
        public String getCommandSyntax() {
            return "config merge-trust -root <secroot> [-secdir <security dir>] -source-root <source secroot> [-source-secdir <source secdir>]";
        }

        @Override
        public String getCommandDescription() {
            return MERGE_TRUST_COMMAND_DESC;
        }
    }

    private static final class SecurityConfigRemoveSecurity
    extends CommandWithSubs.SubCommand {
        private static final String REMOVE_SECURITY_COMMAND_NAME = "remove-security";
        private static final String REMOVE_SECURITY_COMMAND_DESC = "Updates a Storage Node configuration to remove the security configuartion.";

        private SecurityConfigRemoveSecurity() {
            super(REMOVE_SECURITY_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String kvRoot = null;
            String configXml = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (SecurityConfigCommand.ROOT_FLAG.equals(arg)) {
                    kvRoot = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SecurityConfigCommand.CONFIG_FLAG.equals(arg)) {
                    configXml = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (kvRoot == null) {
                shell.requiredArg(SecurityConfigCommand.ROOT_FLAG, this);
            }
            return this.doRemoveSecurity(kvRoot, configXml);
        }

        private String doRemoveSecurity(String kvRoot, String configXml) throws ShellException {
            if (configXml == null) {
                configXml = "config.xml";
            }
            File kvRootFile = new File(kvRoot);
            File configXmlFile = new File(configXml);
            if (!kvRootFile.exists()) {
                throw new ShellException("The -root argument " + kvRootFile + " does not exist.");
            }
            if (!kvRootFile.isDirectory()) {
                throw new ShellException("The -root argument " + kvRootFile + " is not a directory.");
            }
            if (configXmlFile.isAbsolute()) {
                throw new ShellException("The -config argument must be a relative file name.");
            }
            File rootedConfigXmlFile = new File(kvRootFile, configXml);
            if (!rootedConfigXmlFile.exists()) {
                throw new ShellException("The file " + configXml + " does not exist in " + kvRoot);
            }
            if (!rootedConfigXmlFile.isFile()) {
                throw new ShellException(rootedConfigXmlFile.toString() + " is not a file.");
            }
            this.updateConfigFile(rootedConfigXmlFile);
            return "Configuration updated.";
        }

        private void updateConfigFile(File configFile) throws ShellException {
            BootstrapParams bp = null;
            try {
                bp = ConfigUtils.getBootstrapParams(configFile);
            }
            catch (IllegalStateException ise) {
                throw new ShellException("Failed to load or parse " + configFile + ": " + ise.getMessage());
            }
            if (bp == null) {
                throw new ShellException("The file " + configFile + " does not contain a bootstrap configuration.");
            }
            String secDir = bp.getSecurityDir();
            if (secDir == null) {
                throw new ShellException("The file " + configFile + " does not currently have security configured.");
            }
            bp.setSecurityDir(null);
            ConfigUtils.createBootstrapConfig(bp, configFile);
        }

        @Override
        public String getCommandSyntax() {
            return "config remove-security -root <kvroot> [-config <config.xml>]";
        }

        @Override
        public String getCommandDescription() {
            return REMOVE_SECURITY_COMMAND_DESC;
        }
    }

    private static final class SecurityConfigAddSecurity
    extends CommandWithSubs.SubCommand {
        private static final String ADD_SECURITY_COMMAND_NAME = "add-security";
        private static final String ADD_SECURITY_COMMAND_DESC = "Updates a Storage Node configuration to incorporate a security configuartion.";

        private SecurityConfigAddSecurity() {
            super(ADD_SECURITY_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String kvRoot = null;
            String configXml = null;
            String secDir = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (SecurityConfigCommand.ROOT_FLAG.equals(arg)) {
                    kvRoot = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SecurityConfigCommand.SECURITY_DIR_FLAG.equals(arg)) {
                    secDir = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SecurityConfigCommand.CONFIG_FLAG.equals(arg)) {
                    configXml = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (kvRoot == null) {
                shell.requiredArg(SecurityConfigCommand.ROOT_FLAG, this);
            }
            return this.doAddSecurity(kvRoot, configXml, secDir);
        }

        private String doAddSecurity(String kvRoot, String configXml, String secDir) throws ShellException {
            if (configXml == null) {
                configXml = "config.xml";
            }
            if (secDir == null) {
                secDir = "security";
            }
            File kvRootFile = new File(kvRoot);
            File configXmlFile = new File(configXml);
            File secDirFile = new File(secDir);
            if (!kvRootFile.exists()) {
                throw new ShellException("The -root argument " + kvRootFile + " does not exist.");
            }
            if (!kvRootFile.isDirectory()) {
                throw new ShellException("The -root argument " + kvRootFile + " is not a directory.");
            }
            if (configXmlFile.isAbsolute()) {
                throw new ShellException("The -config argument must be a relative file name.");
            }
            File rootedConfigXmlFile = new File(kvRootFile, configXml);
            if (!rootedConfigXmlFile.exists()) {
                throw new ShellException("The file " + configXml + " does not exist in " + kvRoot);
            }
            if (!rootedConfigXmlFile.isFile()) {
                throw new ShellException(rootedConfigXmlFile.toString() + " is not a file.");
            }
            if (secDirFile.isAbsolute()) {
                throw new ShellException("The -secdir argument must be a relative file name.");
            }
            File rootedSecDirFile = new File(kvRootFile, secDir);
            if (!rootedSecDirFile.exists()) {
                throw new ShellException("The file " + secDir + " does not exist in " + kvRoot);
            }
            if (!rootedSecDirFile.isDirectory()) {
                throw new ShellException(rootedSecDirFile.toString() + " is not a directory.");
            }
            this.checkSecurityDirContents(rootedSecDirFile);
            this.updateConfigFile(rootedConfigXmlFile, secDirFile);
            return "Configuration updated.";
        }

        private void updateConfigFile(File configFile, File secDir) throws ShellException {
            BootstrapParams bp = null;
            try {
                bp = ConfigUtils.getBootstrapParams(configFile);
            }
            catch (IllegalStateException ise) {
                throw new ShellException("Failed to load or parse " + configFile + ": " + ise.getMessage());
            }
            if (bp == null) {
                throw new ShellException("The file " + configFile + " does not contain a bootstrap configuration.");
            }
            bp.setSecurityDir(secDir.getPath());
            try {
                this.checkSufficientPorts(bp);
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException("The configuration will not work in a secure  environment. Please adjust the configuration before  enabling security. (" + iae.getMessage() + ")");
            }
            ConfigUtils.createBootstrapConfig(bp, configFile);
        }

        private void checkSufficientPorts(BootstrapParams bp) {
            String servicePortRange = bp.getServicePortRange();
            if (servicePortRange != null && !servicePortRange.isEmpty()) {
                int adminHttpPort = bp.getAdminHttpPort();
                PortRange.validateSufficientPorts(servicePortRange, bp.getCapacity(), true, adminHttpPort != 0, bp.getMgmtPorts());
            }
        }

        private void checkSecurityDirContents(File secDirFile) throws ShellException {
            String[] checkedFileNames;
            for (String fileName : checkedFileNames = new String[]{"security.xml", "store.trust", "store.keys"}) {
                File checkedFile = new File(secDirFile, fileName);
                if (checkedFile.exists() && checkedFile.isFile()) continue;
                throw new ShellException("Security file not found in " + secDirFile.toString() + ": " + fileName);
            }
        }

        @Override
        public String getCommandSyntax() {
            return "config add-security -root <kvroot> [-secdir <security dir>] [-config <config.xml>]";
        }

        @Override
        public String getCommandDescription() {
            return ADD_SECURITY_COMMAND_DESC;
        }
    }

    private static final class SecurityConfigCreate
    extends CommandWithSubs.SubCommand {
        private static final String CREATE_COMMAND_NAME = "create";
        private static final String CREATE_COMMAND_DESC = "Creates a new security configuration.";

        private SecurityConfigCreate() {
            super(CREATE_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            SecurityConfigCreator.ParsedConfig config = new SecurityConfigCreator.ParsedConfig();
            String kvRoot = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (SecurityConfigCommand.PWDMGR_FLAG.equals(arg)) {
                    config.setPwdmgr(Shell.nextArg(args, i++, this));
                    continue;
                }
                if (SecurityConfigCommand.KEYSTORE_PASSWORD_FLAG.equals(arg)) {
                    config.setKeystorePassword(Shell.nextArg(args, i++, this).toCharArray());
                    continue;
                }
                if (SecurityConfigCommand.ROOT_FLAG.equals(arg)) {
                    kvRoot = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SecurityConfigCommand.SECURITY_DIR_FLAG.equals(arg)) {
                    config.setSecurityDir(Shell.nextArg(args, i++, this));
                    continue;
                }
                if (SecurityConfigCommand.CERT_MODE_FLAG.equals(arg)) {
                    config.setCertMode(Shell.nextArg(args, i++, this));
                    continue;
                }
                if (SecurityConfigCommand.PARAM_FLAG.equals(arg)) {
                    try {
                        config.addParam(Shell.nextArg(args, i++, this));
                    }
                    catch (IllegalArgumentException iae) {
                        shell.badArgUsage(arg, iae.getMessage(), this);
                    }
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (kvRoot == null) {
                shell.requiredArg(SecurityConfigCommand.ROOT_FLAG, this);
            }
            return this.doCreate(kvRoot, config, shell);
        }

        private String doCreate(String kvRoot, SecurityConfigCreator.ParsedConfig config, Shell shell) throws ShellException {
            SecurityConfigCreator creator = new SecurityConfigCreator(kvRoot, config, new SecurityConfigCreator.ShellIOHelper(shell));
            try {
                if (creator.createConfig()) {
                    return "Created";
                }
                return "Failed";
            }
            catch (PasswordStoreException pwse) {
                throw new ShellException("PasswordStore error: " + pwse.getMessage(), pwse);
            }
            catch (Exception e) {
                throw new ShellException("Unknown error: " + e.getMessage(), e);
            }
        }

        @Override
        public String getCommandSyntax() {
            return "config create -root <secroot> \n\t[-secdir <security dir>] [-pwdmgr {pwdfile | wallet | <class-name>}] \n\t[-kspwd <password>] [-param <param=value>]*";
        }

        @Override
        public String getCommandDescription() {
            return CREATE_COMMAND_DESC;
        }
    }

    static class ConfigParserHelper {
        private final CommandParser parser;
        private final SecurityConfigCreator.ParsedConfig config;

        public ConfigParserHelper(CommandParser parser) {
            this.parser = parser;
            this.config = new SecurityConfigCreator.ParsedConfig();
        }

        public boolean checkArg(String arg) {
            if (arg.equals(SecurityConfigCommand.PWDMGR_FLAG)) {
                this.config.setPwdmgr(this.parser.nextArg(arg));
                return true;
            }
            if (arg.equals(SecurityConfigCommand.KEYSTORE_PASSWORD_FLAG)) {
                this.config.setKeystorePassword(this.parser.nextArg(arg).toCharArray());
                return true;
            }
            if (arg.equals(SecurityConfigCommand.SECURITY_DIR_FLAG)) {
                this.config.setSecurityDir(this.parser.nextArg(arg));
                return true;
            }
            if (arg.equals(SecurityConfigCommand.CERT_MODE_FLAG)) {
                this.config.setCertMode(this.parser.nextArg(arg));
                return true;
            }
            if (arg.equals(SecurityConfigCommand.SECURITY_PARAM_FLAG)) {
                try {
                    this.config.addParam(this.parser.nextArg(arg));
                }
                catch (IllegalArgumentException iae) {
                    this.parser.usage("invalid argument usage for " + arg + " - " + iae.getMessage());
                }
                return true;
            }
            return false;
        }

        public SecurityConfigCreator.ParsedConfig getConfig() {
            return this.config;
        }

        public static String getConfigUsage() {
            return SecurityConfigCommand.BASIC_CREATE_COMMAND_ARGS;
        }
    }
}

