/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.UnknownMasterException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseUtils {
    private DatabaseUtils() {
    }

    public static boolean handleException(RuntimeException re, Logger logger, String dbName) {
        try {
            throw re;
        }
        catch (ReplicaWriteException rwe) {
            logger.log(Level.FINE, "Failed to open database for {0}. {1}", new Object[]{dbName, rwe.getMessage()});
            return true;
        }
        catch (UnknownMasterException ume) {
            logger.log(Level.FINE, "Failed to open database for {0}. {1}", new Object[]{dbName, ume.getMessage()});
            return true;
        }
        catch (InsufficientReplicasException ire) {
            logger.log(Level.FINE, "Insufficient replicas when creating database {0}. {1}", new Object[]{dbName, ire.getMessage()});
            return true;
        }
        catch (InsufficientAcksException iae) {
            logger.log(Level.FINE, "Insufficient acks when creating database {0}. {1}", new Object[]{dbName, iae.getMessage()});
            return false;
        }
        catch (IllegalStateException ise) {
            logger.log(Level.FINE, "Problem accessing database {0}. {1}", new Object[]{dbName, ise.getMessage()});
            return true;
        }
    }
}

