/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.FileNames;

public class ConfigUtils {
    public static final Character PROPERTY_SEPARATOR = Character.valueOf(';');
    public static final Character PROPERTY_NEWLINE = Character.valueOf('\n');
    private static final String SEC_POLICY_STRING = "grant {\n permission java.security.AllPermission;\n};\n";

    public static void createSecurityPolicyFile(File dest) {
        FileOutputStream output = null;
        try {
            dest.createNewFile();
            output = new FileOutputStream(dest);
            output.write(SEC_POLICY_STRING.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public static void createBootstrapConfig(BootstrapParams bp, String fileName) {
        ConfigUtils.createBootstrapConfig(bp, new File(fileName));
    }

    public static void createBootstrapConfig(BootstrapParams bp, File file) {
        LoadParameters lp = new LoadParameters();
        lp.addMap(bp.getMap());
        lp.addMap(bp.getMountMap());
        lp.setVersion(2);
        lp.saveParameters(file);
    }

    public static BootstrapParams getBootstrapParams(File configFile) {
        return ConfigUtils.getBootstrapParams(configFile, null);
    }

    public static BootstrapParams getBootstrapParams(File configFile, Logger logger) {
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        ParameterMap pm = null;
        ParameterMap mm = null;
        int bootstrapVersion = lp.getVersion();
        if (bootstrapVersion == 1) {
            pm = lp.getMap("bootstrapParams", "bootstrapParams");
        } else {
            pm = lp.getMap("params", "bootstrapParams");
            mm = lp.getMap("mountPoints", "bootstrapParams");
        }
        if (pm == null) {
            throw new IllegalStateException("Could not get bootstrap params from file: " + configFile);
        }
        BootstrapParams bp = new BootstrapParams(pm, mm);
        if (bp.getSoftwareVersion() == null) {
            KVVersion previousVersion = KVVersion.R2_0_23;
            bp.setSoftwareVersion(previousVersion);
            if (logger != null) {
                logger.log(Level.WARNING, "Software version missing from configuration file. Assuming installed software is at: {0}", previousVersion.getNumericVersionString());
            }
        }
        return bp;
    }

    public static void createSecurityConfig(SecurityParams sp, File file) {
        LoadParameters lp = new LoadParameters();
        lp.addMap(sp.getMap());
        for (ParameterMap transportMap : sp.getTransportMaps()) {
            lp.addMap(transportMap);
        }
        lp.setVersion(1);
        lp.saveParameters(file);
    }

    public static SecurityParams getSecurityParams(File configFile) {
        return ConfigUtils.getSecurityParams(configFile, null);
    }

    public static SecurityParams getSecurityParams(File configFile, Logger logger) {
        LoadParameters lp = LoadParameters.getParametersByType(configFile, logger);
        SecurityParams sp = new SecurityParams(lp, configFile);
        return sp;
    }

    public static GlobalParams getGlobalParams(File configFile) {
        return ConfigUtils.getGlobalParams(configFile, null);
    }

    public static GlobalParams getGlobalParams(File configFile, Logger logger) {
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        ParameterMap pm = lp.getMap("globalParams");
        if (pm != null) {
            return new GlobalParams(pm);
        }
        throw new IllegalStateException("Could not get GlobalParams from file: " + configFile);
    }

    public static StorageNodeParams getStorageNodeParams(File configFile) {
        return ConfigUtils.getStorageNodeParams(configFile, null);
    }

    public static StorageNodeParams getStorageNodeParams(File configFile, Logger logger) {
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        ParameterMap pm = lp.getMap("storageNodeParams");
        ParameterMap mm = lp.getMap("mountPoints", "bootstrapParams");
        if (pm != null) {
            return new StorageNodeParams(pm, mm);
        }
        throw new IllegalStateException("Could not get StorageNodeParams from file: " + configFile);
    }

    public static AdminParams getAdminParams(File configFile) {
        return ConfigUtils.getAdminParams(configFile, null);
    }

    public static AdminParams getAdminParams(File configFile, Logger logger) {
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        ParameterMap pm = lp.getMapByType("adminParams");
        if (pm != null) {
            return new AdminParams(pm);
        }
        return null;
    }

    public static AdminParams getAdminParams(File configFile, AdminId adminId, boolean tryByType) {
        return ConfigUtils.getAdminParams(configFile, adminId, tryByType, null);
    }

    public static AdminParams getAdminParams(File configFile, AdminId adminId, boolean tryByType, Logger logger) {
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        ParameterMap pm = lp.getMap(adminId.getFullName(), "adminParams");
        if (pm == null && tryByType) {
            pm = lp.getMapByType("adminParams");
        }
        if (pm != null) {
            return new AdminParams(pm);
        }
        return null;
    }

    public static RepNodeParams getRepNodeParams(File configFile, RepNodeId rnid, Logger logger) {
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        ParameterMap pm = lp.getMap(rnid.getFullName(), "repNodeParams");
        if (pm != null) {
            return new RepNodeParams(pm);
        }
        return null;
    }

    public static List<ParameterMap> getRepNodes(File configFile, Logger logger) {
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        return lp.getAllMaps("repNodeParams");
    }

    public static ParameterMap removeComponent(File configFile, ResourceId rid, String type, Logger logger) {
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        ParameterMap map = lp.removeMap(rid.getFullName());
        if (map == null && type != null) {
            map = lp.removeMapByType(type);
        }
        if (map != null) {
            lp.saveParameters(configFile);
        }
        return map;
    }

    public static ParameterMap getAdminMap(AdminId adminId, StorageNodeParams snp, GlobalParams gp, Logger logger) {
        ParameterMap map = ConfigUtils.getParameterMap(snp, gp, adminId.getFullName(), logger);
        if (map == null) {
            map = ConfigUtils.getParameterMapByType(snp, gp, "adminParams", logger);
        }
        return map;
    }

    public static ParameterMap getRepNodeMap(StorageNodeParams snp, GlobalParams gp, RepNodeId rnid, Logger logger) {
        return ConfigUtils.getParameterMap(snp, gp, rnid.getFullName(), logger);
    }

    public static ParameterMap getGlobalMap(StorageNodeParams snp, GlobalParams gp, Logger logger) {
        return ConfigUtils.getParameterMapByType(snp, gp, "globalParams", logger);
    }

    private static ParameterMap getParameterMap(StorageNodeParams snp, GlobalParams gp, String service, Logger logger) {
        File configFile = FileNames.getSNAConfigFile(snp.getRootDirPath(), gp.getKVStoreName(), snp.getStorageNodeId());
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        return lp.getMap(service);
    }

    private static ParameterMap getParameterMapByType(StorageNodeParams snp, GlobalParams gp, String type, Logger logger) {
        File configFile = FileNames.getSNAConfigFile(snp.getRootDirPath(), gp.getKVStoreName(), snp.getStorageNodeId());
        LoadParameters lp = LoadParameters.getParameters(configFile, logger);
        return lp.getMapByType(type);
    }

    public static InputStream getPropertiesStream(String properties) {
        String newProps = properties.replace(PROPERTY_SEPARATOR.charValue(), PROPERTY_NEWLINE.charValue());
        return new ByteArrayInputStream(newProps.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(Properties props, String comment, File dest) throws IOException {
        FileOutputStream output = null;
        try {
            dest.createNewFile();
            output = new FileOutputStream(dest);
            props.store(output, comment);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

