/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;

@Persistent
abstract class ComponentMap<RID extends ResourceId, COMP extends Topology.Component<RID>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Topology topology;
    private int idSequence = 0;
    protected HashMap<RID, COMP> cmap;

    public ComponentMap(Topology topology) {
        this.topology = topology;
        this.cmap = new HashMap();
    }

    protected ComponentMap() {
    }

    public void setTopology(Topology topology) {
        this.topology = topology;
    }

    public int nextSequence() {
        return ++this.idSequence;
    }

    public COMP get(RID resourceId) {
        return (COMP)((Topology.Component)this.cmap.get(resourceId));
    }

    public COMP put(COMP component) {
        return (COMP)((Topology.Component)this.cmap.put(((Topology.Component)component).getResourceId(), component));
    }

    public void reset() {
        this.idSequence = 0;
        this.cmap.clear();
    }

    abstract RID nextId();

    abstract ResourceId.ResourceType getResourceType();

    COMP add(COMP component) {
        return this.add(component, this.nextId());
    }

    COMP add(COMP component, RID resId) {
        if (((Topology.Component)component).getTopology() != null) {
            throw new IllegalArgumentException("component is already a part of a Topology");
        }
        ((Topology.Component)component).setTopology(this.topology);
        ((Topology.Component)component).setResourceId(resId);
        COMP prev = this.put(component);
        this.topology.getChangeTracker().logAdd((Topology.Component<?>)component);
        if (prev != null) {
            throw new IllegalStateException(prev + " was overwritten in topology by " + component);
        }
        return component;
    }

    COMP update(RID resourceId, COMP component) {
        if (((Topology.Component)component).getTopology() != null || ((Topology.Component)component).getResourceId() != null) {
            throw new IllegalArgumentException("component is already a part of a Topology");
        }
        Topology.Component<Object> prev = this.topology.get((ResourceId)resourceId);
        if (prev == null) {
            throw new IllegalArgumentException("component: " + resourceId + " absent from Topology");
        }
        prev.setTopology(null);
        ((Topology.Component)component).setTopology(this.topology);
        ((Topology.Component)component).setResourceId(resourceId);
        prev = this.put(component);
        assert (prev != null);
        this.topology.getChangeTracker().logUpdate((Topology.Component<?>)component);
        return component;
    }

    public COMP remove(RID resourceId) {
        Topology.Component component = (Topology.Component)this.cmap.remove(resourceId);
        if (component == null) {
            throw new IllegalArgumentException("component: " + resourceId + " absent from Topology");
        }
        component.setTopology(null);
        this.topology.getChangeTracker().logRemove((ResourceId)resourceId);
        return (COMP)component;
    }

    public int size() {
        return this.cmap.size();
    }

    public Collection<COMP> getAll() {
        return this.cmap.values();
    }

    public Collection<RID> getAllIds() {
        return this.cmap.keySet();
    }

    public void apply(TopologyChange change) {
        ResourceId resourceId = change.getResourceId();
        if (change.getType() == TopologyChange.Type.REMOVE) {
            Topology.Component prev = (Topology.Component)this.cmap.remove(resourceId);
            if (prev == null) {
                throw new IllegalStateException("Delete operation detected missing component: " + resourceId);
            }
            this.topology.getChangeTracker().logRemove(resourceId);
            return;
        }
        Topology.Component<?> prev = this.topology.get(resourceId);
        Topology.Component<?> curr = change.getComponent();
        curr.setTopology(this.topology);
        int logSeqNumber = curr.getSequenceNumber();
        prev = this.put(curr);
        switch (change.getType()) {
            case ADD: {
                RID consumeId = this.nextId();
                if (!((ResourceId)consumeId).equals(resourceId)) {
                    throw new IllegalStateException("resource sequence out of sync; expected: " + consumeId + " replayId: " + resourceId);
                }
                if (prev != null) {
                    throw new IllegalStateException("ADD operation found existing component: " + resourceId);
                }
                this.topology.getChangeTracker().logAdd(curr);
                break;
            }
            case UPDATE: {
                if (prev == null) {
                    throw new IllegalStateException("UPDATE operation detected missing component" + resourceId);
                }
                prev.setTopology(null);
                this.topology.getChangeTracker().logUpdate(curr);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected type: " + (Object)((Object)change.getType()));
            }
        }
        if (curr.getSequenceNumber() != logSeqNumber) {
            throw new IllegalStateException("change sequence mismatch; log #: " + logSeqNumber + " replay #: " + curr.getSequenceNumber());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cmap == null ? 0 : this.cmap.hashCode());
        result = 31 * result + this.idSequence;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentMap other = (ComponentMap)obj;
        if (this.cmap == null ? other.cmap != null : !this.cmap.equals(other.cmap)) {
            return false;
        }
        return this.idSequence == other.idSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArrayForSignature() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.write(this.idSequence);
            if (this.cmap != null && !this.cmap.isEmpty()) {
                TreeMap<RID, COMP> sortedCmap = new TreeMap<RID, COMP>(this.cmap);
                for (Topology.Component comp : sortedCmap.values()) {
                    oos.writeObject(comp.cloneForLog());
                }
            }
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }
}

