/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna.masterBalance;

import java.util.logging.Logger;
import oracle.kv.impl.sna.masterBalance.LeaseManager;
import oracle.kv.impl.sna.masterBalance.MasterBalancingInterface;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;

public class MasterLeaseManager
extends LeaseManager {
    MasterLeaseManager(Logger logger) {
        super(logger);
    }

    synchronized boolean getMasterLease(MasterBalancingInterface.MasterLeaseInfo masterLease) {
        RepNodeId rnId = (RepNodeId)masterLease.rn.getResourceId();
        LeaseManager.LeaseTask leaseTask = (LeaseManager.LeaseTask)this.leaseTasks.get(rnId);
        if (leaseTask != null) {
            MasterBalancingInterface.MasterLeaseInfo masterLeaseInfo = (MasterBalancingInterface.MasterLeaseInfo)leaseTask.getLease();
            if (!masterLeaseInfo.lesseeSN.equals(masterLease.lesseeSN)) {
                this.logger.info("Rejected master lease request: " + masterLease + " Lease exists:" + leaseTask.getLease());
                return false;
            }
            this.logger.info("Extending master lease:" + masterLease);
            leaseTask.cancel();
            leaseTask = null;
        }
        leaseTask = new LeaseManager.LeaseTask(masterLease);
        this.logger.info("Established master lease:" + masterLease);
        return true;
    }

    synchronized boolean cancel(StorageNode lesseeSN, RepNode rn) {
        LeaseManager.LeaseTask leaseTask = (LeaseManager.LeaseTask)this.leaseTasks.get(rn.getResourceId());
        if (leaseTask == null || !((MasterBalancingInterface.MasterLeaseInfo)leaseTask.getLease()).lesseeSN.equals(lesseeSN)) {
            return false;
        }
        leaseTask.cancel();
        return true;
    }
}

