/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.io.File;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.KVStorePrivilegeLabel;
import oracle.kv.impl.security.annotations.PublicMethod;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.annotations.SecureR2Method;
import oracle.kv.impl.sna.ManagedService;
import oracle.kv.impl.sna.SNAFaultHandler;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.sna.StorageNodeAgentInterface;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.sna.masterBalance.MasterBalancingInterface;
import oracle.kv.impl.test.RemoteTestInterface;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;
import oracle.kv.impl.util.server.LoggerUtils;

@SecureAPI
public final class StorageNodeAgentImpl
extends VersionedRemoteImpl
implements StorageNodeAgentInterface {
    private final StorageNodeAgent sna;
    private final SNAFaultHandler faultHandler;
    private RemoteTestInterface rti;
    private static final String TEST_INTERFACE_NAME = "oracle.kv.impl.sna.StorageNodeAgentTestInterface";

    public StorageNodeAgentImpl() {
        this(true);
    }

    public StorageNodeAgentImpl(boolean createBootstrapAdmin) {
        this.sna = new StorageNodeAgent(this, createBootstrapAdmin);
        this.faultHandler = new SNAFaultHandler(this);
        this.rti = null;
    }

    public StorageNodeAgent getStorageNodeAgent() {
        return this.sna;
    }

    public SNAFaultHandler getFaultHandler() {
        return this.faultHandler;
    }

    public Logger getLogger() {
        return this.sna.getLogger();
    }

    public StorageNodeAgent.SNAParserResults parseArgs(String[] args) {
        return this.sna.parseArgs(args);
    }

    public void start() throws RemoteException {
        this.sna.start();
    }

    public void addShutdownHook() {
        this.sna.addShutdownHook();
    }

    public boolean isRegistered() {
        return this.sna.isRegistered();
    }

    public String getStoreName() {
        return this.sna.getStoreName();
    }

    public int getRegistryPort() {
        return this.sna.getRegistryPort();
    }

    public void startTestInterface() {
        try {
            Class<?> cl = Class.forName(TEST_INTERFACE_NAME);
            Constructor<?> c = cl.getConstructor(this.getClass());
            this.rti = (RemoteTestInterface)c.newInstance(this);
            this.rti.start((short)7);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopTestInterface() throws RemoteException {
        if (this.rti != null) {
            this.rti.stop((short)7);
        }
    }

    private void checkRegistered(String method) {
        this.sna.checkRegistered(method);
    }

    private void logInfo(String msg) {
        this.sna.getLogger().info(msg);
    }

    private void logFine(String msg) {
        this.sna.getLogger().fine(msg);
    }

    @Override
    @PublicMethod
    public StorageNodeStatus ping(short serialVersion) {
        return this.ping(null, serialVersion);
    }

    @Override
    @PublicMethod
    public StorageNodeStatus ping(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<StorageNodeStatus>(){

            @Override
            public StorageNodeStatus execute() {
                return StorageNodeAgentImpl.this.sna.getStatus();
            }
        });
    }

    @Override
    @SecureR2Method
    public List<ParameterMap> register(ParameterMap gpMap, ParameterMap snpMap, boolean hostingAdmin, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized List<ParameterMap> register(final ParameterMap gpMap, final ParameterMap snpMap, final boolean hostingAdmin, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<List<ParameterMap>, RemoteException>(){

            @Override
            public List<ParameterMap> execute() throws RemoteException {
                GlobalParams gp = new GlobalParams(gpMap);
                StorageNodeParams snp = new StorageNodeParams(snpMap);
                return StorageNodeAgentImpl.this.sna.register(gp, snp, hostingAdmin);
            }
        });
    }

    @Override
    @SecureR2Method
    public void shutdown(boolean stopServices, boolean force, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void shutdown(final boolean stopServices, final boolean force, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.sna.shutdown(stopServices, force);
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean createAdmin(ParameterMap adminParams, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean createAdmin(final ParameterMap adminParams, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                return StorageNodeAgentImpl.this.sna.createAdmin(new AdminParams(adminParams));
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean startAdmin(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean startAdmin(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("startAdmin");
                StorageNodeAgentImpl.this.logInfo("startAdmin called");
                AdminParams ap = ConfigUtils.getAdminParams(StorageNodeAgentImpl.this.sna.getKvConfigFile());
                if (ap == null) {
                    String msg = "Attempt to start an Admin when none is configured";
                    StorageNodeAgentImpl.this.logInfo(msg);
                    throw new IllegalStateException(msg);
                }
                return StorageNodeAgentImpl.this.sna.startAdmin(ap);
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean stopAdmin(boolean force, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean stopAdmin(final boolean force, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("stopAdmin");
                return StorageNodeAgentImpl.this.sna.stopAdmin(null, force);
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean destroyAdmin(AdminId adminId, boolean deleteData, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean destroyAdmin(final AdminId adminId, final boolean deleteData, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("destroyAdmin");
                return StorageNodeAgentImpl.this.sna.destroyAdmin(adminId, deleteData);
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean repNodeExists(RepNodeId repNodeId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean repNodeExists(final RepNodeId repNodeId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("repNodeExists");
                if (StorageNodeAgentImpl.this.sna.lookupRepNode(repNodeId) != null) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean createRepNode(final ParameterMap params, final Set<Metadata<? extends MetadataInfo>> metadataSet, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("createRepNode");
                RepNodeParams repNodeParams = new RepNodeParams(params);
                return StorageNodeAgentImpl.this.sna.createRepNode(repNodeParams, metadataSet);
            }
        });
    }

    @Override
    @Deprecated
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean createRepNode(ParameterMap repNodeParams, Topology topology, AuthContext authCtx, short serialVersion) throws RemoteException {
        HashSet<Metadata<? extends MetadataInfo>> metadataSet = new HashSet<Metadata<? extends MetadataInfo>>(1);
        metadataSet.add(topology);
        return this.createRepNode(repNodeParams, metadataSet, authCtx, serialVersion);
    }

    @Override
    @Deprecated
    @SecureR2Method
    public boolean createRepNode(ParameterMap params, Topology topology, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureR2Method
    public boolean startRepNode(RepNodeId repNodeId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean startRepNode(final RepNodeId repNodeId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("startRepNode");
                return StorageNodeAgentImpl.this.sna.startRepNode(repNodeId);
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean stopRepNode(RepNodeId rnid, boolean force, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean stopRepNode(final RepNodeId rnid, final boolean force, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("stopRepNode");
                return StorageNodeAgentImpl.this.sna.stopRepNode(rnid, force);
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean destroyRepNode(RepNodeId rnid, boolean deleteData, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized boolean destroyRepNode(final RepNodeId rnid, final boolean deleteData, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("destroyRepNode");
                String serviceName = rnid.getFullName();
                StorageNodeAgentImpl.this.logInfo(serviceName + ": destroyRepNode called");
                boolean retval = true;
                try {
                    StorageNodeAgentImpl.this.sna.stopRepNode(rnid, true);
                }
                finally {
                    retval = StorageNodeAgentImpl.this.sna.removeConfigurable(rnid, null, deleteData);
                }
                return retval;
            }
        });
    }

    @Override
    @SecureR2Method
    public void newRepNodeParameters(ParameterMap params, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void newRepNodeParameters(final ParameterMap params, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("newRepNodeParameters");
                RepNodeParams repNodeParams = new RepNodeParams(params);
                String serviceName = repNodeParams.getRepNodeId().getFullName();
                StorageNodeAgentImpl.this.logInfo(serviceName + ": newRepNodeParameters called");
                StorageNodeAgentImpl.this.sna.replaceRepNodeParams(repNodeParams);
            }
        });
    }

    @Override
    @SecureR2Method
    public void newAdminParameters(ParameterMap params, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void newAdminParameters(final ParameterMap params, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("newAdminParameters");
                AdminId adminId = new AdminParams(params).getAdminId();
                StorageNodeAgentImpl.this.logInfo(adminId.getFullName() + ": newAdminParameters called");
                StorageNodeAgentImpl.this.sna.replaceAdminParams(adminId, params);
            }
        });
    }

    @Override
    @SecureR2Method
    public void newStorageNodeParameters(ParameterMap params, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void newStorageNodeParameters(final ParameterMap params, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("newStorageNodeParameters");
                StorageNodeAgentImpl.this.logInfo("newStorageNodeParameters called");
                StorageNodeAgentImpl.this.sna.newParams(params);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void newGlobalParameters(final ParameterMap params, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("newGlobalParameters");
                GlobalParams globalParams = new GlobalParams(params);
                StorageNodeAgentImpl.this.logInfo("newGlobalParameters called");
                StorageNodeAgentImpl.this.sna.replaceGlobalParams(globalParams);
            }
        });
    }

    @Override
    @SecureR2Method
    public void createSnapshot(RepNodeId rnid, String name, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void createSnapshot(final RepNodeId rnid, final String name, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("snapshot RepNode");
                StorageNodeAgentImpl.this.logInfo("createSnapshot called for " + rnid + ", snapshot name: " + name);
                StorageNodeAgentImpl.this.sna.snapshotRepNode(rnid, name);
            }
        });
    }

    @Override
    @SecureR2Method
    public void removeSnapshot(RepNodeId rnid, String name, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void removeSnapshot(final RepNodeId rnid, final String name, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("removeSnapshot");
                StorageNodeAgentImpl.this.logInfo("removeSnapshot called, name is " + name);
                StorageNodeAgentImpl.this.sna.removeSnapshot(rnid, name);
            }
        });
    }

    @Override
    @SecureR2Method
    public void removeAllSnapshots(RepNodeId rnid, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void removeAllSnapshots(final RepNodeId rnid, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("removeAllSnapshots");
                StorageNodeAgentImpl.this.logInfo("removeAllSnapshots called");
                StorageNodeAgentImpl.this.sna.removeSnapshot(rnid, null);
            }
        });
    }

    @Override
    @SecureR2Method
    public void createSnapshot(AdminId aid, String name, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void createSnapshot(final AdminId aid, final String name, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("snapshot Admin");
                StorageNodeAgentImpl.this.logInfo("createSnapshot called for " + aid + ", snapshot name: " + name);
                StorageNodeAgentImpl.this.sna.snapshotAdmin(aid, name);
            }
        });
    }

    @Override
    @SecureR2Method
    public void removeSnapshot(AdminId aid, String name, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void removeSnapshot(final AdminId aid, final String name, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("removeSnapshot");
                StorageNodeAgentImpl.this.logInfo("removeSnapshot called, name is " + name);
                StorageNodeAgentImpl.this.sna.removeSnapshot(aid, name);
            }
        });
    }

    @Override
    @SecureR2Method
    public void removeAllSnapshots(AdminId aid, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public synchronized void removeAllSnapshots(final AdminId aid, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("removeAllSnapshots");
                StorageNodeAgentImpl.this.logInfo("removeAllSnapshots called");
                StorageNodeAgentImpl.this.sna.removeSnapshot(aid, null);
            }
        });
    }

    @Override
    @SecureR2Method
    public String[] listSnapshots(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public String[] listSnapshots(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<String[], RemoteException>(){

            @Override
            public String[] execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("listSnapshots");
                StorageNodeAgentImpl.this.logInfo("listSnapshots called");
                return StorageNodeAgentImpl.this.sna.listSnapshots();
            }
        });
    }

    @Override
    @SecureR2Method
    public LoadParameters getParams(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public LoadParameters getParams(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<LoadParameters>(){

            @Override
            public LoadParameters execute() {
                return StorageNodeAgentImpl.this.sna.getParams();
            }
        });
    }

    @Override
    @SecureR2Method
    public StringBuilder getStartupBuffer(ResourceId rid, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public StringBuilder getStartupBuffer(final ResourceId rid, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<StringBuilder>(){

            @Override
            public StringBuilder execute() {
                StorageNodeAgentImpl.this.checkRegistered("getStartupBuffer");
                return StorageNodeAgentImpl.this.sna.getStartupBuffer(rid);
            }
        });
    }

    public static void main(String[] args) {
        try {
            new Main().doMain(args);
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    @Override
    @SecureR2Method
    public void noteState(MasterBalancingInterface.StateInfo stateInfo, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void noteState(final MasterBalancingInterface.StateInfo stateInfo, final AuthContext authCtx, final short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("noteState");
                StorageNodeAgentImpl.this.logInfo("noteState called");
                StorageNodeAgentImpl.this.sna.getMasterBalanceManager().noteState(stateInfo, authCtx, serialVersion);
            }
        });
    }

    @Override
    @SecureR2Method
    public MasterBalancingInterface.MDInfo getMDInfo(short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public MasterBalancingInterface.MDInfo getMDInfo(final AuthContext authCtx, final short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<MasterBalancingInterface.MDInfo, RemoteException>(){

            @Override
            public MasterBalancingInterface.MDInfo execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("getMD");
                StorageNodeAgentImpl.this.logFine("getMD called");
                return StorageNodeAgentImpl.this.sna.getMasterBalanceManager().getMDInfo(authCtx, serialVersion);
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean getMasterLease(MasterBalancingInterface.MasterLeaseInfo masterLease, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean getMasterLease(final MasterBalancingInterface.MasterLeaseInfo masterLease, final AuthContext authCtx, final short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("lease");
                StorageNodeAgentImpl.this.logFine("Master lease called");
                return StorageNodeAgentImpl.this.sna.getMasterBalanceManager().getMasterLease(masterLease, authCtx, serialVersion);
            }
        });
    }

    @Override
    @SecureR2Method
    public boolean cancelMasterLease(StorageNode lesseeSN, RepNode rn, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean cancelMasterLease(final StorageNode lesseeSN, final RepNode rn, final AuthContext authCtx, final short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() throws RemoteException {
                StorageNodeAgentImpl.this.checkRegistered("cancelLease");
                StorageNodeAgentImpl.this.logFine("cancelLease called");
                return StorageNodeAgentImpl.this.sna.getMasterBalanceManager().cancelMasterLease(lesseeSN, rn, authCtx, serialVersion);
            }
        });
    }

    @Override
    @SecureR2Method
    public void overloadedNeighbor(StorageNodeId storageNodeId, short serialVersion) throws RemoteException {
        throw this.invalidR2MethodException();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void overloadedNeighbor(final StorageNodeId storageNodeId, final AuthContext authCtx, final short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                StorageNodeAgentImpl.this.sna.getMasterBalanceManager().overloadedNeighbor(storageNodeId, authCtx, serialVersion);
            }
        });
    }

    static class Main {
        private final StorageNodeAgentImpl snai = new StorageNodeAgentImpl();
        private final StorageNodeAgent sna = this.snai.getStorageNodeAgent();

        Main() {
        }

        void doMain(String ... args) {
            String command = "start SNA";
            try {
                StorageNodeAgent.SNAParserResults parsedArgs = this.sna.parseArgs(args);
                File configPath = new File(this.sna.getBootstrapDir(), this.sna.getBootstrapFile());
                if (parsedArgs.shutdown) {
                    command = "stop SNA";
                    if (!configPath.exists()) {
                        throw new IllegalStateException("Bootstrap config file " + configPath + " does not exist");
                    }
                    this.printlnVerbose("Stopping SNA based on " + configPath);
                    try {
                        this.sna.stopRunningAgent();
                    }
                    catch (RuntimeException e) {
                        this.printlnVerbose(e.getMessage());
                        this.printlnVerbose("Attempting to stop all SNAs in root directory " + this.sna.getBootstrapDir());
                        String rootPath = "-root " + this.sna.getBootstrapDir();
                        ManagedService.killManagedProcesses("StorageNodeAgentImpl", rootPath, null, this.sna.getLogger());
                        ManagedService.killManagedProcesses(rootPath, null, this.sna.getLogger());
                    }
                } else if (parsedArgs.disableServices) {
                    command = "disable services on SNA";
                    this.printlnVerbose("Disabling services");
                    this.sna.disableServices();
                } else {
                    this.sna.addShutdownHook();
                    this.printlnVerbose("Starting SNA based on " + configPath);
                    this.sna.start();
                }
            }
            catch (Throwable e) {
                String message = "Failed to " + command + ": " + e.getMessage();
                if (this.sna.getLogger() != null) {
                    this.sna.getLogger().severe(message + "\n" + LoggerUtils.getStackTrace(e));
                }
                throw new RuntimeException(message, e);
            }
        }

        void printlnVerbose(String message) {
            if (this.sna.verbose()) {
                System.err.println(message);
            }
        }
    }
}

