/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ContextProxy;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.sna.StorageNodeAgentInterface;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.sna.masterBalance.MasterBalancingInterface;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RemoteAPI;

public final class StorageNodeAgentAPI
extends RemoteAPI {
    private static final AuthContext NULL_CTX = null;
    private final StorageNodeAgentInterface proxyRemote;

    private StorageNodeAgentAPI(StorageNodeAgentInterface remote, LoginHandle loginHdl) throws RemoteException {
        super(remote);
        this.proxyRemote = ContextProxy.create(remote, loginHdl, this.getSerialVersion());
    }

    public static StorageNodeAgentAPI wrap(StorageNodeAgentInterface remote, LoginHandle loginHdl) throws RemoteException {
        return new StorageNodeAgentAPI(remote, loginHdl);
    }

    public StorageNodeStatus ping() throws RemoteException {
        return this.proxyRemote.ping(NULL_CTX, this.getSerialVersion());
    }

    public List<ParameterMap> register(ParameterMap globalParams, ParameterMap storageNodeParams, boolean hostingAdmin) throws RemoteException {
        this.changedInR2("register");
        return this.proxyRemote.register(globalParams, storageNodeParams, hostingAdmin, NULL_CTX, this.getSerialVersion());
    }

    public void shutdown(boolean stopServices, boolean force) throws RemoteException {
        this.proxyRemote.shutdown(stopServices, force, NULL_CTX, this.getSerialVersion());
    }

    public boolean createAdmin(ParameterMap adminParams) throws RemoteException {
        return this.proxyRemote.createAdmin(adminParams, NULL_CTX, this.getSerialVersion());
    }

    public boolean startAdmin() throws RemoteException {
        return this.proxyRemote.startAdmin(NULL_CTX, this.getSerialVersion());
    }

    public boolean stopAdmin(boolean force) throws RemoteException {
        return this.proxyRemote.stopAdmin(force, NULL_CTX, this.getSerialVersion());
    }

    public boolean destroyAdmin(AdminId adminId, boolean deleteData) throws RemoteException {
        this.changedInR2("destroyAdmin");
        return this.proxyRemote.destroyAdmin(adminId, deleteData, NULL_CTX, this.getSerialVersion());
    }

    public boolean repNodeExists(RepNodeId repNodeId) throws RemoteException {
        return this.proxyRemote.repNodeExists(repNodeId, NULL_CTX, this.getSerialVersion());
    }

    public boolean createRepNode(ParameterMap repNodeParams, Set<Metadata<? extends MetadataInfo>> metadataSet) throws RemoteException {
        return this.proxyRemote.createRepNode(repNodeParams, metadataSet, NULL_CTX, this.getSerialVersion());
    }

    public boolean startRepNode(RepNodeId repNodeId) throws RemoteException {
        return this.proxyRemote.startRepNode(repNodeId, NULL_CTX, this.getSerialVersion());
    }

    public boolean stopRepNode(RepNodeId repNodeId, boolean force) throws RemoteException {
        return this.proxyRemote.stopRepNode(repNodeId, force, NULL_CTX, this.getSerialVersion());
    }

    public boolean destroyRepNode(RepNodeId repNodeId, boolean deleteData) throws RemoteException {
        this.changedInR2("destroyRepNode");
        return this.proxyRemote.destroyRepNode(repNodeId, deleteData, NULL_CTX, this.getSerialVersion());
    }

    public void newRepNodeParameters(ParameterMap repNodeParams) throws RemoteException {
        this.proxyRemote.newRepNodeParameters(repNodeParams, NULL_CTX, this.getSerialVersion());
    }

    public void newAdminParameters(ParameterMap adminParams) throws RemoteException {
        this.proxyRemote.newAdminParameters(adminParams, NULL_CTX, this.getSerialVersion());
    }

    public void newStorageNodeParameters(ParameterMap params) throws RemoteException {
        this.proxyRemote.newStorageNodeParameters(params, NULL_CTX, this.getSerialVersion());
    }

    public void newGlobalParameters(ParameterMap params) throws RemoteException {
        this.proxyRemote.newGlobalParameters(params, NULL_CTX, this.getSerialVersion());
    }

    public LoadParameters getParams() throws RemoteException {
        return this.proxyRemote.getParams(NULL_CTX, this.getSerialVersion());
    }

    public StringBuilder getStartupBuffer(ResourceId rid) throws RemoteException {
        return this.proxyRemote.getStartupBuffer(rid, NULL_CTX, this.getSerialVersion());
    }

    public void createSnapshot(RepNodeId rnid, String name) throws RemoteException {
        this.proxyRemote.createSnapshot(rnid, name, NULL_CTX, this.getSerialVersion());
    }

    public void createSnapshot(AdminId aid, String name) throws RemoteException {
        this.proxyRemote.createSnapshot(aid, name, NULL_CTX, this.getSerialVersion());
    }

    public void removeSnapshot(RepNodeId rnid, String name) throws RemoteException {
        this.proxyRemote.removeSnapshot(rnid, name, NULL_CTX, this.getSerialVersion());
    }

    public void removeSnapshot(AdminId aid, String name) throws RemoteException {
        this.proxyRemote.removeSnapshot(aid, name, NULL_CTX, this.getSerialVersion());
    }

    public void removeAllSnapshots(RepNodeId rnid) throws RemoteException {
        this.proxyRemote.removeAllSnapshots(rnid, NULL_CTX, this.getSerialVersion());
    }

    public void removeAllSnapshots(AdminId aid) throws RemoteException {
        this.proxyRemote.removeAllSnapshots(aid, NULL_CTX, this.getSerialVersion());
    }

    public String[] listSnapshots() throws RemoteException {
        return this.proxyRemote.listSnapshots(NULL_CTX, this.getSerialVersion());
    }

    public void noteState(MasterBalancingInterface.StateInfo stateInfo) throws RemoteException {
        this.proxyRemote.noteState(stateInfo, NULL_CTX, this.getSerialVersion());
    }

    public MasterBalancingInterface.MDInfo getMDInfo() throws RemoteException {
        return this.proxyRemote.getMDInfo(NULL_CTX, this.getSerialVersion());
    }

    public boolean getMasterLease(MasterBalancingInterface.MasterLeaseInfo masterLease) throws RemoteException {
        return this.proxyRemote.getMasterLease(masterLease, NULL_CTX, this.getSerialVersion());
    }

    public boolean cancelMasterLease(StorageNode lesseeSN, RepNode rn) throws RemoteException {
        return this.proxyRemote.cancelMasterLease(lesseeSN, rn, NULL_CTX, this.getSerialVersion());
    }

    public void overloadedNeighbor(StorageNodeId storageNodeId) throws RemoteException {
        this.proxyRemote.overloadedNeighbor(storageNodeId, NULL_CTX, this.getSerialVersion());
    }

    private void changedInR2(String m) {
        if (this.getSerialVersion() < 2) {
            throw new UnsupportedOperationException("There was an attempt to invoke " + m + " on a StorageNode " + "that is running an earlier, incompatible release.  Please " + "upgrade all components of the store before attempting " + "to change the store's configuration.");
        }
    }
}

