/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import oracle.kv.impl.security.util.Cache;
import oracle.kv.impl.security.util.CacheBuilder;

public class LruCacheImpl<K, V extends CacheBuilder.CacheEntry>
implements Cache<K, V> {
    private static final float LOAD_FACTOR = 0.6f;
    private static final int EVICT_PERIOD_FACTOR = 10;
    private final int capacity;
    private volatile long entryLifetime;
    private final LinkedHashMap<K, V> cacheMap;
    private CacheBuilder.TimeBasedCleanupTask cleanupTask;
    private final ReentrantLock lock = new ReentrantLock();

    LruCacheImpl(CacheBuilder.CacheConfig config) {
        this.capacity = config.getCapacity();
        this.entryLifetime = config.getEntryLifetime();
        this.cacheMap = this.capacity > 0 ? new LinkedHashMap<K, V>(this.capacity, 0.6f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > LruCacheImpl.this.capacity;
            }
        } : new LinkedHashMap();
        if (config.isEvictionEnabled() && this.entryLifetime > 0L) {
            long evictionPeriodMs = this.entryLifetime * 10L;
            this.cleanupTask = new CacheBuilder.TimeBasedCleanupTask(evictionPeriodMs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                void cleanup() {
                    if (!LruCacheImpl.this.lock.tryLock()) {
                        return;
                    }
                    try {
                        Iterator iter = LruCacheImpl.this.cacheMap.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            if (!LruCacheImpl.this.isEntryExpire((CacheBuilder.CacheEntry)entry.getValue())) continue;
                            iter.remove();
                        }
                    }
                    finally {
                        LruCacheImpl.this.lock.unlock();
                    }
                }
            };
        }
    }

    private boolean isEntryExpire(V value) {
        long now = System.currentTimeMillis();
        return this.entryLifetime > 0L && now > ((CacheBuilder.CacheEntry)value).getCreateTime() + this.entryLifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        CacheBuilder.CacheEntry value = null;
        this.lock.lock();
        try {
            value = (CacheBuilder.CacheEntry)this.cacheMap.get(key);
            if (value == null) {
                V v = null;
                return v;
            }
            if (this.isEntryExpire(value)) {
                this.cacheMap.remove(key);
                V v = null;
                return v;
            }
            CacheBuilder.CacheEntry cacheEntry = value;
            return (V)cacheEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this.lock.lock();
        try {
            this.cacheMap.put(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V invalidate(K key) {
        this.lock.lock();
        try {
            CacheBuilder.CacheEntry cacheEntry = (CacheBuilder.CacheEntry)this.cacheMap.remove(key);
            return (V)cacheEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> getAllValues() {
        this.lock.lock();
        try {
            HashSet<V> copy = new HashSet<V>();
            copy.addAll(this.cacheMap.values());
            HashSet<V> hashSet = copy;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop(boolean wait) {
        if (this.cleanupTask != null) {
            this.cleanupTask.stop(wait);
        }
    }

    @Override
    public void setEntryLifetime(long lifeTimeInMillis) {
        this.entryLifetime = lifeTimeInMillis;
    }
}

