/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;

public class LoginUpdater {
    private final Set<GlobalParamsUpdater> gpUpdaters = Collections.synchronizedSet(new HashSet());
    private final Set<ServiceParamsUpdater> spUpdaters = Collections.synchronizedSet(new HashSet());

    public void addGlobalParamsUpdaters(GlobalParamsUpdater ... updaters) {
        for (GlobalParamsUpdater updater : updaters) {
            this.gpUpdaters.add(updater);
        }
    }

    public void addServiceParamsUpdaters(ServiceParamsUpdater ... updaters) {
        for (ServiceParamsUpdater updater : updaters) {
            this.spUpdaters.add(updater);
        }
    }

    public static interface ServiceParamsUpdater {
        public void newServiceParameters(ParameterMap var1);
    }

    public static interface GlobalParamsUpdater {
        public void newGlobalParameters(ParameterMap var1);
    }

    public class ServiceParamsListener
    implements ParameterListener {
        @Override
        public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
            for (ServiceParamsUpdater spUpdater : LoginUpdater.this.spUpdaters) {
                spUpdater.newServiceParameters(newMap);
            }
        }
    }

    public class GlobalParamsListener
    implements ParameterListener {
        @Override
        public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
            ParameterMap filtered;
            if (oldMap != null && (filtered = oldMap.diff(newMap, true).filter(EnumSet.of(ParameterState.Info.SECURITY))).size() == 0) {
                return;
            }
            for (GlobalParamsUpdater gpUpdater : LoginUpdater.this.gpUpdaters) {
                gpUpdater.newGlobalParameters(newMap);
            }
        }
    }
}

