/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.TopologyResolver;
import oracle.kv.impl.security.login.TrustedLoginAPI;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.registry.RegistryUtils;

public class InternalLoginManager
implements LoginManager {
    private final ConcurrentHashMap<HostPort, LoginHandle> loginMap = new ConcurrentHashMap();
    private final TopologyResolver topoResolver;

    public InternalLoginManager(TopologyResolver topoResolver) {
        this.topoResolver = topoResolver;
    }

    @Override
    public String getUsername() {
        return null;
    }

    @Override
    public LoginHandle getHandle(HostPort target, ResourceId.ResourceType rtype) {
        LoginHandle loginHandle = this.loginMap.get(target);
        if (loginHandle != null) {
            return loginHandle;
        }
        loginHandle = new InternalLoginHandle(null, target.hostname(), target.port());
        try {
            loginHandle.renewToken(null);
        }
        catch (SessionAccessException sae) {
            return loginHandle;
        }
        LoginHandle prevHandle = this.loginMap.putIfAbsent(target, loginHandle);
        if (prevHandle == null) {
            return loginHandle;
        }
        try {
            loginHandle.logoutToken();
        }
        catch (SessionAccessException sae) {
            // empty catch block
        }
        return prevHandle;
    }

    @Override
    public LoginHandle getHandle(ResourceId target) {
        if (this.topoResolver == null) {
            throw new UnsupportedOperationException("Cannot get internal login via ResourceId without a topology resolver");
        }
        TopologyResolver.SNInfo sn = this.topoResolver.getStorageNode(target);
        if (sn == null) {
            return null;
        }
        HostPort snTarget = new HostPort(sn.getHostname(), sn.getRegistryPort());
        return this.getHandle(snTarget, target.getType());
    }

    @Override
    public void logout() {
        Set<Map.Entry<HostPort, LoginHandle>> logins = this.loginMap.entrySet();
        for (Map.Entry<HostPort, LoginHandle> tokenEntry : logins) {
            try {
                this.logout(tokenEntry.getKey(), tokenEntry.getValue());
            }
            catch (SessionAccessException sae) {}
        }
    }

    private boolean logout(HostPort target, LoginHandle loginHandle) throws SessionAccessException {
        if (loginHandle == null) {
            return true;
        }
        try {
            loginHandle.logoutToken();
            this.loginMap.remove(target, loginHandle);
            return true;
        }
        catch (AuthenticationRequiredException are) {
            return true;
        }
    }

    private class InternalLoginHandle
    extends LoginHandle {
        private final String hostname;
        private final int registryPort;

        public InternalLoginHandle(LoginToken loginToken, String hostname, int registryPort) {
            super(loginToken);
            this.hostname = hostname;
            this.registryPort = registryPort;
        }

        @Override
        public LoginToken renewToken(LoginToken prevToken) throws SessionAccessException {
            LoginToken currToken = this.getLoginToken();
            if (prevToken != currToken) {
                return currToken;
            }
            try {
                LoginToken logoutToken;
                TrustedLoginAPI tlAPI = this.getLoginAPI();
                LoginResult result = tlAPI.loginInternal();
                if (result.getLoginToken() == null) {
                    throw new RemoteException("Unable to get login access");
                }
                LoginToken loginToken = logoutToken = this.updateLoginToken(currToken, result.getLoginToken()) ? currToken : result.getLoginToken();
                if (logoutToken != null) {
                    try {
                        tlAPI.logout(logoutToken);
                    }
                    catch (AuthenticationRequiredException are) {
                        // empty catch block
                    }
                }
                return this.getLoginToken();
            }
            catch (RemoteException re) {
                throw new SessionAccessException(re, false);
            }
        }

        @Override
        public void logoutToken() throws SessionAccessException {
            this.logoutToken(true);
        }

        private void logoutToken(boolean retry) throws SessionAccessException {
            block4: {
                LoginToken logoutToken = this.getLoginToken();
                if (logoutToken != null) {
                    try {
                        this.getLoginAPI().logout(logoutToken);
                    }
                    catch (AuthenticationRequiredException are) {
                    }
                    catch (RemoteException re) {
                        if (!retry) break block4;
                        this.logoutToken(false);
                    }
                }
            }
        }

        private TrustedLoginAPI getLoginAPI() throws RemoteException {
            try {
                return RegistryUtils.getStorageNodeAgentLogin(this.hostname, this.registryPort);
            }
            catch (NotBoundException nbe) {
                throw new RemoteException("login interface not bound", nbe);
            }
        }

        @Override
        public boolean isUsable(ResourceId.ResourceType rtype) {
            return rtype.equals((Object)ResourceId.ResourceType.REP_NODE) || rtype.equals((Object)ResourceId.ResourceType.ADMIN) || rtype.equals((Object)ResourceId.ResourceType.STORAGE_NODE);
        }
    }
}

