/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.Serializable;
import java.security.Principal;
import javax.security.auth.Subject;
import oracle.kv.impl.security.ExecutionContext;

public class KVStoreUserPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String userId;
    public static final String INTERNAL_NAME = "_internal_";
    public static final KVStoreUserPrincipal INTERNAL = new KVStoreUserPrincipal("_internal_");

    public KVStoreUserPrincipal(String username) {
        this(username, null);
    }

    public KVStoreUserPrincipal(String username, String userId) {
        if (username == null) {
            throw new IllegalArgumentException("username may not be null");
        }
        this.username = username;
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public static KVStoreUserPrincipal getCurrentUser() {
        return ExecutionContext.getCurrentUserPrincipal();
    }

    public static KVStoreUserPrincipal getSubjectUser(Subject subj) {
        return ExecutionContext.getSubjectUserPrincipal(subj);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.username.equals(((KVStoreUserPrincipal)other).username);
    }

    @Override
    public String getName() {
        return this.username;
    }

    @Override
    public int hashCode() {
        return this.username.hashCode();
    }

    @Override
    public String toString() {
        return "KVStoreUserPrincipal(" + this.username + "," + this.userId + ")";
    }
}

