/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.RoleResolver;

public class KVBuiltInRoleResolver
implements RoleResolver {
    private static final Map<String, RoleInstance> roleMap = new HashMap<String, RoleInstance>();

    @Override
    public RoleInstance resolve(String roleName) {
        return KVBuiltInRoleResolver.resolveRole(roleName);
    }

    public static RoleInstance resolveRole(String roleName) {
        return roleMap.get(RoleInstance.getNormalizedName(roleName));
    }

    Collection<RoleInstance> getAllRoles() {
        return roleMap.values();
    }

    static {
        roleMap.put(RoleInstance.DBADMIN.name(), RoleInstance.DBADMIN);
        roleMap.put(RoleInstance.SYSADMIN.name(), RoleInstance.SYSADMIN);
        roleMap.put(RoleInstance.INTERNAL.name(), RoleInstance.INTERNAL);
        roleMap.put(RoleInstance.READONLY.name(), RoleInstance.READONLY);
        roleMap.put(RoleInstance.WRITEONLY.name(), RoleInstance.WRITEONLY);
        roleMap.put(RoleInstance.READWRITE.name(), RoleInstance.READWRITE);
        roleMap.put(RoleInstance.PUBLIC.name(), RoleInstance.PUBLIC);
        roleMap.put(RoleInstance.ADMIN.name(), RoleInstance.ADMIN);
        roleMap.put(RoleInstance.AUTHENTICATED.name(), RoleInstance.AUTHENTICATED);
    }
}

