/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.Ownable;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.util.server.LoggerUtils;

public class AccessCheckUtils {
    public static void checkPermission(AdminService aservice, OperationContext opCtx) throws SessionAccessException, ClientAccessException {
        ExecutionContext exeCtx = ExecutionContext.getCurrent();
        if (exeCtx == null) {
            return;
        }
        AccessChecker accessChecker = aservice.getAdminSecurity().getAccessChecker();
        if (accessChecker != null) {
            try {
                accessChecker.checkAccess(exeCtx, opCtx);
            }
            catch (KVSecurityException kvse) {
                throw new ClientAccessException(kvse);
            }
        }
    }

    public static boolean currentUserOwnsResource(Ownable resource) {
        ResourceOwner currentUser = SecurityUtils.currentUserAsOwner();
        ResourceOwner owner = resource.getOwner();
        return currentUser != null && currentUser.equals(owner);
    }

    public static void logSecurityError(KVSecurityException kvse, String opDesc, Logger logger) {
        ExecutionContext execCtx = ExecutionContext.getCurrent();
        if (execCtx != null) {
            AccessCheckUtils.logSecurityError(kvse.getMessage(), opDesc, execCtx, logger);
        }
    }

    public static void logSecurityError(String msg, String opDesc, ExecutionContext execCtx, Logger logger) {
        if (logger != null) {
            KVStoreUserPrincipal user;
            String authHost = "";
            String userName = "";
            if (execCtx.requestorContext() != null && execCtx.requestorContext().getClientHost() != null) {
                authHost = execCtx.requestorContext().getClientHost();
            }
            if ((user = ExecutionContext.getSubjectUserPrincipal(execCtx.requestorSubject())) != null) {
                userName = user.getName();
            }
            logger.log((Level)LoggerUtils.SecurityLevel.SEC_WARNING, LoggerUtils.KVAuditInfo.failure(userName, execCtx.requestorHost(), authHost, opDesc, msg));
        }
    }

    public static class TableContext
    extends ResourceContext {
        private final List<KVStorePrivilege> privsToCheck;
        private final String ctxDescription;

        public TableContext(String opDesc, TableImpl table, KVStorePrivilege ... privsToCheck) {
            this(opDesc, table, Arrays.asList(privsToCheck));
        }

        public TableContext(String opDesc, TableImpl table, List<KVStorePrivilege> privsToCheck) {
            super(table, "Table");
            this.privsToCheck = privsToCheck;
            this.ctxDescription = String.format("%s, Table name: %s, Table Id: %d, Owner: %s", opDesc, table.getFullName(), table.getId(), table.getOwner() == null ? "" : table.getOwner());
        }

        @Override
        public String describe() {
            return this.ctxDescription;
        }

        @Override
        List<? extends KVStorePrivilege> privilegesForOwner() {
            return SystemPrivilege.usrviewPrivList;
        }

        @Override
        List<? extends KVStorePrivilege> privilegesForNonOwner() {
            return this.privsToCheck;
        }
    }

    public static class PlanAccessContext
    extends PlanContext {
        public PlanAccessContext(Plan plan, String desc) {
            super(plan, desc);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesForOwner() {
            return SystemPrivilege.usrviewPrivList;
        }

        @Override
        List<? extends KVStorePrivilege> privilegesForNonOwner() {
            return SystemPrivilege.sysviewPrivList;
        }
    }

    public static class PlanOperationContext
    extends PlanContext {
        public PlanOperationContext(Plan plan, String desc) {
            super(plan, desc);
        }

        @Override
        List<? extends KVStorePrivilege> privilegesForOwner() {
            Plan plan = (Plan)this.resource;
            return plan.getRequiredPrivileges();
        }

        @Override
        List<? extends KVStorePrivilege> privilegesForNonOwner() {
            return SystemPrivilege.sysoperPrivList;
        }
    }

    private static abstract class PlanContext
    extends ResourceContext {
        private final String ctxDescription;

        PlanContext(Plan plan, String opDesc) {
            super(plan, "Plan");
            this.ctxDescription = String.format("%s, Plan Name: %s, Plan Id: %d, Owner: %s", opDesc, plan.getName(), plan.getId(), plan.getOwner() == null ? "" : plan.getOwner());
        }

        @Override
        public String describe() {
            return this.ctxDescription;
        }
    }

    private static abstract class ResourceContext
    implements OperationContext {
        final Ownable resource;

        ResourceContext(Ownable resource, String resourceType) {
            if (resource == null) {
                throw new IllegalCommandException(resourceType + " to be checked doesn't exist");
            }
            this.resource = resource;
        }

        @Override
        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            if (AccessCheckUtils.currentUserOwnsResource(this.resource)) {
                return this.privilegesForOwner();
            }
            return this.privilegesForNonOwner();
        }

        abstract List<? extends KVStorePrivilege> privilegesForOwner();

        abstract List<? extends KVStorePrivilege> privilegesForNonOwner();
    }
}

