/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.monitor;

import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.utilint.Latency;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.measurement.ConciseStats;
import oracle.kv.impl.measurement.EnvStats;
import oracle.kv.impl.measurement.LatencyInfo;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.PerfStatType;
import oracle.kv.impl.measurement.RepEnvStats;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.util.FormatUtils;

public class StatsPacket
implements Measurement,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, LatencyInfo> latencies;
    private EnvStats envStats;
    private RepEnvStats repEnvStats;
    private final long start;
    private final long end;
    private List<ConciseStats> otherStats = null;

    public StatsPacket(long start, long end) {
        this.start = start;
        this.end = end;
        this.latencies = new HashMap<Integer, LatencyInfo>();
    }

    public void add(LatencyInfo m) {
        this.latencies.put(m.getPerfStatId(), m);
    }

    public void add(EnvStats stats) {
        this.envStats = stats;
    }

    public void add(RepEnvStats stats) {
        this.repEnvStats = stats;
    }

    public void add(ConciseStats stats) {
        if (this.otherStats == null) {
            this.otherStats = new ArrayList<ConciseStats>();
        }
        this.otherStats.add(stats);
    }

    public LatencyInfo get(PerfStatType perfType) {
        return this.latencies.get(perfType.getId());
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public int getId() {
        return Metrics.RNSTATS.getId();
    }

    public void writeCSVHeader(PrintStream out, PerfStatType[] headerList, Map<String, Long> sortedEnvStats) {
        out.print("Date,");
        for (PerfStatType perfType : headerList) {
            out.print(LatencyInfo.getCSVHeader(perfType.toString()) + ",");
        }
        for (String name : sortedEnvStats.keySet()) {
            out.print(name + ",");
        }
    }

    public void writeStats(PrintStream out, PerfStatType[] statList, Map<String, Long> sortedEnvStats) {
        out.print(this.getFormattedDate() + ",");
        for (PerfStatType statType : statList) {
            LatencyInfo lm = this.latencies.get(statType.getId());
            if (lm == null) {
                out.print("0,0,0,0,0,0,0,0");
            } else {
                out.print(lm.getCSVStats());
            }
            out.print(",");
        }
        for (Long value : sortedEnvStats.values()) {
            out.print(value + ",");
        }
        out.println("");
    }

    private String getFormattedDate() {
        return FormatUtils.formatDateAndTime(this.end);
    }

    public Map<String, Long> sortEnvStats() {
        ArrayList<StatGroup> groups = new ArrayList<StatGroup>();
        if (this.repEnvStats != null) {
            groups.addAll(this.repEnvStats.getStats().getStatGroups());
        }
        if (this.envStats != null) {
            groups.addAll(this.envStats.getStats().getStatGroups());
        }
        TreeMap<String, Long> sortedVals = new TreeMap<String, Long>();
        for (StatGroup sg : groups) {
            for (Map.Entry e : sg.getStats().entrySet()) {
                String name = ('\"' + sg.getName() + "\n" + ((StatDefinition)e.getKey()).getName() + '\"').intern();
                Object val = ((Stat)e.getValue()).get();
                if (!(val instanceof Number)) continue;
                sortedVals.put(name, ((Number)val).longValue());
            }
        }
        return sortedVals;
    }

    public Map<PerfStatType, LatencyInfo> summarizeLatencies(PerfStatType[] summaryList) {
        HashMap<PerfStatType, LatencyInfo> rollupValues = new HashMap<PerfStatType, LatencyInfo>();
        for (LatencyInfo m : this.latencies.values()) {
            for (PerfStatType root : summaryList) {
                if (PerfStatType.getType(m.getPerfStatId()).getParent() != root) continue;
                LatencyInfo existing = (LatencyInfo)rollupValues.get((Object)root);
                if (existing == null) {
                    rollupValues.put(root, new LatencyInfo(root, m));
                    continue;
                }
                existing.rollup(m);
            }
        }
        return rollupValues;
    }

    public Map<PerfStatType, LatencyInfo> summarizeAndWriteStats(PrintStream out, PerfStatType[] summaryList, Map<String, Long> sortedEnvStats) {
        out.print(this.getFormattedDate() + ",");
        Map<PerfStatType, LatencyInfo> rollupValues = this.summarizeLatencies(summaryList);
        for (PerfStatType root : summaryList) {
            LatencyInfo m = rollupValues.get((Object)root);
            if (m == null) {
                m = LatencyInfo.ZERO_MEASUREMENT;
            }
            out.print(m.getCSVStats() + ",");
        }
        for (Long value : sortedEnvStats.values()) {
            out.print(value + ",");
        }
        out.println("");
        return rollupValues;
    }

    public EnvStats getEnvStats() {
        return this.envStats;
    }

    public RepEnvStats getRepEnvStats() {
        return this.repEnvStats;
    }

    public List<ConciseStats> getOtherStats() {
        return this.otherStats;
    }

    public List<Latency> getLatencies() {
        ArrayList<Latency> latencyList = new ArrayList<Latency>();
        for (LatencyInfo lm : this.latencies.values()) {
            latencyList.add(lm.getLatency());
        }
        return latencyList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LatencyInfo m : this.latencies.values()) {
            sb.append(m).append("\n");
        }
        return sb.toString();
    }
}

