/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import oracle.kv.impl.topo.RepNodeId;

class TransferProtocol {
    static final int VERSION = 1;
    private static final int REQUEST_SIZE = 20;

    TransferProtocol() {
    }

    static enum OP {
        COPY,
        PUT,
        DELETE,
        PREPARE,
        COMMIT,
        ABORT,
        EOD;


        static OP get(int ordinal) {
            if (ordinal >= 0 && ordinal < OP.values().length) {
                return OP.values()[ordinal];
            }
            return null;
        }
    }

    static class TransferRequest {
        final int partitionId;
        final RepNodeId targetRNId;
        final DatabaseEntry lastKey;

        private TransferRequest(int partitionId, RepNodeId targetRnId, DatabaseEntry lastKey) {
            this.partitionId = partitionId;
            this.targetRNId = targetRnId;
            this.lastKey = lastKey;
        }

        static void write(DataChannel channel, int partitionId, RepNodeId targetRNId, DatabaseEntry lastKey) throws IOException {
            int keySize = lastKey == null ? 0 : lastKey.getSize();
            ByteBuffer buffer = ByteBuffer.allocate(20 + keySize);
            buffer.putInt(1);
            buffer.putInt(partitionId);
            buffer.putInt(targetRNId.getGroupId());
            buffer.putInt(targetRNId.getNodeNum());
            buffer.putInt(keySize);
            if (lastKey != null) {
                buffer.put(lastKey.getData());
            }
            buffer.flip();
            channel.write(buffer);
        }

        static TransferRequest read(DataChannel channel) throws IOException {
            ByteBuffer readBuffer = ByteBuffer.allocate(20);
            TransferRequest.read(readBuffer, channel);
            int version = readBuffer.getInt();
            if (version != 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("Protocol version mismatch, received ");
                sb.append(version);
                sb.append(" expected ");
                sb.append(1);
                throw new IOException(sb.toString());
            }
            int partitionId = readBuffer.getInt();
            int targetGroupId = readBuffer.getInt();
            int targetNodeNum = readBuffer.getInt();
            int lastKeySize = readBuffer.getInt();
            DatabaseEntry lastKey = null;
            if (lastKeySize > 0) {
                ByteBuffer lastKeyBuffer = ByteBuffer.allocate(lastKeySize);
                TransferRequest.read(lastKeyBuffer, channel);
                lastKey = new DatabaseEntry(lastKeyBuffer.array());
            }
            return new TransferRequest(partitionId, new RepNodeId(targetGroupId, targetNodeNum), lastKey);
        }

        private static void read(ByteBuffer bb, DataChannel channel) throws IOException {
            while (bb.remaining() > 0) {
                if (channel.read(bb) >= 0) continue;
                throw new IOException("Unexpected EOF");
            }
            bb.flip();
        }

        static void writeACKResponse(DataChannel channel) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)ServiceDispatcher.Response.OK.ordinal());
            buffer.flip();
            if (channel.write(buffer) == 0) {
                throw new IOException("Failed to write response. Send buffer size: " + channel.getSocketChannel().socket().getSendBufferSize());
            }
        }

        static void writeBusyResponse(DataChannel channel, int numStreams, String message) throws IOException {
            byte[] mb = message.getBytes();
            ByteBuffer buffer = ByteBuffer.allocate(9 + mb.length);
            buffer.put((byte)ServiceDispatcher.Response.BUSY.ordinal());
            buffer.putInt(numStreams);
            buffer.putInt(mb.length);
            buffer.put(mb);
            buffer.flip();
            if (channel.write(buffer) == 0) {
                throw new IOException("Failed to write response. Send buffer size: " + channel.getSocketChannel().socket().getSendBufferSize());
            }
        }

        static void writeErrorResponse(DataChannel channel, ServiceDispatcher.Response response, String message) throws IOException {
            byte[] mb = message.getBytes();
            ByteBuffer buffer = ByteBuffer.allocate(5 + mb.length);
            buffer.put((byte)response.ordinal());
            buffer.putInt(mb.length);
            buffer.put(mb);
            buffer.flip();
            if (channel.write(buffer) == 0) {
                throw new IOException("Failed to write response. Send buffer size: " + channel.getSocketChannel().socket().getSendBufferSize());
            }
        }

        static ServiceDispatcher.Response readResponse(DataInputStream stream) throws IOException {
            int ordinal = stream.read();
            if (ordinal < 0 || ordinal >= ServiceDispatcher.Response.values().length) {
                throw new IOException("Error reading response= " + ordinal);
            }
            return ServiceDispatcher.Response.values()[ordinal];
        }

        static int readNumStreams(DataInputStream stream) throws IOException {
            return stream.readInt();
        }

        static String readReason(DataInputStream stream) {
            try {
                int size = stream.readInt();
                byte[] bytes = new byte[size];
                stream.readFully(bytes);
                return new String(bytes);
            }
            catch (IOException ioe) {
                return "";
            }
        }
    }
}

