/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.je.DatabaseException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.rep.migration.MigrationManager;
import oracle.kv.impl.rep.migration.PartitionMigrations;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.registry.RegistryUtils;

public class TargetMonitorExecutor
extends ScheduledThreadPoolExecutor {
    private static final long POLL_PERIOD = 2L;
    private final MigrationManager manager;
    private final RepNode repNode;
    private final Logger logger;
    private final RepGroupId sourceRGId;

    TargetMonitorExecutor(MigrationManager manager, RepNode repNode, Logger logger) {
        super(1, new KVThreadFactory(" target monitor", logger));
        this.manager = manager;
        this.repNode = repNode;
        this.logger = logger;
        this.sourceRGId = new RepGroupId(repNode.getRepNodeId().getGroupId());
        this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    void monitorTarget() {
        try {
            this.schedule(new TargetMonitor(), 2L, TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException ree) {
            this.logger.log(Level.WARNING, "Failed to schedule monitor", ree);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null) {
            this.logger.log(Level.INFO, "Target monitor execution failed", t);
            return;
        }
        if (!this.manager.isMaster()) {
            return;
        }
        Future f = (Future)((Object)r);
        TargetMonitor monitor = null;
        try {
            monitor = (TargetMonitor)f.get();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Exception getting monitor", ex);
        }
        if (monitor != null && this.getQueue().isEmpty()) {
            try {
                this.schedule(monitor, 2L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException ree) {
                this.logger.log(Level.WARNING, "Failed to restart monitor", ree);
            }
        }
    }

    private class TargetMonitor
    implements Callable<TargetMonitor> {
        private TargetMonitor() {
        }

        @Override
        public TargetMonitor call() {
            boolean keepChecking = true;
            if (!TargetMonitorExecutor.this.manager.isMaster()) {
                return null;
            }
            PartitionMigrations migrations = TargetMonitorExecutor.this.manager.getMigrations();
            if (migrations == null) {
                return this;
            }
            keepChecking = false;
            Iterator<PartitionMigrations.MigrationRecord> itr = migrations.completed();
            while (itr.hasNext() && TargetMonitorExecutor.this.manager.isMaster()) {
                if (!this.check(itr.next())) continue;
                keepChecking = true;
            }
            return keepChecking ? this : null;
        }

        private boolean check(PartitionMigrations.MigrationRecord record) {
            Exception ex;
            if (record instanceof PartitionMigrations.TargetRecord) {
                return false;
            }
            assert (record.getSourceRGId().equals(TargetMonitorExecutor.this.sourceRGId));
            TargetMonitorExecutor.this.logger.log(Level.FINE, "Check target for {0}", record);
            try {
                RegistryUtils registryUtils = new RegistryUtils(TargetMonitorExecutor.this.repNode.getTopology(), TargetMonitorExecutor.this.repNode.getLoginManager());
                RepGroupId targetRGId = record.getTargetRGId();
                RepNodeState rns = TargetMonitorExecutor.this.repNode.getMaster(targetRGId);
                if (rns == null) {
                    TargetMonitorExecutor.this.logger.log(Level.FINE, "Master not found for {0}, sending NOP to update group table", targetRGId);
                    TargetMonitorExecutor.this.repNode.sendNOP(targetRGId);
                    return true;
                }
                RepNodeAdminAPI rna = registryUtils.getRepNodeAdmin(rns.getRepNodeId());
                RepNodeAdmin.PartitionMigrationState state = rna.getMigrationState(record.getPartitionId());
                switch (state) {
                    case ERROR: {
                        this.failed(record, state);
                        return false;
                    }
                    case SUCCEEDED: {
                        return false;
                    }
                    case UNKNOWN: {
                        TargetMonitorExecutor.this.logger.log(Level.FINE, "Received UNKNOWN status from {0}, sending NOP to update group table", targetRGId);
                        TargetMonitorExecutor.this.repNode.sendNOP(targetRGId);
                        return true;
                    }
                }
                if (record.getTargetRNId().equals(rns.getRepNodeId())) {
                    return true;
                }
                this.failed(record, state);
                return false;
            }
            catch (NotBoundException nbe) {
                ex = nbe;
            }
            catch (RemoteException re) {
                ex = re;
            }
            catch (DatabaseException de) {
                ex = de;
            }
            TargetMonitorExecutor.this.logger.log(Level.INFO, "Exception while monitoring target for {0}: {1}", new Object[]{record, ex});
            return true;
        }

        private void failed(PartitionMigrations.MigrationRecord record, RepNodeAdmin.PartitionMigrationState state) {
            TargetMonitorExecutor.this.logger.log(Level.INFO, "Migration source detected failure of {0}, target returned {1} ({2}), removing completed record", new Object[]{record, state, state.getCause()});
            TargetMonitorExecutor.this.manager.removeRecord(record, true);
        }
    }
}

