/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Transaction;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.migration.MigrationService;
import oracle.kv.impl.rep.migration.MigrationSource;
import oracle.kv.impl.topo.PartitionId;

public class MigrationStreamHandle {
    private static final ThreadLocal<MigrationStreamHandle> handle = new ThreadLocal<MigrationStreamHandle>(){

        @Override
        protected synchronized MigrationStreamHandle initialValue() {
            throw new IllegalStateException("Handle not initialized");
        }
    };
    private static final MigrationStreamHandle noop = new MigrationStreamHandle();

    public static MigrationStreamHandle get() {
        return handle.get();
    }

    public static MigrationStreamHandle initialize(RepNode repNode, PartitionId partitionId, Transaction txn) {
        assert (MigrationStreamHandle.checkForStaleHandle());
        MigrationService service = repNode.getMigrationManager().getMigrationService();
        MigrationSource source = service == null ? null : service.getSource(partitionId);
        MigrationStreamHandle h = source == null ? noop : new MigratingHandle(source, txn);
        handle.set(h);
        return h;
    }

    private static boolean checkForStaleHandle() {
        try {
            MigrationStreamHandle h = handle.get();
            throw new IllegalStateException("Handle still around? " + h);
        }
        catch (IllegalStateException ise) {
            return true;
        }
    }

    private MigrationStreamHandle() {
    }

    public void addPut(DatabaseEntry key, DatabaseEntry value) {
    }

    public void addDelete(DatabaseEntry key) {
    }

    public void prepare() {
    }

    public void done() {
        handle.remove();
    }

    public String toString() {
        return "MigrationStreamHandle[]";
    }

    private static class MigratingHandle
    extends MigrationStreamHandle {
        private final MigrationSource source;
        private final Transaction txn;
        private int opsSent = 0;
        private boolean prepared = false;
        private boolean done = false;

        private MigratingHandle(MigrationSource source, Transaction txn) {
            this.source = source;
            this.txn = txn;
        }

        @Override
        public void addPut(DatabaseEntry key, DatabaseEntry value) {
            assert (!this.prepared);
            assert (key != null);
            assert (value != null);
            if (this.source.sendPut(this.txn.getId(), key, value)) {
                ++this.opsSent;
            }
        }

        @Override
        public void addDelete(DatabaseEntry key) {
            assert (!this.prepared);
            assert (key != null);
            if (this.source.sendDelete(this.txn.getId(), key)) {
                ++this.opsSent;
            }
        }

        @Override
        public void prepare() {
            assert (!this.prepared);
            assert (!this.done);
            if (this.opsSent > 0) {
                this.source.sendPrepare(this.txn.getId());
            }
            this.prepared = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            assert (!this.done);
            try {
                if (this.opsSent > 0) {
                    this.source.sendResolution(this.txn.getId(), this.txn.getState().equals((Object)Transaction.State.COMMITTED));
                }
            }
            finally {
                this.done = true;
                super.done();
            }
        }

        @Override
        public String toString() {
            return "MigratingHandle[" + this.prepared + ", " + this.done + ", " + this.opsSent + "]";
        }
    }
}

