/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Durability;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.net.DataChannel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.migration.MigrationManager;
import oracle.kv.impl.rep.migration.MigrationService;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.rep.migration.PartitionMigrations;
import oracle.kv.impl.rep.migration.TransferProtocol;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.server.LoggerUtils;

class MigrationSource
implements Runnable {
    private final Logger logger;
    private final DataChannel channel;
    private final DataOutputStream stream;
    private final PartitionId partitionId;
    private final RepNodeId targetRNId;
    private final RepNode repNode;
    private final MigrationService service;
    private final Database partitionDb;
    private volatile Thread executingThread = null;
    private DatabaseEntry lastKey = null;
    private volatile boolean canceled = false;
    private volatile boolean eod = false;
    private final long startTime;
    private long endTime = 0L;
    private int operations = 0;
    private final int filtered = 0;
    private int transactionConflicts = 0;
    private long recordsSent = 0L;
    private long clientOpsSent = 0L;

    MigrationSource(DataChannel channel, PartitionId partitionId, RepNodeId targetRNId, RepNode repNode, MigrationService service, RepNodeService.Params params) throws IOException {
        this.channel = channel;
        this.stream = new DataOutputStream(Channels.newOutputStream((WritableByteChannel)channel));
        this.partitionId = partitionId;
        this.targetRNId = targetRNId;
        this.repNode = repNode;
        this.service = service;
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.partitionDb = repNode.getPartitionDB(partitionId);
        SocketChannel sChannel = channel.getSocketChannel();
        sChannel.configureBlocking(true);
        sChannel.socket().setSoTimeout(params.getRepNodeParams().getReadWriteTimeout());
        sChannel.socket().setTcpNoDelay(false);
        this.startTime = System.currentTimeMillis();
    }

    PartitionMigrationStatus getStatus() {
        return new PartitionMigrationStatus(this.partitionId.getPartitionId(), this.targetRNId.getGroupId(), this.repNode.getRepNodeId().getGroupId(), this.operations, this.startTime, this.endTime, this.recordsSent, this.clientOpsSent);
    }

    int getTargetGroupId() {
        return this.targetRNId.getGroupId();
    }

    boolean isAlive() {
        return this.executingThread != null;
    }

    synchronized void cancel(boolean wait) {
        this.canceled = true;
        if (!wait) {
            return;
        }
        Thread thread = this.executingThread;
        if (thread != null && thread.isAlive()) {
            assert (Thread.currentThread() != thread);
            try {
                this.logger.log(Level.FINE, "Waiting for {0} to exit", this);
                thread.join(5000L);
                if (this.isAlive()) {
                    this.logger.log(Level.FINE, "Cancel of {0} timed out", this);
                }
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
    }

    private void error(IOException ioe) {
        this.error("Unexpected exception, stopping " + this, ioe);
    }

    private void error(String message, Exception ex) {
        this.logger.log(Level.INFO, message, ex);
        this.cancel(false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeChannel() {
        try {
            this.channel.close();
        }
        catch (IOException ioe) {
            this.logger.log(Level.WARNING, "Exception closing partition migration channel", ioe);
        }
    }

    private void transferComplete() {
        this.logger.log(Level.INFO, "{0} completed transfer", this);
        this.endTime = System.currentTimeMillis();
        if (!this.persistTransferComplete()) {
            this.cancel(false);
            return;
        }
        this.sendEOD();
        if (this.logger.isLoggable(Level.INFO)) {
            long seconds = (this.endTime - this.startTime) / 1000L;
            long opsPerSec = seconds == 0L ? (long)this.operations : (long)this.operations / seconds;
            this.logger.log(Level.INFO, "Sent EOD for {0}, {1} total operations, {2} filtered, {3} transaction conflicts, {4} ops/second", new Object[]{this.partitionId, this.operations, 0, this.transactionConflicts, opsPerSec});
        }
    }

    private boolean filterOp(DatabaseEntry key) {
        return this.lastKey == null ? false : this.partitionDb.compareKeys(this.lastKey, key) < 0;
    }

    private synchronized void sendCopy(DatabaseEntry key, DatabaseEntry value) {
        try {
            this.writeOp(TransferProtocol.OP.COPY);
            this.writeDbEntry(key);
            this.writeDbEntry(value);
            this.lastKey = new DatabaseEntry(key.getData());
            ++this.recordsSent;
        }
        catch (IOException ioe) {
            this.error(ioe);
        }
    }

    synchronized boolean sendPut(long txnId, DatabaseEntry key, DatabaseEntry value) {
        if (this.canceled) {
            return false;
        }
        if (this.filterOp(key)) {
            return false;
        }
        try {
            this.writeOp(TransferProtocol.OP.PUT, txnId);
            this.writeDbEntry(key);
            this.writeDbEntry(value);
            ++this.clientOpsSent;
            return true;
        }
        catch (IOException ioe) {
            this.error(ioe);
            return false;
        }
    }

    synchronized boolean sendDelete(long txnId, DatabaseEntry key) {
        if (this.canceled) {
            return false;
        }
        if (this.filterOp(key)) {
            return false;
        }
        try {
            this.writeOp(TransferProtocol.OP.DELETE, txnId);
            this.writeDbEntry(key);
            ++this.clientOpsSent;
            return true;
        }
        catch (IOException ioe) {
            this.error(ioe);
            return false;
        }
    }

    synchronized void sendPrepare(long txnId) {
        if (this.canceled) {
            return;
        }
        try {
            this.writeOp(TransferProtocol.OP.PREPARE, txnId);
        }
        catch (IOException ioe) {
            this.error(ioe);
        }
    }

    synchronized void sendResolution(long txnId, boolean commit) {
        if (this.canceled) {
            return;
        }
        try {
            this.writeOp(commit ? TransferProtocol.OP.COMMIT : TransferProtocol.OP.ABORT, txnId);
        }
        catch (IllegalStateException ise) {
            this.error("Exception attempting to send resolution, stopping " + this, ise);
        }
        catch (IOException ioe) {
            this.error(ioe);
        }
    }

    private synchronized void sendEOD() {
        if (this.canceled) {
            return;
        }
        try {
            this.writeOp(TransferProtocol.OP.EOD);
            this.eod = true;
        }
        catch (IOException ioe) {
            this.error(ioe);
        }
    }

    private void writeOp(TransferProtocol.OP op) throws IOException {
        assert (Thread.holdsLock(this));
        if (this.eod) {
            throw new IllegalStateException(this.partitionId + " has moved");
        }
        this.stream.write(op.ordinal());
        ++this.operations;
    }

    private void writeOp(TransferProtocol.OP op, long txnId) throws IOException {
        this.writeOp(op);
        this.stream.writeLong(txnId);
    }

    private void writeDbEntry(DatabaseEntry entry) throws IOException {
        assert (Thread.holdsLock(this));
        this.stream.writeInt(entry.getSize());
        this.stream.write(entry.getData());
    }

    private boolean persistTransferComplete() {
        this.logger.log(Level.FINE, "Persist transfer complete for {0}", this.partitionId);
        final RepGroupId sourceRGId = new RepGroupId(this.repNode.getRepNodeId().getGroupId());
        final PartitionMigrationStatus status = this.getStatus();
        final TransactionConfig txnConfig = new TransactionConfig();
        txnConfig.setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        txnConfig.setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
        MigrationManager manager = this.service.manager;
        Boolean success = manager.tryDBOperation(new MigrationManager.DBOperation<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call(Database db) {
                Boolean bl;
                Transaction txn = null;
                try {
                    txn = db.getEnvironment().beginTransaction(null, txnConfig);
                    PartitionMigrations pm = PartitionMigrations.fetch(db, txn);
                    pm.add(pm.newSource(status, MigrationSource.this.partitionId, sourceRGId, MigrationSource.this.targetRNId));
                    pm.persist(db, txn, true);
                    txn.commit();
                    txn = null;
                    bl = true;
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
                TxnUtil.abort(txn);
                return bl;
            }
        }, true);
        if (success == null || !success.booleanValue()) {
            return false;
        }
        manager.criticalUpdate();
        manager.monitorTarget();
        return true;
    }

    public String toString() {
        return "MigrationSource[" + this.partitionId + ", " + this.targetRNId + ", " + this.eod + "]";
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$com$sleepycat$je$OperationStatus;

        static {
            $SwitchMap$com$sleepycat$je$OperationStatus = new int[OperationStatus.values().length];
            try {
                2.$SwitchMap$com$sleepycat$je$OperationStatus[OperationStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$sleepycat$je$OperationStatus[OperationStatus.NOTFOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$sleepycat$je$OperationStatus[OperationStatus.KEYEMPTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$sleepycat$je$OperationStatus[OperationStatus.KEYEXIST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

