/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.trigger.ReplicatedDatabaseTrigger;
import com.sleepycat.je.trigger.TransactionTrigger;
import com.sleepycat.je.trigger.Trigger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.StateTracker;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.migration.MigrationService;
import oracle.kv.impl.rep.migration.MigrationTarget;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.rep.migration.PartitionMigrations;
import oracle.kv.impl.rep.migration.TargetMonitorExecutor;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.server.LoggerUtils;

public class MigrationManager
implements TopologyManager.Localizer {
    private final Logger logger;
    private static final int NUM_DB_OP_RETRIES = 100;
    private static final long SHORT_RETRY_TIME = 500L;
    private static final long LONG_RETRY_TIME = 1000L;
    private static final long MINIMUM_DELAY = 2000L;
    private final RepNode repNode;
    private final RepNodeService.Params params;
    private final int concurrentTargetLimit;
    private final Map<PartitionId, MigrationTarget> targets = new HashMap<PartitionId, MigrationTarget>();
    private MigrationService migrationService = null;
    private TargetExecutor targetExecutor = null;
    private volatile Database migrationDb = null;
    private volatile boolean isMaster = false;
    private final MigrationStateTracker stateTracker;
    private volatile boolean shutdown = false;
    private volatile TargetMonitorExecutor targetMonitorExecutor = null;
    private long completedSequenceNum = 0L;
    private volatile long lastMigrationDuration = Long.MAX_VALUE;

    public MigrationManager(RepNode repNode, RepNodeService.Params params) {
        this.repNode = repNode;
        this.params = params;
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.concurrentTargetLimit = params.getRepNodeParams().getConcurrentTargetLimit();
        this.stateTracker = new MigrationStateTracker(this.logger);
    }

    public void startTracker() {
        this.stateTracker.start();
    }

    boolean isMaster() {
        return this.isMaster && !this.shutdown;
    }

    public synchronized PartitionMigrationStatus[] getStatus() {
        PartitionMigrations migrations;
        if (!this.isMaster()) {
            return new PartitionMigrationStatus[0];
        }
        HashSet<PartitionMigrationStatus> status = new HashSet<PartitionMigrationStatus>(this.targets.size());
        for (MigrationTarget target : this.targets.values()) {
            status.add(target.getStatus());
        }
        if (this.migrationService != null) {
            this.migrationService.getStatus(status);
        }
        if (this.migrationDb != null && (migrations = this.getMigrations()) != null) {
            for (PartitionMigrations.MigrationRecord record : migrations) {
                if (record.getStatus() == null) continue;
                status.add(record.getStatus());
            }
        }
        return status.toArray(new PartitionMigrationStatus[status.size()]);
    }

    public synchronized PartitionMigrationStatus getStatus(PartitionId partitionId) {
        PartitionMigrations.MigrationRecord record;
        if (!this.isMaster()) {
            return null;
        }
        PartitionMigrationStatus status = null;
        if (this.migrationService != null && (status = this.migrationService.getStatus(partitionId)) != null) {
            return status;
        }
        MigrationTarget target = this.targets.get(partitionId);
        if (target != null) {
            return target.getStatus();
        }
        PartitionMigrations migrations = this.getMigrations();
        if (migrations != null && (record = migrations.get(partitionId)) != null) {
            status = record.getStatus();
            if (record instanceof PartitionMigrations.TargetRecord) {
                PartitionMigrations.TargetRecord targetRecord = (PartitionMigrations.TargetRecord)record;
                this.submitTarget(targetRecord);
            }
        }
        return status;
    }

    public void noteStateChange(StateChangeEvent stateChangeEvent) {
        this.stateTracker.noteStateChange(stateChangeEvent);
    }

    public synchronized void updateDbHandles(ReplicatedEnvironment repEnv) {
        this.logger.fine("Updating migration manager DB handles.");
        this.closeDbHandles(false);
        this.openMigrationDb(repEnv);
    }

    public synchronized void closeDbHandles(boolean force) {
        this.stopServices(force);
        this.closeMigrationDb();
    }

    public synchronized void shutdown(boolean force) {
        this.logger.info("Shutting down migration manager.");
        this.shutdown = true;
        this.closeDbHandles(force);
        if (this.targetMonitorExecutor != null) {
            this.targetMonitorExecutor.shutdown();
            if (!force) {
                try {
                    this.targetMonitorExecutor.awaitTermination(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.targetMonitorExecutor = null;
        }
        this.stateTracker.shutdown();
    }

    private void startServices() {
        assert (Thread.holdsLock(this));
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null) {
            this.logger.info("Failed to open environment, aborting start of migration service");
            return;
        }
        this.openMigrationDb(repEnv);
        if (this.migrationDb == null) {
            this.logger.info("Failed to open partition migration db, aborting start of migration service");
            return;
        }
        assert (this.migrationService == null);
        this.migrationService = new MigrationService(this.repNode, this, this.params);
        this.migrationService.start(repEnv);
        this.monitorTarget();
        this.restartTargets();
    }

    private void stopServices(boolean force) {
        assert (Thread.holdsLock(this));
        if (this.migrationDb == null) {
            assert (this.targets.isEmpty());
            assert (this.targetExecutor == null);
            assert (this.migrationService == null);
            return;
        }
        for (MigrationTarget target : this.targets.values()) {
            target.cancel(!force);
        }
        this.targets.clear();
        this.shutdownTargetExecutor();
        this.targetExecutor = null;
        if (this.migrationService != null) {
            this.migrationService.stop(this.shutdown, !force, (ReplicatedEnvironment)this.migrationDb.getEnvironment());
            this.migrationService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitIdle(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.migrationService == null || this.migrationService.pendingSources()) {
            return false;
        }
        TargetExecutor executor = this.shutdownTargetExecutor();
        if (executor == null) {
            return true;
        }
        if (!executor.awaitTermination(timeout, unit)) {
            return false;
        }
        MigrationManager migrationManager = this;
        synchronized (migrationManager) {
            this.targets.clear();
        }
        return true;
    }

    private synchronized TargetExecutor shutdownTargetExecutor() {
        if (this.targetExecutor != null) {
            this.targetExecutor.shutdown();
        }
        return this.targetExecutor;
    }

    MigrationService getMigrationService() {
        return this.migrationService;
    }

    public synchronized RepNodeAdmin.PartitionMigrationState migratePartition(final PartitionId partitionId, final RepGroupId sourceRGId) {
        if (!this.isMaster()) {
            String message = "Request to migrate " + partitionId + " but node shutdown or not master";
            this.logger.fine(message);
            return RepNodeAdmin.PartitionMigrationState.ERROR.setCause(new IllegalStateException(message));
        }
        MigrationTarget target = this.targets.get(partitionId);
        if (target != null) {
            switch (target.getState()) {
                case ERROR: {
                    this.targets.remove(partitionId);
                    break;
                }
                case SUCCEEDED: {
                    this.targets.remove(partitionId);
                    if (!target.getSource().equals(sourceRGId)) break;
                    return RepNodeAdmin.PartitionMigrationState.SUCCEEDED;
                }
                case PENDING: 
                case RUNNING: {
                    if (target.getSource().equals(sourceRGId)) {
                        return target.getState();
                    }
                    String message = "Migration in progress from " + target.getSource();
                    this.logger.warning(message);
                    return RepNodeAdmin.PartitionMigrationState.ERROR.setCause(new IllegalStateException(message));
                }
                case UNKNOWN: {
                    throw new IllegalStateException("Invalid " + target);
                }
            }
        }
        final TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        try {
            RepNodeAdmin.PartitionMigrationState state = this.tryDBOperation(new DBOperation<RepNodeAdmin.PartitionMigrationState>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public RepNodeAdmin.PartitionMigrationState call(Database db) {
                    PartitionMigrations migrations;
                    Transaction txn;
                    block5: {
                        PartitionMigrations.MigrationRecord record;
                        block7: {
                            block6: {
                                RepNodeAdmin.PartitionMigrationState partitionMigrationState;
                                txn = null;
                                try {
                                    txn = db.getEnvironment().beginTransaction(null, txnConfig);
                                    migrations = PartitionMigrations.fetch(db, txn);
                                    record = migrations.get(partitionId);
                                    if (record == null) break block5;
                                    MigrationManager.this.logger.log(Level.INFO, "Received request to migrate {0} from {1}, migration already in progress : {2}", new Object[]{partitionId, sourceRGId, record});
                                    if (!(record instanceof PartitionMigrations.SourceRecord)) break block6;
                                    String message = "Received request to migrate " + partitionId + " but partition is " + " already in transit to " + record.getTargetRGId();
                                    MigrationManager.this.logger.warning(message);
                                    partitionMigrationState = RepNodeAdmin.PartitionMigrationState.ERROR.setCause(new IllegalStateException(message));
                                }
                                catch (Throwable throwable) {
                                    TxnUtil.abort(txn);
                                    throw throwable;
                                }
                                TxnUtil.abort(txn);
                                return partitionMigrationState;
                            }
                            if (record.getSourceRGId().equals(sourceRGId)) break block7;
                            String message = "Source group " + sourceRGId + " does not match " + record;
                            MigrationManager.this.logger.warning(message);
                            RepNodeAdmin.PartitionMigrationState partitionMigrationState = RepNodeAdmin.PartitionMigrationState.ERROR.setCause(new IllegalStateException(message));
                            TxnUtil.abort(txn);
                            return partitionMigrationState;
                        }
                        RepNodeAdmin.PartitionMigrationState state1 = ((PartitionMigrations.TargetRecord)record).getState();
                        if (state1.equals((Object)RepNodeAdmin.PartitionMigrationState.ERROR)) break block5;
                        RepNodeAdmin.PartitionMigrationState partitionMigrationState = state1;
                        TxnUtil.abort(txn);
                        return partitionMigrationState;
                    }
                    PartitionMigrations.TargetRecord newRecord = migrations.newTarget(partitionId, sourceRGId, MigrationManager.this.repNode.getRepNodeId());
                    migrations.add(newRecord);
                    migrations.persist(db, txn, false);
                    txn.commit();
                    txn = null;
                    RepNodeAdmin.PartitionMigrationState partitionMigrationState = MigrationManager.this.submitTarget(newRecord);
                    TxnUtil.abort(txn);
                    return partitionMigrationState;
                }
            }, false);
            return state == null ? RepNodeAdmin.PartitionMigrationState.UNKNOWN : state;
        }
        catch (InsufficientAcksException iae) {
            return RepNodeAdmin.PartitionMigrationState.PENDING;
        }
        catch (DatabaseException de) {
            String message = "Exception starting migration for " + partitionId;
            this.logger.log(Level.WARNING, message, de);
            return RepNodeAdmin.PartitionMigrationState.ERROR.setCause(new Exception(message, de));
        }
    }

    private RepNodeAdmin.PartitionMigrationState submitTarget(PartitionMigrations.TargetRecord record) {
        assert (Thread.holdsLock(this));
        assert (this.migrationDb != null);
        if (!record.isPending() || this.repNode.getTableManager().isBusyMaintenance()) {
            return record.getState();
        }
        MigrationTarget target = new MigrationTarget(record, this.repNode, this, (ReplicatedEnvironment)this.migrationDb.getEnvironment(), this.params);
        this.targets.put(record.getPartitionId(), target);
        assert (this.targetExecutor == null || !this.targetExecutor.isShutdown() || this.targetExecutor.isTerminated());
        if (this.targetExecutor == null || this.targetExecutor.isTerminated()) {
            this.targetExecutor = new TargetExecutor();
        }
        this.targetExecutor.submitNew(target);
        return record.getState();
    }

    private void restartTargets() {
        assert (Thread.holdsLock(this));
        if (this.migrationDb == null) {
            return;
        }
        PartitionMigrations migrations = this.getMigrations();
        if (migrations == null) {
            return;
        }
        assert (this.targets.isEmpty());
        for (PartitionMigrations.MigrationRecord record : migrations) {
            assert (this.targets.get(record.getPartitionId()) == null);
            if (!(record instanceof PartitionMigrations.TargetRecord)) continue;
            this.submitTarget((PartitionMigrations.TargetRecord)record);
        }
    }

    public synchronized RepNodeAdmin.PartitionMigrationState getMigrationState(PartitionId partitionId) {
        if (!this.isMaster()) {
            String message = "Request migration state for " + partitionId + " but node shutdown or not master";
            this.logger.fine(message);
            return RepNodeAdmin.PartitionMigrationState.UNKNOWN.setCause(new IllegalStateException(message));
        }
        this.logger.log(Level.FINE, "Migration state request for {0}", partitionId);
        MigrationTarget target = this.targets.get(partitionId);
        if (target != null) {
            RepNodeAdmin.PartitionMigrationState state = target.getState();
            if (state.equals((Object)RepNodeAdmin.PartitionMigrationState.SUCCEEDED) || state.equals((Object)RepNodeAdmin.PartitionMigrationState.ERROR)) {
                this.removeTarget(partitionId);
            }
            return state;
        }
        PartitionMigrations migrations = this.getMigrations();
        if (migrations == null) {
            return RepNodeAdmin.PartitionMigrationState.UNKNOWN.setCause(new Exception("Unable to read migration record db"));
        }
        PartitionMigrations.TargetRecord record = migrations.getTarget(partitionId);
        if (record == null) {
            return RepNodeAdmin.PartitionMigrationState.UNKNOWN.setCause(new Exception("Migration record for " + partitionId + " not found"));
        }
        return this.submitTarget(record);
    }

    synchronized void removeTarget(PartitionId partitionId) {
        this.targets.remove(partitionId);
    }

    public synchronized RepNodeAdmin.PartitionMigrationState canCancel(PartitionId partitionId) {
        if (!this.isMaster()) {
            String message = "Request to cancel migration of " + partitionId + " but node shutdown or not master";
            this.logger.fine(message);
            return RepNodeAdmin.PartitionMigrationState.UNKNOWN.setCause(new IllegalStateException(message));
        }
        this.logger.log(Level.INFO, "Request to cancel migration of {0}", partitionId);
        MigrationTarget target = this.targets.get(partitionId);
        if (target != null) {
            if (!target.cancel(false)) {
                this.logger.log(Level.INFO, "Unable to cancel {0}", target);
                assert (target.getState().equals((Object)RepNodeAdmin.PartitionMigrationState.SUCCEEDED));
                return RepNodeAdmin.PartitionMigrationState.SUCCEEDED;
            }
            try {
                this.removeRecord(partitionId, target.getRecordId(), false);
                return target.getState();
            }
            catch (DatabaseException de) {
                String message = "Exception attempting to remove migration record for " + partitionId;
                this.logger.log(Level.INFO, message, de);
                return RepNodeAdmin.PartitionMigrationState.UNKNOWN.setCause(new Exception(message, de));
            }
        }
        PartitionMigrations migrations = this.getMigrations();
        if (migrations == null) {
            return RepNodeAdmin.PartitionMigrationState.UNKNOWN.setCause(new Exception("Unable to read migration record db"));
        }
        PartitionMigrations.TargetRecord record = migrations.getTarget(partitionId);
        return record == null ? null : record.getState();
    }

    public synchronized boolean canceled(PartitionId partitionId, RepGroupId targetRGId) {
        if (!this.isMaster()) {
            return false;
        }
        this.logger.log(Level.INFO, "Canceling source migration of {0} to {1}", new Object[]{partitionId, targetRGId});
        this.migrationService.cancel(partitionId, targetRGId);
        PartitionMigrations migrations = this.getMigrations();
        if (migrations == null) {
            return false;
        }
        PartitionMigrations.MigrationRecord record = migrations.get(partitionId);
        if (record == null) {
            return true;
        }
        if (record.isCompleted() && record.getTargetRGId().equals(targetRGId) && record.getSourceRGId().getGroupId() == this.repNode.getRepNodeId().getGroupId()) {
            this.logger.log(Level.INFO, "Removing {0}", record);
            try {
                this.removeRecord(record, true);
            }
            catch (DatabaseException de) {
                this.logger.log(Level.WARNING, "Exception removing " + record, de);
                return false;
            }
        }
        return true;
    }

    @Override
    public Topology localizeTopology(Topology topology) {
        if (topology == null) {
            return null;
        }
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null) {
            return null;
        }
        this.openMigrationDb(repEnv);
        PartitionMigrations migrations = this.getMigrations();
        if (migrations == null) {
            return null;
        }
        int topoSeqNum = topology.getSequenceNumber();
        if (migrations.getTopoSequenceNum() > topoSeqNum) {
            this.logger.log(Level.INFO, "Cannot localize topology seq#: {0} because it is < migration topology seq#: {1}", new Object[]{topoSeqNum, migrations.getTopoSequenceNum()});
            return null;
        }
        this.logger.log(Level.FINE, "Localizing topology seq#: {0}", topoSeqNum);
        Topology copy = topology.getCopy();
        boolean modified = false;
        Iterator<PartitionMigrations.MigrationRecord> itr = migrations.completed();
        while (itr.hasNext()) {
            PartitionMigrations.MigrationRecord record = itr.next();
            this.logger.log(Level.FINE, "Checking {0}", record);
            PartitionId partitionId = record.getPartitionId();
            RepGroupId targetRGId = record.getTargetRGId();
            if (targetRGId.equals(copy.get(partitionId).getRepGroupId())) {
                this.logger.log(Level.INFO, "ToO completed for {0} by topology seq#: {1}", new Object[]{partitionId, topoSeqNum});
                if (!repEnv.getState().isMaster()) continue;
                try {
                    if (!this.updateTopoSeqNum(topoSeqNum)) continue;
                    if (record.getSourceRGId().equals(new RepGroupId(this.repNode.getRepNodeId().getGroupId()))) {
                        this.repNode.getTableManager().notifyRemoval(partitionId);
                        this.removePartitionDb(partitionId, repEnv);
                        this.removeRecord(record, false);
                        continue;
                    }
                    this.removeRecord(record, false);
                }
                catch (LockConflictException lce) {
                    this.logger.log(Level.FINE, "Lock conflict removing " + record, lce);
                }
                catch (DatabaseException de) {
                    this.logger.log(Level.INFO, "Exception removing " + record, de);
                }
                continue;
            }
            this.logger.log(Level.INFO, "Moving {0} to {1} locally", new Object[]{partitionId, targetRGId});
            copy.updatePartition(partitionId, targetRGId);
            modified = true;
        }
        return modified ? copy : topology;
    }

    private boolean updateTopoSeqNum(final int seqNum) {
        final TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY).setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
        Boolean success = this.tryDBOperation(new DBOperation<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call(Database db) {
                Boolean bl;
                Transaction txn = null;
                try {
                    txn = db.getEnvironment().beginTransaction(null, txnConfig);
                    PartitionMigrations pMigrations = PartitionMigrations.fetch(db, txn);
                    pMigrations.setTopoSequenceNum(seqNum);
                    pMigrations.persist(db, txn, false);
                    txn.commit();
                    txn = null;
                    bl = true;
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
                TxnUtil.abort(txn);
                return bl;
            }
        }, false);
        return success == null ? false : success;
    }

    private void removePartitionDb(PartitionId partitionId, ReplicatedEnvironment repEnv) {
        String dbName = partitionId.getPartitionName();
        this.logger.log(Level.INFO, "Removing database {0} for moved {1}", new Object[]{dbName, partitionId});
        try {
            repEnv.removeDatabase(null, dbName);
        }
        catch (DatabaseNotFoundException ignore) {
            // empty catch block
        }
    }

    private synchronized void openMigrationDb(ReplicatedEnvironment repEnv) {
        while (this.migrationDb == null && !this.shutdown) {
            this.logger.log(Level.FINE, "Open partition migration DB: {0}", this);
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(true);
            try {
                if (repEnv.getState().isReplica()) {
                    dbConfig.getTriggers().add(new CompletionTrigger());
                }
                this.migrationDb = PartitionMigrations.openDb((Environment)repEnv, dbConfig);
                assert (this.migrationDb != null);
                return;
            }
            catch (DatabaseException de) {
                if (!repEnv.isValid()) {
                    return;
                }
            }
            catch (IllegalStateException ise) {
                if (!repEnv.isValid()) {
                    return;
                }
                throw ise;
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
    }

    private synchronized void closeMigrationDb() {
        if (this.migrationDb == null) {
            return;
        }
        this.logger.fine("Close partition migration db");
        TxnUtil.close(this.logger, this.migrationDb, "migration");
        this.migrationDb = null;
    }

    PartitionMigrations getMigrations() {
        if (this.migrationDb == null) {
            return null;
        }
        try {
            return this.tryDBOperation(new DBOperation<PartitionMigrations>(){

                @Override
                public PartitionMigrations call(Database db) {
                    return PartitionMigrations.fetch(db);
                }
            }, false);
        }
        catch (DatabaseException de) {
            this.logger.log(Level.INFO, "Exception accessing the migration db {0}", de);
            return null;
        }
    }

    void removeRecord(PartitionMigrations.MigrationRecord record, boolean affectsTopo) {
        this.removeRecord(record.getPartitionId(), record.getId(), affectsTopo);
    }

    void removeRecord(final PartitionId partitionId, final long recordId, final boolean affectsTopo) {
        Boolean removed;
        final TransactionConfig txnConfig = new TransactionConfig();
        txnConfig.setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        if (affectsTopo) {
            txnConfig.setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
        }
        if ((removed = this.tryDBOperation(new DBOperation<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call(Database db) {
                PartitionMigrations pMigrations;
                Transaction txn;
                block5: {
                    PartitionMigrations.MigrationRecord record;
                    block4: {
                        Boolean bl;
                        txn = null;
                        try {
                            txn = db.getEnvironment().beginTransaction(null, txnConfig);
                            pMigrations = PartitionMigrations.fetch(db, txn);
                            record = pMigrations.remove(partitionId);
                            if (record != null) break block4;
                            MigrationManager.this.logger.log(Level.FINE, "removeRecord: No record for {0}", partitionId);
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            TxnUtil.abort(txn);
                            throw throwable;
                        }
                        TxnUtil.abort(txn);
                        return bl;
                    }
                    if (record.getId() == recordId) break block5;
                    Boolean bl = false;
                    TxnUtil.abort(txn);
                    return bl;
                }
                pMigrations.persist(db, txn, affectsTopo);
                txn.commit();
                txn = null;
                Boolean bl = true;
                TxnUtil.abort(txn);
                return bl;
            }
        }, affectsTopo)) == null) {
            return;
        }
        if (removed.booleanValue() && affectsTopo) {
            this.updateLocalTopology();
        }
    }

    boolean updateLocalTopology() {
        Boolean success = null;
        try {
            success = this.tryDBOperation(new DBOperation<Boolean>(){

                @Override
                public Boolean call(Database db) {
                    return MigrationManager.this.repNode.updateLocalTopology();
                }
            }, true);
        }
        catch (DatabaseException de) {
            this.logger.log(Level.INFO, "Exception updating local topology: {0}", de);
        }
        return success == null ? false : success;
    }

    void criticalUpdate() {
        block3: {
            try {
                if (!this.updateLocalTopology()) {
                    throw new IllegalStateException("Unable to update local topology in critical section");
                }
            }
            catch (Exception ex) {
                if (this.shutdown) break block3;
                this.repNode.getExceptionHandler().uncaughtException(Thread.currentThread(), ex);
            }
        }
    }

    synchronized void monitorTarget() {
        if (!this.isMaster()) {
            return;
        }
        if (this.targetMonitorExecutor == null) {
            this.targetMonitorExecutor = new TargetMonitorExecutor(this, this.repNode, this.logger);
        }
        this.targetMonitorExecutor.monitorTarget();
    }

    <T> T tryDBOperation(DBOperation<T> op, boolean retryIAE) {
        int retryCount = 100;
        while (!this.shutdown) {
            try {
                Database db = this.migrationDb;
                if (db != null) {
                    return op.call(db);
                }
                if (retryCount <= 0) {
                    return null;
                }
                this.retrySleep(retryCount, 1000L, null);
            }
            catch (InsufficientAcksException iae) {
                if (!retryIAE) {
                    throw iae;
                }
                this.retrySleep(retryCount, 1000L, (DatabaseException)((Object)iae));
            }
            catch (InsufficientReplicasException ire) {
                this.retrySleep(retryCount, 1000L, (DatabaseException)((Object)ire));
            }
            catch (LockConflictException lce) {
                this.retrySleep(retryCount, 500L, (DatabaseException)((Object)lce));
            }
            --retryCount;
        }
        return null;
    }

    private void retrySleep(int count, long sleepTime, DatabaseException de) {
        this.logger.log(Level.FINE, "DB op caused {0} attempts left {1}", new Object[]{de, count});
        if (count <= 0) {
            throw de;
        }
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException(ie);
        }
    }

    void setLastMigrationDuration(long duration) {
        this.lastMigrationDuration = duration;
    }

    public void setReadHook(TestHook<DatabaseEntry> hook) {
        this.migrationService.setReadHook(hook);
    }

    public void setResponseHook(TestHook<AtomicReference<ServiceDispatcher.Response>> hook) {
        this.migrationService.setResponseHook(hook);
    }

    public String toString() {
        return "MigrationManager[" + this.repNode.getRepNodeId() + ", " + this.isMaster + ", " + this.completedSequenceNum + "]";
    }

    private class CompletionTrigger
    implements TransactionTrigger,
    ReplicatedDatabaseTrigger {
        private String dbName;

        private CompletionTrigger() {
        }

        public void repeatTransaction(Transaction t) {
        }

        public void repeatAddTrigger(Transaction t) {
        }

        public void repeatRemoveTrigger(Transaction t) {
        }

        public void repeatCreate(Transaction t) {
        }

        public void repeatRemove(Transaction t) {
        }

        public void repeatTruncate(Transaction t) {
        }

        public void repeatRename(Transaction t, String string) {
        }

        public void repeatPut(Transaction t, DatabaseEntry key, DatabaseEntry newData) {
        }

        public void repeatDelete(Transaction t, DatabaseEntry key) {
        }

        public String getName() {
            return "CompletionTrigger";
        }

        public Trigger setDatabaseName(String string) {
            this.dbName = string;
            return this;
        }

        public String getDatabaseName() {
            return this.dbName;
        }

        public void addTrigger(Transaction t) {
        }

        public void removeTrigger(Transaction t) {
        }

        public void put(Transaction t, DatabaseEntry key, DatabaseEntry oldData, DatabaseEntry newData) {
        }

        public void delete(Transaction t, DatabaseEntry key, DatabaseEntry oldData) {
        }

        public void commit(Transaction t) {
            if (MigrationManager.this.shutdown) {
                return;
            }
            MigrationManager.this.logger.fine("Received commit trigger");
            ReplicatedEnvironment env = MigrationManager.this.repNode.getEnv(0L);
            try {
                if (env == null || !env.getState().isReplica()) {
                    MigrationManager.this.logger.info("Environment changed, ignoring trigger");
                    return;
                }
            }
            catch (EnvironmentFailureException efe) {
                MigrationManager.this.logger.info("Environment changing, ignoring trigger");
                return;
            }
            catch (IllegalStateException ise) {
                MigrationManager.this.logger.info("Environment closed, ignoring trigger");
                return;
            }
            PartitionMigrations migrations = MigrationManager.this.getMigrations();
            if (migrations == null) {
                throw new IllegalStateException("unable to access migration db from commit trigger");
            }
            long seqNum = migrations.getChangeNumber();
            if (seqNum != MigrationManager.this.completedSequenceNum) {
                MigrationManager.this.logger.info("Partition migration db has been modified, updating local topology");
                if (!MigrationManager.this.updateLocalTopology()) {
                    throw new IllegalStateException("update of local topology failed from commit trigger");
                }
                MigrationManager.this.completedSequenceNum = seqNum;
            }
        }

        public void abort(Transaction t) {
        }
    }

    private class MigrationStateTracker
    extends StateTracker {
        MigrationStateTracker(Logger logger) {
            super(MigrationStateTracker.class.getSimpleName(), MigrationManager.this.repNode, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doNotify(StateChangeEvent sce) {
            if (this.shutdown.get()) {
                return;
            }
            this.logger.log(Level.INFO, "Migration manager change state to {0}.", (Object)sce.getState());
            MigrationManager migrationManager = MigrationManager.this;
            synchronized (migrationManager) {
                MigrationManager.this.isMaster = sce.getState().isMaster();
                if (MigrationManager.this.isMaster) {
                    MigrationManager.this.startServices();
                } else {
                    MigrationManager.this.stopServices(false);
                }
            }
        }
    }

    private class TargetExecutor
    extends ScheduledThreadPoolExecutor {
        private RepGroupId lastSource;
        private long adjustment;

        TargetExecutor() {
            super(MigrationManager.this.concurrentTargetLimit, new KVThreadFactory(" partition migration target", MigrationManager.this.logger));
            this.lastSource = null;
            this.adjustment = 0L;
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }

        synchronized void submitNew(MigrationTarget target) {
            long delay = 0L;
            if (target.getSource().equals(this.lastSource)) {
                delay = 2000L + this.adjustment;
                this.adjustment += 2000L;
            } else {
                this.lastSource = target.getSource();
                this.adjustment = 0L;
            }
            this.schedule(target, delay, "start");
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                MigrationManager.this.logger.log(Level.INFO, "Target execution failed", t);
                return;
            }
            if (this.isShutdown()) {
                return;
            }
            Future f = (Future)((Object)r);
            MigrationTarget target = null;
            try {
                target = (MigrationTarget)f.get();
            }
            catch (Exception ex) {
                MigrationManager.this.logger.log(Level.WARNING, "Exception getting target", ex);
            }
            if (target == null) {
                return;
            }
            if (MigrationManager.this.repNode.getTableManager().isBusyMaintenance()) {
                MigrationManager.this.logger.log(Level.FINE, "Unable to restart {0}, table operations in progress", target);
                MigrationManager.this.removeTarget(target.getPartitionId());
                return;
            }
            long delay = MigrationManager.this.lastMigrationDuration;
            if (delay < 2000L) {
                delay = 2000L;
            }
            if (delay > target.getRetryWait()) {
                delay = target.getRetryWait();
            }
            if (delay < 0L) {
                return;
            }
            this.schedule(target, delay, "restart");
        }

        private void schedule(MigrationTarget target, long delay, String msg) {
            MigrationManager.this.logger.log(Level.FINE, "Scheduling {0} to {1} in {2}ms", new Object[]{target, msg, delay});
            try {
                this.schedule(target, delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException ree) {
                if (this.isShutdown()) {
                    MigrationManager.this.logger.log(Level.FINE, "Failed to {0} {1}, executor shutdown", new Object[]{msg, target});
                } else {
                    MigrationManager.this.logger.log(Level.WARNING, "Failed to " + msg + " " + target, ree);
                }
                MigrationManager.this.removeTarget(target.getPartitionId());
            }
        }
    }

    static interface DBOperation<V> {
        public V call(Database var1);
    }
}

