/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.masterBalance;

import com.sleepycat.je.rep.StateChangeEvent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.StateTracker;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.masterBalance.MasterBalancingInterface;
import oracle.kv.impl.util.registry.RegistryUtils;

public class MasterBalanceStateTracker
extends StateTracker {
    private static final String THREAD_NAME = MasterBalanceStateTracker.class.getSimpleName();
    private volatile StorageNodeAgentAPI sna;
    private static final int RMI_RETRY_PERIOD_MS = 1000;

    public MasterBalanceStateTracker(RepNode rn, Logger logger) {
        super(THREAD_NAME, rn, logger);
    }

    @Override
    protected void doNotify(StateChangeEvent sce) throws InterruptedException {
        if (!this.ensureTopology()) {
            return;
        }
        if (this.sna == null) {
            this.sna = this.getSNAHandle();
        }
        if (this.sna == null) {
            return;
        }
        int seqNum = this.getTopoSeqNum();
        MasterBalancingInterface.StateInfo stateInfo = new MasterBalancingInterface.StateInfo(this.rn.getRepNodeId(), sce.getState(), seqNum);
        while (true) {
            try {
                this.sna.noteState(stateInfo);
            }
            catch (RemoteException e) {
                if (this.shutdown.get()) {
                    return;
                }
                if (!this.isEmpty()) break;
                Thread.sleep(1000L);
                if (this.isEmpty()) continue;
            }
            break;
        }
    }

    protected boolean ensureTopology() throws InterruptedException {
        while (this.rn.getTopology() == null) {
            if (this.shutdown.get()) {
                return false;
            }
            Thread.sleep(1000L);
        }
        return true;
    }

    private StorageNodeAgentAPI getSNAHandle() throws InterruptedException {
        String storeName = this.rn.getGlobalParams().getKVStoreName();
        StorageNodeParams snp = this.rn.getStorageNodeParams();
        for (int retryCount = 0; retryCount < Integer.MAX_VALUE; ++retryCount) {
            Exception retryException = null;
            if (this.shutdown.get()) {
                return null;
            }
            try {
                return RegistryUtils.getStorageNodeAgent(storeName, snp, snp.getStorageNodeId(), this.rn.getLoginManager());
            }
            catch (RemoteException e) {
                retryException = e;
            }
            catch (NotBoundException e) {
                retryException = e;
            }
            if (retryCount % 10 == 0) {
                this.logger.info("Retrying to obtain SNA handle:" + retryException.getMessage());
            }
            Thread.sleep(1000L);
        }
        throw new IllegalStateException("Unreachable code");
    }

    protected int getTopoSeqNum() {
        return this.rn.getTopology().getSequenceNumber();
    }

    @Override
    public int initiateSoftShutdown() {
        assert (this.shutdown.get());
        if (this.sna == null) {
            return 1;
        }
        return super.initiateSoftShutdown();
    }
}

