/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.login;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import javax.security.auth.Subject;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.login.LoginSession;

public class KVSession {
    static final int VERSION = 2;
    static final int NEXT_VERSION = 3;
    private byte version;
    private byte[] sessionId;
    private String userId;
    private String userName;
    private String[] roles;
    private String clientHost;
    private long sessionExpire;
    byte[] remainder;

    private KVSession(byte version) {
        this.version = version;
    }

    public KVSession(LoginSession session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("session may not be null");
        }
        this.version = (byte)2;
        byte[] idValue = session.getId().getValue();
        this.sessionId = Arrays.copyOf(idValue, idValue.length);
        Subject subj = session.getSubject();
        KVStoreUserPrincipal userPrinc = KVStoreUserPrincipal.getSubjectUser(subj);
        if (userPrinc == null) {
            throw new IllegalArgumentException("No user principal associated with the login session");
        }
        this.userId = userPrinc.getUserId();
        this.userName = userPrinc.getName();
        this.roles = KVStoreRolePrincipal.getSubjectRoleNames(subj);
        if (this.roles == null) {
            this.roles = new String[0];
        }
        this.clientHost = session.getClientHost();
        this.sessionExpire = session.getExpireTime();
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(this.version);
        dos.write(this.sessionId.length);
        dos.write(this.sessionId, 0, this.sessionId.length);
        if (this.userId == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.userId);
        }
        if (this.userName == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.userName);
        }
        if (this.clientHost == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.clientHost);
        }
        dos.write(this.roles.length);
        for (int i = 0; i < this.roles.length; ++i) {
            dos.writeUTF(RoleInstance.getR3CompatName(this.roles[i]));
        }
        dos.writeLong(this.sessionExpire);
        if (this.remainder != null) {
            dos.write(this.remainder, 0, this.remainder.length);
        }
        dos.close();
        return baos.toByteArray();
    }

    public static KVSession fromByteArray(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        byte version = dis.readByte();
        if (version < 1 || version > 3) {
            throw new IOException("Unsupported version: " + version);
        }
        KVSession session = new KVSession(version);
        byte sidLen = dis.readByte();
        session.sessionId = new byte[sidLen];
        dis.readFully(session.sessionId);
        boolean haveUserId = dis.readBoolean();
        session.userId = haveUserId ? dis.readUTF() : null;
        boolean haveUserName = dis.readBoolean();
        session.userName = haveUserName ? dis.readUTF() : null;
        boolean haveClientHost = dis.readBoolean();
        session.clientHost = haveClientHost ? dis.readUTF() : null;
        int nRoles = dis.readByte();
        session.roles = new String[nRoles];
        for (int i = 0; i < nRoles; ++i) {
            session.roles[i] = RoleInstance.getNormalizedName(dis.readUTF());
        }
        session.sessionExpire = dis.readLong();
        if (version == 3) {
            byte[] buffer = new byte[data.length];
            int bytesRead = dis.read(buffer);
            if (bytesRead > 0) {
                session.remainder = Arrays.copyOfRange(buffer, 0, bytesRead);
            }
        } else {
            int read = dis.read(new byte[1]);
            if (read > 0) {
                throw new IOException("Encountered unexpected data");
            }
        }
        dis.close();
        return session;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getSessionExpire() {
        return this.sessionExpire;
    }

    public String[] getUserRoles() {
        return this.roles;
    }

    public void setSessionExpire(long expireTime) {
        this.sessionExpire = expireTime;
    }

    public void setUserRoles(String[] roles) {
        this.roles = roles;
    }

    public LoginSession makeLoginSession() {
        LoginSession sess = new LoginSession(new LoginSession.Id(this.sessionId), this.makeSubject(), this.clientHost, true);
        sess.setExpireTime(this.sessionExpire);
        return sess;
    }

    void setVersion(byte version) {
        if (version < 2) {
            throw new IllegalArgumentException("Version earlier than 2 is deprecated");
        }
        this.version = version;
    }

    private Subject makeSubject() {
        HashSet<Principal> princs = new HashSet<Principal>();
        princs.add(new KVStoreUserPrincipal(this.userName, this.userId));
        for (String role : this.roles) {
            KVStoreRolePrincipal princ = KVStoreRolePrincipal.get(role);
            princs.add(princ);
        }
        HashSet publicCreds = new HashSet();
        HashSet privateCreds = new HashSet();
        return new Subject(true, princs, publicCreds, privateCreds);
    }
}

