/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.login;

import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.kv.impl.rep.login.KVSessionManager;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginSession;
import oracle.kv.impl.security.login.SessionManager;

public class FailoverSessionManager
implements SessionManager {
    public static final byte[] MEMORY_PREFIX = new byte[]{0};
    public static final byte[] PERSISTENT_PREFIX = new byte[]{1};
    private final Logger logger;
    private final KVSessionManager kvSessMgr;
    private final SessionManager tableSessMgr;

    public FailoverSessionManager(KVSessionManager kvSessMgr, SessionManager tableSessMgr, Logger logger) {
        this.kvSessMgr = kvSessMgr;
        this.tableSessMgr = tableSessMgr;
        this.logger = logger;
    }

    @Override
    public LoginSession createSession(Subject subject, String clientHost, long expireTime) {
        try {
            LoginSession session = this.kvSessMgr.createSession(subject, clientHost, expireTime);
            if (session != null) {
                return session;
            }
            this.logger.info("Persistent session manager failed to create a new session.");
        }
        catch (SessionAccessException sae) {
            this.logger.info("Persistent session manager encountered  exception: " + sae);
        }
        return this.tableSessMgr.createSession(subject, clientHost, expireTime);
    }

    @Override
    public LoginSession lookupSession(LoginSession.Id sessionId) throws SessionAccessException {
        if (sessionId.beginsWith(PERSISTENT_PREFIX)) {
            return this.kvSessMgr.lookupSession(sessionId);
        }
        return this.tableSessMgr.lookupSession(sessionId);
    }

    @Override
    public LoginSession updateSessionExpiration(LoginSession.Id sessionId, long newExpireTime) throws SessionAccessException {
        if (sessionId.beginsWith(PERSISTENT_PREFIX)) {
            return this.kvSessMgr.updateSessionExpiration(sessionId, newExpireTime);
        }
        return this.tableSessMgr.updateSessionExpiration(sessionId, newExpireTime);
    }

    @Override
    public void logoutSession(LoginSession.Id sessionId) throws SessionAccessException {
        if (sessionId.beginsWith(PERSISTENT_PREFIX)) {
            this.kvSessMgr.logoutSession(sessionId);
        } else {
            this.tableSessMgr.logoutSession(sessionId);
        }
    }

    @Override
    public List<LoginSession.Id> lookupSessionByUser(String userName) {
        try {
            return this.kvSessMgr.lookupSessionByUser(userName);
        }
        catch (SessionAccessException sae) {
            this.logger.info("Persistent session manager encountered  exception: " + sae);
            return this.tableSessMgr.lookupSessionByUser(userName);
        }
    }

    @Override
    public void updateSessionSubject(LoginSession.Id sessionId, Subject subject) throws SessionAccessException, IllegalArgumentException {
        if (sessionId.beginsWith(PERSISTENT_PREFIX)) {
            this.kvSessMgr.updateSessionSubject(sessionId, subject);
        } else {
            this.tableSessMgr.updateSessionSubject(sessionId, subject);
        }
    }
}

