/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.fault.ProcessFaultException;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.VersionUtil;

public class VersionManager {
    private static final String VERSION_DATABASE_NAME = "VersionDatabase";
    private static final String VERSION_KEY = "LocalVersion";
    private static final DatabaseEntry VKEY_ENTRY = new DatabaseEntry();
    private final RepNode repNode;
    private final Logger logger;

    public VersionManager(Logger logger, RepNode repNode) {
        this.logger = logger;
        this.repNode = repNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkCompatibility(Environment env) {
        Database vdb = null;
        try {
            vdb = VersionManager.openDb(env);
            KVVersion localVersion = VersionManager.getLocalVersion(vdb);
            if (localVersion != null) {
                if (localVersion.equals(KVVersion.CURRENT_VERSION)) {
                    return;
                }
                try {
                    VersionUtil.checkUpgrade(localVersion);
                }
                catch (IllegalStateException ise) {
                    throw new ProcessFaultException(ise.getMessage(), ise);
                }
            }
            this.repNode.versionChange(env, localVersion);
            DatabaseEntry vdata = new DatabaseEntry(SerializationUtil.getBytes(KVVersion.CURRENT_VERSION));
            OperationStatus status = vdb.put(null, VKEY_ENTRY, vdata);
            if (status != OperationStatus.SUCCESS) {
                throw new IllegalStateException("Could not install new version");
            }
            DbInternal.getEnvironmentImpl((Environment)env).getLogManager().flush();
            this.logger.info("Local Environment version updated to: " + KVVersion.CURRENT_VERSION + " Previous version: " + (localVersion == null ? " none" : localVersion.getVersionString()));
        }
        finally {
            if (vdb != null) {
                TxnUtil.close(this.logger, vdb, "version");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KVVersion getLocalVersion(Logger logger, Environment env) {
        Database db = null;
        try {
            db = VersionManager.openDb(env);
            KVVersion kVVersion = VersionManager.getLocalVersion(db);
            return kVVersion;
        }
        finally {
            if (db != null) {
                TxnUtil.close(logger, db, "version");
            }
        }
    }

    private static KVVersion getLocalVersion(Database versionDB) {
        DatabaseEntry vdata = new DatabaseEntry();
        OperationStatus status = versionDB.get(null, VKEY_ENTRY, vdata, LockMode.DEFAULT);
        return status == OperationStatus.SUCCESS ? SerializationUtil.getObject(vdata.getData(), KVVersion.class) : null;
    }

    private static Database openDb(Environment env) {
        DatabaseConfig dbConfig = new DatabaseConfig().setTransactional(false).setAllowCreate(true).setReplicated(false);
        return env.openDatabase(null, VERSION_DATABASE_NAME, dbConfig);
    }

    static {
        StringBinding.stringToEntry((String)VERSION_KEY, (DatabaseEntry)VKEY_ENTRY);
    }
}

