/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.InvalidSignatureException;
import oracle.kv.impl.security.SignatureFaultException;
import oracle.kv.impl.security.SignatureHelper;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.server.LoggerUtils;

public class TopoSignatureManager
implements TopologyManager.PostUpdateListener,
TopologyManager.PreUpdateListener {
    private final SignatureHelper<Topology> topoSignatureHelper;
    private final Logger logger;

    public TopoSignatureManager(SignatureHelper<Topology> topoSignatureHelper, Logger logger) {
        this.topoSignatureHelper = topoSignatureHelper;
        this.logger = logger;
    }

    @Override
    public void preUpdate(Topology topology) throws InvalidSignatureException {
        if (this.isInternalUpdater()) {
            return;
        }
        if (this.topoSignatureHelper != null && !this.verifyTopology(topology)) {
            throw new InvalidSignatureException("Invalid signature for topology with seq# " + topology.getSequenceNumber());
        }
    }

    @Override
    public boolean postUpdate(Topology topology) {
        if (this.topoSignatureHelper != null && topology.getSignature() == null) {
            this.signTopology(topology);
        }
        return false;
    }

    private boolean isInternalUpdater() {
        if (ExecutionContext.getCurrent() == null) {
            return true;
        }
        return ExecutionContext.getCurrentPrivileges().implies(SystemPrivilege.INTLOPER);
    }

    private void signTopology(Topology topo) {
        try {
            byte[] sigBytes = this.topoSignatureHelper.sign(topo);
            topo.updateSignature(sigBytes);
            this.logger.log(Level.INFO, "Updated signature for topology seq# {0}", topo.getSequenceNumber());
        }
        catch (SignatureFaultException sfe) {
            this.logger.log(Level.WARNING, "Failed to generate signature for topology of seq# {0} for {1}", new Object[]{topo.getSequenceNumber(), sfe});
        }
    }

    private boolean verifyTopology(Topology topo) {
        byte[] sigBytes = topo.getSignature();
        if (sigBytes == null || sigBytes.length == 0) {
            this.logger.log((Level)LoggerUtils.SecurityLevel.SEC_WARNING, "Empty signature. Verification failed for topology seq# {0}", topo.getSequenceNumber());
            return false;
        }
        try {
            boolean passedCheck = this.topoSignatureHelper.verify(topo, sigBytes);
            this.logger.log(passedCheck ? Level.INFO : LoggerUtils.SecurityLevel.SEC_WARNING, "Signature verification {0} for topology with seq# {1}", new Object[]{passedCheck ? "passed" : "failed", topo.getSequenceNumber()});
            return passedCheck;
        }
        catch (SignatureFaultException sfe) {
            this.logger.log(Level.WARNING, "Problem verifying signature for topology with seq# {0}: {1}", new Object[]{topo.getSequenceNumber(), sfe});
            return false;
        }
    }
}

