/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.api.rgstate.UpdateThread;
import oracle.kv.impl.api.rgstate.UpdateThreadPoolExecutor;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

public class MetadataUpdateThread
extends UpdateThread {
    private final RepNode repNode;
    private static final int UPDATE_THREAD_PERIOD_MS = 2000;
    private final Map<Metadata.MetadataType, Semaphore> pullsInProgress = new EnumMap<Metadata.MetadataType, Semaphore>(Metadata.MetadataType.class);
    private int nextGroup;

    public MetadataUpdateThread(RequestDispatcher requestDispatcher, RepNode repNode, Logger logger) {
        super(requestDispatcher, 2000, requestDispatcher.getExceptionHandler(), logger);
        this.repNode = repNode;
        this.nextGroup = repNode.getRepNodeId().getGroupId() + 1;
        for (Metadata.MetadataType type : Metadata.MetadataType.values()) {
            this.pullsInProgress.put(type, new Semaphore(1));
        }
    }

    @Override
    protected void doUpdate() {
        Topology topo = this.repNode.getTopology();
        if (topo == null) {
            return;
        }
        Set<RepGroupId> groups = topo.getRepGroupIds();
        if (groups.size() < 2) {
            return;
        }
        if (this.nextGroup > groups.size()) {
            this.nextGroup = 1;
        }
        if (this.nextGroup == this.repNode.getRepNodeId().getGroupId()) {
            ++this.nextGroup;
            return;
        }
        RepGroupState rgState = this.getRepGroupState(new RepGroupId(this.nextGroup));
        this.threadPool.tunePoolSize(topo.getRepNodeIds().size());
        for (Metadata.MetadataType checkType : Metadata.MetadataType.values()) {
            if (this.shutdown.get()) {
                return;
            }
            if (checkType == Metadata.MetadataType.TOPOLOGY) continue;
            try {
                this.checkMetadata(checkType, rgState);
            }
            catch (Exception e) {
                if (this.shutdown.get()) {
                    return;
                }
                this.logOnFailure(this.repNode.getRepNodeId(), e, "Exception attempting to update " + (Object)((Object)checkType) + " metadata");
            }
        }
        ++this.nextGroup;
    }

    private void checkMetadata(Metadata.MetadataType type, RepGroupState rgState) {
        int localSeqNum = this.repNode.getMetadataSeqNum(type);
        int rgSeqNum = rgState.getSeqNum(type);
        if (rgSeqNum >= localSeqNum) {
            return;
        }
        for (RepNodeState rnState : rgState.getRepNodeStates()) {
            if (this.shutdown.get()) {
                return;
            }
            if (this.needsResolution(rnState)) continue;
            this.threadPool.execute(new UpdateMetadata(rgState, rnState, type));
        }
    }

    private class UpdateMetadata
    implements UpdateThreadPoolExecutor.UpdateTask {
        private final RepGroupState rgState;
        private final RepNodeState rnState;
        private final Metadata.MetadataType type;

        public UpdateMetadata(RepGroupState rgState, RepNodeState rnState, Metadata.MetadataType type) {
            this.rgState = rgState;
            this.rnState = rnState;
            this.type = type;
        }

        @Override
        public RepNodeId getResourceId() {
            return this.rnState.getRepNodeId();
        }

        @Override
        public void run() {
            MetadataUpdateThread.this.logger.log(Level.FINE, "Starting {0}", this);
            RepNodeId targetRNId = this.rnState.getRepNodeId();
            try {
                RegistryUtils regUtils = MetadataUpdateThread.this.requestDispatcher.getRegUtils();
                if (regUtils == null) {
                    return;
                }
                RepNodeAdminAPI rnAdmin = regUtils.getRepNodeAdmin(targetRNId);
                int rgSeqNum = this.rgState.updateSeqNum(this.type, rnAdmin.getMetadataSeqNum(this.type));
                int localSeqNum = MetadataUpdateThread.this.repNode.getMetadataSeqNum(this.type);
                if (localSeqNum > rgSeqNum) {
                    this.push(rgSeqNum, regUtils);
                } else if (localSeqNum < rgSeqNum) {
                    this.pull(localSeqNum, regUtils);
                }
            }
            catch (Exception e) {
                MetadataUpdateThread.this.logOnFailure(targetRNId, e, "Exception updating " + targetRNId);
            }
        }

        private void push(int rgSeqNum, RegistryUtils regUtils) {
            RepNodeId targetRNId = this.rnState.getRepNodeId();
            try {
                RepNodeAdminAPI rnAdmin = regUtils.getRepNodeAdmin(targetRNId);
                Metadata<?> md = MetadataUpdateThread.this.repNode.getMetadata(this.type);
                Object info = md.getChangeInfo(rgSeqNum);
                if (!info.isEmpty()) {
                    int updatedSeqNum = rnAdmin.updateMetadata((MetadataInfo)info);
                    this.rgState.updateSeqNum(this.type, updatedSeqNum);
                    if (updatedSeqNum >= rgSeqNum) {
                        MetadataUpdateThread.this.logger.log(Level.FINE, "Pushed {0} metadata changes [{1}] to {2}", new Object[]{this.type, info, targetRNId});
                        return;
                    }
                }
                rnAdmin.updateMetadata(md);
                this.rgState.updateSeqNum(this.type, md.getSequenceNumber());
                MetadataUpdateThread.this.logger.log(Level.INFO, "Pushed {0} to {1}", new Object[]{md, targetRNId});
            }
            catch (Exception e) {
                MetadataUpdateThread.this.logOnFailure(targetRNId, e, "Failed pushing " + (Object)((Object)this.type) + " metadata to " + targetRNId + ", target metadata seq number:" + rgSeqNum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pull(int localSeqNum, RegistryUtils regUtils) {
            ReplicatedEnvironment repEnv = MetadataUpdateThread.this.repNode.getEnv(1L);
            if (repEnv == null || !repEnv.getState().isMaster()) {
                return;
            }
            if (!((Semaphore)MetadataUpdateThread.this.pullsInProgress.get((Object)this.type)).tryAcquire()) {
                return;
            }
            RepNodeId targetRNId = this.rnState.getRepNodeId();
            try {
                RepNodeAdminAPI rnAdmin = regUtils.getRepNodeAdmin(targetRNId);
                MetadataInfo info = rnAdmin.getMetadata(this.type, localSeqNum);
                if (!info.isEmpty()) {
                    this.rgState.updateSeqNum(this.type, info.getSourceSeqNum());
                    MetadataUpdateThread.this.repNode.updateMetadata(info);
                    MetadataUpdateThread.this.logger.log(Level.FINE, "Pulled {0} metadata changes from {1}, updated to: {2}", new Object[]{this.type, targetRNId, MetadataUpdateThread.this.repNode.getMetadata(this.type)});
                    return;
                }
                Metadata<?> md = rnAdmin.getMetadata(this.type);
                if (md != null) {
                    this.rgState.updateSeqNum(this.type, md.getSequenceNumber());
                    if (MetadataUpdateThread.this.repNode.updateMetadata(md)) {
                        MetadataUpdateThread.this.logger.log(Level.FINE, "Pulled {0} from {1}", new Object[]{md, targetRNId});
                    } else {
                        MetadataUpdateThread.this.logger.log(Level.FINE, "Unable to update {0} pulled from {1}", new Object[]{md, targetRNId});
                    }
                }
            }
            catch (Exception e) {
                MetadataUpdateThread.this.logOnFailure(targetRNId, e, "Failed pulling " + (Object)((Object)this.type) + " metadata from " + targetRNId);
            }
            finally {
                ((Semaphore)MetadataUpdateThread.this.pullsInProgress.get((Object)this.type)).release();
            }
        }

        public String toString() {
            return "UpdateThread[" + (Object)((Object)this.type) + ", " + this.rnState.getRepNodeId() + "]";
        }
    }
}

