/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.trigger.ReplicatedDatabaseTrigger;
import com.sleepycat.je.trigger.TransactionTrigger;
import com.sleepycat.je.trigger.Trigger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.fault.DatabaseNotReadyException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.util.DatabaseUtils;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.server.LoggerUtils;

public abstract class MetadataManager<T extends Metadata<? extends MetadataInfo>>
implements TransactionTrigger,
ReplicatedDatabaseTrigger {
    private static final TransactionConfig NO_WAIT_CONFIG = new TransactionConfig().setDurability(new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE)).setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
    private static final TransactionConfig SYNC_SYNC_CONFIG = new TransactionConfig().setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
    private static final int DB_OPEN_RETRY_MS = 1000;
    private static final int NUM_DB_OP_RETRIES = 100;
    private static final long SHORT_RETRY_TIME = 500L;
    private static final long LONG_RETRY_TIME = 1000L;
    private final DatabaseEntry metadataKey = new DatabaseEntry();
    protected final RepNode repNode;
    protected final Logger logger;
    protected volatile boolean shutdown = false;
    private volatile Database metadataDatabase;
    private String dbName;

    protected MetadataManager(RepNode repNode, RepNodeService.Params params) {
        if (repNode == null) {
            throw new NullPointerException("repNode cannot be null");
        }
        this.repNode = repNode;
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        StringBinding.stringToEntry((String)this.getType().getKey(), (DatabaseEntry)this.metadataKey);
    }

    protected MetadataManager(RepNode repNode, Logger logger) {
        if (repNode == null) {
            throw new NullPointerException("repNode cannot be null");
        }
        this.repNode = repNode;
        this.logger = logger;
        StringBinding.stringToEntry((String)this.getType().getKey(), (DatabaseEntry)this.metadataKey);
    }

    protected abstract Metadata.MetadataType getType();

    protected abstract void update(ReplicatedEnvironment var1);

    protected synchronized void updateDbHandles(ReplicatedEnvironment repEnv, boolean reuseExistingHandles) {
        if (!reuseExistingHandles) {
            this.closeMetadataDb();
        }
        this.openMetadataDb(repEnv);
    }

    protected synchronized Database getMetadataDatabase() {
        if (this.metadataDatabase == null) {
            this.openMetadataDb(this.repNode.getEnv(1L));
        }
        return this.metadataDatabase;
    }

    protected synchronized void closeDbHandles() {
        this.closeMetadataDb();
    }

    protected void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T fetchMetadata() {
        if (this.metadataDatabase == null) {
            throw new DatabaseNotReadyException((Object)((Object)this.getType()) + " database is not ready.");
        }
        Transaction txn = this.metadataDatabase.getEnvironment().beginTransaction(null, NO_WAIT_CONFIG);
        try {
            DatabaseEntry value = new DatabaseEntry();
            this.metadataDatabase.get(txn, this.metadataKey, value, LockMode.READ_COMMITTED);
            Metadata metadata = SerializationUtil.getObject(value.getData(), Metadata.class);
            return (T)metadata;
        }
        finally {
            if (txn.isValid()) {
                txn.commit();
            } else {
                TxnUtil.abort(txn);
            }
        }
    }

    protected boolean persistMetadata(final T metadata) {
        Boolean success = this.tryDBOperation(new DBOperation<Boolean>(){
            final DatabaseEntry data;
            {
                this.data = new DatabaseEntry(SerializationUtil.getBytes(metadata));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call(Database db) {
                Boolean bl;
                Transaction txn = null;
                try {
                    txn = db.getEnvironment().beginTransaction(null, SYNC_SYNC_CONFIG);
                    db.put(txn, MetadataManager.this.metadataKey, this.data);
                    txn.commit();
                    txn = null;
                    bl = true;
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
                TxnUtil.abort(txn);
                return bl;
            }
        }, false);
        if (success == null || !success.booleanValue()) {
            return false;
        }
        this.logger.log(Level.INFO, "Metadata stored type: {0}, seq#: {1}", new Object[]{metadata.getType(), metadata.getSequenceNumber()});
        return true;
    }

    private void openMetadataDb(ReplicatedEnvironment repEnv) {
        assert (Thread.holdsLock(this));
        if (repEnv == null) {
            return;
        }
        while (this.metadataDatabase == null && !this.shutdown && repEnv.isValid()) {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true).setTransactional(true).getTriggers().add(this);
            try {
                this.metadataDatabase = this.openDb((Environment)repEnv, dbConfig);
                assert (this.metadataDatabase != null);
                this.logger.log(Level.INFO, "Open {0} DB", this.getDBName());
                return;
            }
            catch (RuntimeException re) {
                if (!DatabaseUtils.handleException(re, this.logger, this.getDBName())) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    throw new IllegalStateException(ie);
                }
            }
        }
    }

    private String getDBName() {
        return this.getType().getKey() + "Metadata";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database openDb(Environment env, DatabaseConfig dbConfig) {
        Database database;
        TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy((ReplicaConsistencyPolicy)NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        Transaction txn = null;
        Database db = null;
        try {
            txn = env.beginTransaction(null, txnConfig);
            db = env.openDatabase(txn, this.getDBName(), dbConfig);
            txn.commit();
            txn = null;
            Database ret = db;
            db = null;
            database = ret;
        }
        catch (Throwable throwable) {
            TxnUtil.abort(txn);
            if (db != null) {
                try {
                    db.close();
                }
                catch (DatabaseException de) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        TxnUtil.abort(txn);
        if (db != null) {
            try {
                db.close();
            }
            catch (DatabaseException de) {
                // empty catch block
            }
        }
        return database;
    }

    private synchronized void closeMetadataDb() {
        if (this.metadataDatabase == null) {
            return;
        }
        this.logger.log(Level.INFO, "Closing {0} db", this.getDBName());
        TxnUtil.close(this.logger, this.metadataDatabase, this.getDBName());
        this.metadataDatabase = null;
    }

    protected <R> R tryDBOperation(DBOperation<R> op, boolean retryIAE) {
        int retryCount = 100;
        while (!this.shutdown) {
            try {
                Database db = this.getMetadataDatabase();
                if (db != null) {
                    return op.call(db);
                }
                if (retryCount <= 0) {
                    return null;
                }
                this.retrySleep(retryCount, 1000L, null);
            }
            catch (InsufficientAcksException iae) {
                if (!retryIAE) {
                    throw iae;
                }
                this.retrySleep(retryCount, 1000L, (DatabaseException)((Object)iae));
            }
            catch (InsufficientReplicasException ire) {
                this.retrySleep(retryCount, 1000L, (DatabaseException)((Object)ire));
            }
            catch (LockConflictException lce) {
                this.retrySleep(retryCount, 500L, (DatabaseException)((Object)lce));
            }
            --retryCount;
        }
        return null;
    }

    private void retrySleep(int count, long sleepTime, DatabaseException de) {
        this.logger.log(Level.FINE, "DB op caused {0} attempts left {1}", new Object[]{de, count});
        if (count <= 0) {
            throw de;
        }
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException(ie);
        }
    }

    public void repeatTransaction(Transaction t) {
    }

    public void repeatAddTrigger(Transaction t) {
    }

    public void repeatRemoveTrigger(Transaction t) {
    }

    public void repeatCreate(Transaction t) {
    }

    public void repeatRemove(Transaction t) {
    }

    public void repeatTruncate(Transaction t) {
    }

    public void repeatRename(Transaction t, String string) {
    }

    public void repeatPut(Transaction t, DatabaseEntry key, DatabaseEntry newData) {
    }

    public void repeatDelete(Transaction t, DatabaseEntry key) {
    }

    public String getName() {
        return this.getType().getKey() + "CompletionTrigger";
    }

    public Trigger setDatabaseName(String string) {
        this.dbName = string;
        return this;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public void addTrigger(Transaction t) {
    }

    public void removeTrigger(Transaction t) {
    }

    public void put(Transaction t, DatabaseEntry key, DatabaseEntry oldData, DatabaseEntry newData) {
    }

    public void delete(Transaction t, DatabaseEntry key, DatabaseEntry oldData) {
    }

    public void commit(Transaction t) {
        if (this.shutdown) {
            return;
        }
        this.logger.log(Level.FINE, "Received trigger for {0}", this.getDBName());
        ReplicatedEnvironment repEnv = this.repNode.getEnv(0L);
        try {
            if (repEnv == null || !repEnv.getState().isReplica()) {
                this.logger.log(Level.INFO, "Environment changed, ignoring trigger for {0}", this.getDBName());
                return;
            }
        }
        catch (EnvironmentFailureException efe) {
            this.logger.log(Level.INFO, "Environment being re-established, ignoring trigger for {0}", this.getDBName());
            return;
        }
        catch (IllegalStateException ise) {
            this.logger.log(Level.INFO, "Environment closed, ignoring trigger for {0}", this.getDBName());
            return;
        }
        this.update(repEnv);
    }

    public void abort(Transaction t) {
    }

    public static interface DBOperation<V> {
        public V call(Database var1);
    }
}

