/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.param;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import oracle.kv.impl.param.BooleanParameter;
import oracle.kv.impl.param.CacheModeParameter;
import oracle.kv.impl.param.DurationParameter;
import oracle.kv.impl.param.IntParameter;
import oracle.kv.impl.param.LongParameter;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.param.StringParameter;

@Persistent
public abstract class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;

    public Parameter() {
        this.name = "";
    }

    public Parameter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract String asString();

    public abstract ParameterState.Type getType();

    public String toString() {
        return this.asString();
    }

    public boolean equals(Parameter other) {
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        String thisString = this.asString();
        String otherString = other.asString();
        if (thisString != null) {
            return thisString.equals(otherString);
        }
        return otherString == null;
    }

    public boolean restartRequired() {
        return ParameterState.restartRequired(this.name);
    }

    public boolean asBoolean() {
        this.unsupportedType("boolean");
        return false;
    }

    public int asInt() {
        this.unsupportedType("int");
        return 0;
    }

    public long asLong() {
        this.unsupportedType("long");
        return 0L;
    }

    public Enum<?> asEnum() {
        this.unsupportedType("enum");
        return null;
    }

    public static Parameter createKnownType(String name, String value, String type) {
        ParameterState.Type ptype = Enum.valueOf(ParameterState.Type.class, type);
        switch (ptype) {
            case INT: {
                return new IntParameter(name, value);
            }
            case LONG: {
                return new LongParameter(name, value);
            }
            case STRING: {
                return new StringParameter(name, value);
            }
            case BOOLEAN: {
                return new BooleanParameter(name, value);
            }
            case CACHEMODE: {
                return new CacheModeParameter(name, value);
            }
            case DURATION: {
                return new DurationParameter(name, value);
            }
        }
        return null;
    }

    private void unsupportedType(String type) {
        throw new IllegalStateException("Parameter (" + this.name + ") cannot be represented as " + type);
    }

    public static Parameter createParameter(String name, String value, ParameterState.Type type) {
        switch (type) {
            case INT: {
                int ivalue = Integer.parseInt(value);
                return new IntParameter(name, ivalue);
            }
            case LONG: {
                long lvalue = Long.parseLong(value);
                return new LongParameter(name, lvalue);
            }
            case BOOLEAN: {
                return new BooleanParameter(name, value);
            }
            case STRING: {
                return new StringParameter(name, value);
            }
            case CACHEMODE: {
                return new CacheModeParameter(name, value);
            }
            case DURATION: {
                return new DurationParameter(name, value);
            }
        }
        throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
    }

    public static Parameter createParameter(String name, String value, boolean ignoreUnknown) {
        ParameterState state = ParameterState.lookup(name);
        if (state != null) {
            if (value == null) {
                return null;
            }
            switch (state.getType()) {
                case INT: {
                    int ivalue = Integer.parseInt(value);
                    state.validate(name, ivalue, true);
                    return new IntParameter(name, ivalue);
                }
                case LONG: {
                    long lvalue = Long.parseLong(value);
                    state.validate(name, lvalue, true);
                    return new LongParameter(name, lvalue);
                }
                case BOOLEAN: {
                    return new BooleanParameter(name, value);
                }
                case STRING: {
                    return new StringParameter(name, value);
                }
                case CACHEMODE: {
                    return new CacheModeParameter(name, value);
                }
                case DURATION: {
                    return new DurationParameter(name, value);
                }
            }
        }
        if (ignoreUnknown) {
            return null;
        }
        throw new IllegalStateException("Invalid parameter: " + name);
    }

    public static Parameter createParameter(String name, String value) {
        return Parameter.createParameter(name, value, false);
    }
}

