/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.param;

import com.sleepycat.persist.model.Persistent;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterState;

@Persistent
public class DurationParameter
extends Parameter {
    private static final long serialVersionUID = 1L;
    private static final String[] allowedRegex = new String[]{"\\s+", "-", "_"};
    private TimeUnit unit;
    private long amount;

    public DurationParameter() {
    }

    public DurationParameter(String name, String value) {
        super(name);
        this.parseDuration(value);
    }

    public DurationParameter(String name, TimeUnit unit, long amount) {
        super(name);
        this.unit = unit;
        this.amount = amount;
    }

    @Override
    public boolean equals(Parameter other) {
        if (other == null || !(other instanceof DurationParameter)) {
            return false;
        }
        return this.toMillis() == ((DurationParameter)other).toMillis();
    }

    public long getAmount() {
        return this.amount;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long toMillis() {
        return this.unit.toMillis(this.amount);
    }

    public void setMillis(long millis) {
        this.unit = TimeUnit.MILLISECONDS;
        this.amount = millis;
    }

    private void parseDuration(String value) {
        for (String regex : allowedRegex) {
            String[] tokens = value.split(regex);
            if (tokens.length != 2) continue;
            this.amount = Long.parseLong(tokens[0]);
            try {
                this.unit = TimeUnit.valueOf(tokens[1].toUpperCase(Locale.ENGLISH));
                return;
            }
            catch (IllegalArgumentException e) {
                try {
                    this.unit = IEEEUnit.unit(tokens[1]);
                    return;
                }
                catch (IllegalArgumentException e1) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("Invalid duration format: " + value);
    }

    public String asString(Character separator) {
        return Long.toString(this.amount) + separator + this.unit.toString();
    }

    @Override
    public String asString() {
        return this.asString(Character.valueOf(' '));
    }

    @Override
    public ParameterState.Type getType() {
        return ParameterState.Type.DURATION;
    }

    private static enum IEEEUnit {
        NS{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.NANOSECONDS;
            }
        }
        ,
        US{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.MICROSECONDS;
            }
        }
        ,
        MS{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.MILLISECONDS;
            }
        }
        ,
        S{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.SECONDS;
            }
        }
        ,
        MIN{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.MINUTES;
            }
        }
        ,
        H{

            @Override
            TimeUnit getUnit() {
                return TimeUnit.HOURS;
            }
        };


        abstract TimeUnit getUnit();

        static TimeUnit unit(String value) {
            return IEEEUnit.valueOf(value.toUpperCase(Locale.ENGLISH)).getUnit();
        }
    }
}

