/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.server.LoggerUtils;

public class ServiceStatusTracker
extends Tracker<ServiceChange>
implements ViewListener<ServiceStatusChange> {
    static final int PRUNE_FREQUENCY = 40;
    private final Map<ResourceId, ServiceChange> serviceHealth = new ConcurrentHashMap<ResourceId, ServiceChange>();
    private final Map<ResourceId, ServiceChange> lastLoggedEvent = new ConcurrentHashMap<ResourceId, ServiceChange>();
    private final List<Tracker.EventHolder<ServiceChange>> queue = new ArrayList<Tracker.EventHolder<ServiceChange>>();
    private final Logger logger;
    private int newInfoCounter = 0;

    public ServiceStatusTracker() {
        this(null);
    }

    public ServiceStatusTracker(AdminServiceParams params) {
        this.logger = params == null ? LoggerUtils.getLogger(this.getClass(), "ServiceStatusTracker") : LoggerUtils.getLogger(this.getClass(), params);
    }

    private void prune() {
        Tracker.EventHolder<ServiceChange> se;
        long interesting = this.getEarliestInterestingTimeStamp();
        while (!this.queue.isEmpty() && (se = this.queue.get(0)).getSyntheticTimestamp() <= interesting) {
            this.queue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newInfo(ResourceId rId, ServiceStatusChange change) {
        EventAction result;
        ServiceChange event = new ServiceChange(rId, change);
        ServiceStatusTracker serviceStatusTracker = this;
        synchronized (serviceStatusTracker) {
            if (this.newInfoCounter++ % 40 == 0) {
                this.prune();
            }
            ResourceId targetId = event.getTarget();
            ServiceChange old = this.serviceHealth.get(targetId);
            ServiceChange oldLogged = this.lastLoggedEvent.get(targetId);
            result = this.shouldUpdate(old, oldLogged, event);
            if (result.shouldMap) {
                this.serviceHealth.put(targetId, event);
                long syntheticTimestamp = this.getSyntheticTimestamp(event.getChangeTime());
                this.queue.add(new Tracker.EventHolder<ServiceChange>(syntheticTimestamp, event, true));
            }
            if (result.shouldLog) {
                this.lastLoggedEvent.put(targetId, event);
            }
        }
        if (result.shouldMap) {
            this.notifyListeners();
        }
        if (result.shouldLog) {
            this.logger.info("[" + rId + "] " + change);
        }
    }

    private EventAction shouldUpdate(ServiceChange previous, ServiceChange previousLogged, ServiceChange newEvent) {
        if (previous == null) {
            return EventAction.LOG_AND_MAP;
        }
        if (previous.getChangeTime() > newEvent.getChangeTime()) {
            return EventAction.LOG_DONT_MAP;
        }
        if (newEvent.getStatus() == ConfigurableService.ServiceStatus.UNREACHABLE && previous.getStatus().isTerminalState()) {
            if (previousLogged.getStatus() == ConfigurableService.ServiceStatus.UNREACHABLE) {
                return EventAction.DONT_LOG_OR_MAP;
            }
            return EventAction.LOG_DONT_MAP;
        }
        if (newEvent.getStatus() == previous.getStatus()) {
            return EventAction.DONT_LOG_OR_MAP;
        }
        return EventAction.LOG_AND_MAP;
    }

    public Map<ResourceId, ServiceChange> getStatus() {
        return new HashMap<ResourceId, ServiceChange>(this.serviceHealth);
    }

    @Override
    public synchronized Tracker.RetrievedEvents<ServiceChange> retrieveNewEvents(long pointInTime) {
        ArrayList values = new ArrayList();
        long syntheticStampOfLastRecord = pointInTime;
        for (Tracker.EventHolder<ServiceChange> se : this.queue) {
            if (se.getSyntheticTimestamp() <= pointInTime) continue;
            values.add(se);
            syntheticStampOfLastRecord = se.getSyntheticTimestamp();
        }
        return new Tracker.RetrievedEvents<ServiceChange>(syntheticStampOfLastRecord, values);
    }

    private static class EventAction {
        final boolean shouldLog;
        final boolean shouldMap;
        static EventAction LOG_AND_MAP = new EventAction(true, true);
        static EventAction LOG_DONT_MAP = new EventAction(true, false);
        static EventAction DONT_LOG_OR_MAP = new EventAction(false, false);

        private EventAction(boolean shouldLog, boolean shouldMap) {
            this.shouldLog = shouldLog;
            this.shouldMap = shouldMap;
        }
    }
}

