/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.io.Serializable;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.ConfigurableService;

public class ServiceChange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ResourceId reportingId;
    private final ResourceId originalId;
    private final long changeTime;
    private final ConfigurableService.ServiceStatus current;

    public ServiceChange(ResourceId reportingId, ServiceStatusChange change) {
        this.reportingId = reportingId;
        this.originalId = change.getTarget(reportingId);
        this.changeTime = change.getTimeStamp();
        this.current = change.getStatus();
    }

    public long getChangeTime() {
        return this.changeTime;
    }

    public ConfigurableService.ServiceStatus getStatus() {
        return this.current;
    }

    public ResourceId getTarget() {
        return this.originalId;
    }

    public ResourceId getReporter() {
        return this.reportingId;
    }

    public int getSeverity() {
        return this.current.getSeverity();
    }

    public boolean isNeedsAlert() {
        return this.current.needsAlert();
    }
}

