/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.plan.PlanStateChange;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.MeasurementType;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.monitor.View;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.server.LoggerUtils;

public class PlanStateChangeView
implements View {
    private final Logger storewideLogger;
    private final Set<ViewListener<PlanStateChange>> listeners = new HashSet<ViewListener<PlanStateChange>>();

    public PlanStateChangeView(AdminServiceParams params) {
        this.storewideLogger = LoggerUtils.getStorewideViewLogger(this.getClass(), params);
    }

    @Override
    public String getName() {
        return "Plan State";
    }

    @Override
    public Set<MeasurementType> getTargetMetricTypes() {
        return Collections.singleton(Metrics.PLAN_STATE);
    }

    @Override
    public synchronized void applyNewInfo(ResourceId resourceId, Measurement m) {
        PlanStateChange change = (PlanStateChange)m;
        this.storewideLogger.info("[" + resourceId + "] " + change);
        for (ViewListener<PlanStateChange> listener : this.listeners) {
            listener.newInfo(resourceId, change);
        }
    }

    public synchronized void addListener(ViewListener<PlanStateChange> l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(ViewListener<PlanStateChange> l) {
        this.listeners.remove(l);
    }

    @Override
    public void close() {
    }
}

