/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.admin.plan.PlanStateChange;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.topo.ResourceId;

public class PlanStateChangeTracker
extends Tracker<PlanStateChange>
implements ViewListener<PlanStateChange> {
    private static final int PRUNE_FREQUENCY = 40;
    private final List<Tracker.EventHolder<PlanStateChange>> queue = new ArrayList<Tracker.EventHolder<PlanStateChange>>();
    private int newInfoCounter = 0;

    private void prune() {
        Tracker.EventHolder<PlanStateChange> psc;
        long interesting = this.getEarliestInterestingTimeStamp();
        while (!this.queue.isEmpty() && (psc = this.queue.get(0)).getSyntheticTimestamp() <= interesting) {
            this.queue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newInfo(ResourceId rId, PlanStateChange psc) {
        PlanStateChangeTracker planStateChangeTracker = this;
        synchronized (planStateChangeTracker) {
            if (this.newInfoCounter++ % 40 == 0) {
                this.prune();
            }
            long syntheticTimestamp = this.getSyntheticTimestamp(psc.getTime());
            this.queue.add(new Tracker.EventHolder<PlanStateChange>(syntheticTimestamp, psc, false));
        }
        this.notifyListeners();
    }

    @Override
    public synchronized Tracker.RetrievedEvents<PlanStateChange> retrieveNewEvents(long since) {
        ArrayList values = new ArrayList();
        long syntheticStampOfLastRecord = since;
        for (Tracker.EventHolder<PlanStateChange> psc : this.queue) {
            if (psc.getSyntheticTimestamp() <= since) continue;
            values.add(psc);
            syntheticStampOfLastRecord = psc.getSyntheticTimestamp();
        }
        return new Tracker.RetrievedEvents<PlanStateChange>(syntheticStampOfLastRecord, values);
    }
}

