/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.server.LoggerUtils;

public class LogTracker
extends Tracker<LogRecord>
implements ViewListener<LogRecord> {
    static final int PRUNE_FREQUENCY = 40;
    static final int QUEUE_MAX = 5000;
    private final List<Tracker.EventHolder<LogRecord>> queue;
    private int newInfoCounter = 0;
    private final Logger logger;

    public LogTracker(Logger logger) {
        this.logger = logger;
        this.queue = new ArrayList<Tracker.EventHolder<LogRecord>>();
    }

    private void prune() {
        Tracker.EventHolder<LogRecord> lr;
        long interesting = this.getEarliestInterestingTimeStamp();
        while (!this.queue.isEmpty() && this.queue.size() >= 40 && (lr = this.queue.get(0)).getSyntheticTimestamp() <= interesting) {
            this.queue.remove(0);
        }
        int currentSize = this.queue.size();
        if (currentSize > 5000) {
            for (int i = 0; i < currentSize - 5000; ++i) {
                this.queue.remove(0);
            }
            this.logger.severe("Log queue size=" + currentSize + " exceeds maximum of " + 5000 + ", was pruned;" + " some messages prior to this one were lost.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newInfo(ResourceId rId, LogRecord lr) {
        LogTracker logTracker = this;
        synchronized (logTracker) {
            if (this.newInfoCounter++ % 40 == 0) {
                this.prune();
            }
            long syntheticTimestamp = this.getSyntheticTimestamp(lr.getMillis());
            this.queue.add(new Tracker.EventHolder<LogRecord>(syntheticTimestamp, lr, lr.getLevel() == Level.SEVERE || lr.getLevel() == LoggerUtils.SecurityLevel.SEC_WARNING));
        }
        if (!Thread.holdsLock(this)) {
            this.notifyListeners();
        }
    }

    @Override
    public synchronized Tracker.RetrievedEvents<LogRecord> retrieveNewEvents(long since) {
        ArrayList values = new ArrayList();
        long syntheticStampOfLastRecord = since;
        for (Tracker.EventHolder<LogRecord> lr : this.queue) {
            if (lr.getSyntheticTimestamp() <= since) continue;
            values.add(lr);
            syntheticStampOfLastRecord = lr.getSyntheticTimestamp();
        }
        return new Tracker.RetrievedEvents<LogRecord>(syntheticStampOfLastRecord, values);
    }
}

