/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.measurement.LatencyInfo;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.MeasurementType;
import oracle.kv.impl.measurement.PerfStatType;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.monitor.View;
import oracle.kv.impl.rep.monitor.StatsPacket;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.server.LoggerUtils;

public class CSVFileView
implements View {
    private final Logger logger;
    private final Map<ResourceId, PrintStream> detailFiles;
    private final Map<ResourceId, PrintStream> summaryFiles;
    private final AdminServiceParams params;
    private final PerfStatType[] detailStats;
    private final PerfStatType[] summaryStats;
    private Map<PerfStatType, LatencyInfo> summary;

    public CSVFileView(AdminServiceParams params) {
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.detailFiles = new HashMap<ResourceId, PrintStream>();
        this.summaryFiles = new HashMap<ResourceId, PrintStream>();
        this.params = params;
        this.detailStats = PerfStatType.getDetailedStats();
        this.summaryStats = PerfStatType.getSummaryStats();
    }

    @Override
    public String getName() {
        return "Internal_StatsCSVFileGenerator";
    }

    @Override
    public Set<MeasurementType> getTargetMetricTypes() {
        return Collections.singleton(Metrics.RNSTATS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyNewInfo(ResourceId resourceId, Measurement m) {
        StatsPacket statsPacket = (StatsPacket)m;
        this.logger.finest("Stats File getting new info from " + resourceId);
        PrintStream detailOut = null;
        PrintStream summaryOut = null;
        Map<String, Long> sortedEnvStats = statsPacket.sortEnvStats();
        CSVFileView cSVFileView = this;
        synchronized (cSVFileView) {
            detailOut = this.detailFiles.get(resourceId);
            summaryOut = this.summaryFiles.get(resourceId);
            if (detailOut == null) {
                this.createFiles(resourceId, statsPacket, sortedEnvStats);
                detailOut = this.detailFiles.get(resourceId);
                summaryOut = this.summaryFiles.get(resourceId);
            }
        }
        statsPacket.writeStats(detailOut, this.detailStats, sortedEnvStats);
        this.summary = statsPacket.summarizeAndWriteStats(summaryOut, this.summaryStats, sortedEnvStats);
    }

    private void createFiles(ResourceId resourceId, StatsPacket packet, Map<String, Long> sortedEnvStats) {
        File rootDir = new File(this.params.getStorageNodeParams().getRootDirPath());
        String storeName = this.params.getGlobalParams().getKVStoreName();
        File loggingDir = FileNames.getLoggingDir(rootDir, storeName);
        File detailCSVFile = new File(loggingDir, resourceId.toString() + "_detail.csv");
        this.initOneFile(resourceId, detailCSVFile, this.detailStats, this.detailFiles, packet, sortedEnvStats);
        File summaryCSVFile = new File(loggingDir, resourceId.toString() + "_summary.csv");
        this.initOneFile(resourceId, summaryCSVFile, this.summaryStats, this.summaryFiles, packet, sortedEnvStats);
    }

    private void initOneFile(ResourceId resourceId, File file, PerfStatType[] headerList, Map<ResourceId, PrintStream> streamMap, StatsPacket packet, Map<String, Long> sortedEnvStats) {
        PrintStream out = null;
        try {
            out = new PrintStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        packet.writeCSVHeader(out, headerList, sortedEnvStats);
        out.println("");
        streamMap.put(resourceId, out);
    }

    @Override
    public void close() {
        for (PrintStream p : this.detailFiles.values()) {
            p.close();
        }
        for (PrintStream p : this.summaryFiles.values()) {
            p.close();
        }
    }

    public Map<PerfStatType, LatencyInfo> getSummary() {
        return this.summary;
    }
}

