/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.plan.PlanStateChange;
import oracle.kv.impl.measurement.LoggerMessage;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.MeasurementType;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.monitor.Collector;
import oracle.kv.impl.monitor.MonitorKeeper;
import oracle.kv.impl.monitor.View;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.monitor.views.CSVFileView;
import oracle.kv.impl.monitor.views.GeneralInfoView;
import oracle.kv.impl.monitor.views.LogTracker;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.monitor.views.PerfTracker;
import oracle.kv.impl.monitor.views.PerfView;
import oracle.kv.impl.monitor.views.PlanStateChangeTracker;
import oracle.kv.impl.monitor.views.PlanStateChangeView;
import oracle.kv.impl.monitor.views.ServiceStatusTracker;
import oracle.kv.impl.monitor.views.ServiceStatusView;
import oracle.kv.impl.monitor.views.StorewideLoggingView;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.server.LoggerUtils;

public class Monitor
implements ParameterListener {
    public static final String INTERNAL_STATUS_CHANGE_VIEW = "Internal_ServiceStateChanges";
    public static final String INTERNAL_STOREWIDE_LOGGING_VIEW = "Internal_LoggingMessages";
    public static final String INTERNAL_GENERAL_INFO_VIEW = "Internal_GeneralInfo";
    public static final String INTERNAL_STATS_FILE_VIEW = "Internal_StatsCSVFileGenerator";
    public static final String GUI_SERVICE_STATUS = "Service Status";
    public static final String PERF_FILE_VIEW = "Performance Stats";
    public static final String PLAN_STATE_VIEW = "Plan State";
    private final Collector collector;
    private final AdminServiceParams params;
    private final AdminId adminId;
    private final MonitorKeeper admin;
    private final Logger logger;
    private final LoginManager loginMgr;
    private final Set<View> views;
    private ServiceStatusView changeView;
    private StorewideLoggingView loggingView;
    private LogTracker logTracker;
    private ServiceStatusTracker serviceStatusTracker;
    private PerfView perfView;
    private PerfTracker perfTracker;
    private PlanStateChangeView planView;
    private PlanStateChangeTracker planTracker;
    private final MetricToViewMap metricToViewMap;

    public Monitor(AdminServiceParams params, MonitorKeeper admin, LoginManager loginMgr) {
        this.admin = admin;
        this.params = params;
        this.loginMgr = loginMgr;
        this.adminId = params.getAdminParams().getAdminId();
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.views = Collections.synchronizedSet(new HashSet());
        this.collector = new Collector(this);
        this.metricToViewMap = new MetricToViewMap();
        this.createPredefinedViews();
    }

    public void setupExistingAgents(Topology topo) {
        for (StorageNode sn : topo.getStorageNodeMap().getAll()) {
            this.registerAgent(sn.getHostname(), sn.getRegistryPort(), sn.getStorageNodeId());
        }
        for (RepGroup rg : topo.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                StorageNode sn = topo.get(rn.getStorageNodeId());
                this.registerAgent(sn.getHostname(), sn.getRegistryPort(), (ResourceId)rn.getResourceId());
            }
        }
    }

    public void registerAgent(String snHostname, int snRegistryPort, ResourceId agentId) {
        this.collector.registerAgent(snHostname, snRegistryPort, agentId);
    }

    public void unregisterAgent(ResourceId agentId) {
        this.collector.unregisterAgent(agentId);
    }

    public void shutdown() {
        for (View v : this.views) {
            v.close();
        }
        this.collector.shutdown();
    }

    private void createPredefinedViews() {
        this.changeView = new ServiceStatusView(this.params);
        this.serviceStatusTracker = new ServiceStatusTracker(this.params);
        this.changeView.addListener(this.serviceStatusTracker);
        this.views.add(this.changeView);
        this.loggingView = new StorewideLoggingView(this.params);
        this.logTracker = new LogTracker(this.logger);
        this.loggingView.addListener(this.logTracker);
        this.views.add(this.loggingView);
        this.views.add(new GeneralInfoView(this.params));
        if (this.params.getAdminParams().createCSV()) {
            this.views.add(new CSVFileView(this.params));
        }
        this.perfView = new PerfView(this.params, this.admin);
        this.perfTracker = new PerfTracker(this.params);
        this.perfView.addListener(this.perfTracker);
        this.views.add(this.perfView);
        this.planView = new PlanStateChangeView(this.params);
        this.planTracker = new PlanStateChangeTracker();
        this.planView.addListener(this.planTracker);
        this.views.add(this.planView);
        for (View v : this.views) {
            this.metricToViewMap.addView(v);
        }
    }

    void setLoggerHook(TestHook<LoggerMessage> hook) {
        this.loggingView.setTestHook(hook);
    }

    public void addView(View v) {
        this.logger.finest("Adding view " + v.getName());
        this.metricToViewMap.addView(v);
    }

    public void trackStatusChange(ViewListener<ServiceStatusChange> l) {
        this.changeView.addListener(l);
    }

    public void trackPerfChange(ViewListener<PerfEvent> p) {
        this.perfView.addListener(p);
    }

    public void trackPlanStateChange(ViewListener<PlanStateChange> p) {
        this.planView.addListener(p);
    }

    public ServiceStatusTracker getServiceChangeTracker() {
        return this.serviceStatusTracker;
    }

    public PerfTracker getPerfTracker() {
        return this.perfTracker;
    }

    public LogTracker getLogTracker() {
        return this.logTracker;
    }

    public PlanStateChangeTracker getPlanTracker() {
        return this.planTracker;
    }

    public void publish(Measurement p) {
        this.metricToViewMap.submit(this.adminId, p);
    }

    public void publish(ResourceId resourceId, List<Measurement> measurements) {
        if (measurements.size() == 0) {
            return;
        }
        for (Measurement m : measurements) {
            this.metricToViewMap.submit(resourceId, m);
        }
    }

    public void collectNow() {
        this.collector.collectNow();
    }

    public void collectNow(ResourceId resource) {
        this.collector.collectNow(resource);
    }

    public AdminServiceParams getParams() {
        return this.params;
    }

    private void changeCSVView(boolean createCSV) {
        if (createCSV) {
            this.logger.info("Adding CSV view");
            CSVFileView view = new CSVFileView(this.params);
            this.views.add(view);
            this.addView(view);
        } else {
            this.logger.info("Removing CSV view");
            for (View view : this.views) {
                if (!(view instanceof CSVFileView)) continue;
                this.metricToViewMap.removeView(view);
                view.close();
                this.views.remove(view);
            }
        }
    }

    private void changePollPeriod(long pollMillis) {
        this.collector.resetAgents(pollMillis);
    }

    private void changeStorewideView() {
        this.loggingView.close();
        this.views.remove(this.loggingView);
        this.loggingView = new StorewideLoggingView(this.params);
        this.loggingView.addListener(this.logTracker);
        this.views.add(this.loggingView);
    }

    @Override
    public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
        this.logger.info("newParameters called for Monitor");
        AdminParams oldParams = new AdminParams(oldMap);
        this.params.setAdminParams(new AdminParams(newMap));
        AdminParams newParams = this.params.getAdminParams();
        if (oldParams.createCSV() != newParams.createCSV()) {
            this.changeCSVView(newParams.createCSV());
        }
        if (oldParams.getPollPeriodMillis() != newParams.getPollPeriodMillis()) {
            this.changePollPeriod(newParams.getPollPeriodMillis());
        }
        if (oldParams.getLogFileCount() != newParams.getLogFileCount() || oldParams.getLogFileLimit() != newParams.getLogFileLimit()) {
            this.changeStorewideView();
        }
    }

    public String getStorewideLogName() {
        return this.loggingView.getStorewideLogName();
    }

    LoginManager getLoginManager() {
        return this.loginMgr;
    }

    int getNumCollectorAgents() {
        return this.collector.getNumAgents();
    }

    static class MetricToViewMap {
        private final ConcurrentMap<Integer, Set<View>> metricMap = new ConcurrentHashMap<Integer, Set<View>>();

        MetricToViewMap() {
        }

        private void addView(View v) {
            for (MeasurementType metricType : v.getTargetMetricTypes()) {
                HashSet<View> existing = (HashSet<View>)this.metricMap.get(metricType.getId());
                if (existing == null) {
                    existing = new HashSet<View>();
                    this.metricMap.put(metricType.getId(), existing);
                }
                existing.add(v);
            }
        }

        public void removeView(View v) {
            for (Set viewset : this.metricMap.values()) {
                for (View view : viewset) {
                    if (view.getClass() != v.getClass()) continue;
                    viewset.remove(view);
                }
            }
        }

        void submit(ResourceId resourceId, Measurement m) {
            Set views = (Set)this.metricMap.get(m.getId());
            if (views != null) {
                for (View view : views) {
                    view.applyNewInfo(resourceId, m);
                }
            }
        }
    }
}

