/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.mgmt;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.ConfigurableService;

public class MgmtUtil {
    public static final String MGMT_FLAG = "-mgmt";
    public static final String MGMT_NOOP_ARG = "none";
    public static final String MGMT_SNMP_ARG = "snmp";
    public static final String MGMT_JMX_ARG = "jmx";
    public static final String MGMT_POLL_PORT_FLAG = "-pollport";
    public static final String MGMT_TRAP_HOST_FLAG = "-traphost";
    public static final String MGMT_TRAP_PORT_FLAG = "-trapport";
    public static final String MGMT_NOOP_IMPL_CLASS = "oracle.kv.impl.mgmt.NoOpAgent";
    public static final String MGMT_SNMP_IMPL_CLASS = "oracle.kv.impl.mgmt.snmp.SnmpAgent";
    public static final String MGMT_JMX_IMPL_CLASS = "oracle.kv.impl.mgmt.jmx.JmxAgent";
    private static final Map<String, String> mgmtArg2ClassNameMap = new HashMap<String, String>();
    private static Map<ConfigurableService.ServiceStatus, String> serviceStatusMap;

    public static String getMgmtUsage(boolean implOnly) {
        StringBuilder usage = new StringBuilder("[");
        usage.append(MGMT_FLAG);
        usage.append(" {");
        String delimiter = "";
        for (String k : mgmtArg2ClassNameMap.keySet()) {
            usage.append(delimiter);
            usage.append(k);
            delimiter = "|";
        }
        usage.append("}]");
        if (!implOnly) {
            usage.append(" [");
            usage.append(MGMT_POLL_PORT_FLAG);
            usage.append(" <snmp poll port>]\n\t");
            usage.append("[");
            usage.append(MGMT_TRAP_HOST_FLAG);
            usage.append(" <snmp trap/notification hostname>]\n\t");
            usage.append("[");
            usage.append(MGMT_TRAP_PORT_FLAG);
            usage.append(" <snmp trap/notification port>]");
        } else {
            usage.append("]");
        }
        return usage.toString();
    }

    public static String getImplClassName(String arg) {
        return mgmtArg2ClassNameMap.get(arg);
    }

    public static boolean verifyImplClassName(String arg) {
        return mgmtArg2ClassNameMap.values().contains(arg);
    }

    public static String ssEnum2TextualConvention(ConfigurableService.ServiceStatus ss) {
        String tc = serviceStatusMap.get((Object)ss);
        if (tc == null) {
            throw new IllegalStateException("Unexpected ServiceStatus" + (Object)((Object)ss));
        }
        return tc;
    }

    public static Byte[] makeDateAndTime(long timestamp) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timestamp);
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        int millisecond = c.get(14);
        Byte[] tc = new Byte[]{new Byte((byte)(year >> 8)), new Byte((byte)(year & 0xFF)), new Byte((byte)(month + 1)), new Byte((byte)day), new Byte((byte)hour), new Byte((byte)minute), new Byte((byte)second), new Byte((byte)(millisecond / 100))};
        return tc;
    }

    static {
        mgmtArg2ClassNameMap.put(MGMT_NOOP_ARG, MGMT_NOOP_IMPL_CLASS);
        mgmtArg2ClassNameMap.put(MGMT_SNMP_ARG, MGMT_SNMP_IMPL_CLASS);
        mgmtArg2ClassNameMap.put(MGMT_JMX_ARG, MGMT_JMX_IMPL_CLASS);
        serviceStatusMap = new HashMap<ConfigurableService.ServiceStatus, String>();
        serviceStatusMap.put(ConfigurableService.ServiceStatus.STARTING, "starting");
        serviceStatusMap.put(ConfigurableService.ServiceStatus.WAITING_FOR_DEPLOY, "waitingForDeploy");
        serviceStatusMap.put(ConfigurableService.ServiceStatus.RUNNING, "running");
        serviceStatusMap.put(ConfigurableService.ServiceStatus.STOPPING, "stopping");
        serviceStatusMap.put(ConfigurableService.ServiceStatus.STOPPED, "stopped");
        serviceStatusMap.put(ConfigurableService.ServiceStatus.ERROR_RESTARTING, "errorRestarting");
        serviceStatusMap.put(ConfigurableService.ServiceStatus.ERROR_NO_RESTART, "errorNoRestart");
        serviceStatusMap.put(ConfigurableService.ServiceStatus.UNREACHABLE, "unreachable");
    }

    public static class ConfigParserHelper {
        private final CommandParser parser;
        private final boolean implOnly;
        private String mgmtImpl = null;
        private int mgmtPollPort = 0;
        private String mgmtTrapHost = null;
        private int mgmtTrapPort = 0;

        public ConfigParserHelper(CommandParser parser, boolean implOnly) {
            this.parser = parser;
            this.implOnly = implOnly;
        }

        public boolean checkArg(String arg) {
            if (arg.equals(MgmtUtil.MGMT_FLAG)) {
                String next = this.parser.nextArg(arg);
                this.mgmtImpl = MgmtUtil.getImplClassName(next);
                if (this.mgmtImpl == null) {
                    this.parser.usage("There is no mgmt implementation named " + next);
                }
                return true;
            }
            if (this.implOnly) {
                return false;
            }
            if (arg.equals(MgmtUtil.MGMT_POLL_PORT_FLAG)) {
                this.mgmtPollPort = this.parser.nextIntArg(arg);
                return true;
            }
            if (arg.equals(MgmtUtil.MGMT_TRAP_HOST_FLAG)) {
                this.mgmtTrapHost = this.parser.nextArg(arg);
                return true;
            }
            if (arg.equals(MgmtUtil.MGMT_TRAP_PORT_FLAG)) {
                this.mgmtTrapPort = this.parser.nextIntArg(arg);
                return true;
            }
            return false;
        }

        public void apply(BootstrapParams bp) {
            if (this.mgmtImpl != null) {
                if (this.mgmtImpl.equals(MgmtUtil.MGMT_SNMP_IMPL_CLASS) && this.mgmtPollPort == 0) {
                    this.parser.usage("When specifying -mgmt snmp, you must also give -pollport.");
                }
                bp.setMgmtClass(this.mgmtImpl);
            }
            if (this.mgmtPollPort != 0) {
                bp.setMgmtPollingPort(this.mgmtPollPort);
            }
            if (this.mgmtTrapHost != null) {
                bp.setMgmtTrapHost(this.mgmtTrapHost);
            }
            if (this.mgmtTrapPort != 0) {
                bp.setMgmtTrapPort(this.mgmtTrapPort);
            }
        }

        public String getSelectedImplClass() {
            return this.mgmtImpl;
        }

        public int getPollPort() {
            return this.mgmtPollPort;
        }

        public String getTrapHost() {
            return this.mgmtTrapHost;
        }

        public int getTrapPort() {
            return this.mgmtTrapPort;
        }
    }
}

