/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic.util;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.UserLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.RegistryUtils;

public class TopologyDetector {
    private String host = null;
    private int port = -1;
    private String user = null;
    private String securityFile = null;
    private boolean forceRepNodeLogon = false;
    private Topology topology = null;
    private CommandServiceAPI commandService = null;

    public TopologyDetector(String host, int port, String user, String securityFile) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.securityFile = securityFile;
    }

    public TopologyDetector(String host, int port, String user, String securityFile, boolean forceRepNodeLogon) {
        this(host, port, user, securityFile);
        this.forceRepNodeLogon = forceRepNodeLogon;
    }

    public Topology getTopology() throws Exception {
        try {
            if (!this.forceRepNodeLogon) {
                LoginManager loginMgr = this.getLoginManager(LoginManagerType.ADMINLOGIN);
                this.commandService = this.getAdmin(this.host, this.port, loginMgr);
                this.topology = this.commandService.getTopology();
                return this.topology;
            }
        }
        catch (Exception e) {
            this.commandService = null;
        }
        String regHostPort = this.host + ":" + this.port;
        try {
            LoginManager loginMgr = this.getLoginManager(LoginManagerType.REPNODELOGIN);
            this.topology = TopologyLocator.get(new String[]{regHostPort}, 0, loginMgr, null);
            List<StorageNode> snList = this.topology.getSortedStorageNodes();
            for (StorageNode sn : snList) {
                this.commandService = this.getAdmin(sn.getHostname(), sn.getRegistryPort(), loginMgr);
                if (this.commandService == null) continue;
                break;
            }
            return this.topology;
        }
        catch (Exception ex) {
            if (ex.getCause() != null && ex.getCause().getMessage() != null && ex.getCause().getMessage().contains("which may be caused by a security mismatch between the client and server")) {
                throw new Exception("Security mismatch between the client server");
            }
            throw new Exception("Could not establish an initial Topology from: " + regHostPort + ":" + ex.getMessage());
        }
    }

    private CommandServiceAPI getAdmin(String hostname, int portNum, LoginManager loginMgr) throws Exception {
        CommandServiceAPI cs = RegistryUtils.getAdmin(hostname, portNum, loginMgr);
        ReplicatedEnvironment.State adminState = cs.getAdminState();
        if (adminState != null) {
            switch (adminState) {
                case MASTER: {
                    break;
                }
                case REPLICA: {
                    URI rmiaddr = cs.getMasterRmiAddress();
                    String adminHostname = rmiaddr.getHost();
                    int adminRegistryPort = rmiaddr.getPort();
                    cs = this.getAdmin(adminHostname, adminRegistryPort, loginMgr);
                    break;
                }
                case DETACHED: 
                case UNKNOWN: {
                    cs = null;
                }
            }
            return cs;
        }
        return null;
    }

    public String getRootDirPath(StorageNode storageNode) {
        try {
            if (this.commandService != null) {
                StorageNodeId sni = storageNode.getStorageNodeId();
                StorageNodeParams param = this.commandService.getParameters().get(sni);
                return param.getRootDirPath();
            }
        }
        catch (Exception ignore) {
            return null;
        }
        return null;
    }

    private LoginManager getLoginManager(LoginManagerType loginMgrType) throws Exception {
        if (this.securityFile != null) {
            KVStoreLogin storeLogin = new KVStoreLogin(this.user, this.securityFile);
            storeLogin.loadSecurityProperties();
            storeLogin.prepareRegistryCSF();
            UserLoginManager loginMgr = null;
            if (storeLogin.foundSSLTransport()) {
                try {
                    PasswordCredentials creds = storeLogin.makeShellLoginCredentials();
                    if (loginMgrType == LoginManagerType.REPNODELOGIN) {
                        loginMgr = KVStoreLogin.getRepNodeLoginMgr(this.host, this.port, creds, null);
                    } else if (loginMgrType == LoginManagerType.ADMINLOGIN) {
                        loginMgr = KVStoreLogin.getAdminLoginMgr(this.host, this.port, creds);
                    }
                }
                catch (AuthenticationFailureException afe) {
                    throw new Exception("Login failed: " + afe.getMessage());
                }
                catch (IOException ioe) {
                    throw new Exception("Failed to get login credentials: " + ioe.getMessage());
                }
            }
            return loginMgr;
        }
        return null;
    }

    private static enum LoginManagerType {
        ADMINLOGIN,
        REPNODELOGIN;

    }
}

