/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic.ssh;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.diagnostic.SNAInfo;
import oracle.kv.impl.diagnostic.ssh.SSHClient;

public class SSHClientManager {
    private static String AT_SIGN = "@";
    private static Map<String, SSHClient> clientCache = new ConcurrentHashMap<String, SSHClient>();

    public static SSHClient getClient(SNAInfo snaInfo) {
        SSHClient client = clientCache.get(SSHClientManager.getCacheKey(snaInfo.getHost(), snaInfo.getUser()));
        if (client == null) {
            client = new SSHClient(snaInfo.getHost(), snaInfo.getUser());
            client.open();
            if (client.isOpen()) {
                clientCache.put(SSHClientManager.getCacheKey(snaInfo.getHost(), snaInfo.getUser()), client);
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<SNAInfo, SSHClient> getClient(List<SNAInfo> snaList) throws Exception {
        ConcurrentHashMap<SNAInfo, SSHClient> clientMap = new ConcurrentHashMap<SNAInfo, SSHClient>();
        int numberSSHThread = snaList.size();
        ThreadPoolExecutor threadExecutor = new ThreadPoolExecutor(numberSSHThread, numberSSHThread, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            HashMap<SNAInfo, Future<SSHClient>> futurnMap = new HashMap<SNAInfo, Future<SSHClient>>();
            for (final SNAInfo sNAInfo : snaList) {
                Callable<SSHClient> snaClientCallable = new Callable<SSHClient>(){

                    @Override
                    public SSHClient call() {
                        SSHClient client = (SSHClient)clientCache.get(SSHClientManager.getCacheKey(sNAInfo.getHost(), sNAInfo.getUser()));
                        if (client == null) {
                            client = new SSHClient(sNAInfo.getHost(), sNAInfo.getUser());
                            client.openByAuthenticatedFile();
                        }
                        return client;
                    }
                };
                futurnMap.put(sNAInfo, threadExecutor.submit(snaClientCallable));
            }
            for (Map.Entry entry : futurnMap.entrySet()) {
                SNAInfo snaInfo = (SNAInfo)entry.getKey();
                SSHClient client = (SSHClient)((Future)entry.getValue()).get();
                if (client == null) continue;
                if (!client.isOpen() && client.getErrorMessage() == null) {
                    SSHClient existingClient = clientCache.get(SSHClientManager.getCacheKey(snaInfo.getHost(), snaInfo.getUser()));
                    if (existingClient == null) {
                        client.openByPassword();
                    } else {
                        client = existingClient;
                    }
                }
                if (client.isOpen()) {
                    clientCache.put(SSHClientManager.getCacheKey(snaInfo.getHost(), snaInfo.getUser()), client);
                }
                clientMap.put(snaInfo, client);
            }
        }
        finally {
            threadExecutor.shutdown();
        }
        return clientMap;
    }

    private static String getCacheKey(String host, String username) {
        return username.toLowerCase(Locale.US).trim() + AT_SIGN + host.toLowerCase(Locale.US).trim();
    }

    public static void clearClients() {
        for (Map.Entry<String, SSHClient> entry : clientCache.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().close();
        }
        clientCache.clear();
    }
}

