/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.diagnostic.JavaVersionVerifier;
import oracle.kv.impl.diagnostic.SNAInfo;
import oracle.kv.impl.security.util.PasswordReader;
import oracle.kv.impl.security.util.ShellPasswordReader;
import oracle.kv.impl.util.ConfigUtils;

public class SSHClient {
    private int SSH_PORT = 22;
    private String EXE_CMD = "exec";
    private String SFTP_CMD = "sftp";
    private String FILTER_JDB = ".jdb";
    private int BUFFER_SZIE = 4096;
    private int INTERVAL_TIME = 500;
    private String UNDER_LINE = "_";
    private String LINUX_HOME_SIGN = "~";
    private long begin;
    private long end;
    private String USER_HOME = System.getProperty("user.home");
    private JSch jsch = new JSch();
    private Session jschSession = null;
    private String host = null;
    private String username = null;
    private boolean openStatus = false;
    private PasswordReader passwordReader = null;
    private String errorMessage;

    public SSHClient(String host, String username) {
        this.host = host;
        this.username = username;
        this.passwordReader = new ShellPasswordReader();
    }

    public SSHClient(String host, String username, PasswordReader passwordReader) {
        this.host = host;
        this.username = username;
        this.passwordReader = passwordReader;
    }

    public boolean isOpen() {
        return this.openStatus;
    }

    public String getErrorMessage() {
        if (this.openStatus) {
            return null;
        }
        return this.errorMessage;
    }

    public void open() {
        this.jschSession = this.createSessionByAuthFile();
        if (this.jschSession == null || !this.jschSession.isConnected()) {
            this.jschSession = this.createSessionByPassword();
        }
        this.setStatus();
    }

    public void openByAuthenticatedFile() {
        this.jschSession = this.createSessionByAuthFile();
        this.setStatus();
    }

    public void openByPassword() {
        this.jschSession = this.createSessionByPassword();
        this.setStatus();
    }

    public void close() {
        if (this.jschSession != null && this.jschSession.isConnected()) {
            this.jschSession.disconnect();
        }
    }

    private void setStatus() {
        if (this.jschSession != null && this.jschSession.isConnected()) {
            this.errorMessage = null;
            this.openStatus = true;
        } else {
            this.openStatus = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSessionByAuthFile() {
        File authKeyDirectory = new File(this.USER_HOME + "/.ssh");
        if (!authKeyDirectory.exists() || authKeyDirectory.isFile()) {
            return null;
        }
        File[] files = authKeyDirectory.listFiles();
        Session session = null;
        int numberSSHThread = files.length;
        ThreadPoolExecutor threadExecutor = new ThreadPoolExecutor(numberSSHThread, numberSSHThread, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            ArrayList<Future<Session>> sessionFutureList = new ArrayList<Future<Session>>();
            for (final File f : files) {
                if (!f.isFile()) continue;
                Callable<Session> clientOpenCallable = new Callable<Session>(){

                    @Override
                    public Session call() {
                        try {
                            return SSHClient.this.createSessionByOneAuthFile(f.getAbsolutePath());
                        }
                        catch (Exception ex) {
                            SSHClient.this.errorMessage = ex.getMessage();
                            return null;
                        }
                    }
                };
                sessionFutureList.add(threadExecutor.submit(clientOpenCallable));
            }
            for (Future future : sessionFutureList) {
                session = (Session)future.get();
                if (session == null || !session.isConnected()) continue;
                break;
            }
        }
        catch (Exception ex) {
            if (session == null || !session.isConnected()) {
                this.errorMessage = ex.getMessage();
            }
        }
        finally {
            threadExecutor.shutdown();
        }
        return session;
    }

    private Session createSessionByOneAuthFile(String authFilePath) throws Exception {
        Session session = null;
        try {
            this.jsch.addIdentity(authFilePath);
            session = this.jsch.getSession(this.username, this.host, this.SSH_PORT);
            AuthUserInfo ui = new AuthUserInfo();
            session.setUserInfo(ui);
            session.setDaemonThread(true);
            session.connect();
        }
        catch (JSchException ex) {
            String msg = ex.getMessage();
            if (msg.contains("java.net.UnknownHostException")) {
                throw new Exception("Unreachable host " + this.host);
            }
            if (msg.contains("Connection refused")) {
                throw new Exception("Cannot establish SSH to connect " + this.host);
            }
            this.errorMessage = null;
        }
        return session;
    }

    private Session createSessionByPassword() {
        Session session = null;
        try {
            session = this.jsch.getSession(this.username, this.host, this.SSH_PORT);
            PasswordUserInfo ui = new PasswordUserInfo();
            session.setUserInfo(ui);
            session.setDaemonThread(true);
            session.connect();
        }
        catch (JSchException ex) {
            String msg = ex.getMessage();
            this.errorMessage = msg.equals("Auth cancel") ? "Authentication cancel for " + this.username + " to connect " + this.host : (msg.equals("Auth fail") ? "Authentication fail for " + this.username + " to connect " + this.host : (msg.contains("authentication failures") ? "Incorrect password for " + this.username + " to connect " + this.host : (msg.contains("java.net.UnknownHostException") ? "Unreachable host " + this.host : (msg.contains("Connection refused") ? "Cannot establish SSH to connect " + this.host : ex.getMessage()))));
        }
        return session;
    }

    public boolean checkFile(String filePath) throws Exception {
        StringBuffer err;
        StringBuffer out;
        String command = "ls " + filePath;
        boolean status = this.executeCommand(command, out = new StringBuffer(), err = new StringBuffer());
        return status;
    }

    private String getRemoteAbsolutePath(String remotePath) throws Exception {
        Channel channel = null;
        try {
            channel = (ChannelSftp)this.jschSession.openChannel(this.SFTP_CMD);
            channel.connect();
            if (remotePath.startsWith(this.LINUX_HOME_SIGN)) {
                String homePath = ((ChannelSftp)channel).pwd();
                remotePath = remotePath.replaceAll(this.LINUX_HOME_SIGN, homePath);
            }
        }
        catch (Exception ex) {
            throw new Exception("Problem get absolute path for file : " + remotePath, ex.getCause());
        }
        finally {
            if (channel != null && channel.isConnected()) {
                ((ChannelSftp)channel).disconnect();
            }
        }
        return remotePath;
    }

    private void sftp(String remoteSource, File localTarget, boolean isRecursive) throws Exception {
        Channel channel = null;
        try {
            SftpATTRS attrs;
            channel = (ChannelSftp)this.jschSession.openChannel(this.SFTP_CMD);
            channel.connect();
            if (remoteSource.startsWith(this.LINUX_HOME_SIGN)) {
                String homePath = ((ChannelSftp)channel).pwd();
                remoteSource = remoteSource.replaceAll(this.LINUX_HOME_SIGN, homePath);
            }
            if ((attrs = ((ChannelSftp)channel).stat(remoteSource)).isDir()) {
                String topFileName = null;
                ((ChannelSftp)channel).cd(remoteSource);
                remoteSource = ((ChannelSftp)channel).pwd();
                topFileName = this.getDirectoryLastName(remoteSource);
                if (topFileName == null) {
                    this.iterateDirectory((ChannelSftp)channel, remoteSource, localTarget, this.FILTER_JDB, isRecursive);
                } else {
                    this.iterateDirectory((ChannelSftp)channel, remoteSource, new File(localTarget, topFileName), this.FILTER_JDB, isRecursive);
                }
            } else {
                int index = remoteSource.lastIndexOf("/");
                String parent = ".";
                if (index > 0) {
                    parent = remoteSource.substring(0, index);
                }
                ((ChannelSftp)channel).cd(parent);
                Vector files = ((ChannelSftp)channel).ls(remoteSource);
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)files.toArray()[0];
                this.getFile((ChannelSftp)channel, entry.getFilename(), localTarget);
            }
        }
        catch (Exception ex) {
            throw new Exception("Problem sftp file : " + remoteSource, ex.getCause());
        }
        finally {
            if (channel != null && channel.isConnected()) {
                ((ChannelSftp)channel).disconnect();
            }
        }
    }

    private String getDirectoryLastName(String directory) {
        int index;
        String lastName = null;
        if (directory == null || directory.equals("")) {
            return null;
        }
        if (directory.equals("/")) {
            return directory;
        }
        if (directory.endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        if ((index = directory.lastIndexOf("/")) > 0) {
            lastName = directory.substring(index + 1);
        }
        return lastName;
    }

    private void iterateDirectory(ChannelSftp channel, String directory, File targetFile, String filteredPattern, boolean isRecursive) throws SftpException {
        channel.cd(directory);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        Vector entries = channel.ls(directory);
        for (Object object : entries) {
            if (!(object instanceof ChannelSftp.LsEntry)) continue;
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)object;
            String name = entry.getFilename();
            if (entry.getAttrs().isDir()) {
                if (!isRecursive || name.equals(".") || name.equals("..")) continue;
                this.iterateDirectory(channel, channel.pwd() + "/" + name + "/", new File(targetFile, entry.getFilename()), filteredPattern, isRecursive);
                continue;
            }
            if (entry.getFilename().endsWith(filteredPattern)) continue;
            this.getFile(channel, entry.getFilename(), targetFile);
        }
        channel.cd("..");
    }

    private void getFile(ChannelSftp channel, String fileName, File targetFile) throws SftpException {
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        channel.get(fileName, targetFile.getAbsolutePath());
    }

    public File getLogFiles(SNAInfo snaInfo, String outputdir, boolean isCompress) throws Exception {
        File[] files;
        String localSNDir = snaInfo.getStoreName() + this.UNDER_LINE + snaInfo.getStorageNodeName();
        File resultDir = new File(outputdir, localSNDir);
        String rootdir = snaInfo.getRootdir();
        String localKVRootDir = this.getDirectoryLastName(rootdir);
        this.getFileFromRemoteDirectory(rootdir, resultDir, resultDir.getParentFile(), localSNDir, isCompress);
        HashSet<String> set = new HashSet<String>();
        File localKVRoot = new File(resultDir, localKVRootDir);
        for (File file : files = localKVRoot.listFiles()) {
            try {
                BootstrapParams bp = ConfigUtils.getBootstrapParams(file);
                for (String mountPoint : bp.getMountPoints()) {
                    set.add(mountPoint);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        for (String mountPoint : set) {
            String localStorageDirName = mountPoint.replace('/', '_');
            this.getFileFromRemoteDirectory(mountPoint, resultDir, resultDir, localStorageDirName, isCompress);
            File originalDir = new File(resultDir, this.getDirectoryLastName(mountPoint));
            File targetDir = new File(resultDir, localStorageDirName);
            originalDir.renameTo(targetDir);
        }
        return resultDir;
    }

    private void getFileFromRemoteDirectory(String remotedir, File resultDir, File targetDir, String targetDirName, boolean isCompress) throws Exception {
        String remotedirName = this.getDirectoryLastName(remotedir);
        if (isCompress) {
            StringBuffer err;
            StringBuffer out;
            String zipfileName = targetDirName + ".zip";
            String remoteZipPath = "/tmp/" + zipfileName;
            String command = "cd " + remotedir + "/.. && zip -r " + remoteZipPath + " " + remotedirName + " -x *" + this.FILTER_JDB;
            boolean status = this.executeCommand(command, out = new StringBuffer(), err = new StringBuffer());
            if (!status) {
                throw new Exception("Generate zip file failed. Please specify -nocompress flag to retry.");
            }
            this.sftp(remoteZipPath, targetDir, true);
            out.setLength(0);
            err.setLength(0);
            this.executeCommand("rm -rf " + remoteZipPath, out, err);
            this.unzip(targetDir + File.separator + zipfileName, resultDir.getAbsolutePath());
        } else {
            this.sftp(remotedir, resultDir, true);
        }
    }

    public long getTimeLatency() throws Exception {
        long minLatency = Long.MAX_VALUE;
        for (int i = 0; i < 5; ++i) {
            StringBuffer out = new StringBuffer();
            StringBuffer err = new StringBuffer();
            boolean status = this.executeCommand("date +%s%N", out, err);
            if (!status) {
                return 0L;
            }
            long remoteTime = 0L;
            try {
                remoteTime = Long.parseLong(out.toString().trim()) / 1000000L;
            }
            catch (NumberFormatException nfe) {
                return Long.MIN_VALUE;
            }
            long latency = remoteTime - (this.end - this.begin) / 2L - this.begin;
            if (latency >= minLatency) continue;
            minLatency = latency;
        }
        return minLatency;
    }

    public JavaVersionVerifier getJavaVersion() throws Exception {
        StringBuffer out = new StringBuffer();
        StringBuffer err = new StringBuffer();
        this.executeCommand("java -XshowSettings:properties", out, err);
        String settings = err.toString().trim();
        List<String> settingList = Arrays.asList(settings.split("\n"));
        String vendor = null;
        String version = null;
        for (String item : settingList) {
            if (item.contains("java.vendor = ")) {
                vendor = item.replace("java.vendor = ", "").trim();
            }
            if (!item.contains("java.version = ")) continue;
            version = item.replace("java.version = ", "").trim();
        }
        JavaVersionVerifier verifier = new JavaVersionVerifier();
        verifier.setJKDVersionInfo(vendor, version);
        return verifier;
    }

    public Map<SNAInfo, Boolean> getNetWorkStatus(List<SNAInfo> list) throws Exception {
        HashMap<InetAddress, SNAInfo> ipSNAMap = new HashMap<InetAddress, SNAInfo>();
        for (SNAInfo si : list) {
            ipSNAMap.put(si.getIP(), si);
        }
        HashMap<SNAInfo, Boolean> map = new HashMap<SNAInfo, Boolean>();
        StringBuffer out = new StringBuffer();
        StringBuffer err = new StringBuffer();
        for (Map.Entry entry : ipSNAMap.entrySet()) {
            String command = "ping -c 1 " + ((SNAInfo)entry.getValue()).getHost();
            boolean status = this.executeCommand(command, out, err);
            map.put((SNAInfo)entry.getValue(), status);
        }
        return map;
    }

    public List<File> getConfigFile(SNAInfo snaInfo, File saveFolder) throws Exception {
        StringBuffer err;
        StringBuffer out;
        if (!saveFolder.exists()) {
            saveFolder.mkdirs();
        }
        String rootdir = snaInfo.getRootdir();
        String zipfileName = saveFolder.getName() + ".zip";
        String remoteZipPath = "/tmp/" + zipfileName;
        String command = "cd " + rootdir + " && zip " + remoteZipPath + " ./* -x *" + this.FILTER_JDB;
        boolean status = this.executeCommand(command, out = new StringBuffer(), err = new StringBuffer());
        if (!status) {
            throw new Exception("Generate zip file failed");
        }
        String remoteRoot = this.getRemoteAbsolutePath(snaInfo.getRootdir());
        this.sftp(remoteZipPath, saveFolder, true);
        out.setLength(0);
        err.setLength(0);
        this.executeCommand("rm -rf " + remoteZipPath, out, err);
        this.unzip(saveFolder + File.separator + zipfileName, saveFolder.getAbsolutePath());
        new File(saveFolder + File.separator + zipfileName).delete();
        snaInfo.setRemoteRootdir(remoteRoot);
        ArrayList<File> list = new ArrayList<File>();
        File[] files = saveFolder.listFiles();
        HashMap<String, String> securityDirMap = new HashMap<String, String>();
        for (File file : files) {
            try {
                String dir;
                BootstrapParams bp = ConfigUtils.getBootstrapParams(file);
                if (bp.getSecurityDir() != null && !bp.getSecurityDir().isEmpty() && (dir = (String)securityDirMap.get(bp.getSecurityDir())) == null) {
                    this.getSecurityFile(file.getParentFile(), snaInfo.getRootdir(), bp.getSecurityDir());
                    securityDirMap.put(bp.getSecurityDir(), bp.getSecurityDir());
                }
                list.add(file);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return list;
    }

    private void getSecurityFile(File targetFile, String source, String securityFolder) throws Exception {
        StringBuffer err;
        StringBuffer out;
        String remoteSource = source.endsWith("/") ? source + securityFolder : source + "/" + securityFolder;
        String zipfileName = targetFile.getName() + "_" + securityFolder + ".zip";
        String remoteZipPath = "/tmp/" + zipfileName;
        String command = "cd " + remoteSource + " && zip -r " + remoteZipPath + " ./* -x *" + this.FILTER_JDB;
        boolean status = this.executeCommand(command, out = new StringBuffer(), err = new StringBuffer());
        if (!status) {
            throw new Exception("Generate zip file failed");
        }
        File saveFolder = new File(targetFile, securityFolder);
        this.sftp(remoteZipPath, saveFolder, true);
        out.setLength(0);
        err.setLength(0);
        this.executeCommand("rm -rf " + remoteZipPath, out, err);
        this.unzip(saveFolder + File.separator + zipfileName, saveFolder.getAbsolutePath());
        new File(saveFolder + File.separator + zipfileName).delete();
    }

    private void unzip(String zipPath, String outputdir) throws Exception {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipPath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(outputdir, entry.getName()).mkdirs();
                    continue;
                }
                BufferedInputStream bis = null;
                OutputStream fos = null;
                BufferedOutputStream bos = null;
                try {
                    int count;
                    bis = new BufferedInputStream(zipFile.getInputStream(entry));
                    File file = new File(outputdir, entry.getName());
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos, this.BUFFER_SZIE);
                    byte[] data = new byte[this.BUFFER_SZIE];
                    while ((count = bis.read(data, 0, this.BUFFER_SZIE)) != -1) {
                        bos.write(data, 0, count);
                    }
                }
                catch (Exception ex) {
                    throw new Exception("Problem unzipping file: " + zipPath);
                }
                finally {
                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                    if (fos != null) {
                        fos.flush();
                        ((FileOutputStream)fos).close();
                    }
                    if (bis == null) continue;
                    bis.close();
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Problem unzipping file: " + zipPath);
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private boolean executeCommand(String command, StringBuffer out, StringBuffer err) throws Exception {
        InputStream outStream = null;
        InputStream errStream = null;
        boolean status = false;
        Channel channel = null;
        try {
            channel = (ChannelExec)this.jschSession.openChannel(this.EXE_CMD);
            ((ChannelExec)channel).setCommand(command);
            outStream = channel.getInputStream();
            errStream = ((ChannelExec)channel).getErrStream();
            this.begin = System.currentTimeMillis();
            channel.connect();
            this.end = System.currentTimeMillis();
            byte[] buffer = new byte[this.BUFFER_SZIE];
            while (true) {
                int len;
                if (outStream.available() > 0) {
                    len = outStream.read(buffer, 0, this.BUFFER_SZIE);
                    out.append(new String(buffer, 0, len));
                    continue;
                }
                while (errStream.available() > 0) {
                    len = errStream.read(buffer, 0, this.BUFFER_SZIE);
                    err.append(new String(buffer, 0, len));
                }
                if (channel.isClosed()) {
                    if (outStream.available() <= 0 && errStream.available() <= 0) break;
                    continue;
                }
                try {
                    Thread.sleep(this.INTERVAL_TIME);
                }
                catch (Exception ignore) {}
            }
            if (channel.getExitStatus() == 0) {
                status = true;
            }
            boolean bl = status;
            return bl;
        }
        catch (JSchException ex) {
            throw new Exception("Problem executing command : " + command, ex.getCause());
        }
        finally {
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
        }
    }

    private class AuthUserInfo
    extends SSHUserInfo {
        private AuthUserInfo() {
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public boolean promptPassphrase(String message) {
            System.out.println(message);
            return true;
        }
    }

    private class PasswordUserInfo
    extends SSHUserInfo {
        private PasswordUserInfo() {
        }

        @Override
        public String getPassword() {
            String prompt = SSHClient.this.username + "@" + SSHClient.this.host + "'s password: ";
            String password = null;
            try {
                password = new String(SSHClient.this.passwordReader.readPassword(prompt));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return password;
        }

        @Override
        public boolean promptPassphrase(String message) {
            return true;
        }
    }

    private abstract class SSHUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private SSHUserInfo() {
        }

        @Override
        public boolean promptYesNo(String str) {
            return true;
        }

        @Override
        public String getPassphrase() {
            return null;
        }

        @Override
        public boolean promptPassword(String message) {
            return true;
        }

        @Override
        public void showMessage(String message) {
            System.out.println(message);
        }

        @Override
        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            return new String[]{this.getPassword()};
        }
    }
}

