/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.diagnostic.execution;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.diagnostic.LogFileInfo;
import oracle.kv.impl.diagnostic.LogInfo;
import oracle.kv.impl.diagnostic.LogSectionFileInfo;
import oracle.kv.impl.diagnostic.execution.LogExtractor;

public class MasterLogExtractor
extends LogExtractor {
    private String MASTER_CHANGED_STR = "Master changed to ";
    private String TEMP_FILE_SUFFIX = "_masterlog.tmp";
    private String UNDER_LINE = "_";
    private String prefixName;
    private List<LogSectionFileInfo> sectionList = new ArrayList<LogSectionFileInfo>();

    public MasterLogExtractor(LogFileInfo.LogFileType logFileType, String prefixName) {
        super(logFileType);
        this.prefixName = prefixName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void extract(Map<String, List<LogFileInfo>> logFileInfoMap) {
        for (Map.Entry<String, List<LogFileInfo>> entry : logFileInfoMap.entrySet()) {
            String nodeName = entry.getKey();
            List<LogFileInfo> logFileInfoList = entry.getValue();
            if (logFileInfoList.isEmpty()) continue;
            File file = new File(this.prefixName + this.UNDER_LINE + nodeName + this.TEMP_FILE_SUFFIX);
            BufferedWriter bw = null;
            List<String> timestampList = null;
            try {
                bw = new BufferedWriter(new FileWriter(file));
                Collections.sort(logFileInfoList, new LogFileInfo.LogFileInfoComparator());
                timestampList = this.extractMasterLog(bw, logFileInfoList);
            }
            catch (IOException ex) {
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException ex) {}
                }
            }
            if (timestampList == null || timestampList.isEmpty()) {
                file.delete();
                continue;
            }
            LogSectionFileInfo fileInfo = new LogSectionFileInfo(file, timestampList);
            this.sectionList.add(fileInfo);
        }
    }

    public List<LogSectionFileInfo> getLogSectionFileInfoList() {
        return this.sectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> extractMasterLog(BufferedWriter bw, List<LogFileInfo> logFileInfoList) {
        BufferedReader br = null;
        boolean isExtractLog = false;
        boolean isNoFoundMasterLog = true;
        ArrayList<LogInfo> preLogList = new ArrayList<LogInfo>();
        ArrayList<LogInfo> logList = new ArrayList<LogInfo>();
        ArrayList<String> timestampList = new ArrayList<String>();
        for (LogFileInfo logFileInfo : logFileInfoList) {
            try {
                String line;
                br = new BufferedReader(new FileReader(new File(logFileInfo.getFilePath())));
                while ((line = br.readLine()) != null) {
                    if (line.contains(this.MASTER_CHANGED_STR)) {
                        isNoFoundMasterLog = false;
                    }
                    if (isNoFoundMasterLog) {
                        preLogList.add(new LogInfo(line));
                    }
                    if (isExtractLog) {
                        if (line.contains(this.MASTER_CHANGED_STR)) {
                            String timestamp = this.writeMasterLog(bw, preLogList, logList);
                            timestampList.add(timestamp);
                            isExtractLog = false;
                            continue;
                        }
                        logList.add(new LogInfo(line));
                        continue;
                    }
                    if (line.contains(this.MASTER_CHANGED_STR + logFileInfo.getNodeID())) {
                        isExtractLog = true;
                        logList.add(new LogInfo(line));
                    }
                    if (!line.contains(this.MASTER_CHANGED_STR) || line.contains(this.MASTER_CHANGED_STR + logFileInfo.getNodeID())) continue;
                    preLogList.clear();
                }
            }
            catch (Exception ex) {}
            continue;
            finally {
                try {
                    if (br == null) continue;
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        try {
            if (preLogList.size() > 0 || logList.size() > 0) {
                String timestamp = this.writeMasterLog(bw, preLogList, logList);
                timestampList.add(timestamp);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return timestampList;
    }

    private String writeMasterLog(BufferedWriter bw, List<LogInfo> preLogList, List<LogInfo> logList) throws IOException {
        String logTimestampString = null;
        if (!preLogList.isEmpty()) {
            logTimestampString = preLogList.get(0).getTimestampString();
        } else if (!logList.isEmpty()) {
            logTimestampString = logList.get(0).getTimestampString();
        }
        for (LogInfo logInfo : preLogList) {
            bw.write(logInfo.toString());
            bw.newLine();
        }
        preLogList.clear();
        for (LogInfo logInfo : logList) {
            bw.write(logInfo.toString());
            bw.newLine();
        }
        logList.clear();
        return logTimestampString;
    }
}

